/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.dom.DOMSource;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.utils.DumpAttachment;
import org.openspcoop2.message.utils.DumpMessaggio;
import org.openspcoop2.message.utils.DumpMessaggioConfig;
import org.openspcoop2.message.utils.DumpMessaggioMultipartInfo;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.w3c.dom.Node;

public class DumpSoapMessageUtils {
    public static DumpMessaggio dumpMessage(OpenSPCoop2SoapMessage msg, boolean dumpAllAttachments) throws MessageException {
        return DumpSoapMessageUtils.dumpMessage(msg, new DumpMessaggioConfig(), dumpAllAttachments);
    }

    public static DumpMessaggio dumpMessage(OpenSPCoop2SoapMessage msg, DumpMessaggioConfig config, boolean dumpAllAttachments) throws MessageException {
        try {
            boolean msgWithAttachments;
            DumpMessaggio dumpMessaggio = new DumpMessaggio();
            dumpMessaggio.setMessageType(msg.getMessageType());
            dumpMessaggio.setContentType(msg.getContentType());
            Map pTrasporto = null;
            if (msg.getTransportRequestContext() != null) {
                if (msg.getTransportRequestContext().getHeaders() != null && msg.getTransportRequestContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                    pTrasporto = msg.getTransportRequestContext().getHeaders();
                }
            } else if (msg.getTransportResponseContext() != null && msg.getTransportResponseContext().getHeaders() != null && msg.getTransportResponseContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                pTrasporto = msg.getTransportResponseContext().getHeaders();
            }
            if (config.isDumpHeaders() && pTrasporto != null) {
                for (String key : pTrasporto.keySet()) {
                    if (key == null) continue;
                    List values = (List)pTrasporto.get(key);
                    dumpMessaggio.getHeadersValues().put(key, values);
                }
            }
            boolean bl = msgWithAttachments = msg.countAttachments() > 0;
            if (config.isDumpBody()) {
                Iterator itM;
                SOAPPart soapPart = msg.getSOAPPart();
                DumpMessaggioMultipartInfo multipartInfoBody = null;
                if (msgWithAttachments && (itM = soapPart.getAllMimeHeaders()) != null) {
                    while (itM.hasNext()) {
                        MimeHeader mh;
                        String key;
                        Object keyO = itM.next();
                        if (!(keyO instanceof MimeHeader) || !"Content-ID".equalsIgnoreCase(key = (mh = (MimeHeader)keyO).getName()) && !"Content-Location".equalsIgnoreCase(key) && !"Content-Type".equalsIgnoreCase(key) && !config.isDumpMultipartHeaders()) continue;
                        ArrayList<String> l = new ArrayList<String>();
                        String[] values = soapPart.getMimeHeader(key);
                        if (values != null && values.length > 0) {
                            for (String value : values) {
                                l.add(value);
                            }
                        } else {
                            l.add(mh.getValue());
                        }
                        if (l.isEmpty()) continue;
                        if (multipartInfoBody == null) {
                            multipartInfoBody = new DumpMessaggioMultipartInfo();
                        }
                        if ("Content-ID".equalsIgnoreCase(key)) {
                            multipartInfoBody.setContentId((String)l.get(0));
                        } else if ("Content-Location".equalsIgnoreCase(key)) {
                            multipartInfoBody.setContentLocation((String)l.get(0));
                        } else if ("Content-Type".equalsIgnoreCase(key)) {
                            multipartInfoBody.setContentType((String)l.get(0));
                        }
                        if (!config.isDumpMultipartHeaders()) continue;
                        multipartInfoBody.getHeadersValues().put(key, l);
                    }
                }
                if (multipartInfoBody != null) {
                    dumpMessaggio.setMultipartInfoBody(multipartInfoBody);
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                bout.write(msg.getAsByte((Node)soapPart.getEnvelope(), false));
                bout.flush();
                bout.close();
                dumpMessaggio.setBody(bout);
            }
            if (config.isDumpAttachments()) {
                Iterator<?> it = msg.getAttachments();
                while (it.hasNext()) {
                    Iterator itM;
                    AttachmentPart ap = (AttachmentPart)it.next();
                    DumpAttachment dumpAttach = new DumpAttachment();
                    dumpAttach.setContentId(ap.getContentId());
                    dumpAttach.setContentLocation(ap.getContentLocation());
                    dumpAttach.setContentType(ap.getContentType());
                    if (config.isDumpMultipartHeaders() && (itM = ap.getAllMimeHeaders()) != null) {
                        while (itM.hasNext()) {
                            Object keyO = itM.next();
                            if (!(keyO instanceof MimeHeader)) continue;
                            MimeHeader mh = (MimeHeader)keyO;
                            String key = mh.getName();
                            ArrayList<String> l = new ArrayList<String>();
                            String[] values = ap.getMimeHeader(key);
                            if (values != null && values.length > 0) {
                                for (String value : values) {
                                    l.add(value);
                                }
                            } else {
                                l.add(mh.getValue());
                            }
                            if (l.isEmpty()) continue;
                            dumpAttach.getHeadersValues().put(key, l);
                        }
                    }
                    ByteArrayOutputStream boutAttach = null;
                    if (dumpAllAttachments) {
                        boutAttach = (ByteArrayOutputStream)DumpSoapMessageUtils._dumpAttachment(msg, ap, true);
                    } else {
                        Object o = DumpSoapMessageUtils._dumpAttachment(msg, ap, false);
                        if (o == null) {
                            dumpAttach.setErrorContentNotSerializable("Contenuto attachment non recuperato??");
                        } else if (o instanceof String) {
                            boutAttach = new ByteArrayOutputStream();
                            boutAttach.write(((String)o).getBytes());
                            boutAttach.flush();
                            boutAttach.close();
                        } else if (o instanceof ByteArrayOutputStream) {
                            boutAttach = (ByteArrayOutputStream)o;
                        } else {
                            dumpAttach.setErrorContentNotSerializable("Contenuto attachment non \u00e8 visualizzabile, tipo: " + o.getClass().getName());
                        }
                    }
                    dumpAttach.setContent(boutAttach);
                    if (dumpMessaggio.getAttachments() == null) {
                        dumpMessaggio.setAttachments(new ArrayList<DumpAttachment>());
                    }
                    dumpMessaggio.getAttachments().add(dumpAttach);
                }
            }
            return dumpMessaggio;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String dumpMessageAsString(DumpMessaggio msg, boolean dumpAllAttachments) throws MessageException {
        return DumpSoapMessageUtils.dumpMessageAsString(msg, new DumpMessaggioConfig(), dumpAllAttachments);
    }

    public static String dumpMessageAsString(DumpMessaggio msg, DumpMessaggioConfig config, boolean dumpAllAttachments) throws MessageException {
        try {
            StringBuilder out = new StringBuilder(msg.toString(config, dumpAllAttachments));
            return out.toString();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static String dumpMessageAsString(OpenSPCoop2SoapMessage msg, boolean dumpAllAttachments) throws MessageException {
        return DumpSoapMessageUtils.dumpMessageAsString(msg, new DumpMessaggioConfig(), dumpAllAttachments);
    }

    public static String dumpMessageAsString(OpenSPCoop2SoapMessage msg, DumpMessaggioConfig config, boolean dumpAllAttachments) throws MessageException {
        try {
            Object values;
            boolean msgWithAttachments;
            StringBuilder out = new StringBuilder();
            Map pTrasporto = null;
            if (msg.getTransportRequestContext() != null) {
                if (msg.getTransportRequestContext().getHeaders() != null && msg.getTransportRequestContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                    pTrasporto = msg.getTransportRequestContext().getHeaders();
                }
            } else if (msg.getTransportResponseContext() != null && msg.getTransportResponseContext().getHeaders() != null && msg.getTransportResponseContext().getHeaders().size() > 0 && config.isDumpHeaders()) {
                pTrasporto = msg.getTransportResponseContext().getHeaders();
            }
            if (config.isDumpHeaders()) {
                out.append("------ Header di trasporto ------\n");
                if (pTrasporto != null && pTrasporto.size() > 0) {
                    for (String key : pTrasporto.keySet()) {
                        List values2;
                        if (key == null || (values2 = (List)pTrasporto.get(key)) == null || values2.isEmpty()) continue;
                        for (String value : values2) {
                            out.append("- " + key + ": " + value + "\n");
                        }
                    }
                } else {
                    out.append("Non presenti\n");
                }
            }
            boolean bl = msgWithAttachments = msg.countAttachments() > 0;
            if (config.isDumpBody()) {
                out.append("------ SOAPEnvelope (ContentType: " + msg.getContentType() + ") (MessageType: " + msg.getMessageType() + ") ------\n");
                SOAPPart soapPart = msg.getSOAPPart();
                if (msgWithAttachments) {
                    List<String> l;
                    HashMap<String, List<String>> mime = new HashMap<String, List<String>>();
                    Iterator itM = soapPart.getAllMimeHeaders();
                    if (itM != null) {
                        while (itM.hasNext()) {
                            String key;
                            Object keyO = itM.next();
                            if (!(keyO instanceof String) || !"Content-ID".equalsIgnoreCase(key = (String)keyO) && !"Content-Location".equalsIgnoreCase(key) && !"Content-Type".equalsIgnoreCase(key) && !config.isDumpMultipartHeaders()) continue;
                            l = new ArrayList();
                            values = soapPart.getMimeHeader(key);
                            if (values != null && ((String[])values).length > 0) {
                                for (Object value : values) {
                                    l.add((String)value);
                                }
                            }
                            if (l.isEmpty()) continue;
                            if ("Content-ID".equalsIgnoreCase(key)) {
                                mime.put(key, l);
                                continue;
                            }
                            if ("Content-Location".equalsIgnoreCase(key)) {
                                mime.put(key, l);
                                continue;
                            }
                            if ("Content-Type".equalsIgnoreCase(key)) {
                                mime.put(key, l);
                                continue;
                            }
                            if (!config.isDumpMultipartHeaders()) continue;
                            mime.put(key, l);
                        }
                    }
                    if (mime.size() > 0) {
                        out.append("\n*** MimePart Header ***\n");
                        for (String key : mime.keySet()) {
                            l = (List)mime.get(key);
                            if (l == null || l.isEmpty()) continue;
                            values = l.iterator();
                            while (values.hasNext()) {
                                String string = (String)values.next();
                                out.append("- " + key + ": " + string + "\n");
                            }
                        }
                    }
                }
                out.append("\n");
                out.append(msg.getAsString((Node)soapPart.getEnvelope(), false));
            }
            if (config.isDumpAttachments()) {
                Iterator<?> it = msg.getAttachments();
                int index = 1;
                while (it.hasNext()) {
                    Iterator itM;
                    AttachmentPart ap = (AttachmentPart)it.next();
                    out.append("\n------ Attachment-" + index + " ------\n");
                    out.append("\n*** MimePart Header ***\n");
                    if (ap.getContentId() != null) {
                        out.append("- Content-ID: " + ap.getContentId() + "\n");
                    }
                    if (ap.getContentLocation() != null) {
                        out.append("- Content-Location: " + ap.getContentLocation() + "\n");
                    }
                    if (ap.getContentType() != null) {
                        out.append("- Content-Location: " + ap.getContentType() + "\n");
                    }
                    if (config.isDumpMultipartHeaders() && (itM = ap.getAllMimeHeaders()) != null) {
                        while (itM.hasNext()) {
                            String key;
                            Object keyO = itM.next();
                            if (!(keyO instanceof String) || "Content-ID".equalsIgnoreCase(key = (String)keyO) || "Content-Location".equalsIgnoreCase(key) || "Content-Type".equalsIgnoreCase(key) || (values = ap.getMimeHeader(key)) == null || ((Object)values).length <= 0) continue;
                            for (Object value : values) {
                                out.append("- " + key + ": " + (String)value + "\n");
                            }
                        }
                    }
                    out.append("\n");
                    if (dumpAllAttachments) {
                        out.append(DumpSoapMessageUtils.dumpAttachment(msg, ap));
                    } else {
                        Object o = ap.getDataHandler().getContent();
                        if ("application/openspcoop2".equals(ap.getContentType())) {
                            DumpSoapMessageUtils.rebuildAttachmentAsByteArray(msg, ap);
                        }
                        if (o instanceof String) {
                            out.append((String)o);
                        } else {
                            out.append("Contenuto attachments non \u00e8 visualizzabile, tipo: " + o.getClass().getName());
                        }
                    }
                    ++index;
                }
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpAttachment(OpenSPCoop2SoapMessage msg, AttachmentPart ap) throws MessageException {
        Object o = DumpSoapMessageUtils._dumpAttachment(msg, ap, false);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bout = null;
            try {
                bout = (ByteArrayOutputStream)o;
                String string = bout.toString();
                return string;
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new MessageException("Dump error (return type " + o.getClass().getName() + " unknown)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dumpAttachmentAsByteArray(OpenSPCoop2SoapMessage msg, AttachmentPart ap) throws MessageException {
        Object o = DumpSoapMessageUtils._dumpAttachment(msg, ap, false);
        if (o instanceof String) {
            return ((String)o).getBytes();
        }
        if (o instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bout = null;
            try {
                bout = (ByteArrayOutputStream)o;
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new MessageException("Dump error (return type " + o.getClass().getName() + " unknown)");
    }

    private static Object _dumpAttachment(OpenSPCoop2SoapMessage msg, AttachmentPart ap, boolean forceReturnAsByteArrayOutputStream) throws MessageException {
        try {
            ByteArrayOutputStream bout = null;
            Object o = ap.getDataHandler().getContent();
            String s = null;
            boolean forceRebuildDataHandler = false;
            if (o != null) {
                if (o instanceof byte[]) {
                    byte[] b = (byte[])o;
                    bout = new ByteArrayOutputStream();
                    bout.write(b);
                    bout.flush();
                    bout.close();
                } else if (o instanceof InputStream) {
                    InputStream is = (InputStream)o;
                    bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = is.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    is.close();
                    bout.flush();
                    bout.close();
                } else if (o instanceof String) {
                    s = (String)o;
                    bout = new ByteArrayOutputStream();
                    bout.write(s.getBytes());
                    bout.flush();
                    bout.close();
                } else {
                    try {
                        DataHandler dh = ap.getDataHandler();
                        InputStream inputDH = dh.getInputStream();
                        bout = new ByteArrayOutputStream();
                        byte[] readB = new byte[8192];
                        int readByte = 0;
                        while ((readByte = inputDH.read(readB)) != -1) {
                            bout.write(readB, 0, readByte);
                        }
                        inputDH.close();
                        bout.flush();
                        bout.close();
                    }
                    catch (Exception e) {
                        if (o instanceof DOMSource) {
                            try {
                                DOMSource domSource = (DOMSource)o;
                                bout = new ByteArrayOutputStream();
                                bout.write(MessageXMLUtils.getInstance(msg.getFactory()).toByteArray(domSource.getNode()));
                                bout.flush();
                                bout.close();
                                forceRebuildDataHandler = true;
                            }
                            catch (Exception eInternal) {
                                throw new UtilsMultiException(new Throwable[]{e, eInternal});
                            }
                        }
                        throw e;
                    }
                }
            } else {
                DataHandler dh = ap.getDataHandler();
                InputStream inputDH = dh.getInputStream();
                bout = new ByteArrayOutputStream();
                byte[] readB = new byte[8192];
                int readByte = 0;
                while ((readByte = inputDH.read(readB)) != -1) {
                    bout.write(readB, 0, readByte);
                }
                inputDH.close();
                bout.flush();
                bout.close();
            }
            if ("application/openspcoop2".equals(ap.getContentType())) {
                DumpSoapMessageUtils.rebuildAttachmentAsByteArray(msg, ap);
            } else if (forceRebuildDataHandler) {
                DumpSoapMessageUtils.rebuildDataHandlerAttachment(msg, ap, bout);
            } else if (MailcapActivationReader.existsDataContentHandler((String)ap.getContentType())) {
                if (ap.getContentType() != null && ap.getContentType().startsWith("text/plain")) {
                    if (s != null) {
                        msg.updateAttachmentPart(ap, s, ap.getContentType());
                    } else {
                        msg.updateAttachmentPart(ap, bout.toString(), ap.getContentType());
                    }
                } else {
                    msg.updateAttachmentPart(ap, bout.toByteArray(), ap.getContentType());
                }
            }
            if (s != null) {
                if (forceReturnAsByteArrayOutputStream) {
                    return bout;
                }
                return s;
            }
            return bout;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private static void rebuildAttachmentAsByteArray(OpenSPCoop2SoapMessage msg, AttachmentPart ap) throws MessageException {
        try {
            DataHandler dh = ap.getDataHandler();
            InputStream inputDH = dh.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] readB = new byte[8192];
            int readByte = 0;
            while ((readByte = inputDH.read(readB)) != -1) {
                bout.write(readB, 0, readByte);
            }
            inputDH.close();
            bout.flush();
            bout.close();
            msg.updateAttachmentPart(ap, bout.toByteArray(), ap.getContentType());
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private static void rebuildDataHandlerAttachment(OpenSPCoop2SoapMessage msg, AttachmentPart ap, ByteArrayOutputStream boutAlreadyRead) throws MessageException {
        try {
            msg.updateAttachmentPart(ap, new DataHandler((Object)boutAlreadyRead.toByteArray(), ap.getContentType()));
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

