/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.mail.internet.ContentType;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.openspcoop2.message.ForwardConfig;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.AbstractBaseOpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.OpenSPCoop2MessageMimeHeaderProperties;
import org.openspcoop2.message.soap.SOAPFaultCode;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.WSSecurityUtils;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.soap.reference.AttachmentReference;
import org.openspcoop2.message.soap.reference.ElementReference;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.dch.DataContentHandlerManager;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractOpenSPCoop2Message_saaj_impl
extends AbstractBaseOpenSPCoop2SoapMessage {
    private SOAPMessage soapMessage;

    protected SOAPMessage _getSoapMessage() {
        return this.soapMessage;
    }

    public AbstractOpenSPCoop2Message_saaj_impl(OpenSPCoop2MessageFactory messageFactory, SOAPMessage soapMessage) {
        super(messageFactory);
        this.soapMessage = soapMessage;
    }

    @Override
    public OpenSPCoop2MessageSoapStreamReader getSoapReader() throws MessageException, MessageNotSupportedException {
        return null;
    }

    @Override
    protected SOAPMessage _getSOAPMessage() throws MessageException {
        return this.soapMessage;
    }

    @Override
    public SOAPPart getSOAPPart() throws MessageException, MessageNotSupportedException {
        return this.soapMessage.getSOAPPart();
    }

    @Override
    public SOAPBody getSOAPBody() throws MessageException, MessageNotSupportedException {
        try {
            return this.soapMessage.getSOAPBody();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasSOAPFault() throws MessageException, MessageNotSupportedException {
        SOAPBody body = this.getSOAPBody();
        return body != null && body.hasFault();
    }

    @Override
    public boolean isSOAPBodyEmpty() throws MessageException, MessageNotSupportedException {
        boolean hasContent;
        SOAPBody body = this.getSOAPBody();
        boolean bl = hasContent = body != null;
        if (hasContent) {
            hasContent = SoapUtils.getFirstNotEmptyChildNode(this.messageFactory, (Node)body, false) != null;
        }
        return !hasContent;
    }

    @Override
    public SOAPHeader getSOAPHeader() throws MessageException, MessageNotSupportedException {
        try {
            return this.soapMessage.getSOAPHeader();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void addAttachmentPart(AttachmentPart attachmentPart) throws MessageException, MessageNotSupportedException {
        this.soapMessage.addAttachmentPart(attachmentPart);
    }

    @Override
    public AttachmentPart createAttachmentPart(DataHandler dataHandler) throws MessageException, MessageNotSupportedException {
        return this.soapMessage.createAttachmentPart(dataHandler);
    }

    @Override
    public AttachmentPart createAttachmentPart() throws MessageException, MessageNotSupportedException {
        return this.soapMessage.createAttachmentPart();
    }

    @Override
    public boolean hasAttachments() throws MessageException, MessageNotSupportedException {
        return this.soapMessage.countAttachments() > 0;
    }

    @Override
    public int countAttachments() throws MessageException, MessageNotSupportedException {
        return this.soapMessage.countAttachments();
    }

    @Override
    public Iterator<?> getAttachments() throws MessageException, MessageNotSupportedException {
        return this.soapMessage.getAttachments();
    }

    @Override
    public Iterator<?> getAttachments(MimeHeaders headers) throws MessageException, MessageNotSupportedException {
        String[] values = headers.getHeader("Content-Id");
        if (!(values.length <= 0 || values[0].startsWith("<") && values[0].endsWith(">"))) {
            headers.removeHeader("Content-Id");
            headers.setHeader("Content-Id", "<" + values[0] + ">");
        }
        return this.soapMessage.getAttachments(headers);
    }

    @Override
    public AttachmentPart getAttachment(SOAPElement element) throws MessageException, MessageNotSupportedException {
        try {
            return this.soapMessage.getAttachment(element);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void removeAllAttachments() throws MessageException, MessageNotSupportedException {
        this.soapMessage.removeAllAttachments();
    }

    @Override
    public void removeAttachments(MimeHeaders mhs) throws MessageException, MessageNotSupportedException {
        this.soapMessage.removeAttachments(mhs);
        if (this.soapMessage.countAttachments() == 0) {
            this.setContentType("text/xml");
        }
    }

    @Override
    public void updateAttachmentPart(AttachmentPart ap, DataHandler dh) throws MessageException, MessageNotSupportedException {
        ap.setDataHandler(dh);
    }

    @Override
    public void updateAttachmentPart(AttachmentPart ap, byte[] content, String contentType) throws MessageException, MessageNotSupportedException {
        try {
            String baseType = ContentTypeUtilities.readBaseTypeFromContentType((String)contentType);
            if ("text/xml".equals(baseType)) {
                Source streamSource = null;
                DataContentHandlerManager dchManager = new DataContentHandlerManager(LoggerWrapperFactory.getLogger(AbstractOpenSPCoop2Message_saaj_impl.class));
                streamSource = dchManager.readMimeTypesContentHandler().containsKey("text/xml") ? new DOMSource(MessageXMLUtils.getInstance(this.messageFactory).newElement(content)) : new StreamSource(new ByteArrayInputStream(content));
                ap.setContent((Object)streamSource, contentType);
            } else {
                this.updateAttachmentPart(ap, new DataHandler((Object)content, contentType));
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAttachmentPart(AttachmentPart ap, String content, String contentType) throws MessageException, MessageNotSupportedException {
        this.updateAttachmentPart(ap, new DataHandler((Object)content, contentType));
    }

    @Override
    public String createContentID(String ns) throws MessageException, MessageNotSupportedException {
        return AbstractOpenSPCoop2Message_saaj_impl._createContentID(ns);
    }

    protected static String _createContentID(String ns) throws MessageException, MessageNotSupportedException {
        try {
            return "<" + AttachmentUtil.createContentID((String)ns) + ">";
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public OpenSPCoop2MessageProperties getForwardTransportHeader(ForwardConfig forwardConfig) throws MessageException {
        OpenSPCoop2MessageProperties msg = super.getForwardTransportHeader(forwardConfig);
        return new OpenSPCoop2MessageMimeHeaderProperties(this.soapMessage, msg);
    }

    protected abstract String _super_getContentType();

    @Override
    public void updateContentType() throws MessageException {
        try {
            if (this.countAttachments() > 0) {
                if (this.saveRequired()) {
                    this.saveChanges();
                }
            } else if (this.saveRequired()) {
                boolean pulizia = false;
                String contentType = this._super_getContentType();
                if (ContentTypeUtilities.isMtom((String)contentType)) {
                    this.saveChanges();
                    pulizia = true;
                } else if (ContentTypeUtilities.isMultipartRelated((String)contentType)) {
                    this.saveChanges();
                    pulizia = true;
                }
                if (pulizia) {
                    try {
                        String startInfo;
                        String start;
                        String boundary;
                        ContentType ctObj = new ContentType(contentType);
                        String contentTypeInternal = ContentTypeUtilities.getInternalMultipartContentType((String)contentType);
                        ContentType ctObjInternal = new ContentType(contentTypeInternal);
                        ctObj.setPrimaryType(ctObjInternal.getPrimaryType());
                        ctObj.setSubType(ctObjInternal.getSubType());
                        String type = ctObj.getParameter("type");
                        if (type != null && !type.equals("")) {
                            ctObj.getParameterList().remove("type");
                        }
                        if ((boundary = ctObj.getParameter("boundary")) != null && !boundary.equals("")) {
                            ctObj.getParameterList().remove("boundary");
                        }
                        if ((start = ctObj.getParameter("start")) != null && !start.equals("")) {
                            ctObj.getParameterList().remove("start");
                        }
                        if ((startInfo = ctObj.getParameter("start-info")) != null && !startInfo.equals("")) {
                            ctObj.getParameterList().remove("start-info");
                        }
                        this.setContentType(ctObj.toString());
                    }
                    catch (Throwable t) {
                        System.err.println("Pulizia messaggio Multipart normalizzato senza attachment non riuscita: " + t.getMessage());
                        t.printStackTrace(System.err);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isContentBuilded() {
        return true;
    }

    @Override
    public void writeTo(OutputStream os, boolean consume) throws MessageException {
        try {
            CountingOutputStream cos = new CountingOutputStream(os);
            this.soapMessage.writeTo((OutputStream)cos);
            this.outgoingsize = cos.getByteCount();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void saveChanges() throws MessageException {
        try {
            this.soapMessage.saveChanges();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public boolean saveRequired() {
        return this.soapMessage.saveRequired();
    }

    @Override
    public Element getFirstChildElement(SOAPElement element) throws MessageException, MessageNotSupportedException {
        return AbstractOpenSPCoop2Message_saaj_impl._getFirstChildElement(element);
    }

    protected static Element _getFirstChildElement(SOAPElement element) throws MessageException, MessageNotSupportedException {
        Element firstElement = null;
        NodeList nl = element.getChildNodes();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node tmp = nl.item(i);
                if (!(tmp instanceof Element)) continue;
                firstElement = (Element)tmp;
                break;
            }
        }
        return firstElement;
    }

    @Override
    public SOAPElement createSOAPElement(byte[] bytes) throws MessageException, MessageNotSupportedException {
        return AbstractOpenSPCoop2Message_saaj_impl._createSOAPElement(bytes, this.getMessageType(), this.messageFactory);
    }

    protected static SOAPElement _createSOAPElement(byte[] bytes, MessageType messageType, OpenSPCoop2MessageFactory messageFactory) throws MessageException, MessageNotSupportedException {
        try {
            SOAPFactory soapFactory = null;
            if (MessageType.SOAP_11.equals(messageType)) {
                soapFactory = messageFactory.getSoapFactory11();
            } else if (MessageType.SOAP_12.equals(messageType)) {
                soapFactory = messageFactory.getSoapFactory12();
            } else {
                throw new MessageException("MessageType [" + messageType + "] not supported");
            }
            return soapFactory.createElement(MessageXMLUtils.getInstance(messageFactory).newElement(bytes));
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public SOAPHeaderElement newSOAPHeaderElement(SOAPHeader hdr, QName name) throws MessageException, MessageNotSupportedException {
        return AbstractOpenSPCoop2Message_saaj_impl._newSOAPHeaderElement(hdr, name);
    }

    protected static SOAPHeaderElement _newSOAPHeaderElement(SOAPHeader hdr, QName name) throws MessageException, MessageNotSupportedException {
        try {
            SOAPHeaderElement newHeader = hdr.addHeaderElement(name);
            return newHeader;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void addHeaderElement(SOAPHeader hdr, SOAPHeaderElement hdrElement) throws MessageException, MessageNotSupportedException {
        AbstractOpenSPCoop2Message_saaj_impl._addHeaderElement(hdr, hdrElement);
    }

    protected static void _addHeaderElement(SOAPHeader hdr, SOAPHeaderElement hdrElement) throws MessageException, MessageNotSupportedException {
        try {
            hdr.addChildElement((SOAPElement)hdrElement);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void removeHeaderElement(SOAPHeader hdr, SOAPHeaderElement hdrElement) throws MessageException, MessageNotSupportedException {
        AbstractOpenSPCoop2Message_saaj_impl._removeHeaderElement(hdr, hdrElement);
    }

    protected static void _removeHeaderElement(SOAPHeader hdr, SOAPHeaderElement hdrElement) throws MessageException, MessageNotSupportedException {
        try {
            hdr.removeChild((Node)hdrElement);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void setFaultCode(SOAPFault fault, SOAPFaultCode code, QName eccezioneName) throws MessageException, MessageNotSupportedException {
        AbstractOpenSPCoop2Message_saaj_impl._setFaultCode(fault, code, eccezioneName);
    }

    protected static void _setFaultCode(SOAPFault fault, SOAPFaultCode code, QName eccezioneName) throws MessageException, MessageNotSupportedException {
        try {
            fault.setFaultCode(eccezioneName);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void setFaultString(SOAPFault fault, String message) throws MessageException, MessageNotSupportedException {
        AbstractOpenSPCoop2Message_saaj_impl._setFaultString(fault, message);
    }

    protected static void _setFaultString(SOAPFault fault, String message) throws MessageException, MessageNotSupportedException {
        try {
            SoapUtils.setFaultString(fault, message, null);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void setFaultString(SOAPFault fault, String message, Locale locale) throws MessageException, MessageNotSupportedException {
        AbstractOpenSPCoop2Message_saaj_impl._setFaultString(fault, message, locale);
    }

    protected static void _setFaultString(SOAPFault fault, String message, Locale locale) throws MessageException, MessageNotSupportedException {
        try {
            SoapUtils.setFaultString(fault, message, locale);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private SOAPPart getSOAPPartForSearchWSSecurity() {
        return this.soapMessage.getSOAPPart();
    }

    @Override
    public List<Reference> getWSSDirtyElements(String actor, boolean mustUnderstand) throws MessageException, MessageNotSupportedException {
        try {
            ArrayList<Reference> references = new ArrayList<Reference>();
            SOAPElement security = WSSecurityUtils.getSecurityHeader(this.getSOAPPartForSearchWSSecurity(), this.messageType, actor, this.isThrowExceptionIfFoundMoreSecurityHeader());
            if (security != null) {
                Iterator it = security.getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"));
                if (it.hasNext()) {
                    SOAPElement encryptedKey = (SOAPElement)it.next();
                    SOAPElement referenceList = (SOAPElement)encryptedKey.getChildElements(new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList")).next();
                    List<SOAPElement> referenceListElements = SoapUtils.getNotEmptyChildSOAPElement(referenceList);
                    for (int i = 0; i < referenceListElements.size(); ++i) {
                        String referenceWithSharp = referenceListElements.get(i).getAttributeValue(new QName("URI"));
                        if (!referenceWithSharp.startsWith("#")) continue;
                        String reference = referenceWithSharp.substring(1);
                        SOAPElement encryptedElement = (SOAPElement)XMLUtils.findElementById((Node)this.getSOAPPartForSearchWSSecurity().getEnvelope(), (String)reference, (boolean)true);
                        if (encryptedElement == null) {
                            throw new SOAPException("Element with 'Id' attribute value (" + referenceWithSharp + ") not found [WSS-Encrypt ReferencesSearch]");
                        }
                        QName qName = new QName("http://www.w3.org/2001/04/xmlenc#", "CipherData");
                        Iterator childElements = encryptedElement.getChildElements(qName);
                        if (childElements != null && childElements.hasNext()) {
                            QName qNameReference = new QName("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
                            Iterator childElementsReference = ((SOAPElement)childElements.next()).getChildElements(qNameReference);
                            if (childElementsReference != null && childElementsReference.hasNext()) {
                                String referenceAttach = ((SOAPElement)childElementsReference.next()).getAttributeValue(new QName("URI"));
                                if (referenceAttach.startsWith("cid:")) {
                                    String referenceCID = referenceAttach.substring(4);
                                    references.add(new AttachmentReference(4, referenceCID));
                                    continue;
                                }
                                throw new SOAPException("Element 'CipherReference' with attribute 'cid' wrong [WSS-Encrypt ReferencesSearch]");
                            }
                            if (encryptedElement.getAttributeNS(null, "Type").equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                                references.add(new ElementReference(encryptedElement.getParentElement(), 1, reference));
                                continue;
                            }
                            references.add(new ElementReference(encryptedElement.getParentElement(), 2, reference));
                            continue;
                        }
                        throw new SOAPException("Element 'CipherData' not found [WSS-Encrypt ReferencesSearch]");
                    }
                }
                if ((it = security.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"))).hasNext()) {
                    SOAPElement signature = (SOAPElement)it.next();
                    SOAPElement signatureInfo = (SOAPElement)signature.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo")).next();
                    Iterator referenceIterator = signatureInfo.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "Reference"));
                    while (referenceIterator.hasNext()) {
                        String reference;
                        String referenceWithSharp = ((SOAPElement)referenceIterator.next()).getAttributeValue(new QName("URI"));
                        if (referenceWithSharp.startsWith("#")) {
                            reference = referenceWithSharp.substring(1);
                            SOAPEnvelope soapEnvelope = this.getSOAPPartForSearchWSSecurity().getEnvelope();
                            SOAPElement signedElement = (SOAPElement)XMLUtils.findElementById((Node)soapEnvelope, (String)reference, (boolean)true);
                            if (signedElement == null) {
                                Object o;
                                String xpath2;
                                DynamicNamespaceContext dnc = null;
                                dnc = MessageType.SOAP_11.equals(this.getMessageType()) ? MessageDynamicNamespaceContextFactory.getInstance(this.messageFactory).getNamespaceContextFromSoapEnvelope11(soapEnvelope) : MessageDynamicNamespaceContextFactory.getInstance(this.messageFactory).getNamespaceContextFromSoapEnvelope12(soapEnvelope);
                                XPathExpressionEngine xpathExpressionEngine = new XPathExpressionEngine(this.messageFactory);
                                try {
                                    xpath2 = "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion[@ID='" + reference + "']";
                                    o = xpathExpressionEngine.getMatchPattern(security, dnc, xpath2, XPathReturnType.NODE);
                                    signedElement = (SOAPElement)o;
                                }
                                catch (XPathNotFoundException xpath2) {
                                    // empty catch block
                                }
                                if (signedElement == null) {
                                    try {
                                        xpath2 = "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion[@AssertionID='" + reference + "']";
                                        o = xpathExpressionEngine.getMatchPattern(security, dnc, xpath2, XPathReturnType.NODE);
                                        signedElement = (SOAPElement)o;
                                    }
                                    catch (XPathNotFoundException xPathNotFoundException) {
                                        // empty catch block
                                    }
                                }
                                if (signedElement == null) {
                                    throw new SOAPException("Element with 'Id' attribute value (" + referenceWithSharp + ") not found [WSS-Signature ReferencesSearch]");
                                }
                            }
                            references.add(new ElementReference(signedElement, 3, reference));
                            continue;
                        }
                        if (!referenceWithSharp.startsWith("cid:")) continue;
                        reference = referenceWithSharp.substring(4);
                        references.add(new AttachmentReference(5, reference));
                    }
                }
            }
            return references;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void cleanWSSDirtyElements(String actor, boolean mustUnderstand, List<Reference> references, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws MessageException, MessageNotSupportedException {
        try {
            SOAPElement security = WSSecurityUtils.getSecurityHeader(this.getSOAPPartForSearchWSSecurity(), this.messageType, actor, this.isThrowExceptionIfFoundMoreSecurityHeader());
            if (detachHeaderWSSecurity) {
                security.detachNode();
            }
            block7: for (int i = 0; i < references.size(); ++i) {
                Reference reference = references.get(i);
                if (!(reference instanceof ElementReference)) continue;
                SOAPElement elementToClean = ((ElementReference)reference).getElement();
                switch (reference.getType()) {
                    case 3: {
                        String namespace;
                        boolean found = false;
                        NodeList securities = this.getSOAPHeader().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
                        for (int s = 0; s < securities.getLength(); ++s) {
                            security = (SOAPElement)securities.item(s);
                            Iterator it = security.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"));
                            if (!it.hasNext()) continue;
                            SOAPElement signature = (SOAPElement)it.next();
                            SOAPElement signatureInfo = (SOAPElement)signature.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "SignedInfo")).next();
                            Iterator referenceIterator = signatureInfo.getChildElements(new QName("http://www.w3.org/2000/09/xmldsig#", "Reference"));
                            while (referenceIterator.hasNext()) {
                                String referenceWithSharp = ((SOAPElement)referenceIterator.next()).getAttributeValue(new QName("URI"));
                                if (!reference.getReference().equals(referenceWithSharp.substring(1))) continue;
                                found = true;
                            }
                        }
                        if (found) continue block7;
                        boolean removeIdRefSignature = false;
                        if (removeAllIdRef) {
                            removeIdRefSignature = true;
                            elementToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                        } else {
                            String valoreRefSignature = elementToClean.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                            if (valoreRefSignature != null && valoreRefSignature.equals(reference.getReference())) {
                                removeIdRefSignature = true;
                            }
                            if (removeIdRefSignature) {
                                elementToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                            }
                        }
                        ArrayList<String> prefixesToRemoveContent = new ArrayList<String>();
                        Iterator prefixes = elementToClean.getNamespacePrefixes();
                        while (prefixes.hasNext()) {
                            String prefix = (String)prefixes.next();
                            namespace = elementToClean.getNamespaceURI(prefix);
                            if (!namespace.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd") || !removeIdRefSignature) continue;
                            prefixesToRemoveContent.add(prefix);
                        }
                        for (int y = 0; y < prefixesToRemoveContent.size(); ++y) {
                            elementToClean.removeNamespaceDeclaration((String)prefixesToRemoveContent.get(y));
                        }
                        continue block7;
                    }
                    case 1: {
                        String namespace;
                        ArrayList<String> prefixesToRemoveContent = new ArrayList<String>();
                        Iterator prefixesContent = elementToClean.getNamespacePrefixes();
                        while (prefixesContent.hasNext()) {
                            String prefix = (String)prefixesContent.next();
                            String namespace2 = elementToClean.getNamespaceURI(prefix);
                            if (!namespace2.equals("http://www.w3.org/2001/04/xmlenc#") && !namespace2.equals(elementToClean.getNamespaceURI(prefix))) continue;
                            prefixesToRemoveContent.add(prefix);
                        }
                        for (int y = 0; y < prefixesToRemoveContent.size(); ++y) {
                            elementToClean.removeNamespaceDeclaration((String)prefixesToRemoveContent.get(y));
                        }
                        boolean removeIdRefEncContent = false;
                        if (removeAllIdRef) {
                            removeIdRefEncContent = true;
                            elementToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                        } else {
                            String valoreRefEncContent = elementToClean.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                            if (valoreRefEncContent != null && valoreRefEncContent.equals(reference.getReference())) {
                                removeIdRefEncContent = true;
                            }
                            if (removeIdRefEncContent) {
                                elementToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                            }
                        }
                        prefixesToRemoveContent = new ArrayList();
                        prefixesContent = elementToClean.getNamespacePrefixes();
                        while (prefixesContent.hasNext()) {
                            String prefix = (String)prefixesContent.next();
                            namespace = elementToClean.getNamespaceURI(prefix);
                            if (!namespace.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd") || !removeIdRefEncContent) continue;
                            prefixesToRemoveContent.add(prefix);
                        }
                        for (int y = 0; y < prefixesToRemoveContent.size(); ++y) {
                            elementToClean.removeNamespaceDeclaration((String)prefixesToRemoveContent.get(y));
                        }
                        continue block7;
                    }
                    case 2: {
                        Iterator childrenToClean = elementToClean.getChildElements();
                        while (childrenToClean.hasNext()) {
                            Object next = childrenToClean.next();
                            if (!(next instanceof SOAPElement)) continue;
                            SOAPElement childToClean = (SOAPElement)next;
                            ArrayList<String> prefixesToRemoveElement = new ArrayList<String>();
                            Iterator prefixesElement = childToClean.getNamespacePrefixes();
                            while (prefixesElement.hasNext()) {
                                String prefix = (String)prefixesElement.next();
                                String namespace = childToClean.getNamespaceURI(prefix);
                                if (!namespace.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")) continue;
                                prefixesToRemoveElement.add(prefix);
                            }
                            for (int y = 0; y < prefixesToRemoveElement.size(); ++y) {
                                childToClean.removeNamespaceDeclaration((String)prefixesToRemoveElement.get(y));
                            }
                            boolean removeIdRefEncElement = false;
                            if (removeAllIdRef) {
                                boolean removeIdRefEncContent = true;
                                childToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                            } else {
                                String valoreRefEncElement = childToClean.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                                if (valoreRefEncElement != null && valoreRefEncElement.equals(reference.getReference())) {
                                    removeIdRefEncElement = true;
                                }
                                if (removeIdRefEncElement) {
                                    childToClean.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                                }
                            }
                            prefixesToRemoveElement = new ArrayList();
                            prefixesElement = childToClean.getNamespacePrefixes();
                            while (prefixesElement.hasNext()) {
                                String prefix = (String)prefixesElement.next();
                                String namespace = childToClean.getNamespaceURI(prefix);
                                if (!namespace.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd") || !removeIdRefEncElement) continue;
                                prefixesToRemoveElement.add(prefix);
                            }
                            for (int y = 0; y < prefixesToRemoveElement.size(); ++y) {
                                childToClean.removeNamespaceDeclaration((String)prefixesToRemoveElement.get(y));
                            }
                        }
                        continue block7;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public String getEncryptedDataHeaderBlockClass() {
        return AbstractOpenSPCoop2Message_saaj_impl._getEncryptedDataHeaderBlockClass();
    }

    protected static String _getEncryptedDataHeaderBlockClass() {
        return "com.sun.xml.wss.core.EncryptedDataHeaderBlock";
    }

    @Override
    public String getProcessPartialEncryptedMessageClass() {
        return AbstractOpenSPCoop2Message_saaj_impl._getProcessPartialEncryptedMessageClass();
    }

    protected static String _getProcessPartialEncryptedMessageClass() {
        return "org.openspcoop2.security.message.soapbox.ProcessPartialEncryptedMessage";
    }

    @Override
    public String getSignPartialMessageProcessorClass() {
        return AbstractOpenSPCoop2Message_saaj_impl._getSignPartialMessageProcessorClass();
    }

    protected static String _getSignPartialMessageProcessorClass() {
        return "org.openspcoop2.security.message.soapbox.SignPartialMessageProcessor";
    }
}

