/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.rest.AbstractBaseOpenSPCoop2RestMessage;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class OpenSPCoop2Message_xml_impl
extends AbstractBaseOpenSPCoop2RestMessage<Element>
implements OpenSPCoop2RestXmlMessage {
    public OpenSPCoop2Message_xml_impl(OpenSPCoop2MessageFactory messageFactory) {
        super(messageFactory);
    }

    public OpenSPCoop2Message_xml_impl(OpenSPCoop2MessageFactory messageFactory, InputStream is, String contentType) throws MessageException {
        super(messageFactory, is, contentType);
    }

    @Override
    protected Element buildContent() throws MessageException {
        try {
            Element element = this.buildContent(this._getInputStream());
            return element;
        }
        finally {
            try {
                this._getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Element buildContent(DumpByteArrayOutputStream contentBuffer) throws MessageException {
        try {
            if (contentBuffer.isSerializedOnFileSystem()) {
                try (FileInputStream is = new FileInputStream(contentBuffer.getSerializedFile());){
                    Element element = this.buildContent(is);
                    return element;
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(contentBuffer.toByteArray());){
                Element element = this.buildContent(is);
                return element;
            }
        }
        catch (MessageException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    protected Element buildContent(InputStream is) throws MessageException {
        InputStreamReader isr = null;
        InputSource isSax = null;
        try {
            isr = new InputStreamReader(is, this.contentTypeCharsetName);
            isSax = new InputSource(isr);
            isSax.setEncoding(this.contentTypeCharsetName);
            Element element = MessageXMLUtils.getInstance(this.messageFactory).newElement(isSax);
            return element;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected String buildContentAsString() throws MessageException {
        try {
            return this.getAsString((Node)this.content, false);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected byte[] buildContentAsByteArray() throws MessageException {
        try {
            return this.getAsString((Node)this.content, false).getBytes(this.contentTypeCharsetName);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected void serializeContent(OutputStream os, boolean consume) throws MessageException {
        try {
            MessageXMLUtils.getInstance(this.messageFactory).writeTo((Element)this.content, os, true, this.contentTypeCharsetName);
            os.flush();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isProblemDetailsForHttpApis_RFC7807() throws MessageException, MessageNotSupportedException {
        try {
            if (this.contentType == null) {
                return false;
            }
            String baseType = ContentTypeUtilities.readBaseTypeFromContentType((String)this.contentType);
            return "application/problem+xml".equalsIgnoreCase(baseType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void addElement(String name, String value) throws MessageException, MessageNotSupportedException {
        this._processElement(name, null, value, true, false, null);
    }

    @Override
    public void addElement(String name, String namespace, String value) throws MessageException, MessageNotSupportedException {
        this._processElement(name, namespace, value, true, false, null);
    }

    @Override
    public void addElementIn(String pattern, String name, String value) throws MessageException, MessageNotSupportedException {
        this._processElement(name, null, value, true, false, pattern);
    }

    @Override
    public void addElementIn(String pattern, String name, String namespace, String value) throws MessageException, MessageNotSupportedException {
        this._processElement(name, namespace, value, true, false, pattern);
    }

    @Override
    public void removeElement(String name) throws MessageException, MessageNotSupportedException {
        this._processElement(name, null, null, false, true, null);
    }

    @Override
    public void removeElement(String name, String namespace) throws MessageException, MessageNotSupportedException {
        this._processElement(name, namespace, null, false, true, null);
    }

    @Override
    public void removeElementIn(String pattern, String name) throws MessageException, MessageNotSupportedException {
        this._processElement(name, null, null, false, true, pattern);
    }

    @Override
    public void removeElementIn(String pattern, String name, String namespace) throws MessageException, MessageNotSupportedException {
        this._processElement(name, namespace, null, false, true, pattern);
    }

    public void _processElement(String name, String namespace, String value, boolean add, boolean remove, String pattern) throws MessageException {
        try {
            if (!this.hasContent()) {
                return;
            }
            Element content = (Element)this.getContent();
            Node element = null;
            if (pattern != null) {
                XPathExpressionEngine engine = new XPathExpressionEngine(this.messageFactory);
                DynamicNamespaceContext dnc = new DynamicNamespaceContext();
                dnc.findPrefixNamespace((Node)content);
                element = (Node)engine.getMatchPattern(content, dnc, pattern, XPathReturnType.NODE);
            } else {
                element = content;
            }
            if (remove) {
                List list = MessageXMLUtils.getInstance(this.messageFactory).getNotEmptyChildNodes(element, false);
                ArrayList<Node> removeNodes = new ArrayList<Node>();
                if (list != null && !list.isEmpty()) {
                    for (Node node : list) {
                        if (namespace != null) {
                            if (!namespace.equals(node.getNamespaceURI()) || !name.equals(node.getLocalName())) continue;
                            removeNodes.add(node);
                            continue;
                        }
                        if (node.getNamespaceURI() != null || !name.equals(node.getLocalName())) continue;
                        removeNodes.add(node);
                    }
                }
                while (!removeNodes.isEmpty()) {
                    Node n = (Node)removeNodes.remove(0);
                    element.removeChild(n);
                }
            } else if (add) {
                Element eAdd = null;
                eAdd = namespace != null ? element.getOwnerDocument().createElementNS(namespace, name) : element.getOwnerDocument().createElement(name);
                eAdd.setTextContent(value);
                element.appendChild(eAdd);
            }
        }
        catch (Exception e) {
            if (pattern != null) {
                throw new MessageException("Operazione fallita (pattern: " + pattern + "): " + e.getMessage(), e);
            }
            throw new MessageException("Operazione fallita: " + e.getMessage(), e);
        }
    }
}

