/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;

public class OpenSPCoop2InputStreamDynamicContent
extends CountingInputStream {
    private CountingInputStream is;
    private DumpByteArrayOutputStream buffer;
    private boolean isReadAll = false;

    public OpenSPCoop2InputStreamDynamicContent(CountingInputStream is, DumpByteArrayOutputStream buffer) {
        super(null);
        this.is = is;
        this.buffer = buffer;
    }

    public CountingInputStream getWrappedInputStream() {
        return this.is;
    }

    public DumpByteArrayOutputStream getBuffer() {
        return this.buffer;
    }

    public boolean isInputStreamConsumed() {
        return this.isReadAll;
    }

    public int read() throws IOException {
        int r = this.is.read();
        if (this.buffer != null && r != -1) {
            this.buffer.write(r);
        }
        if (r == -1) {
            this.isReadAll = true;
        }
        return r;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.is.read(b, off, len);
        if (this.buffer != null && r != -1) {
            this.buffer.write(b, off, r);
        }
        if (r == -1) {
            this.isReadAll = true;
        }
        return r;
    }

    public int read(byte[] b) throws IOException {
        int r = this.is.read(b);
        if (this.buffer != null && r != -1) {
            this.buffer.write(b, 0, r);
        }
        if (r == -1) {
            this.isReadAll = true;
        }
        return r;
    }

    public synchronized long getByteCount() {
        return this.is.getByteCount();
    }

    public int getCount() {
        return this.is.getCount();
    }

    public synchronized long resetByteCount() {
        return this.is.resetByteCount();
    }

    public int resetCount() {
        return this.is.resetCount();
    }

    public synchronized long skip(long length) throws IOException {
        return this.is.skip(length);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public byte[] readAllBytes() throws IOException {
        return this.is.readAllBytes();
    }

    public byte[] readNBytes(int len) throws IOException {
        return this.is.readNBytes(len);
    }

    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.is.readNBytes(b, off, len);
    }

    public long transferTo(OutputStream out) throws IOException {
        return this.is.transferTo(out);
    }

    public int hashCode() {
        return this.is.hashCode();
    }

    public boolean equals(Object obj) {
        return this.is.equals(obj);
    }

    public String toString() {
        return this.is.toString();
    }
}

