/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.QueueManager;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.diagnostica.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciamentoOpenSPCoopAppender;

public class TimerMonitoraggioRisorse
extends Thread {
    public static boolean risorseDisponibili = true;
    public static Exception risorsaNonDisponibile = null;
    public static final String ID_MODULO = "MonitoraggioRisorse";
    private boolean stop = false;
    private OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
    private MsgDiagnostico msgDiag = new MsgDiagnostico(this.propertiesReader.getIdentitaPortaDefault(null), "MonitoraggioRisorse", new IState[0]);
    private boolean lastCheck = true;
    private Logger logger = null;
    private DBManager dbManager = null;
    private QueueManager queueManager = null;
    private ConfigurazionePdDManager configPdDReader = null;
    private RegistroServiziManager registriPdDReader = null;
    private Vector<ITracciamentoOpenSPCoopAppender> tracciamentiPersonalizzati = null;
    private Vector<String> tipiTracciamentiPersonalizzati = null;
    private Vector<IMsgDiagnosticoOpenSPCoopAppender> msgDiagnosticiPersonalizzati = null;
    private Vector<String> tipiMsgDiagnosticiPersonalizzati = null;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerMonitoraggioRisorse() {
        this.msgDiag.setPrefixMsgPersonalizzati("timerMonitoraggioRisorse.");
        this.msgDiag.addKeyword("@ID_TIMER_MONITORAGGIO_RISORSE@", ID_MODULO);
        this.logger = OpenSPCoop2Logger.getLoggerOpenSPCoopResources();
        if (this.propertiesReader.isAbilitatoControlloRisorseDB()) {
            this.dbManager = DBManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseJMS()) {
            this.queueManager = QueueManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseConfigurazione() || this.propertiesReader.isAbilitatoControlloValidazioneSemanticaConfigurazione()) {
            this.configPdDReader = ConfigurazionePdDManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseRegistriServizi() || this.propertiesReader.isAbilitatoControlloValidazioneSemanticaRegistriServizi()) {
            this.registriPdDReader = RegistroServiziManager.getInstance();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
            this.tracciamentiPersonalizzati = OpenSPCoop2Logger.getLoggerTracciamentoOpenSPCoopAppender();
            this.tipiTracciamentiPersonalizzati = OpenSPCoop2Logger.getTipoTracciamentoOpenSPCoopAppender();
        }
        if (this.propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati()) {
            this.msgDiagnosticiPersonalizzati = OpenSPCoop2Logger.getLoggerMsgDiagnosticoOpenSPCoopAppender();
            this.tipiMsgDiagnosticiPersonalizzati = OpenSPCoop2Logger.getTipoMsgDiagnosticoOpenSPCoopAppender();
        }
    }

    @Override
    public void run() {
        String sec = "secondi";
        if (this.propertiesReader.getControlloRisorseCheckInterval() == 1L) {
            sec = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.propertiesReader.getControlloRisorseCheckInterval() + " " + sec);
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        String risorsaNonDisponibile = null;
        block18: while (!this.stop) {
            int i;
            boolean checkRisorseDisponibili = true;
            if (OpenSPCoop2Startup.contextDestroyed) {
                this.logger.error((Object)"[MonitoraggioRisorse] Rilevato sistema in shutdown");
                return;
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati()) {
                String tipoMsgDiagnostico = null;
                try {
                    for (i = 0; i < this.tipiMsgDiagnosticiPersonalizzati.size(); ++i) {
                        tipoMsgDiagnostico = this.tipiMsgDiagnosticiPersonalizzati.get(i);
                        this.logger.debug((Object)("Controllo MsgDiagnosticoPersonalizzato [" + tipoMsgDiagnostico + "] di OpenSPCoop"));
                        this.msgDiagnosticiPersonalizzati.get(i).isAlive();
                    }
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[MessaggioDiagnosticoAppender " + tipoMsgDiagnostico + "]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseDB()) {
                try {
                    this.logger.debug((Object)"Controllo Database di OpenSPCoop");
                    this.dbManager.isAlive();
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[Database della Porta di Dominio]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (this.propertiesReader.isServerJ2EE().booleanValue() && checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseJMS()) {
                try {
                    this.logger.debug((Object)"Controllo BrokerJMS di OpenSPCoop");
                    this.queueManager.isAlive();
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[Broker JMS della Porta di Dominio]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseConfigurazione()) {
                try {
                    this.logger.debug((Object)"Controllo Configurazione di OpenSPCoop");
                    this.configPdDReader.isAlive();
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[Configurazione della Porta di Dominio]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloValidazioneSemanticaConfigurazione()) {
                try {
                    this.logger.debug((Object)"Controllo Validazione semantica della Configurazione di OpenSPCoop");
                    ClassNameProperties classNameReader = ClassNameProperties.getInstance();
                    this.configPdDReader.validazioneSemantica(classNameReader.getConnettore(), classNameReader.getMsgDiagnosticoOpenSPCoopAppender(), classNameReader.getTracciamentoOpenSPCoopAppender(), classNameReader.getAutenticazione(), classNameReader.getAutorizzazione(), classNameReader.getAutorizzazioneContenuto(), classNameReader.getAutorizzazioneContenutoBuste(), classNameReader.getIntegrazionePortaDelegata(), classNameReader.getIntegrazionePortaApplicativa(), true, true, true, null);
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[Validazione semantica della Configurazione della Porta di Dominio]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseRegistriServizi()) {
                try {
                    this.logger.debug((Object)"Controllo Registri dei Servizi");
                    this.registriPdDReader.isAlive(this.propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale());
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[Registri dei Servizi]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloValidazioneSemanticaRegistriServizi()) {
                try {
                    ProtocolFactoryManager pFactoryManager = ProtocolFactoryManager.getInstance();
                    this.logger.debug((Object)"Controllo Validazione semantica del Registri dei Servizi");
                    this.registriPdDReader.validazioneSemantica(this.propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale(), this.propertiesReader.isValidazioneSemanticaRegistroServiziCheckURI(), pFactoryManager.getSubjectTypesAsArray(), pFactoryManager.getServiceTypesAsArray(), ClassNameProperties.getInstance().getConnettore(), true, true, null);
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[Validazione semantica del Registri dei Servizi]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (checkRisorseDisponibili && this.propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
                String tipoTracciamento = null;
                try {
                    for (i = 0; i < this.tipiTracciamentiPersonalizzati.size(); ++i) {
                        tipoTracciamento = this.tipiTracciamentiPersonalizzati.get(i);
                        this.logger.debug((Object)("Controllo TracciamentoPersonalizzato [" + tipoTracciamento + "] di OpenSPCoop"));
                        this.tracciamentiPersonalizzati.get(i).isAlive();
                    }
                }
                catch (Exception e) {
                    risorsaNonDisponibile = "[TracciamentoAppender " + tipoTracciamento + "]";
                    TimerMonitoraggioRisorse.risorsaNonDisponibile = new CoreException(risorsaNonDisponibile + " " + e.getMessage(), (Throwable)e);
                    this.logger.error((Object)(risorsaNonDisponibile + " " + e.getMessage()), (Throwable)e);
                    checkRisorseDisponibili = false;
                }
            }
            if (risorsaNonDisponibile != null) {
                this.msgDiag.addKeyword("@RISORSA_NON_DISPONIBILE@", risorsaNonDisponibile);
            }
            if (!checkRisorseDisponibili && this.lastCheck) {
                if (risorsaNonDisponibile != null && !risorsaNonDisponibile.startsWith("[MessaggioDiagnosticoAppender")) {
                    if (risorsaNonDisponibile.startsWith("[Validazione semantica")) {
                        this.msgDiag.logPersonalizzato("validazioneSemanticaFallita");
                    } else {
                        this.msgDiag.logPersonalizzato("risorsaNonDisponibile");
                    }
                } else {
                    this.logger.warn((Object)("Il Monitoraggio delle risorse ha rilevato che la risorsa " + risorsaNonDisponibile + " non e' raggiungibile, tutti i servizi/moduli della porta di dominio sono momentanemanete sospesi."));
                }
            } else if (checkRisorseDisponibili && !this.lastCheck) {
                this.msgDiag.logPersonalizzato("risorsaRitornataDisponibile");
                risorsaNonDisponibile = null;
            }
            this.lastCheck = checkRisorseDisponibili;
            risorseDisponibili = checkRisorseDisponibili;
            if (this.stop) continue;
            int i2 = 0;
            while ((long)i2 < this.propertiesReader.getControlloRisorseCheckInterval()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.stop) continue block18;
                ++i2;
            }
        }
    }
}

