/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.utils.date.DateManager;

public class TimerGestoreRepositoryBusteLib {
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;

    public TimerGestoreRepositoryBusteLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, boolean orderByQuery) {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error((Object)"[GestoreRepositoryBuste] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error((Object)msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.logTimer.error((Object)("[GestoreRepositoryBuste] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error((Object)("[GestoreRepositoryBuste] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryBuste = DateManager.getTimeMillis();
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(null), "GestoreRepositoryBuste", null);
            RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), this.logTimer, null);
            boolean trovatiMessaggi = true;
            while (trovatiMessaggi) {
                trovatiMessaggi = false;
                String causaMessaggiINBOX = "Eliminazione buste (INBOX) marcate logicamente da eliminare";
                Vector idMsgINBOX = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiINBOX, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgINBOX = repositoryBuste.getBusteDaEliminareFromInBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.propertiesReader.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione(), this.orderByQuery);
                    if (idMsgINBOX.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovate " + idMsgINBOX.size() + " buste da eliminare nel repository (INBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                        for (int i = 0; i < idMsgINBOX.size(); ++i) {
                            String idMsgDaEliminare = (String)idMsgINBOX.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                repositoryBuste.eliminaBustaFromInBox(idMsgDaEliminare);
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneBustaInbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminate " + idMsgINBOX.size() + " buste nel repository (INBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono state trovate buste da eliminare nel repository (INBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiINBOX);
                    }
                    catch (Exception e) {}
                }
                String causaMessaggiOUTBOX = "Eliminazione buste (OUTBOX) marcate logicamente da eliminare";
                Vector idMsgOUTBOX = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiOUTBOX, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgOUTBOX = repositoryBuste.getBusteDaEliminareFromOutBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.propertiesReader.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione(), this.orderByQuery);
                    if (idMsgOUTBOX.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovate " + idMsgOUTBOX.size() + " buste da eliminare nel repository (OUTBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                        for (int i = 0; i < idMsgOUTBOX.size(); ++i) {
                            String idMsgDaEliminare = (String)idMsgOUTBOX.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                repositoryBuste.eliminaBustaFromOutBox(idMsgDaEliminare);
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneBustaOutbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminate " + idMsgOUTBOX.size() + " buste nel repository (OUTBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono state trovate buste da eliminare nel repository (OUTBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiOUTBOX);
                    }
                    catch (Exception e) {}
                }
                if (!trovatiMessaggi) continue;
                this.msgDiag.addKeyword("@NUMERO_BUSTE_INBOX@", idMsgINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_BUSTE_OUTBOX@", idMsgOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
            }
            long endControlloRepositoryBuste = DateManager.getTimeMillis();
            this.logTimer.info((Object)("Controllo Repository Buste terminata in " + (endControlloRepositoryBuste - startControlloRepositoryBuste) / 1000L + " secondi"));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBuste");
            this.logTimer.error((Object)("Riscontrato errore durante l'eliminazione delle buste: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

