/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.date.DateManager;

public class TimerGestorePuliziaMessaggiAnomaliLib {
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;

    public TimerGestorePuliziaMessaggiAnomaliLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, boolean orderByQuery) {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error((Object)"[GestoreConsistenzaDatabase] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error((Object)msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.logTimer.error((Object)("[GestoreConsistenzaDatabase] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error((Object)("[GestoreConsistenzaDatabase] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryMessaggi = DateManager.getTimeMillis();
        RollbackRepositoryBuste rollbackMessaggio = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(null), "GestoreConsistenzaDatabase", null);
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.logTimer, this.msgDiag, null);
            Vector<String> busteInutiliINBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromInBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
            Vector<String> busteInutiliOUTBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromOutBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
            if (this.logQuery && busteInutiliINBOX.size() <= 0 && busteInutiliOUTBOX.size() <= 0) {
                this.logTimer.info((Object)"Non sono stati trovati messaggi anomali");
            }
            while (busteInutiliINBOX.size() > 0 || busteInutiliOUTBOX.size() > 0) {
                String idMsgDaEliminare;
                int i;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_INBOX@", busteInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INCONSISTENTI_OUTBOX@", busteInutiliOUTBOX.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
                if (this.logQuery) {
                    this.logTimer.info((Object)("Trovate " + busteInutiliINBOX.size() + " buste non piu' riferita da messaggi da eliminare (INBOX) ..."));
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                for (i = 0; i < busteInutiliINBOX.size(); ++i) {
                    idMsgDaEliminare = busteInutiliINBOX.get(i);
                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackMessaggio.rollbackBustaIntoInBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        if (!this.logQuery) continue;
                        this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaInbox(" + idMsgDaEliminare + ")");
                        this.logTimer.error((Object)("ErroreEliminazioneBustaInbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                    }
                }
                if (this.logQuery) {
                    this.logTimer.info((Object)("Eliminate " + busteInutiliINBOX.size() + " buste non piu' riferita da messaggi (INBOX)"));
                }
                if (this.logQuery) {
                    this.logTimer.info((Object)("Trovate " + busteInutiliOUTBOX.size() + " buste non piu' riferita da messaggi da eliminare (OUTBOX) ..."));
                }
                this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                for (i = 0; i < busteInutiliOUTBOX.size(); ++i) {
                    idMsgDaEliminare = busteInutiliOUTBOX.get(i);
                    this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                    try {
                        rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                        rollbackMessaggio.rollbackBustaIntoOutBox(false);
                        ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                        this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                        if (!this.logQuery) continue;
                        this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                        continue;
                    }
                    catch (Exception e) {
                        if (rollbackMessaggio != null) {
                            ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            rollbackMessaggio = null;
                        }
                        this.msgDiag.logErroreGenerico(e, "EliminazioneBustaOutbox(" + idMsgDaEliminare + ")");
                        this.logTimer.error((Object)("EliminazioneBustaOutbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                    }
                }
                if (this.logQuery) {
                    this.logTimer.info((Object)("Eliminate " + busteInutiliOUTBOX.size() + " buste non piu' riferita da messaggi (OUTBOX)"));
                }
                busteInutiliINBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromInBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
                busteInutiliOUTBOX = gestoreMsgSearch.readBusteNonRiferiteDaMessaggiFromOutBox(this.limit, this.logQuery, this.propertiesReader.isForceIndex(), this.orderByQuery);
            }
            long endControlloRepositoryMessaggi = DateManager.getTimeMillis();
            this.logTimer.info((Object)("Pulizia Messaggi Anomali terminata in " + (endControlloRepositoryMessaggi - startControlloRepositoryMessaggi) / 1000L + " secondi"));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiInconsistenti");
            this.logTimer.error((Object)("Riscontrato errore durante la pulizia dei messaggi anomali: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

