/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.CheckStatoPdD;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.RicezioneBusteAPIConnector;
import org.openspcoop2.pdd.services.connector.RicezioneBusteSOAPConnector;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiAPIConnector;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiHTTPtoSOAPConnector;
import org.openspcoop2.pdd.services.connector.RicezioneContenutiApplicativiSOAPConnector;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;

public class OpenSPCoop2Servlet
extends HttpServlet {
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.DELETE);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.GET);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.HEAD);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.OPTIONS);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.POST);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.PUT);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.dispatch(req, resp, MethodType.TRACE);
    }

    private void dispatch(HttpServletRequest req, HttpServletResponse res, MethodType method) throws ServletException, IOException {
        block48: {
            Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            Logger logOpenSPCoop2Servlet = Logger.getLogger((String)"openspcoop2.startup");
            boolean doPost = MethodType.POST.equals(method);
            OpenSPCoop2Properties op2Properties = null;
            try {
                op2Properties = OpenSPCoop2Properties.getInstance();
                URLProtocolContext protocolContext = new URLProtocolContext(req, logCore);
                String function = protocolContext.getFunction();
                IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByServletContext(protocolContext.getProtocol());
                if (pf == null) {
                    if (!"@EMPTY@".equals(protocolContext.getProtocol())) {
                        throw new Exception("Non risulta registrato un protocollo con contesto [" + protocolContext.getProtocol() + "]");
                    }
                    throw new Exception("Non risulta registrato un protocollo con contesto speciale 'vuoto'");
                }
                if (function.equals("PD")) {
                    RicezioneContenutiApplicativiSOAPConnector r = new RicezioneContenutiApplicativiSOAPConnector();
                    r.init();
                    if (doPost) {
                        r.doPost(req, res);
                    } else {
                        r.engine(req, res, method);
                    }
                    break block48;
                }
                if (function.equals("PDtoSOAP")) {
                    RicezioneContenutiApplicativiHTTPtoSOAPConnector r = new RicezioneContenutiApplicativiHTTPtoSOAPConnector();
                    r.init();
                    if (doPost) {
                        r.doPost(req, res);
                    } else {
                        r.engine(req, res, method);
                    }
                    break block48;
                }
                if (function.equals("PA")) {
                    RicezioneBusteSOAPConnector r = new RicezioneBusteSOAPConnector();
                    r.init();
                    if (doPost) {
                        r.doPost(req, res);
                    } else {
                        r.engine(req, res, method);
                    }
                    break block48;
                }
                if (function.equals("IntegrationManager")) {
                    boolean wsdl = false;
                    if (MethodType.GET.equals(method)) {
                        Enumeration parameters = req.getParameterNames();
                        while (parameters.hasMoreElements()) {
                            String key = (String)parameters.nextElement();
                            String value = req.getParameter(key);
                            if (!"wsdl".equalsIgnoreCase(key) || value != null && !"".equals(value)) continue;
                            if (op2Properties != null && !op2Properties.isGenerazioneWsdlIntegrationManagerEnabled()) {
                                res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeWsdlUnsupported(IDService.INTEGRATION_MANAGER_SOAP)));
                                return;
                            }
                            wsdl = true;
                            break;
                        }
                    }
                    if (!doPost && !wsdl) {
                        boolean errore404 = false;
                        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedIntegrationManagerEnabled()) {
                            errore404 = true;
                        }
                        if (errore404) {
                            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(IDService.INTEGRATION_MANAGER_SOAP, method)));
                            return;
                        }
                        res.setStatus(500);
                        ConnectorUtils.generateErrorMessage(IDService.INTEGRATION_MANAGER_SOAP, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
                        try {
                            res.getOutputStream().flush();
                        }
                        catch (Exception eClose) {
                            // empty catch block
                        }
                        try {
                            res.getOutputStream().close();
                        }
                        catch (Exception eClose) {
                            // empty catch block
                        }
                        return;
                    }
                    String forwardUrl = "/IntegrationManagerEngine/" + protocolContext.getFunctionParameters();
                    req.setAttribute("PROTOCOLLO", (Object)protocolContext.getProtocol());
                    req.setAttribute("INTEGRATION_MANAGER_ENGINE_DIRECT_INVOCATION", (Object)true);
                    RequestDispatcher dispatcher = req.getRequestDispatcher(forwardUrl);
                    dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                    break block48;
                }
                if (function.equals("checkPdD")) {
                    if (!MethodType.GET.equals(method)) {
                        boolean errore404 = false;
                        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedCheckPdDEnabled()) {
                            errore404 = true;
                        }
                        if (errore404) {
                            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(IDService.CHECK_PDD, method)));
                            return;
                        }
                        res.setStatus(500);
                        ConnectorUtils.generateErrorMessage(IDService.CHECK_PDD, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
                        try {
                            res.getOutputStream().flush();
                        }
                        catch (Exception eClose) {
                            // empty catch block
                        }
                        try {
                            res.getOutputStream().close();
                        }
                        catch (Exception eClose) {
                            // empty catch block
                        }
                        return;
                    }
                    CheckStatoPdD checkStatoPdD = new CheckStatoPdD();
                    req.setAttribute("PROTOCOLLO", (Object)protocolContext.getProtocol());
                    checkStatoPdD.doGet(req, res);
                    break block48;
                }
                if (function.equals("API/PD")) {
                    if (!op2Properties.isAPIServicesEnabled()) {
                        res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeFunctionUnsupported(IDService.PORTA_DELEGATA_API)));
                        return;
                    }
                    RicezioneContenutiApplicativiAPIConnector r = new RicezioneContenutiApplicativiAPIConnector();
                    r.init();
                    r.engine(req, res);
                    break block48;
                }
                if (function.equals("API/PA")) {
                    if (!op2Properties.isAPIServicesEnabled()) {
                        res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeFunctionUnsupported(IDService.PORTA_APPLICATIVA_API)));
                        return;
                    }
                    RicezioneBusteAPIConnector r = new RicezioneBusteAPIConnector();
                    r.init();
                    r.engine(req, res);
                    break block48;
                }
                if (function.equals("API/MessageBox")) {
                    if (!op2Properties.isAPIServicesEnabled()) {
                        res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeFunctionUnsupported(IDService.INTEGRATION_MANAGER_API)));
                        return;
                    }
                    throw new Exception("Service [" + function + "] not implemented (TODO)");
                }
                throw new Exception("Service [" + function + "] not supported");
            }
            catch (Exception e) {
                StringBuffer bf = new StringBuffer();
                bf.append("RemoteAddr[" + req.getRemoteAddr() + "] ");
                bf.append("RemoteHost[" + req.getRemoteHost() + "] ");
                bf.append("RemotePort[" + req.getRemotePort() + "] ");
                bf.append("RemoteUser[" + req.getRemoteUser() + "] ");
                bf.append("LocalAddr[" + req.getLocalAddr() + "] ");
                bf.append("LocalHost[" + req.getLocalName() + "] ");
                bf.append("LocalPort[" + req.getLocalPort() + "] ");
                bf.append("ServerName[" + req.getServerName() + "] ");
                bf.append("ServerPort[" + req.getServerPort() + "] ");
                if (logCore != null) {
                    logCore.error((Object)e.getMessage(), (Throwable)e);
                    logCore.error((Object)("Detail: " + bf.toString()));
                } else {
                    logOpenSPCoop2Servlet.error((Object)e.getMessage(), (Throwable)e);
                    logOpenSPCoop2Servlet.error((Object)("Detail: " + bf.toString()));
                }
                StringBuffer bfLogError = new StringBuffer();
                ConnectorUtils.generateErrorMessage(IDService.OPENSPCOOP2_SERVLET, method, req, bfLogError, e.getMessage(), true, false);
                if (logCore != null) {
                    logCore.error((Object)bfLogError.toString());
                } else {
                    logOpenSPCoop2Servlet.error((Object)bfLogError.toString());
                }
                boolean errore404 = true;
                if (op2Properties != null && op2Properties.isGenerazioneErroreProtocolloNonSupportato()) {
                    errore404 = false;
                }
                if (errore404) {
                    res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeProtocolUnsupported(IDService.OPENSPCOOP2_SERVLET)));
                }
                res.setStatus(500);
                ConnectorUtils.generateErrorMessage(IDService.OPENSPCOOP2_SERVLET, method, req, res, e.getMessage(), true, true);
                try {
                    res.getOutputStream().flush();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    res.getOutputStream().close();
                }
                catch (Exception eClose) {
                    // empty catch block
                }
            }
        }
    }
}

