/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorOutMessage;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.RFC2047Encoding;
import org.openspcoop2.utils.resources.RFC2047Utilities;

public class HttpServletConnectorOutMessage
implements ConnectorOutMessage {
    protected HttpServletResponse res;
    protected OutputStream out;
    protected IProtocolFactory protocolFactory;
    protected String idModulo;
    protected IDService idModuloAsIDService;
    protected OpenSPCoop2Properties openspcoopProperties;
    private int status = -1;

    public HttpServletConnectorOutMessage(IProtocolFactory protocolFactory, HttpServletResponse res, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        try {
            this.res = res;
            this.out = this.res.getOutputStream();
            this.protocolFactory = protocolFactory;
            this.idModuloAsIDService = idModuloAsIDService;
            this.idModulo = idModulo;
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void sendResponse(OpenSPCoop2Message msg, boolean consume) throws ConnectorException {
        try {
            if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                msg.saveChanges();
            }
            msg.writeTo(this.out, consume);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void sendResponse(byte[] message) throws ConnectorException {
        try {
            this.out.write(message);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setHeader(String key, String value) throws ConnectorException {
        try {
            boolean encodingRFC2047 = false;
            Charset charsetRFC2047 = null;
            RFC2047Encoding encodingAlgorithmRFC2047 = null;
            if (this.idModuloAsIDService != null) {
                switch (this.idModuloAsIDService) {
                    case PORTA_DELEGATA_SOAP: 
                    case PORTA_DELEGATA_INTEGRATION_MANAGER: 
                    case PORTA_DELEGATA_XML_TO_SOAP: 
                    case PORTA_DELEGATA_API: {
                        encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_ricezioneContenutiApplicativi();
                        charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_ricezioneContenutiApplicativi();
                        encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_ricezioneContenutiApplicativi();
                        break;
                    }
                    case PORTA_APPLICATIVA_SOAP: 
                    case PORTA_APPLICATIVA_API: {
                        encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_ricezioneBuste();
                        charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_ricezioneBuste();
                        encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_ricezioneBuste();
                        break;
                    }
                }
            }
            if (encodingRFC2047) {
                if (!RFC2047Utilities.isAllCharactersInCharset((String)value, charsetRFC2047)) {
                    String encoded = RFC2047Utilities.encode((String)new String(value), charsetRFC2047, encodingAlgorithmRFC2047);
                    this.res.setHeader(key, encoded);
                } else {
                    this.res.setHeader(key, value);
                }
            } else {
                this.res.setHeader(key, value);
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setContentLength(int length) throws ConnectorException {
        try {
            this.res.setContentLength(length);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setContentType(String type) throws ConnectorException {
        try {
            this.res.setContentType(type);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setStatus(int status) throws ConnectorException {
        try {
            this.res.setStatus(status);
            this.status = status;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public int getResponseStatus() throws ConnectorException {
        return this.status;
    }

    @Override
    public void flush(boolean throwException) throws ConnectorException {
        block10: {
            try {
                block9: {
                    if (this.res != null) {
                        try {
                            this.res.flushBuffer();
                        }
                        catch (Exception e) {
                            if (!throwException) break block9;
                            throw e;
                        }
                    }
                }
                if (this.out == null) break block10;
                try {
                    this.out.flush();
                }
                catch (Exception e) {
                    if (throwException) {
                        throw e;
                    }
                }
            }
            catch (ConnectorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void close(boolean throwException) throws ConnectorException {
        block6: {
            try {
                if (this.out == null) break block6;
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (Exception e) {
                    if (throwException) {
                        throw e;
                    }
                }
            }
            catch (ConnectorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }
}

