/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.Identity;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public class HttpServletConnectorInMessage
implements ConnectorInMessage {
    public static OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();
    protected HttpServletRequest req;
    protected OpenSPCoop2Properties openspcoopProperties;
    protected OpenSPCoop2Message message;
    protected InputStream is;
    protected Logger log;
    protected String idModulo;
    private IDService idModuloAsIDService;
    protected Identity identity;

    public HttpServletConnectorInMessage(HttpServletRequest req, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        try {
            this.req = req;
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
            this.is = this.req.getInputStream();
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                this.log = Logger.getLogger(HttpServletConnectorInMessage.class);
            }
            this.idModuloAsIDService = idModuloAsIDService;
            this.idModulo = idModulo;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public IDService getIdModuloAsIDService() {
        return this.idModuloAsIDService;
    }

    @Override
    public String getIdModulo() {
        return this.idModulo;
    }

    @Override
    public Object getAttribute(String key) throws ConnectorException {
        return this.req.getAttribute(key);
    }

    @Override
    public String getHeader(String key) throws ConnectorException {
        return this.req.getHeader(key);
    }

    @Override
    public String getParameter(String key) throws ConnectorException {
        return this.req.getParameter(key);
    }

    @Override
    public IProtocolFactory getProtocolFactory() throws ConnectorException {
        try {
            return ProtocolFactoryManager.getInstance().getProtocolFactoryByServletContext(this.req);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getContentType() throws ConnectorException {
        try {
            return ServletUtils.readContentTypeFromHeader(this.req);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getSOAPAction(SOAPVersion versioneSoap, String contentType) throws ConnectorException {
        try {
            return ServletUtils.getSoapAction(this.req, versioneSoap, contentType);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public OpenSPCoop2Message getRequest(NotifierInputStreamParams notifierInputStreamParams, String contentType) throws ConnectorException {
        try {
            this.message = factory.createMessage(this.is, notifierInputStreamParams, false, contentType, this.req.getContextPath(), this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
            return this.message;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getRequest() throws ConnectorException {
        try {
            return Utilities.getAsByteArray((InputStream)this.is);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public URLProtocolContext getURLProtocolContext() throws ConnectorException {
        try {
            return ServletUtils.getParametriInvocazionePorta(this.req, this.log);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public Credenziali getCredenziali() throws ConnectorException {
        try {
            return ServletUtils.getCredenziali(this.req, this.log);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getLocation(Credenziali credenziali) throws ConnectorException {
        try {
            return ServletUtils.getLocation(this.req, credenziali);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getProtocol() throws ConnectorException {
        return this.req.getProtocol();
    }

    @Override
    public int getContentLength() throws ConnectorException {
        return this.req.getContentLength();
    }

    @Override
    public void close() throws ConnectorException {
        try {
            if (this.is != null) {
                try {
                    this.is.close();
                    this.is = null;
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public Identity getIdentity() throws ConnectorException {
        if (this.identity == null) {
            this.initIdentity();
        }
        return this.identity;
    }

    private synchronized void initIdentity() {
        if (this.identity == null) {
            this.identity = new Identity(this.req);
        }
    }
}

