/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.resources.MapReader;

public class ConnectorUtils {
    public static Logger getErrorLog() {
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = Logger.getLogger(ConnectorUtils.class);
        }
        return log;
    }

    public static String getMessageHttpMethodNotSupported(MethodType method) {
        return "Method HTTP @METHOD@ non supportato".replace("@METHOD@", method.name());
    }

    private static StringBuffer getPrefixCode(IDService idService) {
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
        }
        if (log == null) {
            log = Logger.getLogger(ConnectorUtils.class);
        }
        StringBuffer bf = new StringBuffer();
        try {
            bf.append(idService.getCode()).append("-");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            bf = new StringBuffer();
            bf.append("0000000");
        }
        return bf;
    }

    public static String getFullCodeProtocolUnsupported(IDService idService) {
        StringBuffer bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0001");
        return bf.toString();
    }

    public static String getFullCodeWsdlUnsupported(IDService idService) {
        StringBuffer bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0021");
        return bf.toString();
    }

    public static String getFullCodeEngineFilter(IDService idService) {
        StringBuffer bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0031");
        return bf.toString();
    }

    public static String getFullCodeFunctionUnsupported(IDService idService) {
        StringBuffer bf = ConnectorUtils.getPrefixCode(idService);
        bf.append("0041");
        return bf.toString();
    }

    public static String getFullCodeHttpMethodNotSupported(IDService idService, MethodType method) {
        StringBuffer bf = ConnectorUtils.getPrefixCode(idService);
        switch (method) {
            case GET: {
                bf.append("0011");
                break;
            }
            case POST: {
                bf.append("0012");
                break;
            }
            case PUT: {
                bf.append("0013");
                break;
            }
            case HEAD: {
                bf.append("0014");
                break;
            }
            case DELETE: {
                bf.append("0015");
                break;
            }
            case OPTIONS: {
                bf.append("0016");
                break;
            }
            case TRACE: {
                bf.append("0017");
            }
        }
        return bf.toString();
    }

    public static String generateError404Message(String code) {
        return "OpenSPCoop2-" + code;
    }

    public static void generateErrorMessage(IDService idService, MethodType httpMethod, HttpServletRequest req, HttpServletResponse res, String msgErrore, boolean erroreGenerale, boolean htmlMessage) throws IOException {
        ConnectorUtils.generateErrorMessage(idService, httpMethod, req, res, msgErrore, erroreGenerale, htmlMessage, null);
    }

    public static void generateErrorMessage(IDService idService, MethodType httpMethod, HttpServletRequest req, StringBuffer log, String msgErrore, boolean erroreGenerale, boolean htmlMessage) throws IOException {
        ConnectorUtils.generateErrorMessage(idService, httpMethod, req, null, msgErrore, erroreGenerale, htmlMessage, log);
    }

    private static void generateErrorMessage(IDService idService, MethodType httpMethod, HttpServletRequest req, HttpServletResponse response, String msgErrore, boolean erroreGenerale, boolean htmlMessage, StringBuffer log) throws IOException {
        boolean doBody;
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        String versione = "Porta di Dominio OpenSPCoop2/tags_2.2.1";
        if (op2Properties != null) {
            versione = "Porta di Dominio " + op2Properties.getPddDetailsForServices();
        }
        if (htmlMessage) {
            versione = StringEscapeUtils.escapeHtml((String)versione);
            if (response != null) {
                response.setContentType("text/html");
            }
        } else if (response != null) {
            response.setContentType("text/plain");
        }
        boolean bl = doBody = !MethodType.HEAD.equals(httpMethod);
        if (!doBody) {
            if (log != null) {
                log.append("X-OpenSPCoop2-Pdd").append("=").append(versione);
                log.append("X-OpenSPCoop2-PddDetails").append("=").append(msgErrore);
            } else {
                response.setHeader("X-OpenSPCoop2-Pdd", versione);
                response.setHeader("X-OpenSPCoop2-PddDetails", msgErrore);
                response.setContentLength(0);
            }
            return;
        }
        StringBuffer risposta = new StringBuffer();
        risposta.append("<html>\n");
        risposta.append("<head>\n");
        risposta.append("<title>" + versione + "</title>\n");
        risposta.append("</head>\n");
        risposta.append("<body>\n");
        risposta.append("<h1>" + versione + "</h1>\n");
        String function = null;
        String parameters = null;
        try {
            URLProtocolContext protocolContext = new URLProtocolContext(req, logCore);
            String url = protocolContext.getUrlInvocazione_formBased();
            if (url.endsWith("?wsdl=")) {
                url = url.substring(0, url.length() - "=".length());
            }
            if (htmlMessage) {
                url = StringEscapeUtils.escapeHtml((String)url);
            }
            risposta.append("<p>" + url + "</p>\n");
            function = protocolContext.getFunction();
            parameters = protocolContext.getFunctionParameters();
        }
        catch (Exception e) {
            if (logCore == null) {
                Logger.getLogger(ConnectorUtils.class).error((Object)e.getMessage(), (Throwable)e);
            } else {
                logCore.error((Object)e.getMessage(), (Throwable)e);
            }
            String context = req.getContextPath();
            if (htmlMessage) {
                context = StringEscapeUtils.escapeHtml((String)context);
            }
            risposta.append("<p>" + context + "</p>\n");
        }
        String errore = msgErrore;
        if (htmlMessage) {
            errore = StringEscapeUtils.escapeHtml((String)errore);
        }
        risposta.append("<p>" + errore + "</p>\n");
        switch (idService) {
            case PORTA_DELEGATA_SOAP: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Delegate esposte dalla PdD OpenSPCoop v2</i><br/><br/>\n");
                break;
            }
            case PORTA_APPLICATIVA_SOAP: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Applicative esposte dalla PdD OpenSPCoop v2</i><br/><br/>\n");
                break;
            }
            case PORTA_DELEGATA_XML_TO_SOAP: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Delegate esposte dalla PdD OpenSPCoop v2, con messaggi xml non imbustati nel protocollo SOAP</i><br/><br/>\n");
                break;
            }
            case INTEGRATION_MANAGER_SOAP: {
                if (parameters == null) {
                    risposta.append("<i>Servizio IntegrationManager</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).equals("IntegrationManager/PD")) {
                    risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Delegate esposte dalla PdD OpenSPCoop v2</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).startsWith("IntegrationManager/PD/")) {
                    risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Delegate esposte dalla PdD OpenSPCoop v2</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).equals("IntegrationManager/MessageBox")) {
                    risposta.append("<i>Servizio utilizzabile per accedere alla MessageBox esposta dalla PdD OpenSPCoop v2</i><br/><br/>\n");
                    break;
                }
                if ((function + "/" + parameters).startsWith("IntegrationManager/MessageBox/")) {
                    risposta.append("<i>Servizio utilizzabile per accedere alla MessageBox esposta dalla PdD OpenSPCoop v2</i><br/><br/>\n");
                    break;
                }
                risposta.append("<i>Servizio IntegrationManager della PdD OpenSPCoop v2</i><br/><br/>\n");
                break;
            }
            case CHECK_PDD: {
                risposta.append("<i>Servizio utilizzabile per comprendere lo stato di funzionamento della PdD OpenSPCoop v2</i><br/><br/>\n");
                break;
            }
            case PORTA_DELEGATA_API: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Delegate esposte dalla PdD OpenSPCoop v2, attraverso richieste HTTP</i><br/><br/>\n");
                break;
            }
            case PORTA_APPLICATIVA_API: {
                risposta.append("<i>Servizio utilizzabile per l'invocazione di Porte Applicative esposte dalla PdD OpenSPCoop v2, attraverso richieste HTTP</i><br/><br/>\n");
                break;
            }
            case INTEGRATION_MANAGER_API: {
                risposta.append("<i>Servizio utilizzabile per accedere alla MessageBox esposta dalla PdD OpenSPCoop v2, attraverso richieste HTTP</i><br/><br/>\n");
                break;
            }
            default: {
                if (htmlMessage) {
                    String useAs = "Use as http[s]://<server>" + req.getContextPath() + "/<protocol-context>/<service>[/...]";
                    useAs = StringEscapeUtils.escapeHtml((String)useAs);
                    risposta.append("<i>" + useAs + "</i><br/>\n");
                }
                try {
                    MapReader prots = ProtocolFactoryManager.getInstance().getProtocolFactories();
                    if (prots.size() <= 0) {
                        risposta.append("<i>ERROR: No protocol installed</i><br/>\n");
                    } else {
                        StringBuffer bfProtocols = new StringBuffer();
                        Enumeration keys = prots.keys();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            IProtocolFactory pf = (IProtocolFactory)prots.get((Object)key);
                            if (pf.getManifest().getWeb().getEmptyContext() != null && pf.getManifest().getWeb().getEmptyContext().isEnabled()) {
                                if (bfProtocols.length() > 0) {
                                    bfProtocols.append(", ");
                                }
                                bfProtocols.append("\"\" (protocol:" + key + ")");
                            }
                            if (pf.getManifest().getWeb().sizeContextList() <= 0) continue;
                            for (String context : pf.getManifest().getWeb().getContextList()) {
                                if (bfProtocols.length() > 0) {
                                    bfProtocols.append(", ");
                                }
                                bfProtocols.append(context + " (protocol:" + key + ")");
                            }
                        }
                        String enabledProtocols = "Enabled protocol-contexts: " + bfProtocols.toString();
                        if (htmlMessage) {
                            enabledProtocols = StringEscapeUtils.escapeHtml((String)enabledProtocols);
                        }
                        risposta.append("<i>" + enabledProtocols + "</i><br/>\n");
                    }
                }
                catch (Exception e) {
                    if (logCore == null) {
                        Logger.getLogger(ConnectorUtils.class).error((Object)e.getMessage(), (Throwable)e);
                    } else {
                        logCore.error((Object)e.getMessage(), (Throwable)e);
                    }
                    risposta.append("<i>ERROR: No protocol installed</i><br/>\n");
                }
                if (!htmlMessage) break;
                risposta.append("<i>Enabled services: PD, PA, PDtoSOAP, checkPdD, IntegrationManager</i><br/><br/>\n");
                risposta.append("<i>Official website: http://www.openspcoop.org</i><br/><br/>\n");
            }
        }
        risposta.append("</body>\n");
        risposta.append("</html>\n");
        if (log != null) {
            log.append(risposta.toString());
        } else {
            response.getOutputStream().write(risposta.toString().getBytes());
        }
    }
}

