/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.pdd.timers.TimerThreshold;
import org.openspcoop2.utils.Identity;

public class CheckStatoPdD
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String msg;
        String resourceName;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (log == null) {
            log = Logger.getLogger(CheckStatoPdD.class);
        }
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        boolean checkPdDReadEnabled = false;
        if (properties != null && properties.isCheckPdDReadJMXResourcesEnabled()) {
            checkPdDReadEnabled = true;
        }
        if ((resourceName = req.getParameter("resourceName")) != null && !"".equals(resourceName)) {
            if (!checkPdDReadEnabled) {
                String msg2 = "Servizio non abilitato";
                log.error((Object)("[CheckStatoPdD] " + msg2));
                res.setStatus(500);
                res.getOutputStream().write(msg2.getBytes());
                return;
            }
            String username = properties.getCheckPdDReadJMXResourcesUsername();
            String password = properties.getCheckPdDReadJMXResourcesPassword();
            if (username != null && password != null) {
                Identity identity = new Identity(req);
                if (!username.equals(identity.getUsername())) {
                    String msg3 = "Lettura risorsa [" + resourceName + "] non autorizzata";
                    log.error((Object)("[CheckStatoPdD] " + msg3 + ". Richiesta effettuata da un username [" + identity.getUsername() + "]"));
                    res.setStatus(500);
                    res.getOutputStream().write(msg3.getBytes());
                    return;
                }
                if (!password.equals(identity.getPassword())) {
                    String msg4 = "Lettura risorsa [" + resourceName + "] non autorizzata";
                    log.error((Object)("[CheckStatoPdD] " + msg4 + ". Richiesta effettuata da un username [" + identity.getUsername() + "] (password errata)"));
                    res.setStatus(500);
                    res.getOutputStream().write(msg4.getBytes());
                    return;
                }
            }
            String attributeName = req.getParameter("attributeName");
            String attributeValue = req.getParameter("attributeValue");
            String attributeBooleanValue = req.getParameter("attributeBooleanValue");
            String methodName = req.getParameter("methodName");
            if (attributeName != null) {
                if (attributeValue != null || attributeBooleanValue != null) {
                    try {
                        Object v = attributeValue;
                        if (attributeBooleanValue != null) {
                            v = Boolean.parseBoolean(attributeBooleanValue);
                        }
                        OpenSPCoop2Startup.gestoreRisorseJMX_staticInstance.setAttribute(resourceName, attributeName, v);
                    }
                    catch (Exception e) {
                        String msg5 = "Aggiornamento attributo [" + attributeName + "] della risorsa [" + resourceName + "] non riuscita (valore:" + attributeValue + "): " + e.getMessage();
                        log.error((Object)("[CheckStatoPdD] " + msg5), (Throwable)e);
                        res.setStatus(500);
                        res.getOutputStream().write(msg5.getBytes());
                        return;
                    }
                } else {
                    try {
                        Object value = OpenSPCoop2Startup.gestoreRisorseJMX_staticInstance.getAttribute(resourceName, attributeName);
                        res.getOutputStream().write(value.toString().getBytes());
                    }
                    catch (Exception e) {
                        String msg6 = "Lettura attributo [" + attributeName + "] della risorsa [" + resourceName + "] non riuscita: " + e.getMessage();
                        log.error((Object)("[CheckStatoPdD] " + msg6), (Throwable)e);
                        res.setStatus(500);
                        res.getOutputStream().write(msg6.getBytes());
                        return;
                    }
                }
            } else {
                if (attributeValue != null) {
                    String msg7 = "Lettura risorsa [" + resourceName + "] non effettuata, fornito un valore di attributo senza aver indicato il nome";
                    log.error((Object)("[CheckStatoPdD] " + msg7));
                    res.setStatus(500);
                    res.getOutputStream().write(msg7.getBytes());
                    return;
                }
                if (methodName != null) {
                    String paramValue = req.getParameter("paramValue");
                    Object[] params = null;
                    String[] signatures = null;
                    if (paramValue != null && !"".equals(paramValue)) {
                        params = new Object[]{paramValue};
                        signatures = new String[]{String.class.getName()};
                    }
                    try {
                        Object value = OpenSPCoop2Startup.gestoreRisorseJMX_staticInstance.invoke(resourceName, methodName, params, signatures);
                        res.getOutputStream().write(value.toString().getBytes());
                    }
                    catch (Exception e) {
                        String msg8 = "Invocazione metodo [" + methodName + "] della risorsa [" + resourceName + "] non riuscita: " + e.getMessage();
                        log.error((Object)("[CheckStatoPdD] " + msg8), (Throwable)e);
                        res.setStatus(500);
                        res.getOutputStream().write(msg8.getBytes());
                        return;
                    }
                } else {
                    String msg9 = "Lettura risorsa [" + resourceName + "] non effettuata, nessun attributo o metodo richiesto";
                    log.error((Object)("[CheckStatoPdD] " + msg9));
                    res.setStatus(500);
                    res.getOutputStream().write(msg9.getBytes());
                    return;
                }
            }
        }
        if (!OpenSPCoop2Startup.initialize) {
            msg = "Porta di dominio OpenSPCoop non inzializzata";
            log.error((Object)("[CheckStatoPdD] " + msg));
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            msg = "Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!TimerThreshold.freeSpace) {
            msg = "Non sono disponibili abbastanza risorse per la gestione della richiesta";
            log.error((Object)("[CheckStatoPdD] " + msg));
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!Tracciamento.tracciamentoDisponibile) {
            msg = "Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            msg = "Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        } else if (!Dump.sistemaDumpDisponibile) {
            msg = "Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage();
            log.error((Object)("[CheckStatoPdD] " + msg), (Throwable)Dump.motivoMalfunzionamentoDump);
            res.setStatus(500);
            res.getOutputStream().write(msg.getBytes());
        }
    }
}

