/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.Detail;
import org.openspcoop2.core.api.utils.Sbustamento;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.HttpServletConnectorOutMessage;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApiServletConnectorOutMessage
extends HttpServletConnectorOutMessage {
    private int status = -1;

    public ApiServletConnectorOutMessage(IProtocolFactory protocolFactory, HttpServletResponse res, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        super(protocolFactory, res, idModuloAsIDService, idModulo);
    }

    @Override
    public void sendResponse(OpenSPCoop2Message msg, boolean consume) throws ConnectorException {
        try {
            if (msg.getSOAPBody() == null) {
                throw new Exception("Message without body?");
            }
            if (msg.getSOAPBody().hasFault()) {
                NodeList list;
                byte[] xmlErrore = null;
                IErroreApplicativoBuilder erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
                Detail d = msg.getSOAPBody().getFault().getDetail();
                if (d != null && (list = d.getChildNodes()) != null) {
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node n = list.item(i);
                        if (!erroreApplicativoBuilder.isErroreApplicativo(n)) continue;
                        xmlErrore = msg.getAsByte(n, false);
                        break;
                    }
                }
                if (xmlErrore == null) {
                    xmlErrore = SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)msg);
                }
                this.res.setStatus(500);
                this.status = 500;
                this.res.setHeader("Content-Type", "text/xml");
                this.res.setHeader("Content-Length", xmlErrore.length + "");
                this.out.write(xmlErrore);
            } else {
                Sbustamento sbustamento = new Sbustamento(msg);
                if (sbustamento.getResponseMessage() != null) {
                    this.res.setStatus(sbustamento.getResponseStatus());
                    this.status = sbustamento.getResponseStatus();
                } else {
                    this.res.setStatus(sbustamento.getResponseStatus());
                    this.status = sbustamento.getResponseStatus();
                }
                if (sbustamento.getTransportProperties() != null && sbustamento.getTransportProperties().size() > 0) {
                    Enumeration<Object> keys = sbustamento.getTransportProperties().keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        this.res.setHeader(key, sbustamento.getTransportProperties().getProperty(key));
                    }
                }
                if (sbustamento.getBody() != null) {
                    String contentType = sbustamento.getContentType();
                    this.res.setHeader("Content-Type", contentType);
                    this.res.setHeader("Content-Length", sbustamento.getBodyLength() + "");
                    this.out.write(sbustamento.getBody());
                } else {
                    this.res.setHeader("Content-Length", "0");
                }
            }
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void sendResponse(byte[] message) throws ConnectorException {
        throw new ConnectorException("Not Implemented");
    }

    @Override
    public void setHeader(String key, String value) throws ConnectorException {
        if ("Content-Type".equals(key)) {
            return;
        }
        if ("Content-Length".equals(key)) {
            return;
        }
        if ("Transfer-Encoding".equals(key)) {
            return;
        }
        super.setHeader(key, value);
    }

    @Override
    public void setContentLength(int length) throws ConnectorException {
    }

    @Override
    public void setContentType(String type) throws ConnectorException {
    }

    @Override
    public void setStatus(int status) throws ConnectorException {
    }

    @Override
    public int getResponseStatus() throws ConnectorException {
        return this.status;
    }
}

