/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.core.api.utils.Imbustamento;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.HttpServletConnectorInMessage;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public class ApiServletConnectorInMessage
extends HttpServletConnectorInMessage {
    public static OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();

    public ApiServletConnectorInMessage(HttpServletRequest req, IDService idModuloAsIDService, String idModulo) throws ConnectorException {
        super(req, idModuloAsIDService, idModulo);
    }

    private synchronized void initMessage(NotifierInputStreamParams notifierInputStreamParams) throws ConnectorException {
        if (this.message == null) {
            try {
                SOAPVersion soapVersion = null;
                soapVersion = this.getProtocolFactory().createProtocolConfiguration().isSupportoSOAP11() ? SOAPVersion.SOAP11 : (this.getProtocolFactory().createProtocolConfiguration().isSupportoSOAP12() ? SOAPVersion.SOAP12 : SOAPVersion.SOAP11);
                String contentType = ServletUtils.readContentTypeFromHeader(this.req, false);
                URLProtocolContext urlProtocolContext = this.getURLProtocolContext();
                Imbustamento imbustamentoAPI = new Imbustamento(soapVersion, notifierInputStreamParams, this.is, MethodType.toEnumConstant((String)this.req.getMethod()), contentType, urlProtocolContext.getParametersTrasporto(), urlProtocolContext.getParametersFormBased(), urlProtocolContext.getFunctionParameters(), this.openspcoopProperties.getAPIServicesWhiteListRequestHeaderList());
                this.message = imbustamentoAPI.getMessage();
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public String getContentType() throws ConnectorException {
        try {
            if (this.message == null) {
                this.initMessage(null);
            }
            return this.message.getContentType();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public String getSOAPAction(SOAPVersion versioneSoap, String contentType) throws ConnectorException {
        return "\"TunnelingApi\"";
    }

    @Override
    public OpenSPCoop2Message getRequest(NotifierInputStreamParams notifierInputStreamParams, String contentType) throws ConnectorException {
        try {
            if (this.message == null) {
                this.initMessage(null);
            }
            return this.message;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getRequest() throws ConnectorException {
        try {
            if (this.message == null) {
                this.initMessage(null);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.message.writeTo((OutputStream)bout, true);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }
}

