/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import com.ctc.wstx.exc.WstxException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.handlers.BaseContext;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.AbstractContext;
import org.openspcoop2.pdd.services.DumpRaw;
import org.openspcoop2.pdd.services.DumpRawConnectorInMessage;
import org.openspcoop2.pdd.services.DumpRawConnectorOutMessage;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.ConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.DirectVMConnectorInMessage;
import org.openspcoop2.pdd.services.connector.DirectVMConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.DirectVMProtocolInfo;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.TransportRequestContext;

public class RicezioneContenutiApplicativiSOAP {
    public static OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ConnectorInMessage req, ConnectorOutMessage res) throws ConnectorException {
        Exception erroreConsegnaRisposta;
        int statoServletResponse;
        EsitoTransazione esito;
        SOAPBody body;
        OpenSPCoop2Message responseMessageError;
        OpenSPCoop2Message requestMessage;
        AbstractContext context;
        BaseContext postOutResponseContext;
        OpenSPCoop2Message responseMessage;
        MsgDiagnostico msgDiag;
        Logger logCore;
        Timestamp dataIngressoMessaggio;
        String idModulo;
        block178: {
            Object vm;
            OpenSPCoop2Properties openSPCoopProperties;
            idModulo = req.getIdModulo();
            IDService idModuloAsService = req.getIdModuloAsIDService();
            dataIngressoMessaggio = DateManager.getTimestamp();
            logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)idModulo);
            }
            if ((openSPCoopProperties = OpenSPCoop2Properties.getInstance()) == null) {
                logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                try {
                    OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(SOAPVersion.SOAP11, "ErroreInizializzazioneOpenSPCoopProperties");
                    res.setStatus(500);
                    res.sendResponse(msg, true);
                    res.flush(false);
                    res.close(false);
                    return;
                }
                catch (Throwable e) {
                    logCore.error((Object)"Errore generazione SOAPFault", e);
                    throw new ConnectorException("Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                }
            }
            ConfigurazionePdDManager configPdDManager = null;
            DumpRaw dumpRaw = null;
            try {
                configPdDManager = ConfigurazionePdDManager.getInstance();
                if (configPdDManager == null || !configPdDManager.isInitializedConfigurazionePdDReader()) {
                    throw new Exception("ConfigurazionePdDManager not initialized");
                }
                if (configPdDManager.dumpBinarioPD()) {
                    dumpRaw = new DumpRaw(logCore, true);
                    req = new DumpRawConnectorInMessage(logCore, req);
                    res = new DumpRawConnectorOutMessage(logCore, res);
                }
            }
            catch (Throwable e) {
                logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: ConfigurazionePdDManager");
                try {
                    OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(SOAPVersion.SOAP11, "ErroreInizializzazioneConfigurazionePdDManager");
                    res.setStatus(500);
                    res.sendResponse(msg, true);
                    res.flush(false);
                    res.close(false);
                    return;
                }
                catch (Throwable eError) {
                    logCore.error((Object)"Errore generazione SOAPFault", e);
                    throw new ConnectorException("Inizializzazione di OpenSPCoop non correttamente effettuata: ConfigurazionePdDManager");
                }
            }
            msgDiag = new MsgDiagnostico(idModulo, new IState[0]);
            msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
            Object oPddContextFromServlet = null;
            try {
                oPddContextFromServlet = req.getAttribute("OPENSPCOOP2_CONTEXT_HEADER_HTTP");
            }
            catch (Exception e) {
                logCore.error((Object)("req.getAttribute(OPENSPCOOP2_CONTEXT_HEADER_HTTP) error: " + e.getMessage()), (Throwable)e);
            }
            PdDContext pddContextFromServlet = null;
            if (oPddContextFromServlet != null) {
                pddContextFromServlet = (PdDContext)oPddContextFromServlet;
            }
            IProtocolFactory protocolFactory = null;
            ErroreApplicativoBuilder erroreApplicativoBuilder = null;
            responseMessage = null;
            ProprietaErroreApplicativo proprietaErroreAppl = null;
            postOutResponseContext = null;
            context = null;
            PdDContext pddContext = null;
            requestMessage = null;
            SOAPVersion versioneSoap = SOAPVersion.SOAP11;
            String protocol = null;
            try {
                protocolFactory = req.getProtocolFactory();
                protocol = protocolFactory.getProtocol();
                proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocol));
                proprietaErroreAppl.setIdModulo(idModulo);
                context = new RicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                context.setTipoPorta(TipoPdD.DELEGATA);
                context.setIdModulo(idModulo);
                context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                msgDiag.setPddContext(context.getPddContext(), protocolFactory);
                pddContext = context.getPddContext();
                try {
                    msgDiag.logPersonalizzato("ricezioneRichiesta.firstLog");
                }
                catch (Exception e) {
                    logCore.error((Object)"Errore generazione diagnostico di ingresso", (Throwable)e);
                }
                if (dumpRaw != null) {
                    dumpRaw.serializeContext(context, protocol);
                }
                vm = null;
                if (req instanceof DirectVMConnectorInMessage) {
                    vm = (DirectVMConnectorInMessage)req;
                } else if (req instanceof DumpRawConnectorInMessage && ((DumpRawConnectorInMessage)req).getWrappedConnectorInMessage() instanceof DirectVMConnectorInMessage) {
                    vm = (DirectVMConnectorInMessage)((DumpRawConnectorInMessage)req).getWrappedConnectorInMessage();
                }
                if (vm != null && ((DirectVMConnectorInMessage)vm).getDirectVMProtocolInfo() != null) {
                    ((DirectVMConnectorInMessage)vm).getDirectVMProtocolInfo().setInfo(pddContext);
                }
                postOutResponseContext = new PostOutResponseContext(logCore, protocolFactory);
                postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
                postOutResponseContext.setPddContext(pddContext);
                postOutResponseContext.setIdModulo(idModulo);
                PreInRequestContext preInRequestContext = new PreInRequestContext(pddContext);
                if (pddContextFromServlet != null) {
                    preInRequestContext.getPddContext().addAll(pddContextFromServlet, true);
                }
                preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
                preInRequestContext.setIdModulo(idModulo);
                preInRequestContext.setProtocolFactory(protocolFactory);
                Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
                transportContext.put("SERVLET_REQUEST", req);
                transportContext.put("SERVLET_RESPONSE", res);
                preInRequestContext.setTransportContext(transportContext);
                preInRequestContext.setLogCore(logCore);
                GestoreHandlers.preInRequest(preInRequestContext, msgDiag, logCore);
                pddContext.addAll(preInRequestContext.getPddContext(), false);
                NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
                context.setNotifierInputStreamParams(notifierInputStreamParams);
                if (dumpRaw != null) {
                    dumpRaw.serializeRequest((DumpRawConnectorInMessage)req, true, notifierInputStreamParams);
                }
                msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.tipologiaMessaggio");
                String contentTypeReq = req.getContentType();
                versioneSoap = ServletUtils.getVersioneSoap(logCore, contentTypeReq);
                boolean contentTypeSupportato = ServletUtils.isContentTypeSupported(versioneSoap, protocolFactory);
                if (versioneSoap == null) {
                    versioneSoap = protocolFactory.createProtocolConfiguration().isSupportoSOAP11() ? SOAPVersion.SOAP11 : SOAPVersion.SOAP12;
                }
                erroreApplicativoBuilder = new ErroreApplicativoBuilder(logCore, protocolFactory, openSPCoopProperties.getIdentitaPortaDefault(protocol), null, null, proprietaErroreAppl.getIdModulo(), proprietaErroreAppl, versioneSoap, TipoPdD.DELEGATA, null);
                pddContext.addObject("SOAP_VERSION", versioneSoap);
                msgDiag.addKeyword("@SOAP_VERSION@", versioneSoap.getSoapVersionAsString());
                msgDiag.addKeyword("@SOAP_NAMESPACE_ATTESO@", versioneSoap.getSoapEnvelopeNS());
                msgDiag.addKeyword("@CONTENT_TYPES_ATTESI@", SOAPVersion.getKnownContentTypesAsString((boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP11(), (boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP12()));
                String[] supportedContentTypes = SOAPVersion.getKnownContentTypes((boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP11(), (boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP12());
                msgDiag.addKeyword("@HEADER_HTTP@", contentTypeReq);
                if (!openSPCoopProperties.isControlloContentTypeAbilitatoRicezioneContenutiApplicativi() && !contentTypeSupportato) {
                    if ("Non presente".equals(contentTypeReq)) {
                        msgDiag.logPersonalizzato("contentType.notDefined");
                    } else {
                        msgDiag.logPersonalizzato("contentType.unsupported");
                    }
                    contentTypeReq = SOAPVersion.SOAP11.getContentTypeForMessageWithoutAttachments();
                    logCore.warn((Object)("Content-Type non supportato, viene utilizzato forzatamente il tipo: " + contentTypeReq));
                    contentTypeSupportato = true;
                }
                if (!contentTypeSupportato) {
                    if ("Non presente".equals(contentTypeReq)) {
                        msgDiag.logPersonalizzato("contentType.notDefined");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_433_CONTENT_TYPE_NON_PRESENTE.getErrore433_ContentTypeNonPresente(versioneSoap, supportedContentTypes), null);
                    } else {
                        msgDiag.logPersonalizzato("contentType.unsupported");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_429_CONTENT_TYPE_NON_SUPPORTATO.getErrore429_ContentTypeNonSupportato(versioneSoap, req.getContentType(), supportedContentTypes), null);
                    }
                } else {
                    String soapAction = req.getSOAPAction(versioneSoap, contentTypeReq);
                    msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.inCorso");
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Pre costruzione richiesta");
                    requestMessage = req.getRequest(notifierInputStreamParams, contentTypeReq);
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Post costruzione richiesta");
                    requestMessage.setProtocolName(protocolFactory.getProtocol());
                    String mustUnderstandError = ServletUtils.checkMustUnderstand((SOAPMessage)requestMessage, protocolFactory);
                    String soapEnvelopeNamespaceVersionMismatch = ServletUtils.checkSOAPEnvelopeNamespace((SOAPMessage)requestMessage, versioneSoap);
                    URLProtocolContext urlProtocolContext = req.getURLProtocolContext();
                    requestMessage.setTransportRequestContext((TransportRequestContext)urlProtocolContext);
                    Credenziali credenziali = req.getCredenziali();
                    context.setFromLocation(req.getLocation(credenziali));
                    if (soapAction != null) {
                        if (openSPCoopProperties.checkSoapActionQuotedString_ricezioneContenutiApplicativi()) {
                            ServletUtils.checkSoapActionQuotedString(soapAction, versioneSoap);
                        }
                        context.setSoapAction(soapAction);
                        requestMessage.setProperty("SOAPAction", (Object)soapAction);
                        requestMessage.getMimeHeaders().addHeader("SOAPAction", soapAction);
                    }
                    context.setCredenziali(credenziali);
                    context.setGestioneRisposta(true);
                    ((RicezioneContenutiApplicativiContext)context).setInvocazionePDPerRiferimento(false);
                    context.setMessageRequest(requestMessage);
                    context.setUrlProtocolContext(urlProtocolContext);
                    context.setMsgDiagnostico(msgDiag);
                    msgDiag.logPersonalizzato("ricezioneRichiesta.elaborazioneDati.completata");
                    if (mustUnderstandError == null && soapEnvelopeNamespaceVersionMismatch == null) {
                        RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi((RicezioneContenutiApplicativiContext)context);
                        gestoreRichiesta.process(req);
                        responseMessage = context.getMessageResponse();
                    } else if (mustUnderstandError != null) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", mustUnderstandError);
                        msgDiag.logPersonalizzato("mustUnderstand.unknown");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_427_MUSTUNDERSTAND_ERROR.getErrore427_MustUnderstandHeaders(mustUnderstandError), null);
                    } else {
                        msgDiag.addKeyword("@SOAP_NAMESPACE@", soapEnvelopeNamespaceVersionMismatch);
                        msgDiag.logPersonalizzato("soapEnvelopeNamespace.versionMismatch");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_430_SOAP_ENVELOPE_NAMESPACE_ERROR.getErrore430_SoapNamespaceNonSupportato(versioneSoap, soapEnvelopeNamespaceVersionMismatch), null);
                    }
                }
            }
            catch (ProtocolException e) {
                try {
                    protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                    proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                    proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocolFactory.getProtocol()));
                    proprietaErroreAppl.setIdModulo(idModulo);
                    erroreApplicativoBuilder = this.newErroreApplicativoBuilder(req, logCore, protocolFactory, openSPCoopProperties, idModulo, proprietaErroreAppl);
                    context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                    context.setTipoPorta(TipoPdD.DELEGATA);
                    context.setIdModulo(idModulo);
                    context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                    pddContext = context.getPddContext();
                    if (postOutResponseContext != null) {
                        postOutResponseContext.setPddContext(pddContext);
                    }
                    msgDiag.setPddContext(pddContext, protocolFactory);
                    msgDiag.logErroreGenerico((Exception)((Object)e), "MessaggioRichiestaMalformato");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, (Exception)((Object)e)), (Exception)((Object)e));
                }
                catch (ProtocolException ep) {
                    throw new ConnectorException(ep.getMessage(), ep);
                }
            }
            catch (Exception e) {
                String msgErrore;
                if (context == null) {
                    context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                    context.setTipoPorta(TipoPdD.DELEGATA);
                    context.setIdModulo(idModulo);
                    context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                    pddContext = context.getPddContext();
                    if (postOutResponseContext != null) {
                        postOutResponseContext.setPddContext(pddContext);
                    }
                    msgDiag.setPddContext(pddContext, protocolFactory);
                }
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                msgDiag.logErroreGenerico(e, "Generale(richiesta)");
                if (erroreApplicativoBuilder == null) {
                    erroreApplicativoBuilder = this.newErroreApplicativoBuilder(req, logCore, protocolFactory, openSPCoopProperties, idModulo, proprietaErroreAppl);
                }
                if ((msgErrore = e.getMessage()) == null) {
                    msgErrore = e.toString();
                }
                if (msgErrore.equals("Transport level information does not match with SOAP Message namespace URI") || msgErrore.equals("I dati ricevuti non rappresentano un messaggio SOAP 1.1 valido: ")) {
                    msgDiag.addKeyword("@SOAP_NAMESPACE@", "Impossibile recuperare il valore del namespace");
                    msgDiag.logPersonalizzato("soapEnvelopeNamespace.versionMismatch");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_430_SOAP_ENVELOPE_NAMESPACE_ERROR.getErrore430_SoapNamespaceNonSupportato(versioneSoap, "Impossibile recuperare il valore del namespace"), e);
                } else {
                    responseMessage = e instanceof WstxException || e.getCause() instanceof WstxException ? erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(true, e), e) : erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, e), e);
                }
            }
            finally {
                if (requestMessage != null) {
                    String msgErrore;
                    if (requestMessage.getParsingError() != null) {
                        msgErrore = requestMessage.getParsingError().getMessage();
                        if (msgErrore == null) {
                            msgErrore = requestMessage.getParsingError().toString();
                        }
                        msgDiag.logErroreGenerico(requestMessage.getParsingError(), "MessaggioRichiestaMalformato");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(true, requestMessage.getParsingError()), requestMessage.getParsingError());
                    } else if (responseMessage != null && responseMessage.getParsingError() != null) {
                        msgErrore = responseMessage.getParsingError().getMessage();
                        if (msgErrore == null) {
                            msgErrore = responseMessage.getParsingError().toString();
                        }
                        msgDiag.logErroreGenerico(responseMessage.getParsingError(), "MessaggioRispostaMalformato");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(false, responseMessage.getParsingError()), responseMessage.getParsingError());
                    }
                }
                try {
                    URLProtocolContext urlProtocolContext = context.getUrlProtocolContext();
                    if (urlProtocolContext == null) {
                        urlProtocolContext = req.getURLProtocolContext();
                    }
                    if (urlProtocolContext != null) {
                        String urlInvocazione = urlProtocolContext.getUrlInvocazione_formBased();
                        if (urlProtocolContext.getFunction() != null) {
                            urlInvocazione = "[" + urlProtocolContext.getFunction() + "] " + urlInvocazione;
                        }
                        pddContext.addObject("URL_INVOCAZIONE", urlInvocazione);
                    }
                }
                catch (Throwable t) {}
                try {
                    Credenziali credenziali = context.getCredenziali();
                    if (credenziali == null) {
                        credenziali = req.getCredenziali();
                    }
                    if (credenziali != null) {
                        pddContext.addObject("CREDENZIALI_INVOCAZIONE", credenziali.toString());
                    }
                }
                catch (Throwable t) {}
                try {
                    req.close();
                }
                catch (Exception e) {
                    logCore.error((Object)("Request.close() error: " + e.getMessage()), (Throwable)e);
                }
            }
            if (context.getMsgDiagnostico() != null) {
                msgDiag = context.getMsgDiagnostico();
            }
            if (context.getHeaderIntegrazioneRisposta() != null) {
                Enumeration<Object> en = context.getHeaderIntegrazioneRisposta().keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = null;
                    try {
                        value = context.getHeaderIntegrazioneRisposta().getProperty(key);
                        res.setHeader(key, value);
                    }
                    catch (Exception e) {
                        logCore.error((Object)("Request.setHeader(" + key + "," + value + ") error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (context != null && context.getProtocol() != null) {
                erroreApplicativoBuilder.setMittente(context.getProtocol().getFruitore());
                IDServizio idServizio = new IDServizio();
                idServizio.setSoggettoErogatore(context.getProtocol().getErogatore());
                idServizio.setTipoServizio(context.getProtocol().getTipoServizio());
                idServizio.setServizio(context.getProtocol().getServizio());
                idServizio.setAzione(context.getProtocol().getAzione());
                erroreApplicativoBuilder.setServizio(idServizio);
                erroreApplicativoBuilder.setDominio(context.getIdentitaPdD());
                erroreApplicativoBuilder.setProprietaErroreApplicato(((RicezioneContenutiApplicativiContext)context).getProprietaErroreAppl());
            }
            if (context != null && context.getIntegrazione() != null) {
                erroreApplicativoBuilder.setServizioApplicativo(context.getIntegrazione().getServizioApplicativoFruitore());
            }
            vm = null;
            if (res instanceof DirectVMConnectorOutMessage) {
                vm = (DirectVMConnectorOutMessage)res;
            } else if (req instanceof DumpRawConnectorOutMessage && ((DumpRawConnectorOutMessage)res).getWrappedConnectorOutMessage() instanceof DirectVMConnectorOutMessage) {
                vm = (DirectVMConnectorOutMessage)((DumpRawConnectorOutMessage)res).getWrappedConnectorOutMessage();
            }
            if (vm != null && context != null && context.getPddContext() != null) {
                DirectVMProtocolInfo pInfo = new DirectVMProtocolInfo();
                Object oIdTransazione = context.getPddContext().getObject("ID");
                if (oIdTransazione != null) {
                    pInfo.setIdTransazione((String)oIdTransazione);
                }
                if (context.getProtocol() != null) {
                    if (context.getProtocol().getIdRichiesta() != null) {
                        pInfo.setIdMessaggioRichiesta(context.getProtocol().getIdRichiesta());
                    }
                    if (context.getProtocol().getIdRisposta() != null) {
                        pInfo.setIdMessaggioRisposta(context.getProtocol().getIdRisposta());
                    }
                }
                ((DirectVMConnectorOutMessage)vm).setDirectVMProtocolInfo(pInfo);
            }
            InformazioniErroriInfrastrutturali informazioniErrori = ServletUtils.readInformazioniErroriInfrastrutturali(pddContext);
            responseMessageError = null;
            body = null;
            esito = null;
            String descrizioneSoapFault = "";
            statoServletResponse = 200;
            erroreConsegnaRisposta = null;
            boolean httpEmptyResponse = false;
            try {
                if (responseMessage != null) {
                    if (responseMessage.getForcedResponseCode() != null) {
                        try {
                            statoServletResponse = Integer.parseInt(responseMessage.getForcedResponseCode());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ServletUtils.setTransferLength(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), req, res, responseMessage);
                    responseMessage.updateContentType();
                    String contentTypeRisposta = responseMessage.getContentType();
                    if (contentTypeRisposta == null) {
                        throw new Exception("Risposta senza Content-type");
                    }
                    res.setContentType(contentTypeRisposta);
                    body = responseMessage.getSOAPBody();
                    esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)req.getURLProtocolContext(), responseMessage, ((RicezioneContenutiApplicativiContext)context).getProprietaErroreAppl(), informazioniErrori, pddContext != null ? pddContext.getContext() : null);
                    if (body != null && body.hasFault()) {
                        statoServletResponse = 500;
                        descrizioneSoapFault = " (" + SoapUtils.toString((SOAPFault)body.getFault(), (boolean)false) + ")";
                    }
                    res.setStatus(statoServletResponse);
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Pre scrittura risposta");
                    if (TransferLengthModes.CONTENT_LENGTH.equals(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi())) {
                        res.sendResponse(responseMessage, false);
                    } else {
                        res.sendResponse(responseMessage, true);
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Post scrittura risposta");
                    break block178;
                }
                statoServletResponse = protocolFactory.createProtocolManager().getHttpReturnCodeEmptyResponseOneWay();
                res.setStatus(statoServletResponse);
                httpEmptyResponse = true;
                esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)req.getURLProtocolContext(), responseMessage, ((RicezioneContenutiApplicativiContext)context).getProprietaErroreAppl(), informazioniErrori, pddContext != null ? pddContext.getContext() : null);
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                erroreConsegnaRisposta = e;
                try {
                    if (responseMessage.getParsingError() != null) {
                        String msgErrore = responseMessage.getParsingError().getMessage();
                        if (msgErrore == null) {
                            msgErrore = responseMessage.getParsingError().toString();
                        }
                        msgDiag.logErroreGenerico(responseMessage.getParsingError(), "MessaggioRispostaMalformato");
                        responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(false, responseMessage.getParsingError()), e);
                    } else {
                        responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(false, e), responseMessage.getParsingError());
                    }
                    ServletUtils.setTransferLength(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), req, res, responseMessageError);
                    String contentTypeRisposta = responseMessage.getContentType();
                    if (contentTypeRisposta == null) {
                        throw new Exception("Risposta errore senza Content-type");
                    }
                    res.setContentType(contentTypeRisposta);
                    body = responseMessageError.getSOAPBody();
                    esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)req.getURLProtocolContext(), responseMessageError, ((RicezioneContenutiApplicativiContext)context).getProprietaErroreAppl(), null, pddContext != null ? pddContext.getContext() : null);
                    if (body != null && body.hasFault()) {
                        statoServletResponse = 500;
                        res.setStatus(500);
                        descrizioneSoapFault = " (" + SoapUtils.toString((SOAPFault)body.getFault(), (boolean)false) + ")";
                    }
                    if (TransferLengthModes.CONTENT_LENGTH.equals(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi())) {
                        res.sendResponse(responseMessageError, false);
                        break block178;
                    }
                    res.sendResponse(responseMessageError, true);
                }
                catch (Exception error) {
                    logCore.error((Object)"Generazione di un risposta errore non riuscita", (Throwable)error);
                    statoServletResponse = 500;
                    try {
                        res.setStatus(500);
                    }
                    catch (Exception eStatus) {
                        logCore.error((Object)("Response.setStatus(500) error: " + eStatus.getMessage()), (Throwable)eStatus);
                    }
                    try {
                        OpenSPCoop2Message m = OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, (Throwable)error);
                        res.sendResponse(m, true);
                    }
                    catch (Exception eError) {
                        try {
                            res.sendResponse(error.toString().getBytes());
                        }
                        catch (Exception erroreStreamChiuso) {
                            // empty catch block
                        }
                    }
                    try {
                        esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                    }
                    catch (Exception eBuildError) {
                        esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                    }
                }
            }
            finally {
                block179: {
                    statoServletResponse = res.getResponseStatus();
                    msgDiag.addKeyword("@CODICE_CONSEGNA@", "" + statoServletResponse);
                    msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
                    try {
                        res.flush(true);
                        res.close(true);
                        if (erroreConsegnaRisposta != null) {
                            msgDiag.addKeyword("@ERRORE_CONSEGNA@", erroreConsegnaRisposta.toString());
                            msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                        } else if (httpEmptyResponse) {
                            msgDiag.logPersonalizzato("consegnaRispostaApplicativaVuota");
                        } else if (statoServletResponse == 500) {
                            msgDiag.logPersonalizzato("consegnaRispostaApplicativaKoEffettuata");
                        } else {
                            msgDiag.logPersonalizzato("consegnaRispostaApplicativaOkEffettuata");
                        }
                    }
                    catch (Exception e) {
                        logCore.error((Object)"Chiusura stream non riuscita", (Throwable)e);
                        msgDiag.addKeyword("@ERRORE_CONSEGNA@", e.toString());
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                        erroreConsegnaRisposta = e;
                        if (esito == null || !EsitoTransazioneName.OK.equals(esito.getName())) break block179;
                        try {
                            esito = protocolFactory.createEsitoBuilder().getEsito((TransportRequestContext)req.getURLProtocolContext(), EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX);
                        }
                        catch (Exception eBuildError) {
                            esito = EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
                        }
                    }
                }
                if (dumpRaw != null) {
                    dumpRaw.serializeResponse((DumpRawConnectorOutMessage)res);
                }
            }
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (context.getIdMessage() != null) {
                c = RepositoryConnettori.removeConnettorePD(context.getIdMessage());
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        if (postOutResponseContext != null) {
            try {
                postOutResponseContext.getPddContext().addObject("CONTEXT_DATA_INGRESSO_MESSAGGIO_RICHIESTA", dataIngressoMessaggio);
                postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
                ((PostOutResponseContext)postOutResponseContext).setEsito(esito);
                ((PostOutResponseContext)postOutResponseContext).setReturnCode(statoServletResponse);
                ((OutResponseContext)postOutResponseContext).setPropertiesRispostaTrasporto(context.getHeaderIntegrazioneRisposta());
                ((OutResponseContext)postOutResponseContext).setProtocollo(context.getProtocol());
                ((OutResponseContext)postOutResponseContext).setIntegrazione(context.getIntegrazione());
                if (context.getTipoPorta() != null) {
                    postOutResponseContext.setTipoPorta(context.getTipoPorta());
                }
                postOutResponseContext.setIdModulo(idModulo);
                if (requestMessage != null) {
                    long incomingRequestMessageContentLength = requestMessage.getIncomingMessageContentLength();
                    long outgoingRequestMessageContentLenght = requestMessage.getOutgoingMessageContentLength();
                    if (incomingRequestMessageContentLength < 0L) {
                        int cl = req.getContentLength();
                        if (cl > 0) {
                            incomingRequestMessageContentLength = (long)cl + 0L;
                        } else {
                            try {
                                requestMessage.writeTo((OutputStream)new NullOutputStream(), true);
                            }
                            catch (Exception eFlush) {
                                // empty catch block
                            }
                            incomingRequestMessageContentLength = requestMessage.getIncomingMessageContentLength();
                        }
                    }
                    ((PostOutResponseContext)postOutResponseContext).setInputRequestMessageSize(incomingRequestMessageContentLength);
                    ((PostOutResponseContext)postOutResponseContext).setOutputRequestMessageSize(outgoingRequestMessageContentLenght);
                } else {
                    ((PostOutResponseContext)postOutResponseContext).setInputRequestMessageSize((long)req.getContentLength() + 0L);
                }
                if (erroreConsegnaRisposta != null) {
                    if (responseMessageError != null) {
                        ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessageError.getIncomingMessageContentLength());
                        ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(responseMessageError.getOutgoingMessageContentLength());
                        postOutResponseContext.setMessaggio(responseMessageError);
                    } else if (responseMessage != null) {
                        ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessage.getIncomingMessageContentLength());
                        ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(responseMessage.getOutgoingMessageContentLength());
                        postOutResponseContext.setMessaggio(responseMessage);
                    }
                    ((PostOutResponseContext)postOutResponseContext).setErroreConsegna(erroreConsegnaRisposta.toString());
                } else if (responseMessage != null) {
                    ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessage.getIncomingMessageContentLength());
                    ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(responseMessage.getOutgoingMessageContentLength());
                    postOutResponseContext.setMessaggio(responseMessage);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
            }
            GestoreHandlers.postOutResponse((PostOutResponseContext)postOutResponseContext, msgDiag, logCore);
        }
        try {
            if (requestMessage != null && requestMessage.getNotifierInputStream() != null) {
                requestMessage.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream richiesta");
        }
        try {
            if (responseMessage != null && responseMessage.getNotifierInputStream() != null) {
                responseMessage.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream risposta");
        }
        requestMessage = null;
        body = null;
        responseMessage = null;
        responseMessageError = null;
    }

    private ErroreApplicativoBuilder newErroreApplicativoBuilder(ConnectorInMessage req, Logger logCore, IProtocolFactory protocolFactory, OpenSPCoop2Properties openSPCoopProperties, String idModulo, ProprietaErroreApplicativo proprietaErroreAppl) throws ConnectorException {
        try {
            SOAPVersion versioneSoap = SOAPVersion.SOAP11;
            try {
                String contentTypeReq = req.getContentType();
                versioneSoap = ServletUtils.getVersioneSoap(logCore, contentTypeReq);
            }
            catch (Exception e) {
                // empty catch block
            }
            return new ErroreApplicativoBuilder(logCore, protocolFactory, openSPCoopProperties.getIdentitaPortaDefault(protocolFactory.getProtocol()), null, null, idModulo, proprietaErroreAppl, versioneSoap, TipoPdD.DELEGATA, null);
        }
        catch (Throwable ep) {
            throw new ConnectorException(ep.getMessage(), ep);
        }
    }
}

