/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.Imbustamento;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.SbustamentoRisposte;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiGestioneRisposta;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class RicezioneContenutiApplicativi {
    public static final String ID_MODULO = "RicezioneContenutiApplicativi";
    public static boolean initializeService = false;
    public static Boolean isActivePDService = true;
    public static List<TipoFiltroAbilitazioneServizi> listaAbilitazioniPDService = null;
    public static List<TipoFiltroAbilitazioneServizi> listaDisabilitazioniPDService = null;
    private static String[] defaultGestoriIntegrazionePD = null;
    private static Hashtable<String, String[]> defaultPerProtocolloGestoreIntegrazionePD = null;
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneContenutiApplicativiContext msgContext;
    boolean responseAsByte = false;
    private OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();

    protected static synchronized void initializeService(ConfigurazionePdDManager configReader, ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        isActivePDService = configReader.isPDServiceActive();
        listaAbilitazioniPDService = configReader.getFiltriAbilitazionePDService();
        listaDisabilitazioniPDService = configReader.getFiltriDisabilitazionePDService();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        defaultGestoriIntegrazionePD = propertiesReader.getTipoIntegrazionePD();
        for (int i = 0; i < defaultGestoriIntegrazionePD.length; ++i) {
            classType = className.getIntegrazionePortaDelegata(defaultGestoriIntegrazionePD[i]);
            try {
                IGestoreIntegrazionePD gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                gestore.toString();
                logCore.info((Object)("Inizializzazione gestore integrazione servizioApplicativo->PdD di tipo " + defaultGestoriIntegrazionePD[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + defaultGestoriIntegrazionePD[i] + "]: " + e.getMessage());
            }
        }
        defaultPerProtocolloGestoreIntegrazionePD = new Hashtable();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePD = propertiesReader.getTipoIntegrazionePD(protocol);
            if (tipiIntegrazionePD == null || tipiIntegrazionePD.length <= 0) continue;
            Vector<String> tipiIntegrazionePerProtocollo = new Vector<String>();
            for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
                classType = className.getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                try {
                    IGestoreIntegrazionePD test = (IGestoreIntegrazionePD)loader.newInstance(classType);
                    test.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePD[i]);
                    logCore.info((Object)("Inizializzazione gestore per lettura integrazione PD di tipo " + tipiIntegrazionePD[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                }
            }
            if (tipiIntegrazionePerProtocollo.size() <= 0) continue;
            defaultPerProtocolloGestoreIntegrazionePD.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPD();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    logCore.info((Object)("Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneContenutiApplicativi(RicezioneContenutiApplicativiContext context) {
        this.msgContext = context;
    }

    public void process(Object ... params) {
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        OpenSPCoop2Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            try {
                requestMessage = this.msgContext.getMessageRequestFromByte();
                this.responseAsByte = true;
            }
            catch (Exception e) {
                this.setSOAPFault(logCore, msgDiag, e, "LetturaMessaggioRichiesta");
                return;
            }
        }
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore, protocolFactory);
        inRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        inRequestContext.setIdModulo(this.msgContext.getIdModulo());
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null) {
            connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        }
        connettore.setSoapAction(this.msgContext.getSoapAction());
        connettore.setFromLocation(this.msgContext.getFromLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(this.msgContext.getPddContext());
        inRequestContext.setMessaggio(requestMessage);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        try {
            this.process_engine(inRequestContext, params);
        }
        catch (TracciamentoException e) {
            this.setSOAPFault(logCore, msgDiag, (Exception)((Object)e), "TracciamentoNonRiuscito");
            return;
        }
        catch (ProtocolException e) {
            this.setSOAPFault(logCore, msgDiag, (Exception)((Object)e), "InstanziazioneProtocolFactoryNonRiuscita");
            return;
        }
        try {
            if (this.msgContext.getPddContext() != null && this.msgContext.getIntegrazione() != null) {
                if (this.msgContext.getPddContext().containsKey("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@")) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRichiesta((String)this.msgContext.getPddContext().getObject("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@"));
                }
                if (this.msgContext.getPddContext().containsKey("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@")) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRisposta((String)this.msgContext.getPddContext().getObject("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@"));
                }
                if (this.msgContext.getPddContext().containsKey("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@")) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRichiesta((String)this.msgContext.getPddContext().getObject("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@"));
                }
                if (this.msgContext.getPddContext().containsKey("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@")) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRisposta((String)this.msgContext.getPddContext().getObject("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@"));
                }
            }
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "FinalizeIntegrationContextRicezioneContenutiApplicativi");
            return;
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore, protocolFactory);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setIdModulo(this.msgContext.getIdModulo());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setProtocollo(this.msgContext.getProtocol());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setPropertiesRispostaTrasporto(this.msgContext.getHeaderIntegrazioneRisposta());
        OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        OpenSPCoop2Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (properties != null) {
                rispostaPresente = ServletUtils.verificaRispostaRelazioneCodiceTrasporto202(protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                if (this.responseAsByte) {
                    this.msgContext.setMessageResponseAsByte(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(msgRisposta);
                }
            } else {
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "FineGestioneRicezioneContenutiApplicativi");
            return;
        }
        if (Dump.sistemaDumpDisponibile) {
            try {
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (configurazionePdDReader.dumpMessaggi() && msgRisposta != null) {
                    ProtocolContext protocolContext = this.msgContext.getProtocol();
                    Dump dumpApplicativo = null;
                    dumpApplicativo = protocolContext != null ? new Dump(protocolContext.getDominio(), this.msgContext.getIdModulo(), protocolContext.getIdRichiesta(), protocolContext.getFruitore(), new IDServizio(protocolContext.getErogatore(), protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getAzione()), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null) : new Dump(null, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null);
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore(), outResponseContext.getPropertiesRispostaTrasporto());
                }
            }
            catch (TracciamentoException e) {
                this.setSOAPFault(logCore, msgDiag, (Exception)((Object)e), "TracciamentoNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setSOAPFault(Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        HandlerException he = null;
        if (e != null && e instanceof HandlerException) {
            he = (HandlerException)e;
        }
        if (msgDiag != null) {
            if (he != null) {
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, posizione);
                }
            } else {
                msgDiag.logErroreGenerico(e, posizione);
            }
        } else {
            logCore.error((Object)(posizione + ": " + e.getMessage()), (Throwable)e);
        }
        if (this.msgContext.isGestioneRisposta()) {
            String posizioneFault = posizione + ": " + e.getMessage();
            OpenSPCoop2Message messageFault = this.fac.createFaultMessage(this.msgContext.getMessageRequest().getVersioneSoap(), posizioneFault);
            if (this.responseAsByte) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    messageFault.writeTo((OutputStream)out, false);
                }
                catch (Exception eWriteTo) {
                    msgDiag.logErroreGenerico(e, "GenerazioneFaultAsBytes");
                }
                this.msgContext.setMessageRequestAsByte(out.toByteArray());
            } else {
                this.msgContext.setMessageResponse(messageFault);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void process_engine(InRequestContext inRequestContext, Object ... params) throws TracciamentoException, ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [370[CATCHBLOCK]], but top level block is 140[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        if (credenziali != null) {
            if (credenziali.getUsername() != null) {
                msgDiag.setServizioApplicativo("username(" + credenziali.getUsername() + ")");
            } else if (credenziali.getSubject() != null) {
                msgDiag.setServizioApplicativo("subject(" + credenziali.getSubject() + ")");
            } else {
                msgDiag.setServizioApplicativo(null);
            }
        }
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean comportamentoStateless(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta, ImbustamentoMessage imbustamentoMSG) {
        OpenSPCoopStateless openspcoopstate = (OpenSPCoopStateless)parametriGestioneRisposta.getOpenspcoopstate();
        ConfigurazionePdDManager configurazionePdDReader = parametriGestioneRisposta.getConfigurazionePdDReader();
        RegistroServiziManager registroServiziReader = parametriGestioneRisposta.getRegistroServiziReader();
        MsgDiagnostico msgDiag = parametriGestioneRisposta.getMsgDiag();
        Logger logCore = parametriGestioneRisposta.getLogCore();
        ErroreApplicativoBuilder xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
        OpenSPCoop2Properties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
        String idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
        GestoreMessaggi msgRequest = parametriGestioneRisposta.getMsgRequest();
        parametriGestioneRisposta.setPortaStateless(true);
        boolean rinegoziamentoConnessione = propertiesReader.isRinegoziamentoConnessione(this.msgContext.getProtocol().getProfiloCollaborazione()) && !parametriGestioneRisposta.isOneWayVers11();
        boolean localForward = parametriGestioneRisposta.isLocalForward();
        String idTransazione = PdDContext.getValue("ID", imbustamentoMSG.getPddContext());
        if (localForward) {
            if ("ConsegnaContenutiApplicativi".equals(openspcoopstate.getDestinatarioRequestMsgLib()) && openspcoopstate.getDestinatarioResponseMsgLib() == null) {
                EsitoLib esito;
                ConsegnaContenutiApplicativi consegnaContenutiLib = null;
                try {
                    consegnaContenutiLib = new ConsegnaContenutiApplicativi(logCore);
                    esito = consegnaContenutiLib.onMessage(openspcoopstate);
                    if (esito.getStatoInvocazione() == 3) {
                        if (esito.getErroreNonGestito() != null) {
                            throw esito.getErroreNonGestito();
                        }
                        throw new Exception("Errore non gestito");
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Stateless.ConsegnaContenutiApplicativi");
                    logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                    }
                    return false;
                }
                if (esito.getStatoInvocazione() != 1) {
                    openspcoopstate.setUseConnection(true);
                    this.gestioneRisposta(parametriGestioneRisposta);
                    return false;
                }
            }
        } else {
            EsitoLib esito;
            Imbustamento imbustamentoLib = null;
            openspcoopstate.setMessageLib(imbustamentoMSG);
            openspcoopstate.setIDMessaggioSessione(idMessageRequest);
            try {
                imbustamentoLib = new Imbustamento(logCore);
                esito = imbustamentoLib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.Imbustamento");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO) && propertiesReader.isGestioneOnewayStateful_1_1()) {
                return true;
            }
            if (rinegoziamentoConnessione) {
                openspcoopstate.setUseConnection(true);
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                openspcoopstate.releaseResource();
                openspcoopstate.setUseConnection(false);
            }
            InoltroBuste inoltroBusteLib = null;
            try {
                inoltroBusteLib = new InoltroBuste(logCore);
                esito = inoltroBusteLib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.InoltroBuste");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                return true;
            }
            SbustamentoRisposte sbustamentoRisposteLib = null;
            boolean erroreSbustamentoRisposta = false;
            try {
                sbustamentoRisposteLib = new SbustamentoRisposte(logCore);
                if (rinegoziamentoConnessione && openspcoopstate.resourceReleased()) {
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.initResource(parametriGestioneRisposta.getIdentitaPdD(), "SbustamentoRisposte", idTransazione);
                    openspcoopstate.setUseConnection(false);
                    registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                    configurazionePdDReader.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                    msgDiag.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                }
                if ((esito = sbustamentoRisposteLib.onMessage(openspcoopstate)).getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                erroreSbustamentoRisposta = true;
                msgDiag.logErroreGenerico(e, "Stateless.SbustamentoRisposte");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                    openspcoopstate.setUseConnection(true);
                    try {
                        openspcoopstate.commit();
                    }
                    catch (Exception e) {}
                    openspcoopstate.releaseResource();
                    openspcoopstate.setUseConnection(false);
                }
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
        }
        return true;
    }

    private void gestioneRisposta(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta) {
        Busta bustaRisposta;
        SOAPVersion versioneSoap;
        String idCorrelazioneApplicativaRisposta;
        OpenSPCoop2Message responseMessage;
        String profiloCollaborazioneValue;
        ProfiloDiCollaborazione profiloCollaborazione;
        String idCollaborazioneResponse;
        String idMessageResponse;
        Loader loader;
        Busta bustaRichiesta;
        IProtocolFactory protocolFactory;
        String idTransazione;
        PdDContext pddContext;
        boolean richiestaAsincronaSimmetricaStateless;
        boolean oneWayVers11;
        boolean portaStateless;
        GestoreMessaggi msgRequest;
        String[] tipiIntegrazionePD;
        HeaderIntegrazione headerIntegrazioneRisposta;
        HeaderIntegrazione headerIntegrazioneRichiesta;
        String servizioApplicativo;
        String idMessageRequest;
        ErroreApplicativoBuilder xmlBuilder;
        OpenSPCoop2Properties propertiesReader;
        Logger logCore;
        MsgDiagnostico msgDiag;
        IOpenSPCoopState openspcoopstate;
        block60: {
            openspcoopstate = parametriGestioneRisposta.getOpenspcoopstate();
            msgDiag = parametriGestioneRisposta.getMsgDiag();
            logCore = parametriGestioneRisposta.getLogCore();
            propertiesReader = parametriGestioneRisposta.getPropertiesReader();
            xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
            IDSoggetto identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
            idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
            servizioApplicativo = parametriGestioneRisposta.getServizioApplicativo();
            headerIntegrazioneRichiesta = parametriGestioneRisposta.getHeaderIntegrazioneRichiesta();
            headerIntegrazioneRisposta = parametriGestioneRisposta.getHeaderIntegrazioneRisposta();
            tipiIntegrazionePD = parametriGestioneRisposta.getTipiIntegrazionePD();
            msgRequest = parametriGestioneRisposta.getMsgRequest();
            portaStateless = parametriGestioneRisposta.isPortaStateless();
            oneWayVers11 = parametriGestioneRisposta.isOneWayVers11();
            richiestaAsincronaSimmetricaStateless = parametriGestioneRisposta.isRichiestaAsincronaSimmetricaStateless();
            pddContext = parametriGestioneRisposta.getPddContext();
            idTransazione = PdDContext.getValue("ID", pddContext);
            protocolFactory = parametriGestioneRisposta.getProtocolFactory();
            bustaRichiesta = parametriGestioneRisposta.getBustaRichiesta();
            loader = Loader.getInstance();
            idMessageResponse = null;
            idCollaborazioneResponse = null;
            profiloCollaborazione = null;
            profiloCollaborazioneValue = null;
            responseMessage = null;
            idCorrelazioneApplicativaRisposta = null;
            versioneSoap = (SOAPVersion)this.msgContext.pddContext.getObject("SOAP_VERSION");
            try {
                if (portaStateless || oneWayVers11) {
                    RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)((OpenSPCoopStateless)openspcoopstate).getMessageLib();
                    idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                    responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
                    if (responseMessage != null) {
                        versioneSoap = responseMessage.getVersioneSoap();
                    }
                    idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)openspcoopstate).getIDCorrelazioneApplicativaRisposta();
                    if (!ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
                        this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                    }
                    this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                    msgDiag.setIdMessaggioRisposta(idMessageResponse);
                    msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                    break block60;
                }
                try {
                    responseMessage = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
                    String classType = null;
                    INodeReceiver nodeReceiver = null;
                    try {
                        classType = ClassNameProperties.getInstance().getNodeReceiver(propertiesReader.getNodeReceiver());
                        nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                    }
                    msgDiag.mediumDebug("Attesa/lettura risposta...");
                    RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)nodeReceiver.receive(msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi(), propertiesReader.getNodeReceiverCheckInterval());
                    idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                    pddContext = ricezioneContenutiApplicativiMSG.getPddContext();
                    if (pddContext != null) {
                        Enumeration<String> enumPddContext = pddContext.keys();
                        while (enumPddContext.hasMoreElements()) {
                            String key = enumPddContext.nextElement();
                            this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                        }
                    }
                    if (!ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
                        this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                    }
                    this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                }
                catch (Exception e) {
                    logCore.error((Object)("Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore"), (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GestioneRispostaErroreGenerale");
                    if (e instanceof NodeTimeoutException) {
                        try {
                            openspcoopstate.updateResource(idTransazione);
                        }
                        catch (Exception eDB) {
                            msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                            this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), eDB));
                            return;
                        }
                        try {
                            msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            openspcoopstate.commit();
                        }
                        catch (Exception eDel) {
                            msgDiag.logErroreGenerico(eDel, "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                        }
                        openspcoopstate.releaseResource();
                    }
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE), e));
                    return;
                }
                msgDiag.setIdMessaggioRisposta(idMessageResponse);
                msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                try {
                    openspcoopstate.updateResource(idTransazione);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e));
                    return;
                }
                msgRequest.updateOpenSPCoopState(openspcoopstate);
                msgDiag.mediumDebug("Lettura messaggio di risposta...");
                GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                try {
                    responseMessage = msgResponse.getMessage();
                    idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                }
                catch (GestoreMessaggiException e) {
                    msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    openspcoopstate.releaseResource();
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG), (Exception)e));
                    return;
                }
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                msgDiag.logErroreGenerico(e, "ErroreGenerale");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
            }
        }
        msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
        if (this.msgContext.getProtocol() != null) {
            this.msgContext.getProtocol().setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
        }
        if (this.msgContext.getIntegrazione() != null) {
            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        }
        msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
        headerIntegrazioneRisposta.getBusta().setIdCollaborazione(idCollaborazioneResponse);
        headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(profiloCollaborazione);
        headerIntegrazioneRisposta.getBusta().setID(idMessageRequest);
        OutResponsePDMessage outResponsePDMessage = new OutResponsePDMessage();
        outResponsePDMessage.setBustaRichiesta(bustaRichiesta);
        Object bustaRispostaObject = pddContext.getObject("BustaProprietaHeaderIntegrazione");
        if (bustaRispostaObject != null && bustaRispostaObject instanceof Busta && (bustaRisposta = (Busta)bustaRispostaObject).sizeProperties() > 0) {
            String[] propertyNames = bustaRisposta.getPropertiesNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                outResponsePDMessage.getBustaRichiesta().addProperty(propertyNames[i], bustaRisposta.getProperty(propertyNames[i]));
            }
        }
        outResponsePDMessage.setMessage(responseMessage);
        outResponsePDMessage.setPortaDelegata(parametriGestioneRisposta.getPortaDelegata());
        Properties propertiesIntegrazioneRisposta = new Properties();
        outResponsePDMessage.setProprietaTrasporto(propertiesIntegrazioneRisposta);
        outResponsePDMessage.setServizio(parametriGestioneRisposta.getIdServizio());
        outResponsePDMessage.setSoggettoMittente(parametriGestioneRisposta.getSoggettoMittente());
        if (this.msgContext.getIdModulo().startsWith(ID_MODULO + IntegrationManager.ID_MODULO)) {
            try {
                String classType = null;
                IGestoreIntegrazionePD gestore = null;
                try {
                    classType = ClassNameProperties.getInstance().getIntegrazionePortaDelegata("trasporto");
                    gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo (Risposta IM) [" + "trasporto" + "]: " + e.getMessage());
                }
                if (gestore != null) {
                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
            }
        }
        for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
            try {
                String classType = null;
                IGestoreIntegrazionePD gestore = null;
                try {
                    classType = ClassNameProperties.getInstance().getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                    gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione (Risposta) di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                }
                if (gestore != null) {
                    if (gestore instanceof IGestoreIntegrazionePDSoap) {
                        if (propertiesReader.processHeaderIntegrazionePDResponse(false)) {
                            if (!propertiesReader.deleteHeaderIntegrazioneResponsePD()) continue;
                            if (responseMessage == null) {
                                responseMessage = this.fac.createEmptySOAPMessage(versioneSoap);
                                outResponsePDMessage.setMessage(responseMessage);
                            }
                            gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                            continue;
                        }
                        if (responseMessage == null) {
                            responseMessage = this.fac.createEmptySOAPMessage(versioneSoap);
                            outResponsePDMessage.setMessage(responseMessage);
                        }
                        gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                        continue;
                    }
                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                    continue;
                }
                msgDiag.logErroreGenerico("Creazione header di integrazione [" + tipiIntegrazionePD[i] + "] non riuscito, gestore non inzializzato", "setHeaderIntegrazioneRisposta");
                continue;
            }
            catch (Exception e) {
                logCore.error((Object)("Errore durante la creazione dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage()), (Throwable)e);
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta(" + tipiIntegrazionePD[i] + ")");
            }
        }
        this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
        if (!portaStateless) {
            this.eliminaSIL((OpenSPCoopStateful)openspcoopstate, msgDiag, idMessageRequest, idMessageResponse, servizioApplicativo);
        }
        if (portaStateless && !oneWayVers11) {
            msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                if (richiestaAsincronaSimmetricaStateless) {
                    boolean resourceReleased = openspcoopstate.resourceReleased();
                    if (resourceReleased) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.updateResource(idTransazione);
                    }
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                    msgResponse.setReadyForDrop(true);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgResponse.setReadyForDrop(false);
                    msgRequest.updateOpenSPCoopState(openspcoopstate);
                    msgRequest.setReadyForDrop(true);
                    msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgRequest.setReadyForDrop(false);
                }
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Errore durante l'aggiornamento del proprietario al GestoreMessaggi (Stateless)", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
            }
        }
        if (oneWayVers11) {
            msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Riscontrato errore durante il commit della gestione oneWay stateful/stateless", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        if (profiloCollaborazione != null) {
            if (profiloCollaborazione.equals(ProfiloDiCollaborazione.SINCRONO)) {
                msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta sincrona");
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO)) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            }
        }
        msgDiag.mediumDebug("Imposto risposta nel context...");
        this.msgContext.setMessageResponse(responseMessage);
    }

    private void eliminaSIL(OpenSPCoopStateful openspcoopstate, MsgDiagnostico msgDiag, String idMessageRequest, String idMessageResponse, String servizioApplicativo) {
        msgDiag.mediumDebug("Eliminazione SIL destinatario del messaggio nella tabelle MSG_SERVIZI_APPLICATIVI...");
        if (openspcoopstate.getConnectionDB() != null) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, idMessageRequest);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
            }
        } else {
            msgDiag.logErroreGenerico("Connessione non disponibile", "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
        }
    }
}

