/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop2.pdd.mdb.InoltroRisposte;
import org.openspcoop2.pdd.mdb.Sbustamento;
import org.openspcoop2.pdd.services.FlowProperties;
import org.openspcoop2.pdd.services.RicezioneBusteContext;
import org.openspcoop2.pdd.services.RicezioneBusteParametriGenerazioneBustaErrore;
import org.openspcoop2.pdd.services.RicezioneBusteParametriInvioBustaErrore;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.constants.TipoTraccia;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class RicezioneBuste {
    public static final String ID_MODULO = "RicezioneBuste";
    public static boolean initializeService = false;
    public static Boolean isActivePAService = true;
    public static List<TipoFiltroAbilitazioneServizi> listaAbilitazioniPAService = null;
    public static List<TipoFiltroAbilitazioneServizi> listaDisabilitazioniPAService = null;
    private static String[] defaultGestoriIntegrazionePA = null;
    private static Hashtable<String, String[]> defaultPerProtocolloGestoreIntegrazionePA = null;
    private OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneBusteContext msgContext;
    boolean responseAsByte = false;

    protected static synchronized void initializeService(ConfigurazionePdDManager configReader, ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        isActivePAService = configReader.isPAServiceActive();
        listaAbilitazioniPAService = configReader.getFiltriAbilitazionePAService();
        listaDisabilitazioniPAService = configReader.getFiltriDisabilitazionePAService();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        String[] tipiIntegrazioneDefault = propertiesReader.getTipoIntegrazionePA();
        Vector<String> s = new Vector<String>();
        for (int i = 0; i < tipiIntegrazioneDefault.length; ++i) {
            classType = className.getIntegrazionePortaApplicativa(tipiIntegrazioneDefault[i]);
            try {
                IGestoreIntegrazionePA test = (IGestoreIntegrazionePA)loader.newInstance(classType);
                test.toString();
                s.add(tipiIntegrazioneDefault[i]);
                logCore.info((Object)("Inizializzazione gestore per lettura integrazione PA di tipo " + tipiIntegrazioneDefault[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazioneDefault[i] + "]: " + e.getMessage());
            }
        }
        if (s.size() > 0) {
            defaultGestoriIntegrazionePA = s.toArray(new String[1]);
        }
        defaultPerProtocolloGestoreIntegrazionePA = new Hashtable();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePA = propertiesReader.getTipoIntegrazionePA(protocol);
            if (tipiIntegrazionePA == null || tipiIntegrazionePA.length <= 0) continue;
            Vector<String> tipiIntegrazionePerProtocollo = new Vector<String>();
            for (int i = 0; i < tipiIntegrazionePA.length; ++i) {
                classType = className.getIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                try {
                    IGestoreIntegrazionePA test = (IGestoreIntegrazionePA)loader.newInstance(classType);
                    test.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePA[i]);
                    logCore.info((Object)("Inizializzazione gestore per lettura integrazione PA di tipo " + tipiIntegrazionePA[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePA[i] + "]: " + e.getMessage());
                }
            }
            if (tipiIntegrazionePerProtocollo.size() <= 0) continue;
            defaultPerProtocolloGestoreIntegrazionePA.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPA();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    logCore.info((Object)("Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneBuste(RicezioneBusteContext context) {
        this.msgContext = context;
    }

    public void process(Object ... params) {
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        OpenSPCoop2Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            try {
                requestMessage = this.msgContext.getMessageRequestFromByte();
                this.responseAsByte = true;
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(logCore, msgDiag, e, "LetturaMessaggioRichiesta");
                return;
            }
        }
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore, protocolFactory);
        inRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
        inRequestContext.setIdModulo(this.msgContext.getIdModulo());
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null) {
            connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        }
        connettore.setSoapAction(this.msgContext.getSoapAction());
        connettore.setFromLocation(this.msgContext.getFromLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(this.msgContext.getPddContext());
        inRequestContext.setMessaggio(requestMessage);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        try {
            this.process_engine(inRequestContext, params);
        }
        catch (TracciamentoException tracciamentoException) {
            this.setSOAPFault_processamento(logCore, msgDiag, (Exception)((Object)tracciamentoException), "TracciamentoNonRiuscito");
            return;
        }
        catch (ProtocolException protocolException) {
            this.setSOAPFault_processamento(logCore, msgDiag, (Exception)((Object)protocolException), "ProtocolFactoryNonInstanziata");
            return;
        }
        try {
            if (this.msgContext.getPddContext() != null && this.msgContext.getIntegrazione() != null) {
                if (this.msgContext.getPddContext().containsKey("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@")) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRichiesta((String)this.msgContext.getPddContext().getObject("@TIPO_PROCESSAMENTO_MTOM_RICHIESTA@"));
                }
                if (this.msgContext.getPddContext().containsKey("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@")) {
                    this.msgContext.getIntegrazione().setTipoProcessamentoMtomXopRisposta((String)this.msgContext.getPddContext().getObject("@TIPO_PROCESSAMENTO_MTOM_RISPOSTA@"));
                }
                if (this.msgContext.getPddContext().containsKey("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@")) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRichiesta((String)this.msgContext.getPddContext().getObject("@TIPO_SICUREZZA_MESSAGGIO_RICHIESTA@"));
                }
                if (this.msgContext.getPddContext().containsKey("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@")) {
                    this.msgContext.getIntegrazione().setTipoMessageSecurityRisposta((String)this.msgContext.getPddContext().getObject("@TIPO_SICUREZZA_MESSAGGIO_RISPOSTA@"));
                }
            }
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "FinalizeIntegrationContextRicezioneBuste");
            return;
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore, protocolFactory);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setIdModulo(this.msgContext.getIdModulo());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setProtocollo(this.msgContext.getProtocol());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setPropertiesRispostaTrasporto(this.msgContext.getHeaderIntegrazioneRisposta());
        OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        OpenSPCoop2Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (properties != null) {
                rispostaPresente = ServletUtils.verificaRispostaRelazioneCodiceTrasporto202(protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                if (this.responseAsByte) {
                    this.msgContext.setMessageResponseAsByte(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(msgRisposta);
                }
            } else {
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "FineGestioneRicezioneBuste");
            return;
        }
        if (Dump.sistemaDumpDisponibile) {
            try {
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (configurazionePdDReader.dumpMessaggi() && msgRisposta != null) {
                    ProtocolContext protocolContext = this.msgContext.getProtocol();
                    Dump dumpApplicativo = null;
                    dumpApplicativo = protocolContext != null ? new Dump(protocolContext.getDominio(), this.msgContext.getIdModulo(), protocolContext.getIdRichiesta(), protocolContext.getFruitore(), new IDServizio(protocolContext.getErogatore(), protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getAzione()), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null) : new Dump(null, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null);
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore(), outResponseContext.getPropertiesRispostaTrasporto());
                }
            }
            catch (TracciamentoException tracciamentoException) {
                this.setSOAPFault_processamento(logCore, msgDiag, (Exception)((Object)tracciamentoException), "TracciamentoNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setSOAPFault_processamento(Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        this.setSOAPFault_engine(logCore, msgDiag, e, null, null, posizione, false);
    }

    private void setSOAPFault_processamento(String posizione) {
        this.setSOAPFault_engine(null, null, null, null, null, posizione, false);
    }

    private void setSOAPFault_intestazione(ErroreCooperazione erroreCooperazione) {
        this.setSOAPFault_engine(null, null, null, erroreCooperazione, null, null, true);
    }

    private void setSOAPFault_intestazione(ErroreIntegrazione erroreIntegrazione) {
        this.setSOAPFault_engine(null, null, null, null, erroreIntegrazione, null, true);
    }

    private void setSOAPFault_engine(Logger logCore, MsgDiagnostico msgDiag, Exception e, ErroreCooperazione erroreCooperazione, ErroreIntegrazione erroreIntegrazione, String posizioneErrore, boolean validazione) {
        boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1 = true;
        try {
            setSoapPrefixBackwardCompatibilityOpenSPCoop1 = OpenSPCoop2Properties.getInstance().isForceSoapPrefixCompatibilitaOpenSPCoopV1();
        }
        catch (Exception eReader) {
            // empty catch block
        }
        HandlerException he = null;
        if (e != null && e instanceof HandlerException) {
            he = (HandlerException)e;
        }
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        if (msgDiag != null) {
            if (he != null) {
                if (he.isEmettiDiagnostico()) {
                    msgDiag.logErroreGenerico(e, posizioneErrore);
                }
            } else {
                msgDiag.logErroreGenerico(e, posizioneErrore);
            }
        } else if (logCore != null) {
            logCore.error((Object)(posizioneErrore + e.getMessage()), (Throwable)e);
        }
        if (this.msgContext.isGestioneRisposta()) {
            OpenSPCoop2Message messageFault = null;
            try {
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
                Imbustamento imbustamentoErroreBuilder = new Imbustamento(logCore, protocolFactory);
                if (validazione) {
                    messageFault = erroreCooperazione != null ? imbustamentoErroreBuilder.buildSoapFaultProtocollo_intestazione(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), erroreCooperazione.getCodiceErrore(), erroreCooperazione.getDescrizione(protocolFactory), versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1) : imbustamentoErroreBuilder.buildSoapFaultProtocollo_intestazione(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), erroreIntegrazione, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
                } else if (e != null) {
                    ErroreIntegrazione erroreIntegrazioneGenerato = null;
                    erroreIntegrazioneGenerato = he != null && he.isSetErrorMessageInFault() ? ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(he.getMessage()) : ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore);
                    messageFault = imbustamentoErroreBuilder.buildSoapFaultProtocollo_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), erroreIntegrazioneGenerato, e, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
                } else {
                    messageFault = imbustamentoErroreBuilder.buildSoapFaultProtocollo_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore), versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
                }
            }
            catch (ProtocolException protocolException) {
                protocolException.printStackTrace();
            }
            if (this.responseAsByte) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    messageFault.writeTo((OutputStream)out, false);
                }
                catch (Exception eWriteTo) {
                    msgDiag.logErroreGenerico(e, "GenerazioneFaultAsBytes");
                }
                this.msgContext.setMessageRequestAsByte(out.toByteArray());
            }
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    /*
     * Exception decompiling
     */
    private void process_engine(InRequestContext inRequestContext, Object ... params) throws TracciamentoException, ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [416[CATCHBLOCK]], but top level block is 157[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI@", credenzialiFornite);
    }

    private OpenSPCoop2Message generaBustaErroreProcessamento(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore, Exception e) {
        parametriGenerazioneBustaErrore.setErroreProcessamento(true);
        parametriGenerazioneBustaErrore.setEccezioneProcessamento(e);
        return this.generaBustaErrore(parametriGenerazioneBustaErrore);
    }

    private OpenSPCoop2Message generaBustaErroreValidazione(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore) {
        parametriGenerazioneBustaErrore.setErroreProcessamento(false);
        return this.generaBustaErrore(parametriGenerazioneBustaErrore);
    }

    private OpenSPCoop2Message generaBustaErrore(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore) {
        String idTransazione = (String)this.msgContext.getPddContext().getObject("ID");
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        try {
            OpenSPCoop2Message responseErrorMessage = null;
            ErroreCooperazione erroreCooperazione = parametriGenerazioneBustaErrore.getErroreCooperazione();
            ErroreIntegrazione erroreIntegrazione = parametriGenerazioneBustaErrore.getErroreIntegrazione();
            List<Eccezione> error = parametriGenerazioneBustaErrore.getError();
            Imbustamento imbustatore = parametriGenerazioneBustaErrore.getImbustatore();
            IDSoggetto identitaPdD = parametriGenerazioneBustaErrore.getIdentitaPdD();
            Hashtable<String, Object> securityPropertiesResponse = null;
            if (parametriGenerazioneBustaErrore.getFlowPropertiesResponse() != null && parametriGenerazioneBustaErrore.getFlowPropertiesResponse().messageSecurity != null) {
                securityPropertiesResponse = parametriGenerazioneBustaErrore.getFlowPropertiesResponse().messageSecurity.getFlowParameters();
            }
            MessageSecurityContext messageSecurityContext = parametriGenerazioneBustaErrore.getMessageSecurityContext();
            OpenSPCoop2Properties propertiesReader = parametriGenerazioneBustaErrore.getPropertiesReader();
            String profiloGestione = parametriGenerazioneBustaErrore.getProfiloGestione();
            String implementazionePdDMittente = parametriGenerazioneBustaErrore.getImplementazionePdDMittente();
            Tracciamento tracciamento = parametriGenerazioneBustaErrore.getTracciamento();
            MsgDiagnostico msgDiag = parametriGenerazioneBustaErrore.getMsgDiag();
            Integrazione integrazione = parametriGenerazioneBustaErrore.getIntegrazione();
            if (integrazione == null) {
                integrazione = new Integrazione();
                integrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
            }
            IOpenSPCoopState openspcoopState = parametriGenerazioneBustaErrore.getOpenspcoop();
            if (parametriGenerazioneBustaErrore.isErroreProcessamento()) {
                responseErrorMessage = erroreCooperazione != null ? imbustatore.msgErroreProtocollo_Processamento(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreCooperazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1()) : (erroreIntegrazione != null ? imbustatore.msgErroreProtocollo_Processamento(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreIntegrazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1()) : imbustatore.msgErroreProtocollo_Processamento(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, error, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1()));
            } else if (erroreCooperazione != null) {
                responseErrorMessage = imbustatore.msgErroreProtocollo_Validazione(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreCooperazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1());
            } else {
                if (erroreIntegrazione != null) {
                    throw new Exception("Method 'generaBustaErroreValidazione' not supported for MessaggioErroreIntegrazione");
                }
                responseErrorMessage = imbustatore.msgErroreProtocollo_Validazione(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, error, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1());
            }
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
            if (this.msgContext.isTracciamentoAbilitato()) {
                EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                SecurityInfo securityInfoResponse = null;
                boolean functionAsRouter = false;
                if (functionAsRouter && messageSecurityContext != null && messageSecurityContext.getDigestReader() != null) {
                    IValidazioneSemantica validazioneSemantica = protocolFactory.createValidazioneSemantica();
                    securityInfoResponse = validazioneSemantica.readSecurityInformation(messageSecurityContext.getDigestReader(), responseErrorMessage);
                }
                Validatore v = new Validatore(responseErrorMessage, openspcoopState.getStatoRichiesta(), parametriGenerazioneBustaErrore.getLogCore(), protocolFactory);
                tracciamento.registraRisposta(responseErrorMessage, securityInfoResponse, v.getHeaderProtocollo_senzaControlli(), parametriGenerazioneBustaErrore.getBusta(), esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getFromLocation()), parametriGenerazioneBustaErrore.getCorrelazioneApplicativa(), parametriGenerazioneBustaErrore.getCorrelazioneApplicativaRisposta());
            }
            msgDiag.addKeywords(parametriGenerazioneBustaErrore.getBusta(), false);
            IProtocolManager protocolManager = protocolFactory.createProtocolManager();
            if (!protocolManager.getKeywordMittenteSconosciuto().equals(parametriGenerazioneBustaErrore.getBusta().getDestinatario()) && !protocolManager.getKeywordTipoMittenteSconosciuto().equals(parametriGenerazioneBustaErrore.getBusta().getTipoDestinatario())) {
                msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta");
            } else {
                msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta.destinatarioSconosciuto");
            }
            msgDiag.setIdMessaggioRisposta(parametriGenerazioneBustaErrore.getBusta().getID());
            this.msgContext.getProtocol().setIdRisposta(parametriGenerazioneBustaErrore.getBusta().getID());
            return responseErrorMessage;
        }
        catch (Exception e) {
            return this.fac.createFaultMessage(versioneSoap, "ErroreGenerazioneMessaggioRispostaErrore: " + e.getMessage());
        }
    }

    private void sendRispostaBustaErrore(RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore) {
        this.sendRispostaBustaErrore(parametriInvioBustaErrore, true);
    }

    private void sendRispostaBustaErrore(RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore, boolean eliminaMessaggioRicevuto) {
        GestoreMessaggi msgResponse = null;
        RepositoryBuste repositoryBuste = null;
        boolean httpReply = true;
        IOpenSPCoopState openspcoop = parametriInvioBustaErrore.getOpenspcoop();
        Busta bustaRisposta = parametriInvioBustaErrore.getBusta();
        MsgDiagnostico msgDiag = parametriInvioBustaErrore.getMsgDiag();
        Logger logCore = parametriInvioBustaErrore.getLogCore();
        PdDContext pddContext = parametriInvioBustaErrore.getPddContext();
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            if (eliminaMessaggioRicevuto && parametriInvioBustaErrore.isOnewayVersione11()) {
                GestoreMessaggi msgRichiesta = new GestoreMessaggi(openspcoop, true, bustaRisposta.getRiferimentoMessaggio(), "INBOX", logCore, msgDiag, pddContext);
                msgRichiesta.setReadyForDrop(true);
                msgRichiesta.aggiornaProprietarioMessaggio("GestoreMessaggi");
                RepositoryBuste repositoryBustaRichiesta = new RepositoryBuste(openspcoop.getStatoRichiesta(), true, protocolFactory);
                repositoryBustaRichiesta.eliminaBustaStatelessFromInBox(bustaRisposta.getRiferimentoMessaggio());
            }
            if (parametriInvioBustaErrore.isNewConnectionForResponse()) {
                httpReply = false;
            }
            if (bustaRisposta.getIndirizzoDestinatario() != null && parametriInvioBustaErrore.isUtilizzoIndirizzoTelematico()) {
                httpReply = false;
            }
            if (!httpReply) {
                repositoryBuste = new RepositoryBuste(openspcoop.getStatoRisposta(), false, protocolFactory);
                repositoryBuste.registraBustaIntoOutBox(bustaRisposta, parametriInvioBustaErrore.getPropertiesReader().getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox(bustaRisposta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(openspcoop, true, bustaRisposta.getID(), "OUTBOX", msgDiag, pddContext);
                msgResponse.setOneWayVersione11(parametriInvioBustaErrore.isOnewayVersione11());
                msgResponse.registraMessaggio(parametriInvioBustaErrore.getOpenspcoopMsg(), parametriInvioBustaErrore.getCorrelazioneApplicativa(), parametriInvioBustaErrore.getCorrelazioneApplicativaRisposta());
                msgResponse.aggiornaRiferimentoMessaggio(bustaRisposta.getRiferimentoMessaggio());
                msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                EJBUtils ejb = new EJBUtils(parametriInvioBustaErrore.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), bustaRisposta.getRiferimentoMessaggio(), bustaRisposta.getID(), "OUTBOX", openspcoop, msgDiag, parametriInvioBustaErrore.isFunctionAsRouter(), parametriInvioBustaErrore.getImplementazionePdDMittente(), parametriInvioBustaErrore.getImplementazionePdDDestinatario(), parametriInvioBustaErrore.getProfiloGestione(), parametriInvioBustaErrore.getPddContext());
                ejb.sendToInoltroRisposte(bustaRisposta, false, null, msgResponse, parametriInvioBustaErrore.getCorrelazioneApplicativa(), parametriInvioBustaErrore.getCorrelazioneApplicativaRisposta(), parametriInvioBustaErrore.getServizioApplicativoFruitore(), false);
                OpenSPCoop2Message soapBodyEmpty = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
                this.msgContext.setMessageResponse(soapBodyEmpty);
            } else {
                OpenSPCoop2Message risposta = parametriInvioBustaErrore.getOpenspcoopMsg();
                this.msgContext.setMessageResponse(risposta);
            }
            openspcoop.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposta verso nuova connessione");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposta verso nuova connessione", bustaRisposta.getRiferimentoMessaggio(), parametriInvioBustaErrore.isFunctionAsRouter());
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "sendRispostaBustaErrore");
            try {
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
                Imbustamento protocolErroreBuilder = new Imbustamento(protocolFactory);
                this.msgContext.setMessageResponse(protocolErroreBuilder.buildSoapFaultProtocollo_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, versioneSoap, parametriInvioBustaErrore.getPropertiesReader().isForceSoapPrefixCompatibilitaOpenSPCoopV1()));
            }
            catch (Exception eBustaErrore) {
                this.msgContext.setMessageResponse(this.fac.createFaultMessage(versioneSoap, "ErroreSendBustaErrore: " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowProperties getFlowPropertiesRequest(Busta bustaRichiesta, ConfigurazionePdDManager configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoop2Properties properties, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, PdDContext pddContext, PortaApplicativa paFind) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = TipoTraccia.RICHIESTA;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            IDPortaApplicativaByNome idPAbyNome;
            PortaApplicativa pa;
            IDPortaApplicativa idPA;
            PortaDelegata pd;
            IDPortaDelegata idPD;
            RepositoryBuste repository;
            Integrazione integrazione;
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente) && (integrazione = (repository = new RepositoryBuste((IState)state, true, protocolFactory)).getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiscontro(0).getID())).getLocationPD() != null) {
                idPD = new IDPortaDelegata();
                idPD.setLocationPD(integrazione.getLocationPD());
                idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
            }
            if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa);
                } else {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa);
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForSender(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForSender(pd);
                } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, true, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa);
                } else {
                    profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione((IState)state, protocolFactory);
                    if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        IDPortaApplicativaByNome idPAbyNome2;
                        idPA = new IDPortaApplicativa();
                        IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                        idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                        PortaApplicativa pa2 = paFind;
                        if (pa2 == null && (idPAbyNome2 = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                            pa2 = configurazionePdDReader.getPortaApplicativa(idPAbyNome2);
                        }
                        flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa2);
                        flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa2);
                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        repository = new RepositoryBuste((IState)state, true, protocolFactory);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(integrazione.getLocationPD());
                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                        pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                        flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                        flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                    } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        repository = new RepositoryBuste((IState)state, false, protocolFactory);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(integrazione.getLocationPD());
                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                        pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                        flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                        flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                    }
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "lettura_MessageSecurity_MTOM_RequestProperties");
            logCore.error((Object)"Lettura dati Message-Security / MTOM per la ricezione del messaggio non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null) {
                state.closePreparedStatement();
            }
        }
        return flowProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowProperties getFlowPropertiesResponse(Busta bustaRichiesta, ConfigurazionePdDManager configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoop2Properties properties, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, PdDContext pddContext, PortaApplicativa paFind) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente)) {
                if (bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                }
            } else if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                IDPortaApplicativaByNome idPAbyNome;
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                PortaApplicativa pa = paFind;
                if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                    pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                }
                flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    RepositoryBuste repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    Integrazione integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    PortaDelegata pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForSender(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForSender(pd);
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione((IState)state, protocolFactory);
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "lettura_MessageSecurity_MTOM_ResponseProperties");
            logCore.error((Object)"Lettura dati Message-Security / MTOM per la spedizione del messaggio di risposta non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null) {
                state.closePreparedStatement();
            }
        }
        return flowProperties;
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws Exception {
        boolean attendiTerminazioneRichiesta = false;
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRichiesta;
            String idRichiesta;
            msgDiag.mediumDebug("RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamento())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamento())) break;
            }
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "] non gestibile, si attende il completamento" + " della gestione della richiesta");
            } else {
                msgDiag.mediumDebug("Busta di risposta con profilo null?? non gestibile, si attende il completamento della gestione della richiesta");
            }
            try {
                Thread.sleep(checkInterval);
            }
            catch (Exception eRandom) {}
        }
        return attendiTerminazioneRichiesta;
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRicevutaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws Exception {
        boolean attendiTerminazioneRicevutaRichiesta = false;
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRicevutaRichiesta;
            String idRicevutaRichiesta;
            msgDiag.mediumDebug("RICEVUTA RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) break;
            }
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "] non gestibile, si attende il completamento" + " della gestione della ricevuta alla richiesta");
            } else {
                msgDiag.mediumDebug("Busta di risposta con profilo null??? non gestibile, si attende il completamento della gestione della ricevuta alla richiesta");
            }
            try {
                Thread.sleep(checkInterval);
            }
            catch (Exception eRandom) {}
        }
        return attendiTerminazioneRicevutaRichiesta;
    }

    private OpenSPCoop2Message generaRisposta_msgGiaRicevuto(boolean printMsg, Busta bustaRichiesta, Integrazione integrazione, MsgDiagnostico msgDiag, OpenSPCoopState openspcoopstate, Logger log, ConfigurazionePdDManager config, OpenSPCoop2Properties properties, String profiloGestione, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, IProtocolFactory protocolFactory, IDSoggetto identitaPdD, String idTransazione, Loader loader, boolean oneWayVersione11, String implementazionePdDSoggettoMittente, Tracciamento tracciamento, MessageSecurityContext messageSecurityContext, String idCorrelazioneApplicativa) throws ProtocolException, TracciamentoException {
        Vector<Eccezione> v;
        String id_busta_risposta;
        RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        History historyBuste = new History(openspcoopstate.getStatoRichiesta(), log);
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        Busta bustaHTTPReply = null;
        IProtocolVersionManager protocolManager = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO")).createProtocolVersionManager(profiloGestione);
        boolean consegnaAffidabile = false;
        switch (protocolManager.getConsegnaAffidabile(bustaRichiesta.getProfiloDiCollaborazione())) {
            case ABILITATA: {
                consegnaAffidabile = true;
                break;
            }
            case DISABILITATA: {
                consegnaAffidabile = false;
                break;
            }
            default: {
                consegnaAffidabile = properties.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione();
            }
        }
        try {
            IFiltroDuplicati gestoreFiltroDuplicati = Sbustamento.getGestoreFiltroDuplicati(properties, loader, openspcoopstate, this.msgContext.getPddContext(), historyBuste, repositoryBuste, oneWayVersione11);
            gestoreFiltroDuplicati.isDuplicata(protocolFactory, bustaRichiesta.getID());
            if (printMsg) {
                msgDiag.logPersonalizzato("sbustamentoBusta.", "ricezioneBustaDuplicata.count");
            }
            gestoreFiltroDuplicati.incrementaNumeroDuplicati(protocolFactory, bustaRichiesta.getID());
            openspcoopstate.commit();
        }
        catch (Exception e) {
            log.error((Object)("Aggiornamento numero duplicati per busta [" + bustaRichiesta.getID() + "] non riuscito: " + e.getMessage()), (Throwable)e);
        }
        if (printMsg) {
            msgDiag.logPersonalizzato("sbustamentoBusta.", "ricezioneBustaDuplicata");
        }
        Imbustamento imbustatore = new Imbustamento(log, protocolFactory);
        boolean http200 = true;
        if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) && consegnaAffidabile) {
            msgDiag.logPersonalizzato("generazioneRiscontro");
            TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta(implementazionePdDMittente);
            bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
            String id_busta_risposta2 = imbustatore.buildID(openspcoopstate.getStatoRichiesta(), identitaPdD, idTransazione, properties.getGestioneSerializableDB_AttesaAttiva(), properties.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
            bustaHTTPReply.setID(id_busta_risposta2);
            Riscontro r = new Riscontro();
            r.setID(bustaRichiesta.getID());
            r.setOraRegistrazione(DateManager.getDate());
            r.setTipoOraRegistrazione(properties.getTipoTempoBusta(implementazionePdDMittente));
            bustaHTTPReply.addRiscontro(r);
        } else if (!(!ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || properties.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione() || !protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() && !properties.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente))) {
            http200 = false;
            id_busta_risposta = imbustatore.buildID(openspcoopstate.getStatoRichiesta(), identitaPdD, idTransazione, properties.getGestioneSerializableDB_AttesaAttiva(), properties.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
            v = new Vector<Eccezione>();
            v.add(Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory));
            bustaHTTPReply = imbustatore.buildMessaggioErroreProtocollo_Validazione(v, bustaRichiesta, id_busta_risposta, properties.getTipoTempoBusta(implementazionePdDSoggettoMittente));
            if (!identitaPdD.getNome().equals(bustaHTTPReply.getMittente()) || !identitaPdD.getTipo().equals(bustaHTTPReply.getTipoMittente())) {
                bustaHTTPReply.setMittente(identitaPdD.getNome());
                bustaHTTPReply.setTipoMittente(identitaPdD.getTipo());
                bustaHTTPReply.setIdentificativoPortaMittente(identitaPdD.getCodicePorta());
                bustaHTTPReply.setIndirizzoMittente(null);
            }
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
            String ricevuta = null;
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                } else if (ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    ricevuta = "ricevuta di una risposta asincrona simmetrica";
                }
            } else if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
            } else if (ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
            }
            if (ricevuta != null) {
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                msgDiag.logPersonalizzato("generazioneRicevutaAsincrona");
                TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta(implementazionePdDMittente);
                bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                bustaHTTPReply.setVersioneServizio(bustaRichiesta.getVersioneServizio());
                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                if (properties.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                }
                String id_busta_risposta3 = imbustatore.buildID(openspcoopstate.getStatoRichiesta(), identitaPdD, idTransazione, properties.getGestioneSerializableDB_AttesaAttiva(), properties.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
                bustaHTTPReply.setID(id_busta_risposta3);
            }
        } else if (protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() || properties.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente)) {
            http200 = false;
            id_busta_risposta = imbustatore.buildID(openspcoopstate.getStatoRichiesta(), identitaPdD, idTransazione, properties.getGestioneSerializableDB_AttesaAttiva(), properties.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
            v = new Vector();
            v.add(Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory));
            bustaHTTPReply = imbustatore.buildMessaggioErroreProtocollo_Validazione(v, bustaRichiesta, id_busta_risposta, properties.getTipoTempoBusta(implementazionePdDSoggettoMittente));
            if (!identitaPdD.getNome().equals(bustaHTTPReply.getMittente()) || !identitaPdD.getTipo().equals(bustaHTTPReply.getTipoMittente())) {
                bustaHTTPReply.setMittente(identitaPdD.getNome());
                bustaHTTPReply.setTipoMittente(identitaPdD.getTipo());
                bustaHTTPReply.setIdentificativoPortaMittente(identitaPdD.getCodicePorta());
                bustaHTTPReply.setIndirizzoMittente(null);
            }
        }
        if (bustaHTTPReply == null) {
            return SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
        }
        OpenSPCoop2Message msg = null;
        msg = http200 ? SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap) : imbustatore.buildSoapMsgErroreProtocollo_Validazione(versioneSoap, properties.isForceSoapPrefixCompatibilitaOpenSPCoopV1());
        imbustatore.imbustamento(openspcoopstate.getStatoRichiesta(), msg, bustaHTTPReply, integrazione, false, false, false, null);
        if (this.msgContext.isTracciamentoAbilitato()) {
            EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
            SecurityInfo securityInfoResponse = null;
            Validatore v2 = new Validatore(msg, openspcoopstate.getStatoRichiesta(), log, protocolFactory);
            tracciamento.registraRisposta(msg, securityInfoResponse, v2.getHeaderProtocollo_senzaControlli(), bustaHTTPReply, esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getFromLocation()), idCorrelazioneApplicativa, null);
        }
        return msg;
    }

    private EsitoLib chiamaLibreria(OpenSPCoopStateless openspcoopstate, Logger log) throws OpenSPCoopStateException, GenericLibException {
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
            Sbustamento lib = new Sbustamento(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("ConsegnaContenutiApplicativi")) {
            ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(log);
            EsitoLib result = lib.onMessage(openspcoopstate);
            if (result.getStatoInvocazione() == 1) {
                openspcoopstate.setDestinatarioRequestMsgLib("");
            }
            return result;
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte")) {
            ImbustamentoRisposte lib = new ImbustamentoRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("InoltroRisposte")) {
            InoltroRisposte lib = new InoltroRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        throw new OpenSPCoopStateException("RicezioneBuste.chiamaLibreria: nome libreria non valido");
    }

    private IDServizio getIdServizioPerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta) {
        IDServizio idServizioPerAutorizzazione = new IDServizio();
        idServizioPerAutorizzazione.setServizio(idServizio.getServizio());
        idServizioPerAutorizzazione.setTipoServizio(idServizio.getTipoServizio());
        idServizioPerAutorizzazione.setUriAccordo(idServizio.getUriAccordo());
        idServizioPerAutorizzazione.setAzione(idServizio.getAzione());
        idServizioPerAutorizzazione.setTipologiaServizio(idServizio.getTipologiaServizio());
        IDSoggetto soggettoDestinatarioPerAutorizzazione = null;
        soggettoDestinatarioPerAutorizzazione = functionAsRouter ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()))) : (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()))) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()))));
        idServizioPerAutorizzazione.setSoggettoErogatore(soggettoDestinatarioPerAutorizzazione);
        return idServizioPerAutorizzazione;
    }

    private IDSoggetto getIDSoggettoMittentePerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta) {
        IDSoggetto soggettoMittentePerAutorizzazione = null;
        soggettoMittentePerAutorizzazione = functionAsRouter ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()))) : (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()))) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()))));
        return soggettoMittentePerAutorizzazione;
    }
}

