/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.message.MailcapActivationReader;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.GeneralInstanceProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PddProperties;
import org.openspcoop2.pdd.config.QueueManager;
import org.openspcoop2.pdd.config.SystemPropertiesManager;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazione;
import org.openspcoop2.pdd.core.handlers.ExitContext;
import org.openspcoop2.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InitContext;
import org.openspcoop2.pdd.core.jmx.AccessoRegistroServizi;
import org.openspcoop2.pdd.core.jmx.ConfigurazioneSistema;
import org.openspcoop2.pdd.core.jmx.EngineAutorizzazione;
import org.openspcoop2.pdd.core.jmx.GestoreRisorseJMX;
import org.openspcoop2.pdd.core.jmx.InformazioniStatoPorta;
import org.openspcoop2.pdd.core.jmx.InformazioniStatoPortaCache;
import org.openspcoop2.pdd.core.jmx.RepositoryMessaggi;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.RicezioneBuste;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.pdd.timers.TimerConsegnaContenutiApplicativiThread;
import org.openspcoop2.pdd.timers.TimerGestoreBusteNonRiscontrate;
import org.openspcoop2.pdd.timers.TimerGestoreMessaggi;
import org.openspcoop2.pdd.timers.TimerGestoreMessaggiThread;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomali;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomaliThread;
import org.openspcoop2.pdd.timers.TimerGestoreRepositoryBuste;
import org.openspcoop2.pdd.timers.TimerGestoreRepositoryBusteThread;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.pdd.timers.TimerThreshold;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.utils.IDSerialGenerator;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.message.engine.MessageSecurityFactory;
import org.openspcoop2.security.utils.ExternalPWCallback;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.resources.Loader;

public class OpenSPCoop2Startup
implements ServletContextListener {
    private static Logger log = Logger.getLogger((String)"openspcoop2.startup");
    private static final String ID_MODULO = "InizializzazioneRisorse";
    public static boolean contextDestroyed = false;
    ServletContext servletContext;
    public static boolean initialize = false;
    private TimerGestoreBusteNonRiscontrate timerRiscontri;
    private TimerGestoreMessaggi timerEliminazioneMsg;
    private TimerGestoreMessaggiThread threadEliminazioneMsg;
    private TimerGestorePuliziaMessaggiAnomali timerPuliziaMsgAnomali;
    private TimerGestorePuliziaMessaggiAnomaliThread threadPuliziaMsgAnomali;
    private TimerGestoreRepositoryBuste timerRepositoryBuste;
    private TimerGestoreRepositoryBusteThread threadRepositoryBuste;
    private TimerThreshold timerThreshold = null;
    private TimerMonitoraggioRisorse timerMonitoraggioRisorse = null;
    private TimerConsegnaContenutiApplicativiThread threadConsegnaContenutiApplicativi;
    private GestoreRisorseJMX gestoreRisorseJMX = null;
    public static GestoreRisorseJMX gestoreRisorseJMX_staticInstance = null;
    private boolean serverJ2EE = false;
    protected long startDate;
    private PdDContext pddContext = new PdDContext();
    private OpenSPCoopStartupThread th;

    public void contextInitialized(ServletContextEvent sce) {
        contextDestroyed = false;
        this.startDate = System.currentTimeMillis();
        this.servletContext = sce.getServletContext();
        this.th = new OpenSPCoopStartupThread();
        new Thread(this.th).start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        contextDestroyed = true;
        try {
            ExitContext context = new ExitContext();
            context.setPddContext(this.pddContext);
            context.setLogConsole(log);
            context.setLogCore(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            GestoreHandlers.exit(context);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.serverJ2EE) {
            try {
                if (this.timerRiscontri != null) {
                    this.timerRiscontri.stop();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.timerEliminazioneMsg != null) {
                    this.timerEliminazioneMsg.stop();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.timerPuliziaMsgAnomali != null) {
                    this.timerPuliziaMsgAnomali.stop();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.timerRepositoryBuste != null) {
                    this.timerRepositoryBuste.stop();
                }
            }
            catch (Throwable e) {}
        } else {
            try {
                if (this.threadEliminazioneMsg != null) {
                    this.threadEliminazioneMsg.setStop(true);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.threadPuliziaMsgAnomali != null) {
                    this.threadPuliziaMsgAnomali.setStop(true);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.threadRepositoryBuste != null) {
                    this.threadRepositoryBuste.setStop(true);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.threadConsegnaContenutiApplicativi != null) {
                    this.threadConsegnaContenutiApplicativi.setStop(true);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            if (this.timerMonitoraggioRisorse != null) {
                this.timerMonitoraggioRisorse.setStop(true);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (this.timerThreshold != null) {
                this.timerThreshold.setStop(true);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.gestoreRisorseJMX != null) {
            this.gestoreRisorseJMX.unregisterMBeans();
        }
        DateManager.close();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class OpenSPCoopStartupThread
    implements Runnable {
        private void logError(String msg) {
            this.logError(msg, null);
        }

        private void logError(String msg, Exception e) {
            if (e == null) {
                log.error((Object)msg);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            if (OpenSPCoop2Logger.isLoggerOpenSPCoopConsoleStartupAgganciatoLog()) {
                System.err.println(msg);
                if (e != null) {
                    e.printStackTrace(System.err);
                }
            }
        }

        @Override
        public void run() {
            MsgDiagnostico msgDiag;
            ConfigurazionePdDManager configurazionePdDReader;
            AccessoConfigurazionePdD accessoConfigurazione;
            Logger logCore;
            Loader loader;
            OpenSPCoop2Properties propertiesReader;
            ClassNameProperties classNameReader;
            block256: {
                MsgDiagnosticiProperties msgDiagProperties;
                Properties cacheP;
                Properties localConfig;
                Properties loggerP;
                Properties classNameP;
                Object[] o;
                block255: {
                    if (!OpenSPCoop2Logger.initializeLogConsole(log)) {
                        return;
                    }
                    log = Logger.getLogger((String)"openspcoop2.startup");
                    if (!ClassNameProperties.initialize()) {
                        this.logError("Riscontrato errore durante l'inizializzazione del reader di 'className.properties'");
                        return;
                    }
                    classNameReader = ClassNameProperties.getInstance();
                    GeneralInstanceProperties instanceProperties = new GeneralInstanceProperties();
                    o = null;
                    Properties openspcoopP = null;
                    classNameP = null;
                    loggerP = null;
                    localConfig = null;
                    cacheP = null;
                    try {
                        o = instanceProperties.reads(log);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (o != null) {
                            Loader.initialize((ClassLoader)((ClassLoader)o[0]));
                            try {
                                openspcoopP = (Properties)o[1];
                                classNameP = (Properties)o[2];
                                loggerP = (Properties)o[4];
                                localConfig = (Properties)o[5];
                                cacheP = (Properties)o[7];
                            }
                            catch (Exception e) {}
                        } else {
                            Loader.initialize();
                        }
                    }
                    catch (Exception e) {
                        this.logError("Loader non istanziato: " + e.getMessage(), e);
                        return;
                    }
                    if (!OpenSPCoop2Properties.initialize(openspcoopP)) {
                        this.logError("Riscontrato errore durante l'inizializzazione del reader di 'openspcoop2.properties'");
                        return;
                    }
                    propertiesReader = OpenSPCoop2Properties.getInstance();
                    try {
                        propertiesReader.checkOpenSPCoopHome();
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage(), e);
                        if (!StatoFunzionalitaConWarning.ABILITATO.equals(propertiesReader.getCheckOpenSPCoopHome())) break block255;
                        return;
                    }
                }
                classNameReader.refreshLocalProperties(classNameP, propertiesReader.getRootDirectory());
                if (o != null ? !propertiesReader.validaConfigurazione((ClassLoader)o[0]) : !propertiesReader.validaConfigurazione(null)) {
                    return;
                }
                OpenSPCoop2Startup.this.serverJ2EE = propertiesReader.isServerJ2EE();
                if (propertiesReader.getClassLoader() != null) {
                    try {
                        Loader.update((String)propertiesReader.getClassLoader());
                    }
                    catch (Exception e) {
                        this.logError("Loader non aggiornato: " + e.getMessage(), e);
                        return;
                    }
                }
                loader = Loader.getInstance();
                boolean isInitializeLogger = false;
                isInitializeLogger = OpenSPCoop2Logger.initialize(log, propertiesReader.getRootDirectory(), loggerP);
                if (!isInitializeLogger) {
                    return;
                }
                logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
                log = Logger.getLogger((String)"openspcoop2.startup");
                Utilities.log = logCore;
                Utilities.freeMemoryLog = propertiesReader.getFreeMemoryLog();
                String locationPddProperties = null;
                if (propertiesReader.getLocationPddProperties() != null) {
                    locationPddProperties = propertiesReader.getLocationPddProperties();
                }
                if (!PddProperties.initialize(locationPddProperties, propertiesReader.getRootDirectory())) {
                    this.logError("Riscontrato errore durante l'inizializzazione del reader di 'pdd.properties'");
                    return;
                }
                if (o != null) {
                    try {
                        PddProperties.updateLocalImplementation((Properties)o[3]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    OpenSPCoop2Properties.updatePddPropertiesReader(PddProperties.getInstance());
                }
                catch (Exception e) {
                    this.logError("Riscontrato errore durante l'assegnamento del pddPropertiesReader a OpenSPCoopPropertiesReader: " + e.getMessage(), e);
                    return;
                }
                if (!MsgDiagnosticiProperties.initialize(null, propertiesReader.getRootDirectory())) {
                    this.logError("Riscontrato errore durante l'inizializzazione del reader di 'msgDiagnostici.properties'");
                    return;
                }
                if (o != null) {
                    try {
                        MsgDiagnosticiProperties.updateLocalImplementation((Properties)o[6]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!(msgDiagProperties = MsgDiagnosticiProperties.getInstance()).initializeMsgDiagnosticiPersonalizzati()) {
                    return;
                }
                boolean isInitializeCache = Cache.initialize((Logger)log, (Logger)logCore, (String)propertiesReader.getRootDirectory(), (Properties)cacheP, (String)"OPENSPCOOP2_HOME", (String)"OPENSPCOOP2_CACHE_PROPERTIES", (String)"cache_local.properties");
                if (!isInitializeCache) {
                    this.logError("Riscontrato errore durante l'inizializzazione della cache di OpenSPCoop.");
                    return;
                }
                try {
                    OpenSPCoop2MessageFactory.setMessageFactoryImpl((String)classNameReader.getOpenSPCoop2MessageFactory(propertiesReader.getOpenspcoop2MessageFactory()));
                    OpenSPCoop2MessageFactory.initMessageFactory();
                    MessageSecurityFactory.setMessageSecurityContextClassName((String)classNameReader.getMessageSecurityContext(propertiesReader.getMessageSecurityContext()));
                    MessageSecurityFactory.setMessageSecurityDigestReaderClassName((String)classNameReader.getMessageSecurityDigestReader(propertiesReader.getMessageSecurityDigestReader()));
                    GestoreKeystoreCache.setKeystoreCacheParameters((boolean)propertiesReader.isAbilitataCacheMessageSecurityKeystore(), (int)propertiesReader.getItemLifeSecondCacheMessageSecurityKeystore(), (int)propertiesReader.getDimensioneCacheMessageSecurityKeystore());
                    XMLUtils xmlUtils = XMLUtils.getInstance();
                    xmlUtils.initBuilder();
                    xmlUtils.initTransformer();
                    xmlUtils.initCalendarConverter();
                    OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory11();
                    OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory12();
                    OpenSPCoop2MessageFactory.getMessageFactory().getSoapMessageFactory();
                    OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();
                    if (propertiesReader.isPrintInfoFactory()) {
                        log.info((Object)("OpenSPCoop MessageFactory: " + factory.getClass().getName()));
                        log.info((Object)("OpenSPCoop Message: " + factory.createEmptySOAPMessage(SOAPVersion.SOAP11).getClass().getName()));
                        if (OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory11() != null) {
                            log.info((Object)("SOAP1.1 Factory: " + OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory11().getClass().getName()));
                        } else {
                            log.info((Object)"SOAP1.1 Factory: not implemented");
                        }
                        if (OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory12() != null) {
                            log.info((Object)("SOAP1.2 Factory: " + OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory12().getClass().getName()));
                        } else {
                            log.info((Object)"SOAP1.2 Factory: not implemented");
                        }
                        log.info((Object)("SOAP MessageFactory: " + OpenSPCoop2MessageFactory.getMessageFactory().getSoapMessageFactory().getClass().getName()));
                        log.info((Object)("XML DocumentFactory: " + xmlUtils.getDocumentFactory().getClass().getName()));
                        log.info((Object)("XML TransformerFactory: " + xmlUtils.getTransformerFactory().getClass().getName()));
                        log.info((Object)("XML DatatypeFactory: " + xmlUtils.getDatatypeFactory().getClass().getName()));
                    }
                    if (propertiesReader.isPrintInfoMessageSecurity()) {
                        log.info((Object)("MessageSecurity Context: " + MessageSecurityFactory.messageSecurityContextImplClass));
                        log.info((Object)("MessageSecurity DigestReader: " + MessageSecurityFactory.messageSecurityDigestReaderImplClass));
                        log.info((Object)("MessageSecurity Keystore Cache enabled[" + propertiesReader.isAbilitataCacheMessageSecurityKeystore() + "] itemLifeSecond[" + propertiesReader.getItemLifeSecondCacheMessageSecurityKeystore() + "] size[" + propertiesReader.getDimensioneCacheMessageSecurityKeystore() + "]"));
                        log.info((Object)("MessageSecurity (SoapBox) EncryptedDataHeaderBlock: " + factory.getEncryptedDataHeaderBlockClass()));
                        log.info((Object)("MessageSecurity (SoapBox) ProcessPartialEncryptedMessage: " + factory.getProcessPartialEncryptedMessageClass()));
                        log.info((Object)("MessageSecurity (SoapBox) getSignPartialMessageProcessor: " + factory.getSignPartialMessageProcessorClass()));
                    }
                }
                catch (Exception e) {
                    this.logError("Inizializzazione Message/DOM/SOAP: " + e.getMessage(), e);
                    return;
                }
                try {
                    String tipoClass = classNameReader.getDateManager(propertiesReader.getTipoDateManager());
                    DateManager.initializeDataManager((String)tipoClass, (Properties)propertiesReader.getDateManagerProperties(), (Logger)logCore);
                }
                catch (Exception e) {
                    this.logError("Riscontrato errore durante l'inizializzazione del DataManager: " + e.getMessage(), e);
                    return;
                }
                String erroreDB = null;
                try {
                    DBManager.initialize(propertiesReader.getJNDIName_DataSource(), propertiesReader.getJNDIContext_DataSource());
                }
                catch (Exception e) {
                    erroreDB = e.getMessage();
                    log.info((Object)"Datasource non inizializzato... riprovo");
                    logCore.error((Object)erroreDB, (Throwable)e);
                }
                int count = 0;
                boolean trovato = DBManager.isInitialized();
                while (!trovato && count < 600000) {
                    try {
                        DBManager.initialize(propertiesReader.getJNDIName_DataSource(), propertiesReader.getJNDIContext_DataSource());
                    }
                    catch (Exception e) {
                        erroreDB = e.getMessage();
                        log.info((Object)("Attendo inizializzazione del Datasource ... " + erroreDB));
                        logCore.error((Object)erroreDB, (Throwable)e);
                    }
                    if (DBManager.isInitialized()) {
                        trovato = true;
                        continue;
                    }
                    count += 10000;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {}
                }
                if (!DBManager.isInitialized()) {
                    log.fatal((Object)"Inizializzazione DBManager non effettuata", (Throwable)new Exception(erroreDB));
                    return;
                }
                log.info((Object)"Inizializzazione DBManager effettuata con successo.");
                if (JDBCUtilities.isTransactionIsolationNone((int)DBManager.getTransactionIsolationLevel())) {
                    log.info((Object)"Database TransactionLevel is NONE");
                } else if (JDBCUtilities.isTransactionIsolationReadCommitted((int)DBManager.getTransactionIsolationLevel())) {
                    log.info((Object)"Database TransactionLevel is READ_COMMITTED");
                } else if (JDBCUtilities.isTransactionIsolationReadUncommitted((int)DBManager.getTransactionIsolationLevel())) {
                    log.info((Object)"Database TransactionLevel is READ_UNCOMMITTED");
                } else if (JDBCUtilities.isTransactionIsolationRepeatableRead((int)DBManager.getTransactionIsolationLevel())) {
                    log.info((Object)"Database TransactionLevel is REPEATABLE_READ");
                } else if (JDBCUtilities.isTransactionIsolationSerializable((int)DBManager.getTransactionIsolationLevel())) {
                    log.info((Object)"Database TransactionLevel is SERIALIZABLE");
                } else if (JDBCUtilities.isTransactionIsolationSqlServerSnapshot((int)DBManager.getTransactionIsolationLevel())) {
                    log.info((Object)"Database TransactionLevel is SQLSERVER SNAPSHOT");
                } else {
                    log.fatal((Object)"TransactionLevel associato alla connessione non conosciuto");
                    return;
                }
                try {
                    IDSerialGenerator.init((DataSource)DBManager.getInstance().getDataSource());
                }
                catch (Exception e) {
                    log.fatal((Object)"Inizializzazione datasource libreria serial generator", (Throwable)e);
                    return;
                }
                try {
                    String tipoGeneratoreClusterID = propertiesReader.getTipoIDManager();
                    String classClusterID = null;
                    if ("none".equals(tipoGeneratoreClusterID)) {
                        String clusterID = propertiesReader.getClusterId(false);
                        if (clusterID != null) {
                            classClusterID = "org.openspcoop.utils.id.ClusterIdentifierGenerator";
                        }
                    } else {
                        classClusterID = classNameReader.getUniqueIdentifier(tipoGeneratoreClusterID);
                    }
                    if (classClusterID == null) {
                        UniqueIdentifierManager.disabilitaGenerazioneUID();
                    } else {
                        UniqueIdentifierManager.inizializzaUniqueIdentifierManager((String)classClusterID, (Object[])new Object[]{propertiesReader.getClusterId(false)});
                        if (propertiesReader.generazioneDateCasualiLogAbilitato()) {
                            GeneratoreCasualeDate.init(OpenSPCoop2Properties.getGenerazioneDateCasualiLog_dataInizioIntervallo(), OpenSPCoop2Properties.getGenerazioneDateCasualiLog_dataFineIntervallo(), log);
                        }
                    }
                }
                catch (Exception e) {
                    this.logError("Riscontrato errore durante l'inizializzazione del generatore di identificatori unici: " + e.getMessage(), e);
                    return;
                }
                try {
                    ExtendedInfoManager.initialize((boolean)true, (Loader)loader, (String)propertiesReader.getExtendedInfoConfigurazione(), (String)propertiesReader.getExtendedInfoPortaDelegata(), (String)propertiesReader.getExtendedInfoPortaApplicativa());
                }
                catch (Exception e) {
                    this.logError("Riscontrato errore durante l'inizializzazione del componente ExtendedInfoManager: " + e.getMessage(), e);
                    return;
                }
                accessoConfigurazione = null;
                try {
                    accessoConfigurazione = propertiesReader.getAccessoConfigurazionePdD();
                }
                catch (Exception e) {
                    this.logError("Riscontrato errore durante la lettura della modalita' di accesso alla configurazione di OpenSPCoop: " + e.getMessage(), e);
                    return;
                }
                boolean isInitializeConfig = ConfigurazionePdDReader.initialize(accessoConfigurazione, logCore, log, localConfig, propertiesReader.getJNDIName_DataSource(), false);
                if (!isInitializeConfig) {
                    this.logError("Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop.");
                    return;
                }
                configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (!msgDiagProperties.checkValoriFiltriMsgDiagnostici(log)) {
                    return;
                }
                log.info((Object)("ConfigurazionePdD, refresh: " + propertiesReader.isConfigurazioneDinamica()));
                try {
                    IGestoreRepository repository = null;
                    String tipoClass = classNameReader.getRepositoryBuste(propertiesReader.getGestoreRepositoryBuste());
                    repository = (IGestoreRepository)loader.newInstance(tipoClass);
                    Configurazione.init((int)propertiesReader.getGestioneSerializableDB_CheckInterval(), (IGestoreRepository)repository, (String)propertiesReader.getDatabaseType(), (Logger)logCore);
                }
                catch (Exception e) {
                    this.logError("Riscontrato errore durante l'inizializzazione della libreria del protocollo: " + e.getMessage());
                    logCore.error((Object)("Riscontrato errore durante l'inizializzazione della libreria del protocollo: " + e.getMessage()), (Throwable)e);
                    return;
                }
                msgDiag = new MsgDiagnostico(OpenSPCoop2Startup.ID_MODULO, new IState[0]);
                try {
                    SystemPropertiesManager spm = new SystemPropertiesManager(configurazionePdDReader, logCore);
                    spm.updateSystemProperties();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "Inizializzazione proprieta' di sistema");
                    return;
                }
                try {
                    AccessoDatiAutorizzazione datiAutorizzazione = configurazionePdDReader.getAccessoDatiAutorizzazione();
                    if (datiAutorizzazione != null && datiAutorizzazione.getCache() != null) {
                        int dimensioneCache = -1;
                        if (datiAutorizzazione.getCache().getDimensione() != null) {
                            try {
                                dimensioneCache = Integer.parseInt(datiAutorizzazione.getCache().getDimensione());
                            }
                            catch (Exception e) {
                                throw new Exception("Parametro 'dimensioneCache' errato per la cache di accesso di ai dati di autorizzazione");
                            }
                        }
                        String algoritmo = null;
                        if (datiAutorizzazione.getCache().getAlgoritmo() != null) {
                            algoritmo = datiAutorizzazione.getCache().getAlgoritmo().toString();
                        }
                        long idleTime = -1L;
                        if (datiAutorizzazione.getCache().getItemIdleTime() != null) {
                            try {
                                idleTime = Integer.parseInt(datiAutorizzazione.getCache().getItemIdleTime());
                            }
                            catch (Exception e) {
                                throw new Exception("Parametro 'idleTime' errato per la cache di accesso di ai dati di autorizzazione");
                            }
                        }
                        long itemLifeSecond = -1L;
                        if (datiAutorizzazione.getCache().getItemLifeSecond() != null) {
                            try {
                                itemLifeSecond = Integer.parseInt(datiAutorizzazione.getCache().getItemLifeSecond());
                            }
                            catch (Exception e) {
                                throw new Exception("Parametro 'itemLifeSecond' errato per la cache di accesso di ai dati di autorizzazione");
                            }
                        }
                        GestoreAutorizzazione.initialize(dimensioneCache, algoritmo, idleTime, itemLifeSecond, logCore);
                        break block256;
                    }
                    GestoreAutorizzazione.initialize(logCore);
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "Gestore Autorizzazione");
                    return;
                }
            }
            try {
                if (propertiesReader.isRisorseJMXAbilitate()) {
                    if (propertiesReader.getJNDIName_MBeanServer() != null) {
                        OpenSPCoop2Startup.this.gestoreRisorseJMX = new GestoreRisorseJMX(propertiesReader.getJNDIName_MBeanServer(), propertiesReader.getJNDIContext_MBeanServer());
                    } else {
                        OpenSPCoop2Startup.this.gestoreRisorseJMX = new GestoreRisorseJMX();
                    }
                    gestoreRisorseJMX_staticInstance = OpenSPCoop2Startup.this.gestoreRisorseJMX;
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Gestore Risorse JMX");
                return;
            }
            ProtocolFactoryManager protocolFactoryManager = null;
            try {
                ConfigurazionePdD configPdD = new ConfigurazionePdD();
                configPdD.setConfigurationDir(propertiesReader.getRootDirectory());
                configPdD.setLoader(loader);
                configPdD.setAttesaAttivaJDBC(propertiesReader.getGestioneSerializableDB_AttesaAttiva());
                configPdD.setCheckIntervalJDBC(propertiesReader.getGestioneSerializableDB_CheckInterval());
                configPdD.setLog(logCore);
                ProtocolFactoryManager.initialize((Logger)log, (ConfigurazionePdD)configPdD, (String)propertiesReader.getDefaultProtocolName());
                ProtocolFactoryManager.updateLogger((Logger)logCore);
                protocolFactoryManager = ProtocolFactoryManager.getInstance();
                log.info((Object)("ProtocolFactory default: " + protocolFactoryManager.getDefaultProtocolFactory().getProtocol()));
            }
            catch (Exception e) {
                this.logError("Initialize ProtocolFactoryManager failed: " + e.getMessage());
                logCore.error((Object)("Initialize ProtocolFactoryManager failed: " + e.getMessage()), (Throwable)e);
                msgDiag.logStartupError("Riscontrato errore durante l'inizializzazione del ProtocolFactoryManager", "initProtocolFactoryManager");
                return;
            }
            boolean isInitializeAppender = false;
            isInitializeAppender = OpenSPCoop2Logger.initializeMsgDiagnosticiOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_MsgDiagnostici());
            if (!isInitializeAppender) {
                return;
            }
            isInitializeAppender = OpenSPCoop2Logger.initializeTracciamentoOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_Tracciamento());
            if (!isInitializeAppender) {
                return;
            }
            isInitializeAppender = OpenSPCoop2Logger.initializeDumpOpenSPCoopAppender(configurazionePdDReader.getOpenSPCoopAppender_Tracciamento());
            if (!isInitializeAppender) {
                return;
            }
            if (OpenSPCoop2Startup.this.serverJ2EE && ("jms".equals(propertiesReader.getNodeReceiver()) || "jms".equals(propertiesReader.getNodeSender()))) {
                try {
                    QueueManager.initialize(propertiesReader.getJNDIName_ConnectionFactory(), propertiesReader.getJNDIContext_ConnectionFactory());
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "QueueManager.initConnectionFactory");
                    return;
                }
                log.info((Object)("Inizializzazione connectionFactoryJMS [" + propertiesReader.getJNDIName_ConnectionFactory() + "] effettuata."));
                if ("jms".equals(propertiesReader.getNodeReceiver())) {
                    try {
                        QueueManager.initializeQueueNodeReceiver(propertiesReader.getJNDIContext_CodeInterne());
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "QueueManager.initQueueNodeReceiver");
                        return;
                    }
                    log.info((Object)"Inizializzazione code JMS per la ricezione di messaggi nell'infrastruttura di OpenSPCoop, effettuata.");
                }
                try {
                    QueueManager.initializeQueueNodeSender(propertiesReader.getJNDIContext_CodeInterne());
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "QueueManager.initQueueNodeSender");
                    return;
                }
                log.info((Object)"Inizializzazione code JMS per la spedizione di messaggi nell'infrastruttura di OpenSPCoop, effettuata.");
            }
            if (configurazionePdDReader.getAccessoRegistroServizi() == null) {
                msgDiag.logStartupError("Riscontrato errore durante la lettura dei valori associati al registro dei servizi di OpenSPCoop.", "Lettura configurazione PdD");
                return;
            }
            AccessoRegistro accessoRegistro = configurazionePdDReader.getAccessoRegistroServizi();
            for (int i = 0; i < accessoRegistro.sizeRegistroList(); ++i) {
                AccessoRegistroRegistro registro = accessoRegistro.getRegistro(i);
                if (!CostantiConfigurazione.REGISTRO_DB.equals(registro.getTipo().toString())) continue;
                if (registro.getLocation().indexOf("@") != -1) {
                    try {
                        String tipoDatabase = DBUtils.estraiTipoDatabaseFromLocation((String)registro.getLocation());
                        String location = registro.getLocation().substring(registro.getLocation().indexOf("@") + 1);
                        accessoRegistro.getRegistro(i).setLocation(location);
                        accessoRegistro.getRegistro(i).setTipoDatabase(tipoDatabase);
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Inizializzazione registro dei servizi di OpenSPCoop [" + registro.getNome() + "]; analisi del tipo di database (tipoDatabase@datasource)");
                        return;
                    }
                }
                if (propertiesReader.getDatabaseType() == null) {
                    msgDiag.logStartupError("Il Registro dei Servizi di tipo [" + CostantiConfigurazione.REGISTRO_DB + "] richiede la definizione del tipo di database indicato o come prefisso della location (tipoDB@datasource) o attraverso la proprieta' 'org.openspcoop.pdd.repository.tipoDatabase' della porta di dominio", "Inizializzazione registro dei servizi di OpenSPCoop [" + registro.getNome() + "]; analisi del tipo di database");
                    return;
                }
                accessoRegistro.getRegistro(i).setTipoDatabase(propertiesReader.getDatabaseType());
            }
            boolean isInitializeRegistro = RegistroServiziReader.initialize((AccessoRegistro)accessoRegistro, (Logger)logCore, (Logger)log, (boolean)propertiesReader.isControlloRisorseRegistriRaggiungibilitaTotale(), (boolean)propertiesReader.isReadObjectStatoBozza(), (String)propertiesReader.getJNDIName_DataSource());
            if (!isInitializeRegistro) {
                msgDiag.logStartupError("Inizializzazione fallita", "Accesso registro/i dei servizi");
                return;
            }
            boolean validazioneSemanticaConfigurazione = false;
            validazioneSemanticaConfigurazione = "xml".equalsIgnoreCase(accessoConfigurazione.getTipo()) ? propertiesReader.isValidazioneSemanticaConfigurazioneStartupXML() : propertiesReader.isValidazioneSemanticaConfigurazioneStartup();
            if (validazioneSemanticaConfigurazione) {
                try {
                    ConfigurazionePdDManager.getInstance().validazioneSemantica(classNameReader.getConnettore(), classNameReader.getMsgDiagnosticoOpenSPCoopAppender(), classNameReader.getTracciamentoOpenSPCoopAppender(), classNameReader.getAutenticazione(), classNameReader.getAutorizzazione(), classNameReader.getAutorizzazioneContenuto(), classNameReader.getAutorizzazioneContenutoBuste(), classNameReader.getIntegrazionePortaDelegata(), classNameReader.getIntegrazionePortaApplicativa(), propertiesReader.isValidazioneSemanticaConfigurazioneStartupXML(), propertiesReader.isValidazioneSemanticaConfigurazioneStartup(), true, log);
                    if (propertiesReader.isValidazioneSemanticaConfigurazioneStartupXML()) {
                        ConfigurazionePdDManager.getInstance().setValidazioneSemanticaModificaConfigurazionePdDXML(classNameReader.getConnettore(), classNameReader.getMsgDiagnosticoOpenSPCoopAppender(), classNameReader.getTracciamentoOpenSPCoopAppender(), classNameReader.getAutenticazione(), classNameReader.getAutorizzazione(), classNameReader.getAutorizzazioneContenuto(), classNameReader.getAutorizzazioneContenutoBuste(), classNameReader.getIntegrazionePortaDelegata(), classNameReader.getIntegrazionePortaApplicativa());
                    }
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "Validazione semantica della configurazione");
                    return;
                }
            }
            try {
                RegistroServiziManager.getInstance().validazioneSemantica(true, propertiesReader.isValidazioneSemanticaRegistroServiziCheckURI(), protocolFactoryManager.getSubjectTypesAsArray(), protocolFactoryManager.getServiceTypesAsArray(), classNameReader.getConnettore(), propertiesReader.isValidazioneSemanticaRegistroServiziStartupXML(), propertiesReader.isValidazioneSemanticaRegistroServiziStartup(), log);
                if (propertiesReader.isValidazioneSemanticaRegistroServiziStartupXML()) {
                    RegistroServiziManager.getInstance().setValidazioneSemanticaModificaRegistroServiziXML(propertiesReader.isValidazioneSemanticaRegistroServiziCheckURI(), protocolFactoryManager.getSubjectTypesAsArray(), protocolFactoryManager.getServiceTypesAsArray(), classNameReader.getConnettore());
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Validazione semantica del registro dei servizi");
                return;
            }
            try {
                GestoreMessaggi.initialize();
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Cache GestoreMessaggi");
                return;
            }
            try {
                String wssPropertiesFileExternalPWCallback = propertiesReader.getExternalPWCallbackPropertyFile();
                if (wssPropertiesFileExternalPWCallback != null) {
                    ExternalPWCallback.initialize((String)wssPropertiesFileExternalPWCallback);
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione MessageSecurity");
                return;
            }
            try {
                RicezioneContenutiApplicativi.initializeService(configurazionePdDReader, classNameReader, propertiesReader, logCore);
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione servizio RicezioneContenutiApplicativi");
                return;
            }
            try {
                RicezioneBuste.initializeService(configurazionePdDReader, classNameReader, propertiesReader, logCore);
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione servizio RicezioneBuste");
                return;
            }
            try {
                MailcapActivationReader.initDataContentHandler((Logger)log, (boolean)propertiesReader.isTunnelSOAP_loadMailcap());
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "Inizializzazione DataContentHandler (MET-INF/mailcap)");
                return;
            }
            if (OpenSPCoop2Startup.this.gestoreRisorseJMX != null) {
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanConfigurazionePdD();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - configurazione della Porta di Dominio");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanAccessoRegistroServizi();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - accesso al Registro dei Servizi");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanMonitoraggioRisorse();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - monitoraggio delle Risorse");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanAutorizzazione();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - dati di autorizzazione");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanRepositoryMessaggi();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - repository dei messaggi");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanStatoServiziPdD();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - stato servizi della Porta di Dominio");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanStatistichePdD();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - statistiche della Porta di Dominio");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanSystemPropertiesPdD();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - propriet\u00e0 di sistema della Porta di Dominio");
                }
                try {
                    OpenSPCoop2Startup.this.gestoreRisorseJMX.registerMBeanConfigurazioneSistema();
                }
                catch (Exception e) {
                    msgDiag.logStartupError(e, "RisorsaJMX - configurazione di sistema della Porta di Dominio");
                }
            }
            InformazioniStatoPorta informazioniStatoPorta = new InformazioniStatoPorta();
            ArrayList<InformazioniStatoPortaCache> informazioniStatoPortaCache = new ArrayList<InformazioniStatoPortaCache>();
            AccessoRegistroServizi infoRegistroServizi = new AccessoRegistroServizi();
            InformazioniStatoPortaCache informazioniStatoPortaCache_registro = new InformazioniStatoPortaCache("AccessoRegistroServizi", infoRegistroServizi.isCacheAbilitata());
            if (infoRegistroServizi.isCacheAbilitata()) {
                informazioniStatoPortaCache_registro.setStatoCache(infoRegistroServizi.printStatCache());
            }
            informazioniStatoPortaCache.add(informazioniStatoPortaCache_registro);
            org.openspcoop2.pdd.core.jmx.ConfigurazionePdD infoConfigurazione = new org.openspcoop2.pdd.core.jmx.ConfigurazionePdD();
            InformazioniStatoPortaCache informazioniStatoPortaCache_config = new InformazioniStatoPortaCache("ConfigurazionePdD", infoConfigurazione.isCacheAbilitata());
            if (infoConfigurazione.isCacheAbilitata()) {
                informazioniStatoPortaCache_config.setStatoCache(infoConfigurazione.printStatCache());
            }
            informazioniStatoPortaCache.add(informazioniStatoPortaCache_config);
            EngineAutorizzazione infoAutorizzazioneDati = new EngineAutorizzazione();
            InformazioniStatoPortaCache informazioniStatoPortaCache_autorizzazioneDati = new InformazioniStatoPortaCache("DatiAutorizzazione", infoAutorizzazioneDati.isCacheAbilitata());
            if (infoAutorizzazioneDati.isCacheAbilitata()) {
                informazioniStatoPortaCache_autorizzazioneDati.setStatoCache(infoAutorizzazioneDati.printStatCache());
            }
            informazioniStatoPortaCache.add(informazioniStatoPortaCache_autorizzazioneDati);
            RepositoryMessaggi infoRepositoryMessaggi = new RepositoryMessaggi();
            InformazioniStatoPortaCache informazioniStatoPortaCache_repositoryMessaggi = new InformazioniStatoPortaCache("RepositoryMessaggi", infoRepositoryMessaggi.isCacheAbilitata());
            if (infoRepositoryMessaggi.isCacheAbilitata()) {
                informazioniStatoPortaCache_repositoryMessaggi.setStatoCache(infoRepositoryMessaggi.printStatCache());
            }
            informazioniStatoPortaCache.add(informazioniStatoPortaCache_repositoryMessaggi);
            ConfigurazioneSistema infoConfigSistema = new ConfigurazioneSistema();
            OpenSPCoop2Logger.getLoggerOpenSPCoopConfigurazioneSistema().info((Object)informazioniStatoPorta.formatStatoPorta(infoConfigSistema.getVersionePdD(), infoConfigSistema.getVersioneBaseDati(), infoConfigSistema.getDirectoryConfigurazione(), infoConfigSistema.getVersioneJava(), LogLevels.toOpenSPCoop2(configurazionePdDReader.getSeverita_msgDiagnostici(), true), LogLevels.toOpenSPCoop2(configurazionePdDReader.getSeveritaLog4J_msgDiagnostici(), true), OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato, OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato, OpenSPCoop2Logger.loggerIntegrationManagerAbilitato, configurazionePdDReader.tracciamentoBuste(), configurazionePdDReader.dumpMessaggi(), configurazionePdDReader.dumpBinarioPD(), configurazionePdDReader.dumpBinarioPA(), OpenSPCoop2Logger.loggerTracciamentoAbilitato, OpenSPCoop2Logger.loggerDumpAbilitato, infoConfigSistema.getInformazioniDatabase(), infoConfigSistema.getPluginProtocols(), informazioniStatoPortaCache.toArray(new InformazioniStatoPortaCache[1])));
            try {
                InitContext initContext = new InitContext();
                initContext.setLogCore(logCore);
                initContext.setLogConsole(log);
                initContext.setPddContext(OpenSPCoop2Startup.this.pddContext);
                GestoreHandlers.init(initContext, msgDiag, log);
            }
            catch (HandlerException e) {
                if (e.isEmettiDiagnostico()) {
                    msgDiag.logStartupError(e, e.getIdentitaHandler());
                } else {
                    logCore.error((Object)e.getMessage(), (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "InitHandler");
                return;
            }
            try {
                if (propertiesReader.isAbilitatoControlloRisorseConfigurazione() || propertiesReader.isAbilitatoControlloValidazioneSemanticaConfigurazione() || propertiesReader.isAbilitatoControlloRisorseDB() || propertiesReader.isAbilitatoControlloRisorseJMS() || propertiesReader.isAbilitatoControlloRisorseMsgDiagnosticiPersonalizzati() || propertiesReader.isAbilitatoControlloRisorseRegistriServizi() || propertiesReader.isAbilitatoControlloValidazioneSemanticaRegistriServizi() || propertiesReader.isAbilitatoControlloRisorseTracciamentiPersonalizzati()) {
                    OpenSPCoop2Startup.this.timerMonitoraggioRisorse = new TimerMonitoraggioRisorse();
                    OpenSPCoop2Startup.this.timerMonitoraggioRisorse.start();
                    log.info((Object)"Inizializzo Timer per il Monitoraggio delle Risorse");
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "TimerMonitoraggioRisorse");
                return;
            }
            try {
                String[] tipiThreshold = propertiesReader.getRepositoryThresholdTypes();
                if (tipiThreshold != null) {
                    OpenSPCoop2Startup.this.timerThreshold = new TimerThreshold();
                    OpenSPCoop2Startup.this.timerThreshold.start();
                    log.info((Object)"Inizializzo Timer per il Controllo dei Threshold sulle risorse");
                }
            }
            catch (Exception e) {
                msgDiag.logStartupError(e, "TimerThreshold");
                return;
            }
            initialize = true;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean gestoreBusteNonRiscontrate = false;
            boolean gestoreMessaggi = false;
            boolean gestorePuliziaMessaggiAnomali = false;
            boolean gestoreRepository = false;
            if (OpenSPCoop2Startup.this.serverJ2EE) {
                long scadenzaWhile = System.currentTimeMillis() + propertiesReader.getTimerEJBDeployTimeout();
                GestoreJNDI jndi = null;
                jndi = propertiesReader.getJNDIContext_TimerEJB() == null ? new GestoreJNDI() : new GestoreJNDI(propertiesReader.getJNDIContext_TimerEJB());
                while (!(System.currentTimeMillis() >= scadenzaWhile || gestoreBusteNonRiscontrate && gestoreMessaggi && gestorePuliziaMessaggiAnomali && gestoreRepository)) {
                    String nomeJNDI;
                    block259: {
                        block258: {
                            block257: {
                                gestoreBusteNonRiscontrate = false;
                                gestoreMessaggi = false;
                                gestorePuliziaMessaggiAnomali = false;
                                gestoreRepository = false;
                                if (propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
                                    try {
                                        nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreBusteNonRiscontrate");
                                        log.info((Object)("Inizializzo EJB gestore riscontri [" + nomeJNDI + "]"));
                                        jndi.lookup(nomeJNDI);
                                        gestoreBusteNonRiscontrate = true;
                                        break block257;
                                    }
                                    catch (Exception e) {
                                        this.logError("Search EJB gestore riscontri non trovato: " + e.getMessage(), e);
                                        try {
                                            Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                        }
                                        catch (Exception eRandom) {}
                                        continue;
                                    }
                                }
                                gestoreBusteNonRiscontrate = true;
                            }
                            if (propertiesReader.isTimerGestoreMessaggiAbilitato()) {
                                try {
                                    nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreMessaggi");
                                    log.info((Object)("Inizializzo EJB gestore messaggi [" + nomeJNDI + "]"));
                                    jndi.lookup(nomeJNDI);
                                    gestoreMessaggi = true;
                                    break block258;
                                }
                                catch (Exception e) {
                                    this.logError("Search EJB gestore messaggi non trovato: " + e.getMessage(), e);
                                    try {
                                        Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                    }
                                    catch (Exception eRandom) {}
                                    continue;
                                }
                            }
                            gestoreMessaggi = true;
                        }
                        if (propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                            try {
                                nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreConsistenzaDatabase");
                                log.info((Object)("Inizializzo EJB gestore pulizia messaggi anomali [" + nomeJNDI + "]"));
                                jndi.lookup(nomeJNDI);
                                gestorePuliziaMessaggiAnomali = true;
                                break block259;
                            }
                            catch (Exception e) {
                                this.logError("Search EJB pulizia messaggi anomali non trovato: " + e.getMessage(), e);
                                try {
                                    Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                                }
                                catch (Exception eRandom) {}
                                continue;
                            }
                        }
                        gestorePuliziaMessaggiAnomali = true;
                    }
                    if (propertiesReader.isTimerGestoreRepositoryBusteAbilitato()) {
                        try {
                            nomeJNDI = propertiesReader.getJNDITimerEJBName().get("GestoreRepositoryBuste");
                            log.info((Object)("Inizializzo EJB gestore repository [" + nomeJNDI + "]"));
                            jndi.lookup(nomeJNDI);
                            gestoreRepository = true;
                        }
                        catch (Exception e) {
                            this.logError("Search EJB gestore repository non trovato: " + e.getMessage(), e);
                            try {
                                Thread.sleep(new Random().nextInt(propertiesReader.getTimerEJBDeployCheckInterval()));
                            }
                            catch (Exception eRandom) {}
                        }
                        continue;
                    }
                    gestoreRepository = true;
                }
            }
            if (OpenSPCoop2Startup.this.serverJ2EE) {
                if (propertiesReader.isTimerGestoreRiscontriRicevuteAbilitato()) {
                    if (gestoreBusteNonRiscontrate) {
                        try {
                            OpenSPCoop2Startup.this.timerRiscontri = ServicesUtils.createTimerGestoreBusteNonRiscontrate();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreBusteNonRiscontrate'");
                        }
                        if (OpenSPCoop2Startup.this.timerRiscontri != null) {
                            try {
                                OpenSPCoop2Startup.this.timerRiscontri.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreBusteNonRiscontrate'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreBusteNonRiscontrate'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreBusteNonRiscontrate'");
                    }
                } else {
                    msgDiag.setPrefixMsgPersonalizzati("timerGestoreRiscontriRicevute.");
                    msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreBusteNonRiscontrate");
                    msgDiag.logPersonalizzato("disabilitato");
                    msgDiag.setPrefixMsgPersonalizzati(null);
                }
            }
            if (propertiesReader.isTimerGestoreMessaggiAbilitato()) {
                if (OpenSPCoop2Startup.this.serverJ2EE) {
                    if (gestoreMessaggi) {
                        try {
                            OpenSPCoop2Startup.this.timerEliminazioneMsg = ServicesUtils.createTimerGestoreMessaggi();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreMessaggi'");
                        }
                        if (OpenSPCoop2Startup.this.timerEliminazioneMsg != null) {
                            try {
                                OpenSPCoop2Startup.this.timerEliminazioneMsg.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreMessaggi'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreMessaggi'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreMessaggi'");
                    }
                } else {
                    try {
                        OpenSPCoop2Startup.this.threadEliminazioneMsg = new TimerGestoreMessaggiThread();
                        OpenSPCoop2Startup.this.threadEliminazioneMsg.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'GestoreMessaggi'");
                    }
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
                msgDiag.logPersonalizzato("disabilitato");
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
            if (propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitato()) {
                if (OpenSPCoop2Startup.this.serverJ2EE) {
                    if (gestorePuliziaMessaggiAnomali) {
                        try {
                            OpenSPCoop2Startup.this.timerPuliziaMsgAnomali = ServicesUtils.createTimerGestorePuliziaMessaggiAnomali();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreConsistenzaDatabase'");
                        }
                        if (OpenSPCoop2Startup.this.timerPuliziaMsgAnomali != null) {
                            try {
                                OpenSPCoop2Startup.this.timerPuliziaMsgAnomali.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreConsistenzaDatabase'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreConsistenzaDatabase'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreConsistenzaDatabase'");
                    }
                } else {
                    try {
                        OpenSPCoop2Startup.this.threadPuliziaMsgAnomali = new TimerGestorePuliziaMessaggiAnomaliThread();
                        OpenSPCoop2Startup.this.threadPuliziaMsgAnomali.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'GestoreConsistenzaDatabase'");
                    }
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
                msgDiag.logPersonalizzato("disabilitato");
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
            if (propertiesReader.isTimerGestoreRepositoryBusteAbilitato()) {
                if (OpenSPCoop2Startup.this.serverJ2EE) {
                    if (gestoreRepository) {
                        try {
                            OpenSPCoop2Startup.this.timerRepositoryBuste = ServicesUtils.createTimerGestoreRepositoryBuste();
                        }
                        catch (Exception e) {
                            msgDiag.logStartupError(e, "Creazione timer 'GestoreRepositoryBuste'");
                        }
                        if (OpenSPCoop2Startup.this.timerRepositoryBuste != null) {
                            try {
                                OpenSPCoop2Startup.this.timerRepositoryBuste.start();
                            }
                            catch (RemoteException e) {
                                msgDiag.logStartupError(e, "Avvio timer 'GestoreRepositoryBuste'");
                            }
                        } else {
                            msgDiag.logStartupError("timer is null", "Avvio timer 'GestoreRepositoryBuste'");
                        }
                    } else {
                        msgDiag.logStartupError("timer non esiste nell'application server", "Avvio timer 'GestoreRepositoryBuste'");
                    }
                } else {
                    try {
                        OpenSPCoop2Startup.this.threadRepositoryBuste = new TimerGestoreRepositoryBusteThread();
                        OpenSPCoop2Startup.this.threadRepositoryBuste.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'GestoreRepositoryBuste'");
                    }
                }
            } else {
                msgDiag.setPrefixMsgPersonalizzati("timerGestoreRepositoryBuste.");
                msgDiag.addKeyword("@ID_TIMER_GESTORE_REPOSITORY_BUSTE@", "GestoreRepositoryBuste");
                msgDiag.logPersonalizzato("disabilitato");
                msgDiag.setPrefixMsgPersonalizzati(null);
            }
            if (!OpenSPCoop2Startup.this.serverJ2EE) {
                if (propertiesReader.isTimerConsegnaContenutiApplicativiAbilitato()) {
                    try {
                        OpenSPCoop2Startup.this.threadConsegnaContenutiApplicativi = new TimerConsegnaContenutiApplicativiThread();
                        OpenSPCoop2Startup.this.threadConsegnaContenutiApplicativi.start();
                    }
                    catch (Exception e) {
                        msgDiag.logStartupError(e, "Avvio timer (thread) 'TimerConsegnaContenutiApplicativi'");
                    }
                } else {
                    msgDiag.setPrefixMsgPersonalizzati("timerConsegnaContenutiApplicativi.");
                    msgDiag.addKeyword("@ID_TIMER@", "TimerConsegnaContenutiApplicativi");
                    msgDiag.logPersonalizzato("disabilitato");
                    msgDiag.setPrefixMsgPersonalizzati(null);
                }
            }
            long endDate = System.currentTimeMillis();
            long secondStarter = (endDate - OpenSPCoop2Startup.this.startDate) / 1000L;
            msgDiag.setPrefixMsgPersonalizzati("openspcoopStartup.");
            msgDiag.addKeyword("@VERSIONE@", propertiesReader.getPddDetailsForLog());
            msgDiag.addKeyword("@TEMPO_DI_AVVIO@", secondStarter + " secondi");
            log.info((Object)("Porta di Dominio " + propertiesReader.getPddDetailsForLog() + " avviata correttamente in " + secondStarter + " secondi."));
            if (OpenSPCoop2Logger.isLoggerOpenSPCoopConsoleStartupAgganciatoLog()) {
                System.out.println("Porta di Dominio " + propertiesReader.getPddDetailsForLog() + " avviata correttamente in " + secondStarter + " secondi.");
            }
            msgDiag.logPersonalizzato("pdd");
            MsgDiagnostico msgIM = new MsgDiagnostico(IntegrationManager.ID_MODULO, new IState[0]);
            msgIM.setPrefixMsgPersonalizzati("openspcoopStartup.");
            msgIM.addKeyword("@VERSIONE@", propertiesReader.getPddDetailsForLog());
            msgIM.addKeyword("@TEMPO_DI_AVVIO@", secondStarter + " secondi");
            msgIM.logPersonalizzato("IntegrationManager");
        }
    }
}

