/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.AbstractContext;
import org.openspcoop2.pdd.services.DumpRawConnectorInMessage;
import org.openspcoop2.pdd.services.DumpRawConnectorOutMessage;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.utils.Identity;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public class DumpRaw {
    private static final String format = "yyyy-MM-dd_HH:mm:ss.SSS";
    private StringBuffer bfContext = new StringBuffer();
    private StringBuffer bfRequest = new StringBuffer();
    private StringBuffer bfResponse = new StringBuffer();
    private Logger log;
    private boolean pd;
    private String idTransaction;
    private Logger logDump;

    public DumpRaw(Logger log, boolean isPD) throws ConnectorException {
        this.log = log;
        this.pd = isPD;
        this.logDump = this.pd ? OpenSPCoop2Logger.getLoggerOpenSPCoopDumpBinarioPD() : OpenSPCoop2Logger.getLoggerOpenSPCoopDumpBinarioPA();
        if (this.logDump == null) {
            throw new ConnectorException("Logger per la registrazione dei dati binari non inizializzato");
        }
    }

    public void serializeContext(AbstractContext context, String protocol) {
        try {
            Object tmp;
            Date dataIngresso = null;
            String idTransazione = null;
            IDService serviceType = context.getIdModuloAsIDService();
            TipoPdD tipoPdD = context.getTipoPorta();
            if (context.getDataIngressoRichiesta() != null) {
                dataIngresso = context.getDataIngressoRichiesta();
            }
            if (context.getPddContext() != null && (tmp = context.getPddContext().getObject("ID")) != null) {
                idTransazione = (String)tmp;
            }
            this.serializeContext(dataIngresso, idTransazione, serviceType, tipoPdD, protocol);
        }
        catch (Throwable t) {
            this.bfContext.append("SerializeContext (AbstractContext) error: " + t.getMessage() + "\n");
            this.log.error((Object)("SerializeContext (AbstractContext) error: " + t.getMessage()), t);
        }
    }

    public void serializeContext(Date dataIngresso, String idTransazione, IDService serviceType, TipoPdD tipoPdD, String protocol) {
        this.bfContext.append("------ RequestContext (" + idTransazione + ") ------\n");
        this.idTransaction = idTransazione;
        try {
            if (dataIngresso != null) {
                SimpleDateFormat dateformat = new SimpleDateFormat(format);
                this.bfContext.append("Date: ");
                this.bfContext.append(dateformat.format(dataIngresso));
                this.bfContext.append("\n");
            }
            if (idTransazione != null) {
                this.bfContext.append("IdTransaction: ");
                this.bfContext.append(idTransazione);
                this.bfContext.append("\n");
            }
            if (protocol != null) {
                this.bfContext.append("Protocol: ");
                this.bfContext.append(protocol);
                this.bfContext.append("\n");
            }
            if (serviceType != null) {
                this.bfContext.append("Service: ");
                this.bfContext.append(serviceType.getValue());
                this.bfContext.append("\n");
            }
            if (tipoPdD != null) {
                this.bfContext.append("PddType: ");
                this.bfContext.append(tipoPdD.getTipo());
                this.bfContext.append("\n");
            }
        }
        catch (Throwable t) {
            this.bfContext.append("SerializeContext error: " + t.getMessage() + "\n");
            this.log.error((Object)("SerializeContext error: " + t.getMessage()), t);
        }
        this.bfContext.append("------ End-RequestContext (" + this.idTransaction + ") ------\n\n");
        this.logDump.info((Object)this.bfContext.toString());
    }

    public void serializeRequest(DumpRawConnectorInMessage req, boolean buildOpenSPCoopMessage, NotifierInputStreamParams notifierInputStreamParams) {
        String contentType = null;
        try {
            contentType = req.getContentType();
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getContentType error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getContentType error: " + t.getMessage()), t);
        }
        Integer contentLength = null;
        try {
            contentLength = req.getContentLength();
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getContentLength error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getContentLength error: " + t.getMessage()), t);
        }
        Identity identity = null;
        try {
            identity = req.getIdentity();
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getIdentity error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getIdentity error: " + t.getMessage()), t);
        }
        URLProtocolContext urlProtocolContext = null;
        try {
            urlProtocolContext = req.getURLProtocolContext();
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getURLProtocolContext error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getURLProtocolContext error: " + t.getMessage()), t);
        }
        try {
            if (buildOpenSPCoopMessage) {
                req.getRequest(notifierInputStreamParams, contentType);
            } else {
                req.getRequest();
            }
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getURLProtocolContext error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getURLProtocolContext error: " + t.getMessage()), t);
        }
        this.serializeRequest(contentType, contentLength, identity, urlProtocolContext, req.getRequestAsString());
    }

    public void serializeRequest(String contentType, Integer contentLength, Identity identity, URLProtocolContext urlProtocolContext, String rawMessage) {
        this.bfRequest.append("------ Request (" + this.idTransaction + ") ------\n");
        try {
            if (contentType != null) {
                this.bfRequest.append("ContentType: ");
                this.bfRequest.append(contentType);
                this.bfRequest.append("\n");
            }
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getContentType error: " + t.getMessage());
            this.log.error((Object)("Request.getContentType error: " + t.getMessage()), t);
        }
        try {
            if (contentLength != null && contentLength >= 0) {
                this.bfRequest.append("ContentLength: ");
                this.bfRequest.append(contentLength);
                this.bfRequest.append("\n");
            }
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getContentLength error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getContentLength error: " + t.getMessage()), t);
        }
        try {
            if (identity != null) {
                X509Certificate[] certificates;
                String subjectX509;
                String password;
                String username;
                String principal = identity.getPrincipal();
                if (principal != null) {
                    this.bfRequest.append("Principal: ");
                    this.bfRequest.append(principal);
                    this.bfRequest.append("\n");
                }
                if ((username = identity.getUsername()) != null) {
                    this.bfRequest.append("Username: ");
                    this.bfRequest.append(username);
                    this.bfRequest.append("\n");
                }
                if ((password = identity.getPassword()) != null) {
                    this.bfRequest.append("Password: ");
                    this.bfRequest.append(password);
                    this.bfRequest.append("\n");
                }
                if ((subjectX509 = identity.getSubject()) != null) {
                    this.bfRequest.append("X509.Subject: ");
                    this.bfRequest.append(subjectX509);
                    this.bfRequest.append("\n");
                }
                if ((certificates = identity.getCerts()) != null && certificates.length > 0) {
                    Identity.printCertificate((StringBuffer)this.bfRequest, (X509Certificate[])certificates);
                }
            }
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getIdentity error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getIdentity error: " + t.getMessage()), t);
        }
        try {
            if (urlProtocolContext != null) {
                Properties transportHeader;
                String function;
                String urlInvocazione = urlProtocolContext.getUrlInvocazione_formBased();
                if (urlInvocazione != null) {
                    this.bfRequest.append("URLInvocazione: ");
                    this.bfRequest.append(urlInvocazione);
                    this.bfRequest.append("\n");
                }
                if ((function = urlProtocolContext.getFunction()) != null) {
                    this.bfRequest.append("Function: ");
                    this.bfRequest.append(function);
                    this.bfRequest.append("\n");
                }
                if ((transportHeader = urlProtocolContext.getParametersTrasporto()) != null && transportHeader.size() > 0) {
                    this.bfRequest.append("TransportHeaders: " + transportHeader.size() + "\n");
                    Enumeration<Object> keys = transportHeader.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = transportHeader.getProperty(key);
                        if (value instanceof String) {
                            this.bfRequest.append("\t" + key + "=" + value + "\n");
                            continue;
                        }
                        this.bfRequest.append("\t" + key + "=ObjectType(" + value.getClass().getName() + ")\n");
                    }
                } else {
                    this.bfRequest.append("TransportHeaders: 0\n");
                }
                Properties parameterUrl = urlProtocolContext.getParametersFormBased();
                if (parameterUrl != null && parameterUrl.size() > 0) {
                    this.bfRequest.append("URLParameters: " + parameterUrl.size() + "\n");
                    Enumeration<Object> keys = parameterUrl.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = parameterUrl.getProperty(key);
                        if (value instanceof String) {
                            this.bfRequest.append("\t" + key + "=" + value + "\n");
                            continue;
                        }
                        this.bfRequest.append("\t" + key + "=ObjectType(" + value.getClass().getName() + ")\n");
                    }
                } else {
                    this.bfRequest.append("URLParameters: 0\n");
                }
            }
        }
        catch (Throwable t) {
            this.bfRequest.append("Request.getURLProtocolContext error: " + t.getMessage() + "\n");
            this.log.error((Object)("Request.getURLProtocolContext error: " + t.getMessage()), t);
        }
        if (rawMessage != null) {
            this.bfRequest.append("Binary Request Length: ");
            this.bfRequest.append(rawMessage.length());
            this.bfRequest.append("\n");
            this.bfRequest.append("Binary Request: \n");
            this.bfRequest.append(rawMessage);
            this.bfRequest.append("\n");
        } else {
            this.bfRequest.append("Binary Request Length: ");
            this.bfRequest.append(0);
            this.bfRequest.append("\n");
            this.bfRequest.append("Binary Request: \n");
            this.bfRequest.append("Nessuna contenuto presente nel payload");
            this.bfRequest.append("\n");
        }
        this.bfRequest.append("------ End-Request (" + this.idTransaction + ") ------\n\n");
        this.logDump.info((Object)this.bfRequest.toString());
    }

    public void serializeResponse(DumpRawConnectorOutMessage res) {
        this.serializeResponse(res.getResponseAsString(), res.getTrasporto(), res.getContentLenght(), res.getContentType(), res.getStatus());
    }

    public void serializeResponse(String rawMessage, Properties transportHeader, Integer contentLength, String contentType, Integer status) {
        this.bfResponse.append("------ Response (" + this.idTransaction + ") ------\n");
        try {
            if (contentType != null) {
                this.bfResponse.append("ContentType: ");
                this.bfResponse.append(contentType);
                this.bfResponse.append("\n");
            }
        }
        catch (Throwable t) {
            this.bfResponse.append("Response.contentType error: " + t.getMessage());
            this.log.error((Object)("Response.contentType error: " + t.getMessage()), t);
        }
        try {
            if (contentLength != null && contentLength >= 0) {
                this.bfResponse.append("ContentLength: ");
                this.bfResponse.append(contentLength);
                this.bfResponse.append("\n");
            }
        }
        catch (Throwable t) {
            this.bfResponse.append("Response.contentLength error: " + t.getMessage() + "\n");
            this.log.error((Object)("Response.contentLength error: " + t.getMessage()), t);
        }
        try {
            if (status != null) {
                this.bfResponse.append("Status: ");
                this.bfResponse.append(status);
                this.bfResponse.append("\n");
            }
        }
        catch (Throwable t) {
            this.bfResponse.append("Response.status error: " + t.getMessage() + "\n");
            this.log.error((Object)("Response.status error: " + t.getMessage()), t);
        }
        if (transportHeader != null && transportHeader.size() > 0) {
            this.bfResponse.append("TransportHeaders: " + transportHeader.size() + "\n");
            Enumeration<Object> keys = transportHeader.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = transportHeader.getProperty(key);
                if (value instanceof String) {
                    this.bfResponse.append("\t" + key + "=" + value + "\n");
                    continue;
                }
                this.bfResponse.append("\t" + key + "=ObjectType(" + value.getClass().getName() + ")\n");
            }
        } else {
            this.bfResponse.append("TransportHeaders: 0\n");
        }
        if (rawMessage != null) {
            this.bfResponse.append("Binary Response Length: ");
            this.bfResponse.append(rawMessage.length());
            this.bfResponse.append("\n");
            this.bfResponse.append("Binary Response: \n");
            this.bfResponse.append(rawMessage);
            this.bfResponse.append("\n");
        } else {
            this.bfResponse.append("Binary Response Length: ");
            this.bfResponse.append(0);
            this.bfResponse.append("\n");
            this.bfResponse.append("Binary Response: \n");
            this.bfResponse.append("Nessuna contenuto presente nel payload");
            this.bfResponse.append("\n");
        }
        this.bfResponse.append("------ End-Response (" + this.idTransaction + ") ------\n\n");
        this.logDump.info((Object)this.bfResponse.toString());
    }
}

