/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.message.SoapUtilsBuildParameter;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.IntegrationContext;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.utils.id.UniqueIdentifierException;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public abstract class AbstractContext
implements Serializable {
    private static final OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private static final long serialVersionUID = 1L;
    protected Date dataIngressoRichiesta;
    protected PdDContext pddContext;
    private URLProtocolContext urlProtocolContext;
    private String idMessage;
    private String idModulo;
    protected IDSoggetto identitaPdD;
    private OpenSPCoop2Message messageRequest;
    private byte[] messageRequest_ByteArray;
    private OpenSPCoop2Message messageResponse;
    private byte[] messageResponse_ByteArray;
    private boolean gestioneRisposta;
    private Credenziali credenziali;
    private String fromLocation;
    private String soapAction = null;
    private ProtocolContext protocol;
    private IntegrationContext integrazione;
    private TipoPdD tipoPorta;
    private MsgDiagnostico msgDiagnostico;
    private Properties headerIntegrazioneRisposta;
    private NotifierInputStreamParams notifierInputStreamParams;
    private IDService idModuloAsIDService;

    public Date getDataIngressoRichiesta() {
        return this.dataIngressoRichiesta;
    }

    public PdDContext getPddContext() {
        return this.pddContext;
    }

    public AbstractContext(IDService idModuloAsIDService, Date dataIngressoRichiesta, IDSoggetto identitaPdD) throws UniqueIdentifierException {
        this.pddContext = new PdDContext();
        this.pddContext.addObject("ID", UniqueIdentifierManager.newUniqueIdentifier().getAsString());
        this.dataIngressoRichiesta = dataIngressoRichiesta;
        this.identitaPdD = identitaPdD;
        this.idModuloAsIDService = idModuloAsIDService;
    }

    protected AbstractContext(IDService idModuloAsIDService) {
        this.idModuloAsIDService = idModuloAsIDService;
    }

    public IDService getIdModuloAsIDService() {
        return this.idModuloAsIDService;
    }

    public String getIdModulo() {
        return this.idModulo;
    }

    public void setIdModulo(String idModulo) {
        this.idModulo = idModulo;
    }

    public OpenSPCoop2Message getMessageRequest() {
        return this.messageRequest;
    }

    public OpenSPCoop2Message getMessageResponse() {
        return this.messageResponse;
    }

    public void setMessageRequest(OpenSPCoop2Message message) {
        this.messageRequest = message;
    }

    public void setMessageResponse(OpenSPCoop2Message messageResponse) {
        this.messageResponse = messageResponse;
    }

    public Credenziali getCredenziali() {
        return this.credenziali;
    }

    public void setCredenziali(Credenziali credenziali) {
        this.credenziali = credenziali;
    }

    public boolean isGestioneRisposta() {
        return this.gestioneRisposta;
    }

    public void setGestioneRisposta(boolean gestioneRisposta) {
        this.gestioneRisposta = gestioneRisposta;
    }

    public OpenSPCoop2Message getMessageRequestFromByte() throws Exception {
        OpenSPCoop2Message requestSOAPMessage = null;
        try {
            requestSOAPMessage = SoapUtils.build((SoapUtilsBuildParameter)new SoapUtilsBuildParameter(this.messageRequest_ByteArray, false, openspcoopProperties.isDeleteInstructionTargetMachineXml(), openspcoopProperties.isFileCacheEnable(), openspcoopProperties.getAttachmentRepoDir(), openspcoopProperties.getFileThreshold()), (NotifierInputStreamParams)this.getNotifierInputStreamParams());
            return requestSOAPMessage;
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di richiesta Soap, per la ricostruzione, non valida: " + e.getMessage());
        }
    }

    public byte[] getMessageRequestAsByte() throws Exception {
        return this.messageRequest_ByteArray;
    }

    public void setMessageRequestAsByte(byte[] messageRequestByte) {
        this.messageRequest_ByteArray = messageRequestByte;
    }

    public void setMessageRequestAsByte(OpenSPCoop2Message messageRequestByte) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            messageRequestByte.writeTo((OutputStream)out, false);
            this.messageRequest_ByteArray = out.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di richiesta Soap, per il salvataggio, non valida: " + e.getMessage());
        }
    }

    public OpenSPCoop2Message getMessageResponseFromByte() throws Exception {
        OpenSPCoop2Message requestSOAPMessage = null;
        try {
            requestSOAPMessage = SoapUtils.build((SoapUtilsBuildParameter)new SoapUtilsBuildParameter(this.messageResponse_ByteArray, false, openspcoopProperties.isDeleteInstructionTargetMachineXml(), openspcoopProperties.isFileCacheEnable(), openspcoopProperties.getAttachmentRepoDir(), openspcoopProperties.getFileThreshold()), (NotifierInputStreamParams)this.getNotifierInputStreamParams());
            return requestSOAPMessage;
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di risposta Soap, per la ricostruzione non valida: " + e.getMessage());
        }
    }

    public byte[] getMessageResponseAsByte() throws Exception {
        return this.messageResponse_ByteArray;
    }

    public void setMessageResponseAsByte(byte[] messageResponseByte) {
        this.messageResponse_ByteArray = messageResponseByte;
    }

    public void setMessageResponseAsByte(OpenSPCoop2Message messageResponseByte) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            messageResponseByte.writeTo((OutputStream)out, false);
            this.messageResponse_ByteArray = out.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("Struttura del messaggio di risposta Soap, per il salvataggio, non valida: " + e.getMessage());
        }
    }

    public String getFromLocation() {
        return this.fromLocation;
    }

    public void setFromLocation(String fromLocation) {
        this.fromLocation = fromLocation;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public MsgDiagnostico getMsgDiagnostico() {
        return this.msgDiagnostico;
    }

    public void setMsgDiagnostico(MsgDiagnostico msgDiagnostico) {
        this.msgDiagnostico = msgDiagnostico;
    }

    public String getIdMessage() {
        return this.idMessage;
    }

    public void setIdMessage(String id) {
        this.idMessage = id;
    }

    public ProtocolContext getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolContext p) {
        this.protocol = p;
    }

    public IntegrationContext getIntegrazione() {
        return this.integrazione;
    }

    public void setIntegrazione(IntegrationContext integrazione) {
        this.integrazione = integrazione;
    }

    public TipoPdD getTipoPorta() {
        return this.tipoPorta;
    }

    public void setTipoPorta(TipoPdD tipoPorta) {
        this.tipoPorta = tipoPorta;
    }

    public Properties getHeaderIntegrazioneRisposta() {
        return this.headerIntegrazioneRisposta;
    }

    public void setHeaderIntegrazioneRisposta(Properties headerIntegrazione) {
        this.headerIntegrazioneRisposta = headerIntegrazione;
    }

    public IDSoggetto getIdentitaPdD() {
        return this.identitaPdD;
    }

    public void setIdentitaPdD(IDSoggetto identitaPdD) {
        this.identitaPdD = identitaPdD;
    }

    public URLProtocolContext getUrlProtocolContext() {
        return this.urlProtocolContext;
    }

    public void setUrlProtocolContext(URLProtocolContext urlProtocolContext) {
        this.urlProtocolContext = urlProtocolContext;
    }

    public NotifierInputStreamParams getNotifierInputStreamParams() {
        return this.notifierInputStreamParams;
    }

    public void setNotifierInputStreamParams(NotifierInputStreamParams notifierInputStreamParams) {
        this.notifierInputStreamParams = notifierInputStreamParams;
    }
}

