/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.monitor.driver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.monitor.Busta;
import org.openspcoop2.pdd.monitor.BustaServizio;
import org.openspcoop2.pdd.monitor.BustaSoggetto;
import org.openspcoop2.pdd.monitor.Dettaglio;
import org.openspcoop2.pdd.monitor.Messaggio;
import org.openspcoop2.pdd.monitor.Proprieta;
import org.openspcoop2.pdd.monitor.ServizioApplicativoConsegna;
import org.openspcoop2.pdd.monitor.StatoPdd;
import org.openspcoop2.pdd.monitor.constants.StatoMessaggio;
import org.openspcoop2.pdd.monitor.driver.DriverMonitoraggioException;
import org.openspcoop2.pdd.monitor.driver.FilterSearch;
import org.openspcoop2.pdd.monitor.driver.IDriverMonitoraggio;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DriverMonitoraggio
implements IDriverMonitoraggio {
    private DataSource datasource = null;
    private Connection globalConnection = null;
    private String tipoDatabase = null;
    private Logger log = null;
    private Vector<String> properties;

    public void setProperties(Vector<String> properties) {
        this.properties = properties;
    }

    public DriverMonitoraggio(String nomeDataSource, String tipoDatabase, Properties prop) throws DriverMonitoraggioException {
        this(nomeDataSource, tipoDatabase, prop, null);
    }

    public DriverMonitoraggio(String nomeDataSource, String tipoDatabase, Properties prop, Logger log) throws DriverMonitoraggioException {
        try {
            this.log = log == null ? Logger.getLogger((String)"DRIVER_DB_MONITORAGGIO") : log;
        }
        catch (Exception e) {
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info((Object)"Inizializzo DriverMonitoraggioDB...");
            InitialContext initCtx = new InitialContext(prop);
            this.datasource = (DataSource)initCtx.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            initCtx.close();
            this.log.info((Object)"Inizializzo DriverMonitoraggioDB terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject ...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del SQLQueryObject(" + tipoDatabase + ")...", e);
        }
    }

    public DriverMonitoraggio(String connectionUrl, String driverJDBC, String username, String password, String tipoDatabase) throws DriverMonitoraggioException {
        this(connectionUrl, driverJDBC, username, password, tipoDatabase, null);
    }

    public DriverMonitoraggio(String connectionUrl, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverMonitoraggioException {
        try {
            this.log = log == null ? Logger.getLogger((String)"DRIVER_DB_MONITORAGGIO") : log;
        }
        catch (Exception e) {
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info((Object)"Inizializzo DriverMonitoraggioDB...");
            Class.forName(driverJDBC).newInstance();
            this.globalConnection = username != null ? DriverManager.getConnection(connectionUrl, username, password) : DriverManager.getConnection(connectionUrl);
            if (this.globalConnection == null) {
                throw new Exception("Connection is null");
            }
            this.log.info((Object)"Inizializzo DriverMonitoraggioDB terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante l'inizializzazione della connessione...", (Throwable)e);
            throw new DriverMonitoraggioException("Errore durante l'inizializzazione della connessione...", e);
        }
        try {
            this.log.info((Object)"Inizializzo ISQLQueryObject ...");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info((Object)"Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMonitoraggioException("Errore durante la ricerca del SQLQueryObject(" + tipoDatabase + ")...", e);
        }
    }

    @Override
    public StatoPdd getStatoRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        try {
            int k;
            List<BustaSoggetto> filtroSoggetti;
            con = this.datasource != null ? this.datasource.getConnection() : this.globalConnection;
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            StatoPdd statoPdD = new StatoPdd();
            Timestamp now = DateManager.getTimestamp();
            Timestamp data_registrazione_limite = null;
            if (search.getSoglia() != -1L) {
                data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            long totaleMessaggi = 0L;
            long totaleMessaggiDuplicati = -1L;
            sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int param_index = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++param_index, data_registrazione_limite);
            }
            if ((filtroSoggetti = search.getSoggettoList()) != null) {
                for (k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                }
            }
            if ((rs = pstmt.executeQuery()).next() && (totaleMessaggi = rs.getLong("totMessaggi")) > 0L) {
                statoPdD.setTotMessaggi(totaleMessaggi);
                statoPdD.setTempoMedioAttesa((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                statoPdD.setTempoMaxAttesa((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
            }
            rs.close();
            pstmt.close();
            this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggi:" + totaleMessaggi));
            this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] totaleMessaggi"));
            if (totaleMessaggi > 0L) {
                if (search.getStato() == null || "".equals(search.getStato()) || StatoMessaggio.CONSEGNA.equals(search.getStato())) {
                    long tot;
                    sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                    if (search.getStato() == null || "".equals(search.getStato())) {
                        sqlQueryObject.addWhereCondition("MESSAGGI.proprietario='ConsegnaContenutiApplicativi'");
                    }
                    pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    param_index = 0;
                    if (search.getSoglia() != -1L) {
                        pstmt.setTimestamp(++param_index, data_registrazione_limite);
                    }
                    if (filtroSoggetti != null) {
                        for (k = 0; k < filtroSoggetti.size(); ++k) {
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                        statoPdD.setNumMsgInConsegna(tot);
                        statoPdD.setTempoMedioAttesaInConsegna((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                        statoPdD.setTempoMaxAttesaInConsegna((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                    }
                    rs.close();
                    pstmt.close();
                    this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggiInConsegna:" + statoPdD.getNumMsgInConsegna()));
                    this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] totaleMessaggiInConsegna"));
                }
                if (search.getStato() == null || "".equals(search.getStato()) || StatoMessaggio.SPEDIZIONE.equals(search.getStato())) {
                    long tot;
                    sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                    if (search.getStato() == null || "".equals(search.getStato())) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"MESSAGGI.proprietario='InoltroBuste'", "MESSAGGI.proprietario='InoltroRisposte'"});
                    }
                    pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    param_index = 0;
                    if (search.getSoglia() != -1L) {
                        pstmt.setTimestamp(++param_index, data_registrazione_limite);
                    }
                    if (filtroSoggetti != null) {
                        for (k = 0; k < filtroSoggetti.size(); ++k) {
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                        statoPdD.setNumMsgInSpedizione(tot);
                        statoPdD.setTempoMedioAttesaInSpedizione((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                        statoPdD.setTempoMaxAttesaInSpedizione((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                    }
                    rs.close();
                    pstmt.close();
                    this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggiInSpedizione:" + statoPdD.getNumMsgInSpedizione()));
                    this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] totaleMessaggiInSpedizione"));
                }
                if (search.getStato() == null || "".equals(search.getStato()) || StatoMessaggio.PROCESSAMENTO.equals(search.getStato())) {
                    long tot;
                    sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
                    if (search.getStato() == null || "".equals(search.getStato())) {
                        sqlQueryObject.addWhereCondition(true, new String[]{"MESSAGGI.proprietario<>'InoltroBuste'", "MESSAGGI.proprietario<>'InoltroRisposte'", "MESSAGGI.proprietario<>'ConsegnaContenutiApplicativi'"});
                    }
                    pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
                    param_index = 0;
                    if (search.getSoglia() != -1L) {
                        pstmt.setTimestamp(++param_index, data_registrazione_limite);
                    }
                    if (filtroSoggetti != null) {
                        for (k = 0; k < filtroSoggetti.size(); ++k) {
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                            pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next() && (tot = rs.getLong("totMessaggi")) > 0L) {
                        statoPdD.setNumMsgInProcessamento(tot);
                        statoPdD.setTempoMedioAttesaInProcessamento((now.getTime() - rs.getLong("ora_registrazione_media")) / 1000L);
                        statoPdD.setTempoMaxAttesaInProcessamento((now.getTime() - rs.getLong("ora_registrazione_old")) / 1000L);
                    }
                    rs.close();
                    pstmt.close();
                    this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggiInProcessamento:" + statoPdD.getNumMsgInProcessamento()));
                    this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] totaleMessaggiInProcessamento"));
                }
            }
            this.log.debug((Object)"Calcolo numero pacchetti duplicati...");
            sqlQueryObject = this.newSQLQueryPacchettiDuplicati(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(1, data_registrazione_limite);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                totaleMessaggiDuplicati = rs.getLong("numduplicati");
                statoPdD.setTotMessaggiDuplicati(totaleMessaggiDuplicati);
            }
            rs.close();
            pstmt.close();
            this.log.debug((Object)("query[" + sqlQueryObject.toString() + "] totaleMessaggiDuplicati:" + totaleMessaggiDuplicati));
            this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] totaleMessaggiDuplicati"));
            StatoPdd statoPdd = statoPdD;
            return statoPdd;
        }
        catch (Exception e) {
            if (sqlQueryObject != null) {
                this.log.error((Object)("getStatoRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                throw new DriverMonitoraggioException("getStatoRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
            }
            this.log.error((Object)"getStatoRichiestePendenti error", (Throwable)e);
            throw new DriverMonitoraggioException("getStatoRichiestePendenti error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.datasource != null && con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public long getTotaleMessaggiInGestione() throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource != null ? this.datasource.getConnection() : this.globalConnection;
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            long totaleMessaggi = 0L;
            String query = "SELECT count(*) as totMessaggi FROM MESSAGGI WHERE MESSAGGI.proprietario<>'GestoreMessaggi'";
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                totaleMessaggi = rs.getLong("totMessaggi");
            }
            rs.close();
            pstmt.close();
            this.log.debug((Object)("query[" + query + "] totaleMessaggi:" + totaleMessaggi));
            long l = totaleMessaggi;
            return l;
        }
        catch (Exception e) {
            this.log.error((Object)"getTotaleMessaggiInGestione error", (Throwable)e);
            throw new DriverMonitoraggioException("getStatoRichiestePendenti error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.datasource != null && con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public long countListaRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        long oldLimit = search.getLimit();
        long oldOffset = search.getOffset();
        try {
            List<BustaSoggetto> filtroSoggetti;
            con = this.datasource != null ? this.datasource.getConnection() : this.globalConnection;
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            Timestamp data_registrazione_limite = null;
            if (search.getSoglia() != -1L) {
                data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            long totaleMessaggi = 0L;
            search.setLimit(-1L);
            search.setOffset(-1L);
            sqlQueryObject = this.newSQLQueryObjectStatoRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int param_index = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++param_index, data_registrazione_limite);
            }
            if ((filtroSoggetti = search.getSoggettoList()) != null) {
                for (int k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                totaleMessaggi = rs.getLong("totMessaggi");
            }
            rs.close();
            pstmt.close();
            this.log.debug((Object)("query[" + sqlQueryObject + "] totaleMessaggi:" + totaleMessaggi));
            this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] totaleMessaggi"));
            long l = totaleMessaggi;
            return l;
        }
        catch (Exception e) {
            if (sqlQueryObject != null) {
                this.log.error((Object)("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                throw new DriverMonitoraggioException("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
            }
            this.log.error((Object)"getListaRichiestePendenti error", (Throwable)e);
            throw new DriverMonitoraggioException("getListaRichiestePendenti error: " + e.getMessage(), e);
        }
        finally {
            search.setLimit(oldLimit);
            search.setOffset(oldOffset);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.datasource != null && con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public List<Messaggio> getListaRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        try {
            con = this.datasource != null ? this.datasource.getConnection() : this.globalConnection;
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            Timestamp data_registrazione_limite = null;
            if (search.getSoglia() != -1L) {
                data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            List<BustaSoggetto> filtroSoggetti = search.getSoggettoList();
            sqlQueryObject = this.newSQLQueryObjectListaRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int param_index = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++param_index, data_registrazione_limite);
            }
            if (filtroSoggetti != null) {
                for (int k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                }
            }
            rs = pstmt.executeQuery();
            ArrayList<Messaggio> msgs = new ArrayList<Messaggio>();
            this.log.debug((Object)("query[" + sqlQueryObject + "] listaMessaggi"));
            this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] listaMessaggi"));
            while (rs.next()) {
                Messaggio m = new Messaggio();
                m.setIdMessaggio(rs.getString("id_messaggio"));
                Dettaglio dettaglio = new Dettaglio();
                dettaglio.setIdModulo(rs.getString("proprietario"));
                dettaglio.setTipo(rs.getString("tipo"));
                dettaglio.setErroreProcessamento(rs.getString("ERRORE_PROCESSAMENTO"));
                dettaglio.setIdCorrelazioneApplicativa(rs.getString("CORRELAZIONE_APPLICATIVA"));
                if (this.properties != null) {
                    for (int i = 0; i < this.properties.size(); ++i) {
                        String key = this.properties.get(i);
                        Proprieta proprieta = new Proprieta();
                        proprieta.setNome(key);
                        proprieta.setValore(rs.getString(key));
                        dettaglio.addProprieta(proprieta);
                    }
                }
                m.setDettaglio(dettaglio);
                if (rs.getTimestamp("ORA_REGISTRAZIONE") != null) {
                    m.setOraRegistrazione(rs.getTimestamp("ORA_REGISTRAZIONE"));
                }
                m.setOraAttuale(DateManager.getDate());
                if ("ConsegnaContenutiApplicativi".equals(rs.getString("proprietario"))) {
                    m.setStato(StatoMessaggio.CONSEGNA);
                } else if ("InoltroBuste".equals(rs.getString("proprietario"))) {
                    m.setStato(StatoMessaggio.SPEDIZIONE);
                } else if ("InoltroRisposte".equals(rs.getString("proprietario"))) {
                    m.setStato(StatoMessaggio.SPEDIZIONE);
                } else {
                    m.setStato(StatoMessaggio.PROCESSAMENTO);
                }
                if (search.getBusta() != null) {
                    Busta bustaInfo = new Busta();
                    BustaSoggetto mittente = new BustaSoggetto();
                    mittente.setNome(rs.getString("MITTENTE"));
                    mittente.setTipo(rs.getString("TIPO_MITTENTE"));
                    bustaInfo.setMittente(mittente);
                    BustaSoggetto destinatario = new BustaSoggetto();
                    destinatario.setNome(rs.getString("DESTINATARIO"));
                    destinatario.setTipo(rs.getString("TIPO_DESTINATARIO"));
                    bustaInfo.setDestinatario(destinatario);
                    BustaServizio servizio = new BustaServizio();
                    servizio.setTipo(rs.getString("TIPO_SERVIZIO"));
                    servizio.setNome(rs.getString("SERVIZIO"));
                    bustaInfo.setServizio(servizio);
                    bustaInfo.setAzione(rs.getString("AZIONE"));
                    bustaInfo.setProfiloCollaborazione(rs.getString("PROFILO_DI_COLLABORAZIONE"));
                    bustaInfo.setRiferimentoMessaggio(rs.getString("RIFERIMENTO_MESSAGGIO"));
                    bustaInfo.setCollaborazione(rs.getString("COLLABORAZIONE"));
                    m.setBustaInfo(bustaInfo);
                }
                msgs.add(m);
            }
            rs.close();
            pstmt.close();
            for (int i = 0; i < msgs.size(); ++i) {
                boolean checkSA = false;
                if (msgs.get(i) != null && StatoMessaggio.CONSEGNA.equals(((Messaggio)msgs.get(i)).getStato()) && ((Messaggio)msgs.get(i)).getDettaglio() != null) {
                    checkSA = true;
                } else if (msgs.get(i) != null && ((Messaggio)msgs.get(i)).getDettaglio() != null && ((Messaggio)msgs.get(i)).getDettaglio().getIdModulo() != null && ((Messaggio)msgs.get(i)).getDettaglio().getIdModulo().startsWith("RicezioneContenutiApplicativi")) {
                    checkSA = true;
                }
                if (checkSA) {
                    this.log.debug((Object)"Raccolgo informazioni dei servizi applicativi...");
                    String sqlQuerySA = "SELECT * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=?";
                    pstmt = con.prepareStatement(sqlQuerySA);
                    pstmt.setString(1, ((Messaggio)msgs.get(i)).getIdMessaggio());
                    rs = pstmt.executeQuery();
                    Vector<ServizioApplicativoConsegna> sconsegna = new Vector<ServizioApplicativoConsegna>();
                    while (rs.next()) {
                        ServizioApplicativoConsegna datiConsegna = new ServizioApplicativoConsegna();
                        if (rs.getInt("SBUSTAMENTO_SOAP") == 1) {
                            datiConsegna.setSbustamentoSoap(true);
                        } else {
                            datiConsegna.setSbustamentoSoap(false);
                        }
                        if (rs.getInt("INTEGRATION_MANAGER") == 1) {
                            datiConsegna.setAutorizzazioneIntegrationManager(true);
                        } else {
                            datiConsegna.setAutorizzazioneIntegrationManager(false);
                        }
                        datiConsegna.setNome(rs.getString("SERVIZIO_APPLICATIVO"));
                        datiConsegna.setTipoConsegna(rs.getString("TIPO_CONSEGNA"));
                        datiConsegna.setErroreProcessamento(rs.getString("ERRORE_PROCESSAMENTO"));
                        sconsegna.add(datiConsegna);
                    }
                    rs.close();
                    pstmt.close();
                    if (sconsegna.size() > 0) {
                        ((Messaggio)msgs.get(i)).getDettaglio().setServizioApplicativoConsegnaList(sconsegna);
                    }
                }
                if (msgs.get(i) == null || ((Messaggio)msgs.get(i)).getBustaInfo() == null || !StatoMessaggio.SPEDIZIONE.equals(((Messaggio)msgs.get(i)).getStato())) continue;
                if (search.getBusta() != null && search.getBusta().isAttesaRiscontro()) {
                    ((Messaggio)msgs.get(i)).getBustaInfo().setAttesaRiscontro(true);
                    continue;
                }
                this.log.debug((Object)"Raccolgo informazioni per attesa riscontro...");
                String sqlQueryRiscontro = "SELECT * FROM RISCONTRI_DA_RICEVERE WHERE ID_MESSAGGIO=?";
                pstmt = con.prepareStatement(sqlQueryRiscontro);
                pstmt.setString(1, ((Messaggio)msgs.get(i)).getIdMessaggio());
                rs = pstmt.executeQuery();
                ((Messaggio)msgs.get(i)).getBustaInfo().setAttesaRiscontro(rs.next());
                rs.close();
                pstmt.close();
            }
            ArrayList<Messaggio> arrayList = msgs;
            return arrayList;
        }
        catch (Exception e) {
            if (sqlQueryObject != null) {
                this.log.error((Object)("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                throw new DriverMonitoraggioException("getListaRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
            }
            this.log.error((Object)"getListaRichiestePendenti error", (Throwable)e);
            throw new DriverMonitoraggioException("getListaRichiestePendenti error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.datasource != null && con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private boolean deleteMessaggio(String idMessaggio, String tipo) throws DriverMonitoraggioException {
        boolean bl;
        Connection con = null;
        Statement pstmt = null;
        try {
            String sqlQuery;
            con = this.datasource != null ? this.datasource.getConnection() : this.globalConnection;
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            String tipoMessaggio = tipo;
            if (tipoMessaggio == null) {
                this.log.debug((Object)"Ricerco tipo messaggio...");
                FilterSearch filtro = new FilterSearch();
                filtro.setIdMessaggio(idMessaggio);
                List<Messaggio> lista = this.getListaRichiestePendenti(filtro);
                if (lista == null || lista.size() <= 0) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (lista.get(0).getDettaglio() == null || lista.get(0).getDettaglio().getTipo() == null) {
                    throw new Exception("Tipo messaggio non identificato per l'id: " + idMessaggio);
                }
                tipoMessaggio = lista.get(0).getDettaglio().getTipo();
            }
            this.log.debug((Object)("Messaggio con id(" + idMessaggio + ") da eliminare possiede tipo: " + tipoMessaggio));
            if ("OUTBOX".equals(tipoMessaggio)) {
                sqlQuery = "DELETE FROM RISCONTRI_DA_RICEVERE WHERE ID_MESSAGGIO=?";
                pstmt = con.prepareStatement(sqlQuery);
                pstmt.setString(1, idMessaggio);
                int operation = pstmt.executeUpdate();
                if (operation > 0) {
                    this.log.debug((Object)("Attesa riscontro per " + idMessaggio + " eliminato"));
                } else {
                    this.log.debug((Object)("Attesa riscontro per " + idMessaggio + " non esistente"));
                }
                pstmt.close();
                sqlQuery = "DELETE FROM ASINCRONO WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = con.prepareStatement(sqlQuery);
                pstmt.setString(1, idMessaggio);
                pstmt.setString(2, tipoMessaggio);
                operation = pstmt.executeUpdate();
                if (operation > 0) {
                    this.log.debug((Object)("ProfiloAsincrono per " + idMessaggio + " eliminato"));
                } else {
                    this.log.debug((Object)("ProfiloAsincrono per " + idMessaggio + " non esistente"));
                }
                pstmt.close();
            }
            sqlQuery = "UPDATE MESSAGGI SET proprietario='GestoreMessaggi' WHERE proprietario<>'GestoreMessaggi' AND ID_MESSAGGIO=?  AND tipo=?";
            pstmt = con.prepareStatement(sqlQuery);
            pstmt.setString(1, idMessaggio);
            pstmt.setString(2, tipoMessaggio);
            int operation = pstmt.executeUpdate();
            boolean result = false;
            if (operation > 0) {
                result = true;
                this.log.debug((Object)("Messaggio " + idMessaggio + " eliminato"));
            } else {
                this.log.debug((Object)("Messaggio " + idMessaggio + " non esistente"));
            }
            pstmt.close();
            bl = result;
        }
        catch (Exception e) {
            this.log.error((Object)"deleteMessaggio error", (Throwable)e);
            throw new DriverMonitoraggioException("deleteMessaggio error: " + e.getMessage());
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.datasource != null && con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
        return bl;
    }

    @Override
    public long deleteRichiestePendenti(FilterSearch search) throws DriverMonitoraggioException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Object sqlQueryObject = null;
        try {
            List<BustaSoggetto> filtroSoggetti;
            con = this.datasource != null ? this.datasource.getConnection() : this.globalConnection;
            if (con == null) {
                throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
            }
            Timestamp data_registrazione_limite = null;
            if (search.getSoglia() != -1L) {
                data_registrazione_limite = new Timestamp(DateManager.getTimeMillis() - search.getSoglia() * 1000L * 60L);
            }
            sqlQueryObject = this.newSQLQueryObjectListaRichiestePendenti(search);
            pstmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int param_index = 0;
            if (search.getSoglia() != -1L) {
                pstmt.setTimestamp(++param_index, data_registrazione_limite);
            }
            if ((filtroSoggetti = search.getSoggettoList()) != null) {
                for (int k = 0; k < filtroSoggetti.size(); ++k) {
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getTipo());
                    pstmt.setString(++param_index, filtroSoggetti.get(k).getNome());
                }
            }
            rs = pstmt.executeQuery();
            Vector<Messaggio> msgs = new Vector<Messaggio>();
            this.log.debug((Object)("query[" + sqlQueryObject + "] listaMessaggi"));
            this.log.debug((Object)("Soglia [" + search.getSoglia() + "] [" + data_registrazione_limite + "] listaMessaggi"));
            while (rs.next()) {
                Messaggio m = new Messaggio();
                m.setIdMessaggio(rs.getString("ID_MESSAGGIO"));
                Dettaglio dettaglio = new Dettaglio();
                dettaglio.setTipo(rs.getString("tipo"));
                m.setDettaglio(dettaglio);
                msgs.add(m);
            }
            rs.close();
            pstmt.close();
            long numeroMsgEliminati = 0L;
            while (msgs.size() > 0) {
                Messaggio msgForDelete = (Messaggio)msgs.remove(0);
                if (!this.deleteMessaggio(msgForDelete.getIdMessaggio(), msgForDelete.getDettaglio().getTipo())) continue;
                ++numeroMsgEliminati;
            }
            this.log.debug((Object)("eliminati " + numeroMsgEliminati + " messaggi"));
            long l = numeroMsgEliminati;
            return l;
        }
        catch (Exception e) {
            if (sqlQueryObject != null) {
                this.log.error((Object)("deleteRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]"), (Throwable)e);
                throw new DriverMonitoraggioException("deleteRichiestePendenti error SQL[" + sqlQueryObject.toString() + "]: " + e.getMessage(), e);
            }
            this.log.error((Object)"deleteRichiestePendenti error", (Throwable)e);
            throw new DriverMonitoraggioException("deleteRichiestePendenti error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.datasource != null && con != null) {
                    con.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private ISQLQueryObject newSQLQueryObjectStatoRichiestePendenti(FilterSearch search) throws SQLQueryObjectException {
        return this.newSQLQueryObjectRichiestePendenti(true, search);
    }

    private ISQLQueryObject newSQLQueryObjectListaRichiestePendenti(FilterSearch search) throws SQLQueryObjectException {
        return this.newSQLQueryObjectRichiestePendenti(false, search);
    }

    private ISQLQueryObject newSQLQueryObjectRichiestePendenti(boolean statoRichieste, FilterSearch search) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("MESSAGGI");
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addFromTable("DEFINIZIONE_MESSAGGI");
        }
        if (search.getBusta() != null && !"".equals(search.getBusta())) {
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
            if (search.getBusta().isAttesaRiscontro()) {
                sqlQueryObject.addFromTable("RISCONTRI_DA_RICEVERE");
            }
        } else if (search.getSoggettoList() != null && search.getSoggettoList().size() > 0) {
            sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
        }
        String legameTabelleSQL_MSG_ID = "MESSAGGI.ID_MESSAGGIO=DEFINIZIONE_MESSAGGI.ID_MESSAGGIO";
        String legameTabelleSQL_MSG_TIPO = "MESSAGGI.tipo=DEFINIZIONE_MESSAGGI.tipo";
        String legameTabelleSQL_BUSTA_ID = "MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO";
        String legameTabelleSQL_BUSTA_TIPO = "MESSAGGI.tipo=REPOSITORY_BUSTE.tipo";
        String legameTabelleSQL_RISCONTRO = "MESSAGGI.ID_MESSAGGIO=RISCONTRI_DA_RICEVERE.ID_MESSAGGIO";
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQL_MSG_ID, legameTabelleSQL_MSG_TIPO});
        }
        if (search.getBusta() != null) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQL_BUSTA_ID, legameTabelleSQL_BUSTA_TIPO});
        } else if (search.getSoggettoList() != null && search.getSoggettoList().size() > 0) {
            sqlQueryObject.addWhereCondition(true, new String[]{legameTabelleSQL_BUSTA_ID, legameTabelleSQL_BUSTA_TIPO});
        }
        if (search.getBusta() != null && search.getBusta().isAttesaRiscontro()) {
            sqlQueryObject.addWhereCondition(legameTabelleSQL_RISCONTRO);
        }
        if (statoRichieste) {
            sqlQueryObject.addSelectCountField("MESSAGGI.ID_MESSAGGIO", "totMessaggi", true);
            sqlQueryObject.addSelectAvgTimestampField("MESSAGGI.ora_registrazione", "ora_registrazione_media");
            sqlQueryObject.addSelectMinTimestampField("MESSAGGI.ora_registrazione", "ora_registrazione_old");
        } else {
            sqlQueryObject.addSelectField("MESSAGGI", "ID_MESSAGGIO");
            sqlQueryObject.addSelectField("MESSAGGI", "tipo");
            sqlQueryObject.addSelectField("MESSAGGI", "proprietario");
            sqlQueryObject.addSelectField("MESSAGGI", "ORA_REGISTRAZIONE");
            sqlQueryObject.addSelectField("MESSAGGI", "ERRORE_PROCESSAMENTO");
            sqlQueryObject.addSelectField("MESSAGGI", "CORRELAZIONE_APPLICATIVA");
            if (this.properties != null) {
                for (int i = 0; i < this.properties.size(); ++i) {
                    String key = this.properties.get(i);
                    sqlQueryObject.addSelectField("MESSAGGI", key);
                }
            }
            if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
                sqlQueryObject.addSelectField("DEFINIZIONE_MESSAGGI", "MSG_BYTES");
            }
            if (search.getBusta() != null) {
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_MITTENTE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "MITTENTE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_DESTINATARIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "DESTINATARIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_SERVIZIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "SERVIZIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "AZIONE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "PROFILO_DI_COLLABORAZIONE");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "RIFERIMENTO_MESSAGGIO");
                sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "COLLABORAZIONE");
            }
            if (search.getBusta() == null || search.getBusta().isAttesaRiscontro()) {
                // empty if block
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (!statoRichieste) {
            sqlQueryObject.addOrderBy("MESSAGGI.ORA_REGISTRAZIONE");
            sqlQueryObject.setSortType(false);
        }
        if (search.getStato() == null || "".equals(search.getStato()) || !StatoMessaggio.CANCELLATO.equals(search.getStato())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.proprietario<>'GestoreMessaggi'");
        }
        if (search.getStato() != null && !"".equals(search.getStato())) {
            if (StatoMessaggio.CONSEGNA.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition("MESSAGGI.proprietario='ConsegnaContenutiApplicativi'");
            } else if (StatoMessaggio.SPEDIZIONE.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition(false, new String[]{"MESSAGGI.proprietario='InoltroBuste'", "MESSAGGI.proprietario='InoltroRisposte'"});
            } else if (StatoMessaggio.CANCELLATO.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition("MESSAGGI.proprietario='GestoreMessaggi'");
            } else if (StatoMessaggio.PROCESSAMENTO.equals(search.getStato())) {
                sqlQueryObject.addWhereCondition(true, new String[]{"MESSAGGI.proprietario<>'InoltroBuste'", "MESSAGGI.proprietario<>'InoltroRisposte'", "MESSAGGI.proprietario<>'ConsegnaContenutiApplicativi'"});
            } else {
                throw new SQLQueryObjectException("Stato per filtro non conosciuto: " + search.getStato());
            }
        }
        if (search.getIdMessaggio() != null && !"".equals(search.getIdMessaggio())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.ID_MESSAGGIO='" + search.getIdMessaggio() + "'");
        }
        if (search.getProprietaList() != null && search.getProprietaList().size() > 0) {
            List<Proprieta> proprietaList = search.getProprietaList();
            for (Proprieta proprieta : proprietaList) {
                sqlQueryObject.addWhereCondition("MESSAGGI." + proprieta.getNome() + "='" + proprieta.getValore() + "'");
            }
        }
        if (search.getMessagePattern() != null && !"".equals(search.getMessagePattern())) {
            sqlQueryObject.addWhereLikeCondition("DEFINIZIONE_MESSAGGI.MSG_BYTES", search.getMessagePattern(), true, true);
        }
        if (search.getCorrelazioneApplicativa() != null && !"".equals(search.getCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereCondition("MESSAGGI.CORRELAZIONE_APPLICATIVA='" + search.getCorrelazioneApplicativa() + "'");
        }
        if (search.getSoglia() != -1L) {
            sqlQueryObject.addWhereCondition("MESSAGGI.ora_registrazione<=?");
        }
        if (!statoRichieste) {
            if (search.getLimit() != -1L) {
                sqlQueryObject.setLimit((int)search.getLimit());
            }
            if (search.getOffset() != -1L) {
                sqlQueryObject.setOffset((int)search.getOffset());
            }
        }
        if (search.getBusta() != null) {
            if (search.getBusta().getMittente() != null) {
                if (search.getBusta().getMittente().getTipo() != null && !"".equals(search.getBusta().getMittente().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_MITTENTE='" + search.getBusta().getMittente().getTipo() + "'");
                }
                if (search.getBusta().getMittente().getNome() != null && !"".equals(search.getBusta().getMittente().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.MITTENTE='" + search.getBusta().getMittente().getNome() + "'");
                }
            }
            if (search.getBusta().getDestinatario() != null) {
                if (search.getBusta().getDestinatario().getTipo() != null && !"".equals(search.getBusta().getDestinatario().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_DESTINATARIO='" + search.getBusta().getDestinatario().getTipo() + "'");
                }
                if (search.getBusta().getDestinatario().getNome() != null && !"".equals(search.getBusta().getDestinatario().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.DESTINATARIO='" + search.getBusta().getDestinatario().getNome() + "'");
                }
            }
            if (search.getBusta().getServizio() != null) {
                if (search.getBusta().getServizio().getTipo() != null && !"".equals(search.getBusta().getServizio().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_SERVIZIO='" + search.getBusta().getServizio().getTipo() + "'");
                }
                if (search.getBusta().getServizio().getNome() != null && !"".equals(search.getBusta().getServizio().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.SERVIZIO='" + search.getBusta().getServizio().getNome() + "'");
                }
            }
            if (search.getBusta().getAzione() != null && !"".equals(search.getBusta().getAzione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.AZIONE='" + search.getBusta().getAzione() + "'");
            }
            if (search.getBusta().getProfiloCollaborazione() != null && !"".equals(search.getBusta().getProfiloCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.PROFILO_DI_COLLABORAZIONE='" + search.getBusta().getProfiloCollaborazione() + "'");
            }
            if (search.getBusta().getRiferimentoMessaggio() != null && !"".equals(search.getBusta().getRiferimentoMessaggio())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.RIFERIMENTO_MESSAGGIO='" + search.getBusta().getRiferimentoMessaggio() + "'");
            }
            if (search.getBusta().getCollaborazione() != null && !"".equals(search.getBusta().getCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.COLLABORAZIONE='" + search.getBusta().getCollaborazione() + "'");
            }
        }
        if (search.getSoggettoList() != null && search.getSoggettoList().size() > 0) {
            List<BustaSoggetto> filtroSoggetti = search.getSoggettoList();
            StringBuffer query = new StringBuffer();
            for (int k = 0; k < filtroSoggetti.size(); ++k) {
                if (k > 0) {
                    query.append(" OR ");
                }
                query.append("( ");
                query.append("(REPOSITORY_BUSTE.TIPO_MITTENTE = ? AND REPOSITORY_BUSTE.MITTENTE = ?)");
                query.append(" OR ");
                query.append("(REPOSITORY_BUSTE.TIPO_DESTINATARIO = ? AND REPOSITORY_BUSTE.DESTINATARIO = ?)");
                query.append(" )");
            }
            sqlQueryObject.addWhereCondition(query.toString());
        }
        return sqlQueryObject;
    }

    private ISQLQueryObject newSQLQueryPacchettiDuplicati(FilterSearch search) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDatabase);
        sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
        sqlQueryObject.addSelectField("sum(DUPLICATI) as numduplicati");
        sqlQueryObject.setANDLogicOperator(true);
        if (search.getIdMessaggio() != null && !"".equals(search.getIdMessaggio())) {
            sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.ID_MESSAGGIO='" + search.getIdMessaggio() + "'");
        }
        if (search.getSoglia() != -1L) {
            sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.ora_registrazione<=?");
        }
        if (search.getBusta() != null) {
            if (search.getBusta().getMittente() != null) {
                if (search.getBusta().getMittente().getTipo() != null && !"".equals(search.getBusta().getMittente().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_MITTENTE='" + search.getBusta().getMittente().getTipo() + "'");
                }
                if (search.getBusta().getMittente().getNome() != null && !"".equals(search.getBusta().getMittente().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.MITTENTE='" + search.getBusta().getMittente().getNome() + "'");
                }
            }
            if (search.getBusta().getDestinatario() != null) {
                if (search.getBusta().getDestinatario().getTipo() != null && !"".equals(search.getBusta().getDestinatario().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_DESTINATARIO='" + search.getBusta().getDestinatario().getTipo() + "'");
                }
                if (search.getBusta().getDestinatario().getNome() != null && !"".equals(search.getBusta().getDestinatario().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.DESTINATARIO='" + search.getBusta().getDestinatario().getNome() + "'");
                }
            }
            if (search.getBusta().getServizio() != null) {
                if (search.getBusta().getServizio().getTipo() != null && !"".equals(search.getBusta().getServizio().getTipo())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_SERVIZIO='" + search.getBusta().getServizio().getTipo() + "'");
                }
                if (search.getBusta().getServizio().getNome() != null && !"".equals(search.getBusta().getServizio().getNome())) {
                    sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.SERVIZIO='" + search.getBusta().getServizio().getNome() + "'");
                }
            }
            if (search.getBusta().getAzione() != null && !"".equals(search.getBusta().getAzione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.AZIONE='" + search.getBusta().getAzione() + "'");
            }
            if (search.getBusta().getProfiloCollaborazione() != null && !"".equals(search.getBusta().getProfiloCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.PROFILO_DI_COLLABORAZIONE='" + search.getBusta().getProfiloCollaborazione() + "'");
            }
            if (search.getBusta().getRiferimentoMessaggio() != null && !"".equals(search.getBusta().getRiferimentoMessaggio())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.RIFERIMENTO_MESSAGGIO='" + search.getBusta().getRiferimentoMessaggio() + "'");
            }
            if (search.getBusta().getCollaborazione() != null && !"".equals(search.getBusta().getCollaborazione())) {
                sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.COLLABORAZIONE='" + search.getBusta().getCollaborazione() + "'");
            }
        }
        return sqlQueryObject;
    }
}

