/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb.threads;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.GenericMessage;
import org.openspcoop2.pdd.mdb.threads.IWorker;
import org.openspcoop2.pdd.mdb.threads.MessageIde;
import org.openspcoop2.pdd.mdb.threads.MessaggioSerializzato;
import org.openspcoop2.pdd.mdb.threads.ThreadsImplProperties;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.utils.date.DateManager;

public abstract class ModuloAlternativoWorker
implements IWorker {
    protected static final long serialVersionUID = 1L;
    protected String ID_MODULO = "ModuloAlternativo";
    protected ConfigurazionePdDReader configurazionePdDReader;
    protected ThreadsImplProperties propertiesReader;
    protected OpenSPCoop2Properties oSPCpropertiesReader;
    protected RegistroServiziManager registroServiziReader;
    protected DBManager dbManager;
    protected Logger log;
    MessageIde ide = null;

    public ModuloAlternativoWorker(String idModulo, MessageIde ide) {
        this.ide = ide;
        this.ID_MODULO = idModulo;
    }

    protected void init() throws Exception {
        try {
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            this.initReaders();
            this.initDBManager();
        }
        catch (Exception e) {
            throw new Exception("[ModuloAlternativoWorker.init] " + e.getMessage());
        }
    }

    protected MessaggioSerializzato ricostruisciMessaggio() throws Exception {
        if (this.ide.getMsg_bytes() == null) {
            System.out.println("Buffer di byte nullo");
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.ide.getMsg_bytes()));
        MessaggioSerializzato messaggioSerializzato = (MessaggioSerializzato)in.readObject();
        in.close();
        return messaggioSerializzato;
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + "Worker init abortito a causa di: " + e));
            e.printStackTrace();
            return;
        }
        MessaggioSerializzato msgSerial = null;
        try {
            msgSerial = this.ricostruisciMessaggio();
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + "Worker ricostruisci messaggio abortito a causa di: " + e));
            return;
        }
        try {
            EsitoLib esito = this.onMessage(msgSerial.getMsg(), msgSerial.getIdMessaggio());
            if (esito.isEsitoInvocazione()) {
                this.gestisciOK();
            } else {
                this.gestisciNOK();
            }
        }
        catch (Exception e1) {
            this.log.error((Object)(this.ID_MODULO + e1.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gestisciOK() throws Exception {
        Resource resourceDB = null;
        Connection connectionDB = null;
        try {
            resourceDB = this.initResource();
            connectionDB = this.initConnection(resourceDB, false);
            this.log.info((Object)(this.ID_MODULO + ": connessione ottenuta"));
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + ": impossibile collegarsi al db: +"));
            throw new Exception(this.ID_MODULO + ": impossibile collegarsi al db: " + e.getMessage());
        }
        String queryProprietario = "SELECT proprietario, scheduling, scheduling_time, redelivery_delay, redelivery_count, id_messaggio, tipo FROM MESSAGGI WHERE id_messaggio=? AND tipo= ? FOR UPDATE";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connectionDB.prepareStatement(queryProprietario, 1005, 1008);
            ps.setString(1, this.ide.getIdMessaggio());
            ps.setString(2, this.ide.getTipo());
            rs = ps.executeQuery();
            while (rs.next()) {
                String proprietario = rs.getString(1);
                if (proprietario.equalsIgnoreCase(this.ID_MODULO)) {
                    rs.updateInt("scheduling", 2);
                } else {
                    rs.updateInt("scheduling", 0);
                    rs.updateTimestamp("scheduling_time", DateManager.getTimestamp());
                    rs.updateInt("redelivery_count", 0);
                }
                rs.updateRow();
            }
            connectionDB.commit();
        }
        catch (Exception e) {
            System.out.println(e);
            connectionDB.rollback();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            this.releaseResource(resourceDB);
            if (!connectionDB.isClosed()) {
                this.log.error((Object)(this.ID_MODULO + ": gestisciOK: db non ha rilasciato il db"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gestisciNOK() throws Exception {
        Resource resourceDB = null;
        Connection connectionDB = null;
        try {
            resourceDB = this.initResource();
            connectionDB = this.initConnection(resourceDB, false);
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + ": impossibile collegarsi al db: +"));
            throw new Exception(this.ID_MODULO + ".gestisciNOK: impossibile collegarsi al db: " + e.getMessage());
        }
        long redelivery_delay = this.propertiesReader.getRedeliveryDelay();
        int redelivery_count = this.ide.getRedelivery_count();
        String query = "UPDATE MESSAGGI set scheduling=0, redelivery_count=?, redelivery_delay= ?, scheduling_time=? where id_messaggio=? AND tipo= ?";
        PreparedStatement ps = null;
        ++redelivery_count;
        System.out.println("La proprieta' redelivery_delay vale: " + redelivery_delay);
        Timestamp ts = new Timestamp(DateManager.getTimestamp().getTime() + redelivery_delay);
        try {
            ps = connectionDB.prepareStatement(query);
            ps.setInt(1, redelivery_count);
            ps.setTimestamp(2, ts);
            ps.setTimestamp(3, DateManager.getTimestamp());
            ps.setString(4, this.ide.getIdMessaggio());
            ps.setString(5, this.ide.getTipo());
            ps.executeUpdate();
            connectionDB.commit();
            System.out.println(this.ID_MODULO + ".gestisciNOK: chiamata alla libreria dell'MDB fallita " + "rimetto scheduling a 0 per il messaggio: " + this.ide.getIdMessaggio() + " | " + this.ide.getTipo() + " settato redelivery_delay a: " + ts);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            connectionDB.rollback();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            try {
                if (!connectionDB.isClosed()) {
                    this.releaseResource(resourceDB);
                }
                if (!connectionDB.isClosed()) {
                    System.out.println(this.ID_MODULO + ": gestisciNOK: non riesco a chiudere il db");
                }
            }
            catch (Exception e2) {
                System.out.println(e2);
            }
        }
    }

    protected void initReaders() throws GenericLibException {
        try {
            this.propertiesReader = ThreadsImplProperties.getInstance();
            this.oSPCpropertiesReader = OpenSPCoop2Properties.getInstance();
            this.configurazionePdDReader = ConfigurazionePdDReader.getInstance();
            this.registroServiziReader = RegistroServiziManager.getInstance();
        }
        catch (Exception e) {
            throw new GenericLibException("Riscontrato Errore durante l'inizializzazione del Reader della Configurazione");
        }
    }

    protected void initDBManager() throws GenericLibException {
        try {
            this.dbManager = DBManager.getInstance();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error((Object)("Riscontrato errore durante l'inizializzazione del Thread ModuloAlternativoWorker: " + e.getMessage()));
            }
            throw new GenericLibException("Riscontrato errore durante l'inizializzazione del DBmanager");
        }
    }

    protected Resource initResource() throws Exception {
        Resource resourceDB = null;
        try {
            resourceDB = this.dbManager.getResource(this.oSPCpropertiesReader.getIdentitaPortaDefault(null), this.ID_MODULO, null);
        }
        catch (Exception e) {
            throw new Exception("Impossibile ottenere una Risorsa dal DBManager", e);
        }
        if (resourceDB == null) {
            throw new Exception("Impossibile ottenere una Resource dal DBManager");
        }
        return resourceDB;
    }

    protected Connection initConnection(Resource resourceDB, boolean autocommit) throws Exception {
        Connection connectionDB = null;
        try {
            connectionDB = (Connection)resourceDB.getResource();
            connectionDB.setAutoCommit(autocommit);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la richiesta di una connessione al DB: " + e.getMessage()));
            throw new Exception("Impossibile ottenere una Connessione dal DBManager");
        }
        return connectionDB;
    }

    protected void releaseResource(Resource resourceDB) {
        if (resourceDB != null) {
            this.dbManager.releaseResource(this.oSPCpropertiesReader.getIdentitaPortaDefault(null), this.ID_MODULO, resourceDB);
        }
    }

    protected abstract EsitoLib onMessage(GenericMessage var1, String var2) throws OpenSPCoopStateException;
}

