/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb.threads;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.threshold.ThreadsUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.threads.IProducer;
import org.openspcoop2.pdd.mdb.threads.IWorker;
import org.openspcoop2.pdd.mdb.threads.MessageIde;
import org.openspcoop2.pdd.mdb.threads.ThreadsImplProperties;
import org.openspcoop2.utils.date.DateManager;

public class ModuloAlternativoProducer
implements IProducer {
    protected String ID_MODULO = "ModuloAlternativo";
    protected BlockingQueue<IWorker> coda;
    protected String cluster_id = null;
    private ThreadsImplProperties propertiesReader;
    private OpenSPCoop2Properties oSPCpropertiesReader;
    private Logger log;
    private DBManager dbManager;
    private long attesa_producer = 100L;
    private boolean stop = false;

    public ModuloAlternativoProducer(String idModulo, BlockingQueue<IWorker> coda) {
        try {
            this.ID_MODULO = idModulo;
            this.initLettoreProperties();
            this.initLogger();
            this.initDBManager();
            this.attesa_producer = this.propertiesReader.getAttesaProducer();
            this.cluster_id = this.oSPCpropertiesReader.getClusterId(true);
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + " Errore in fase di inizializzazione " + e));
        }
        this.coda = coda;
    }

    @Override
    public void run() {
        Resource resourceDB = null;
        Connection connectionDB = null;
        if (this.propertiesReader == null) {
            System.out.println("Lettore ThreadProp null");
        }
        if (this.oSPCpropertiesReader == null) {
            System.out.println("Lettore OpenSPCoopProp null");
        }
        if (this.dbManager == null) {
            System.out.println("DBManager null");
        }
        if (this.log == null) {
            System.out.println("Logger null");
        }
        try {
            resourceDB = this.initResource();
            connectionDB = this.initConnection(resourceDB, false);
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + ".cercaNuoviMessaggi: Impossibile connettersi al db: " + e));
            return;
        }
        PreparedStatement ps = this.prepareStatement(connectionDB);
        System.out.println(this.ID_MODULO + " producer attivato ");
        while (!this.stop) {
            Vector<MessageIde> messaggiTrovati;
            int postiLiberi = this.coda.remainingCapacity();
            if (postiLiberi > 0 && (messaggiTrovati = this.EseguiCercaNuoviMessaggi(connectionDB, ps, postiLiberi)) != null && messaggiTrovati.size() > 0) {
                this.creaWorkers(messaggiTrovati);
            }
            ThreadsUtils.attesa(this.attesa_producer);
        }
        try {
            if (ps != null) {
                ps.close();
            }
            this.releaseResource(resourceDB);
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + " " + e));
        }
        this.log.info((Object)(this.ID_MODULO + "Producer: Fermato"));
        System.out.println(this.ID_MODULO + " Producer fermato");
    }

    public void creaWorkers(Vector<MessageIde> messaggiTrovati) {
    }

    private PreparedStatement prepareStatement(Connection connectionDB) {
        PreparedStatement ps = null;
        String preparedQuery = "SELECT id_messaggio, tipo, scheduling, redelivery_count, redelivery_delay, ora_registrazione, scheduling_time, msg_bytes FROM MESSAGGI WHERE\tproprietario= ? AND scheduling=0 AND redelivery_delay < ? AND redelivery_COUNT < ? AND cluster_id= ? ORDER BY ora_registrazione LIMIT ? FOR UPDATE";
        try {
            ps = connectionDB.prepareStatement(preparedQuery, 1005, 1008);
            ps.setString(1, this.ID_MODULO);
            ps.setInt(3, this.propertiesReader.getRedeliveryCount());
            ps.setString(4, this.cluster_id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<MessageIde> EseguiCercaNuoviMessaggi(Connection connectionDB, PreparedStatement ps, int limiteRisultati) {
        Vector<MessageIde> result = new Vector<MessageIde>();
        ResultSet rs = null;
        try {
            Cloneable temp;
            ps.setTimestamp(2, DateManager.getTimestamp());
            ps.setInt(5, limiteRisultati);
            rs = ps.executeQuery();
            while (rs.next()) {
                System.out.println(this.ID_MODULO + ".EseguiCercaNuoviMess: trovato: " + rs.getString("id_messaggio") + "/ sched: " + rs.getInt("scheduling") + " redelivery_delay: " + rs.getTimestamp("redelivery_delay"));
                System.out.println("....");
                rs.updateInt("scheduling", 1);
                rs.updateTimestamp("scheduling_time", DateManager.getTimestamp());
                temp = new Timestamp(DateManager.getTimestamp().getTime() + 1000L);
                System.out.println(temp);
                rs.updateTimestamp("redelivery_delay", (Timestamp)temp);
                rs.updateRow();
                MessageIde ide = new MessageIde();
                ide.setIdMessaggio(rs.getString(1));
                ide.setTipo(rs.getString(2));
                ide.setRedelivery_count(rs.getInt(4));
                byte[] data = rs.getBytes("msg_bytes");
                if (data != null) {
                    ide.setMsg_bytes(data);
                }
                result.add(ide);
                System.out.println(this.ID_MODULO + ".EseguiCercaNuoviMess: modificato: " + rs.getString("id_messaggio") + "/ sched: " + rs.getInt("scheduling") + " redelivery_delay: " + rs.getTimestamp("redelivery_delay"));
                System.out.println("messaggio inserito nei risultati da processare");
                System.out.println("/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/*/");
                System.out.println("");
            }
            connectionDB.commit();
            if (result != null && result.size() > 0) {
                System.out.println(this.ID_MODULO + ".EseguiCercaNuoviMess: Commit eseguito su " + result.size() + " messaggi");
            }
            temp = result;
            return temp;
        }
        catch (Exception e) {
            System.out.println(e);
            this.log.error((Object)(this.ID_MODULO + ":" + e.getMessage()));
            try {
                connectionDB.rollback();
                System.out.println(this.ID_MODULO + ".EseguiCercaNuoviMess: Rollback eseguito su " + result.size() + " messaggi");
            }
            catch (SQLException e1) {
                this.log.error((Object)(this.ID_MODULO + ":Fallito Rollback" + e.getMessage()));
            }
            Vector<MessageIde> vector = null;
            return vector;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                this.log.error((Object)(this.ID_MODULO + ": non riesco a rilasciare la connessione " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<MessageIde> cercaNuoviMessaggi(int limiteRisultati, Connection connectionDB) {
        String preparedQuery = "SELECT id_messaggio, tipo, scheduling, redelivery_count, redelivery_delay, ora_registrazione, scheduling_time, msg_bytes FROM MESSAGGI WHERE\tproprietario= ? AND scheduling='0' AND redelivery_delay < ? AND redelivery_COUNT < ? AND cluster_id= ? ORDER BY ora_registrazione LIMIT " + limiteRisultati + " FOR UPDATE";
        Vector<MessageIde> result = new Vector<MessageIde>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            Cloneable ts;
            ps = connectionDB.prepareStatement(preparedQuery, 1005, 1008);
            ps.setString(1, this.ID_MODULO);
            ps.setTimestamp(2, DateManager.getTimestamp());
            ps.setInt(3, this.propertiesReader.getRedeliveryCount());
            ps.setString(4, this.cluster_id);
            rs = ps.executeQuery();
            while (rs.next()) {
                rs.updateInt("scheduling", 1);
                rs.updateTimestamp("scheduling_time", DateManager.getTimestamp());
                ts = new Timestamp(System.currentTimeMillis() + 5000L);
                rs.updateTimestamp("redelivery_delay", (Timestamp)ts);
                rs.updateRow();
                MessageIde ide = new MessageIde();
                ide.setIdMessaggio(rs.getString(1));
                ide.setTipo(rs.getString(2));
                ide.setRedelivery_count(rs.getInt(4));
                if (rs.getTimestamp(5) != null) {
                    ide.setRedelivery_delay(rs.getTimestamp(5));
                }
                if (rs.getBytes("msg_bytes") != null) {
                    ide.setMsg_bytes(rs.getBytes("msg_bytes"));
                }
                result.add(ide);
            }
            connectionDB.commit();
            ts = result;
            return ts;
        }
        catch (Exception e) {
            System.out.println(e);
            this.log.error((Object)(this.ID_MODULO + ":" + e.getMessage()));
            try {
                connectionDB.rollback();
            }
            catch (SQLException e1) {
                this.log.error((Object)(this.ID_MODULO + ":Fallito Rollback" + e.getMessage()));
            }
            Vector<MessageIde> vector = null;
            return vector;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                this.log.error((Object)(this.ID_MODULO + ": non riesco a rilasciare la connessione " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<MessageIde> cercaNuoviMessaggiOld(int limiteRisultati) {
        String preparedQuery = "SELECT id_messaggio, tipo, scheduling, redelivery_count, redelivery_delay, ora_registrazione, scheduling_time, msg_bytes FROM MESSAGGI WHERE\tproprietario= ? AND scheduling=0 AND redelivery_delay < ? AND redelivery_COUNT < ? AND cluster_id= ? ORDER BY ora_registrazione LIMIT ? FOR UPDATE";
        Resource resourceDB = null;
        Connection connectionDB = null;
        Vector<MessageIde> id_messaggi = new Vector<MessageIde>();
        try {
            resourceDB = this.initResource();
            connectionDB = this.initConnection(resourceDB, false);
        }
        catch (Exception e) {
            System.out.println(this.ID_MODULO + ": Impossibile connettersi al db: " + e);
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = connectionDB.prepareStatement(preparedQuery);
            ps.setString(1, this.ID_MODULO);
            ps.setTimestamp(2, DateManager.getTimestamp());
            ps.setInt(3, this.propertiesReader.getRedeliveryCount());
            ps.setString(4, this.cluster_id);
            ps.setInt(5, limiteRisultati);
            rs = ps.executeQuery();
            while (rs.next()) {
                System.out.println(this.ID_MODULO + "trovato: " + rs.getString("id_messaggio") + "/ sched: " + rs.getInt("scheduling"));
                MessageIde ide = new MessageIde();
                ide.setIdMessaggio(rs.getString(1));
                ide.setTipo(rs.getString(2));
                ide.setRedelivery_count(rs.getInt(4));
                byte[] data = rs.getBytes("msg_bytes");
                if (data != null) {
                    ide.setMsg_bytes(data);
                }
                id_messaggi.add(ide);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error((Object)(this.ID_MODULO + ":" + e.getMessage()));
            this.releaseResource(resourceDB);
            return null;
        }
        try {
            if (id_messaggi != null && id_messaggi.size() > 0) {
                String preparedUpdate = "UPDATE MESSAGGI set scheduling=1 where id_messaggio = ? and tipo = ? ";
                PreparedStatement ps3 = connectionDB.prepareStatement(preparedUpdate);
                for (int i = 0; i < id_messaggi.size(); ++i) {
                    try {
                        ps3.setString(1, id_messaggi.elementAt(i).getIdMessaggio());
                        ps3.setString(2, id_messaggi.elementAt(i).getTipo());
                        ps3.executeUpdate();
                        System.out.print(this.ID_MODULO + "set sched=1 al msg: " + id_messaggi.elementAt(i).getIdMessaggio() + " | " + id_messaggi.elementAt(i).getTipo() + ".......");
                        continue;
                    }
                    catch (SQLException e1) {
                        this.log.error((Object)(this.ID_MODULO + ": SqlExecption, eseguo rollback " + e1));
                        connectionDB.rollback();
                    }
                }
                ps3.close();
                connectionDB.commit();
                System.out.println(this.ID_MODULO + ".................................................... COMMIT ESEGUITO");
            }
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + ": errore " + e));
            try {
                connectionDB.rollback();
            }
            catch (SQLException e1) {
                this.log.error((Object)(this.ID_MODULO + ": rollback fallito"));
            }
            Vector<MessageIde> vector = null;
            return vector;
        }
        finally {
            try {
                this.releaseResource(resourceDB);
                if (!connectionDB.isClosed()) {
                    this.log.error((Object)(this.ID_MODULO + ": CercaNuoviMessaggi: non riesco a chiudere il db"));
                }
            }
            catch (Exception e) {
                this.log.error((Object)(this.ID_MODULO + ": non riesco a rilasciare la connessione"));
            }
        }
        return id_messaggi;
    }

    private void initLogger() {
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    }

    private void initLettoreProperties() throws GenericLibException {
        try {
            this.propertiesReader = ThreadsImplProperties.getInstance();
            this.oSPCpropertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            throw new GenericLibException("Riscontrato Errore durante l'inizializzazione del Reader delle Properties");
        }
    }

    private void initDBManager() throws GenericLibException {
        try {
            this.dbManager = DBManager.getInstance();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error((Object)("Riscontrato errore durante l'inizializzazione del Thread InoltroBusteProducer: " + e.getMessage()));
            }
            throw new GenericLibException("Riscontrato errore durante l'inizializzazione del DBManager di " + this.ID_MODULO);
        }
    }

    private Resource initResource() throws Exception {
        Resource resourceDB = null;
        try {
            resourceDB = this.dbManager.getResource(this.oSPCpropertiesReader.getIdentitaPortaDefault(null), this.ID_MODULO, null);
        }
        catch (Exception e) {
            throw new Exception("Impossibile ottenere una Risorsa dal DBManager", e);
        }
        if (resourceDB == null) {
            System.out.println(this.ID_MODULO + "producer initResource fallita");
            throw new Exception("Impossibile ottenere una Resource dal DBManager");
        }
        return resourceDB;
    }

    private Connection initConnection(Resource resourceDB, boolean autocommit) throws Exception {
        Connection connectionDB = null;
        try {
            connectionDB = (Connection)resourceDB.getResource();
            connectionDB.setAutoCommit(autocommit);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la richiesta di una connessione al DB: " + e.getMessage()));
            System.out.println(this.ID_MODULO + "producer initResource fallita");
            throw new Exception("Impossibile ottenere una Connessione dal DBManager");
        }
        return connectionDB;
    }

    private void releaseResource(Resource resourceDB) {
        if (resourceDB != null) {
            this.dbManager.releaseResource(this.oSPCpropertiesReader.getIdentitaPortaDefault(null), this.ID_MODULO, resourceDB);
        }
    }

    @Override
    public boolean isStop() {
        return this.stop;
    }

    @Override
    public void setStop(boolean stop) {
        this.stop = stop;
    }
}

