/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.Sbustamento;
import org.openspcoop2.pdd.mdb.SbustamentoMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;

public class SbustamentoMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private MessageDrivenContext ctxMDB;
    private Logger log = null;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[Sbustamento] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[Sbustamento] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                this.log.error((Object)("[Sbustamento] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                this.log.error((Object)("[Sbustamento] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.sistemaDumpDisponibile) {
                this.log.error((Object)("[Sbustamento] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Sbustamento lib = null;
            try {
                lib = new Sbustamento(this.log);
            }
            catch (Exception e) {
                this.log.error((Object)("Sbustamento.instanziazione: " + e.getMessage()), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger(SbustamentoMDB.class);
                this.log.error((Object)"[Sbustamento] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("Sbustamento", new IState[0]);
            msgDiag.mediumDebug("Ricezione richiesta (SbustamentoMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            SbustamentoMessage sbustamentoMsg = null;
            try {
                sbustamentoMsg = (SbustamentoMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(SbustamentoMessage)");
                return;
            }
            String idRequest = null;
            try {
                idRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopStateful stato = null;
            try {
                stato = new OpenSPCoopStateful();
                stato.setIDMessaggioSessione(idRequest);
                stato.setMessageLib(sbustamentoMsg);
            }
            catch (Exception e) {
                this.log.error((Object)"[Sbustamento] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = sbustamentoMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO")));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "Sbustamento", idRequest, "INBOX", received.getJMSMessageID(), pddContext)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "Sbustamento");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[Sbustamento] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.info((Object)"[Sbustamento] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log.debug((Object)"[Sbustamento] Invocazione della libreria terminata correttamente");
        }
    }
}

