/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.EJBUtilsConsegnaException;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.SbustamentoMessage;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.driver.FiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class Sbustamento
extends GenericLib {
    public static final String ID_MODULO = "Sbustamento";
    private ErroreApplicativoBuilder erroreApplicativoBuilder;

    public Sbustamento(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    protected void inizializza() throws GenericLibException {
        super.inizializza();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        sbustamentoMsg = (SbustamentoMessage)openspcoopstate.getMessageLib();
        esito = new EsitoLib();
        pddContext = sbustamentoMsg.getPddContext();
        idTransazione = PdDContext.getValue("ID", pddContext);
        protocolFactory = null;
        protocolManager = null;
        traduttore = null;
        try {
            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            protocolManager = protocolFactory.createProtocolVersionManager(sbustamentoMsg.getRichiestaApplicativa().getProfiloGestione());
            traduttore = protocolFactory.createTraduttore();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        versioneSoap = (SOAPVersion)pddContext.getObject("SOAP_VERSION");
        msgDiag.setPddContext(pddContext, protocolFactory);
        bustaRichiesta = sbustamentoMsg.getBusta();
        implementazionePdDMittente = sbustamentoMsg.getImplementazionePdDSoggettoMittente();
        richiestaApplicativa = sbustamentoMsg.getRichiestaApplicativa();
        idServizio = richiestaApplicativa.getIDServizio();
        idSoggettoFruitore = richiestaApplicativa.getSoggettoFruitore();
        errors = sbustamentoMsg.getErrors();
        isMessaggioErroreProtocollo = sbustamentoMsg.isMessaggioErroreProtocollo();
        bustaDiServizio = sbustamentoMsg.getIsBustaDiServizio();
        tipoPdD = TipoPdD.APPLICATIVA;
        identitaPdD = sbustamentoMsg.getRichiestaApplicativa().getDominio();
        msgDiag.setDominio(identitaPdD);
        msgDiag.setPrefixMsgPersonalizzati("sbustamentoBusta.");
        msgDiag.addKeywords(bustaRichiesta, true);
        if (richiestaApplicativa.getIdentitaServizioApplicativoFruitore() != null) {
            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaApplicativa.getIdentitaServizioApplicativoFruitore());
        }
        msgDiag.setIdCorrelazioneApplicativa(richiestaApplicativa.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaApplicativa.getIdCorrelazioneApplicativa());
        profiloGestione = richiestaApplicativa.getProfiloGestione();
        msgDiag.mediumDebug("Profilo di gestione [Sbustamento] della busta: " + profiloGestione);
        try {
            this.erroreApplicativoBuilder = new ErroreApplicativoBuilder(this.log, protocolFactory, identitaPdD, idSoggettoFruitore, idServizio, this.idModulo, this.propertiesReader.getProprietaGestioneErrorePD((IProtocolManager)protocolManager), versioneSoap, TipoPdD.APPLICATIVA, null);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ErroreApplicativoBuilder.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, "Sbustamento", idTransazione);
        registroServiziManager.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        configurazionePdDManager.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        msgDiag.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        idMessageRequest = openspcoopstate.getIDMessaggioSessione();
        msgDiag.setIdMessaggioRichiesta(idMessageRequest);
        msgDiag.setFruitore(idSoggettoFruitore);
        msgDiag.setServizio(idServizio);
        msgDiag.setDelegata(false);
        msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, tipoPdD, "Sbustamento", idMessageRequest, idMessageRequest, "INBOX", openspcoopstate, msgDiag, false, sbustamentoMsg.getImplementazionePdDSoggettoMittente(), sbustamentoMsg.getImplementazionePdDSoggettoDestinatario(), profiloGestione, pddContext);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        oneWayVersione11 = sbustamentoMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        ejbUtils.setPortaDiTipoStateless_esclusoOneWay11(sbustamentoMsg.isStateless());
        profiloCollaborazione = null;
        try {
            profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        historyBuste = new History(openspcoopstate.getStatoRichiesta());
        repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        ricevutaAsincrona = null;
        msgRequest = new GestoreMessaggi(openspcoopstate, true, idMessageRequest, "INBOX", msgDiag, pddContext);
        msgResponse = null;
        msgRequest.setOneWayVersione11(oneWayVersione11);
        servizioApplicativoFruitore = richiestaApplicativa.getIdentitaServizioApplicativoFruitore();
        idCorrelazioneApplicativa = richiestaApplicativa.getIdCorrelazioneApplicativa();
        newConnectionForResponse = false;
        if (!ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) && !sbustamentoMsg.isStateless()) {
            newConnectionForResponse = configurazionePdDManager.newConnectionForResponse();
        }
        ejbUtils.setReplyOnNewConnection(newConnectionForResponse);
        gestioneIndirizzoTelematico = false;
        if (!sbustamentoMsg.isStateless()) {
            gestioneIndirizzoTelematico = configurazionePdDManager.isUtilizzoIndirizzoTelematico();
        }
        ejbUtils.setUtilizzoIndirizzoTelematico(gestioneIndirizzoTelematico);
        sendSbloccoRicezioneBuste = true;
        if (configurazionePdDManager.isUtilizzoIndirizzoTelematico() && bustaRichiesta.getIndirizzoMittente() != null && !sbustamentoMsg.isStateless()) {
            sendSbloccoRicezioneBuste = false;
        } else if (newConnectionForResponse) {
            sendSbloccoRicezioneBuste = false;
        }
        ruoloBustaRicevuta = sbustamentoMsg.getRuoloBustaRicevuta();
        bustaHTTPReply = null;
        try {
            block263: {
                block265: {
                    ricezioneRiscontri = false;
                    switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getConsegnaAffidabile(bustaRichiesta.getProfiloDiCollaborazione()).ordinal()]) {
                        case 1: {
                            ricezioneRiscontri = true;
                            break;
                        }
                        case 2: {
                            ricezioneRiscontri = false;
                            break;
                        }
                        default: {
                            ricezioneRiscontri = this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente);
                        }
                    }
                    consegnaAffidabile = false;
                    switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getConsegnaAffidabile(bustaRichiesta.getProfiloDiCollaborazione()).ordinal()]) {
                        case 1: {
                            consegnaAffidabile = true;
                            break;
                        }
                        case 2: {
                            consegnaAffidabile = false;
                            break;
                        }
                        default: {
                            consegnaAffidabile = this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) != false && bustaRichiesta.isConfermaRicezione() != false;
                        }
                    }
                    idCollaborazione = false;
                    switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getCollaborazione(bustaRichiesta.getProfiloDiCollaborazione()).ordinal()]) {
                        case 1: {
                            idCollaborazione = true;
                            break;
                        }
                        case 2: {
                            idCollaborazione = false;
                            break;
                        }
                        default: {
                            idCollaborazione = this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente) != false && bustaRichiesta.getCollaborazione() != null;
                        }
                    }
                    consegnaInOrdine = false;
                    switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getConsegnaInOrdine(bustaRichiesta.getProfiloDiCollaborazione()).ordinal()]) {
                        case 1: {
                            consegnaInOrdine = true;
                            break;
                        }
                        case 2: {
                            consegnaInOrdine = false;
                            break;
                        }
                        default: {
                            gestioneConsegnaInOrdineAbilitata = this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) != false && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente) != false && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDMittente) != false;
                            consegnaInOrdine = gestioneConsegnaInOrdineAbilitata != false && bustaRichiesta.getSequenza() != -1L;
                        }
                    }
                    imbustamentoFiltroDuplicatiAbilitato = false;
                    switch (1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[protocolManager.getFiltroDuplicati(bustaRichiesta.getProfiloDiCollaborazione()).ordinal()]) {
                        case 1: {
                            imbustamentoFiltroDuplicatiAbilitato = true;
                            break;
                        }
                        case 2: {
                            imbustamentoFiltroDuplicatiAbilitato = false;
                            break;
                        }
                        default: {
                            imbustamentoFiltroDuplicatiAbilitato = Inoltro.SENZA_DUPLICATI.equals(bustaRichiesta.getInoltro()) != false || this.propertiesReader.isCheckFromRegistroFiltroDuplicatiAbilitato(implementazionePdDMittente) != false && sbustamentoMsg.isFiltroDuplicatiRichiestoAccordo() != false;
                        }
                    }
                    try {
                        protocolConfiguration = protocolFactory.createProtocolConfiguration();
                        if (bustaRichiesta.getProfiloDiCollaborazione() != null && !ProfiloDiCollaborazione.UNKNOWN.equals(bustaRichiesta.getProfiloDiCollaborazione()) && !protocolConfiguration.isSupportato(bustaRichiesta.getProfiloDiCollaborazione())) {
                            throw new Exception("Profilo di Collaborazione [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "]");
                        }
                        if (imbustamentoFiltroDuplicatiAbilitato && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.FILTRO_DUPLICATI)) {
                            throw new Exception(FunzionalitaProtocollo.FILTRO_DUPLICATI.getEngineValue());
                        }
                        if (consegnaAffidabile && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.CONFERMA_RICEZIONE)) {
                            throw new Exception(FunzionalitaProtocollo.CONFERMA_RICEZIONE.getEngineValue());
                        }
                        if (idCollaborazione && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.COLLABORAZIONE)) {
                            throw new Exception(FunzionalitaProtocollo.COLLABORAZIONE.getEngineValue());
                        }
                        if (consegnaInOrdine && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.CONSEGNA_IN_ORDINE)) {
                            throw new Exception(FunzionalitaProtocollo.CONSEGNA_IN_ORDINE.getEngineValue());
                        }
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("protocolli.funzionalita.unsupported");
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                        return esito;
                    }
                    if (isMessaggioErroreProtocollo) {
                        msgDiag.mediumDebug("Gestione messaggio errore protocollo...");
                        msgErroreProtocolloValido = true;
                        if (!configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) && errors.size() != 0) {
                            eccBuffer = new StringBuffer();
                            for (k = 0; k < errors.size(); ++k) {
                                er = errors.get(k);
                                if (k > 0) {
                                    eccBuffer.append("\n");
                                }
                                eccBuffer.append(er.toString(protocolFactory));
                            }
                            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                            msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                            msgDiag.logPersonalizzato("validazioneBustaErrore.listaEccezioniMalformata");
                            if (configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                msgErroreProtocolloValido = false;
                            }
                        }
                        if (msgErroreProtocolloValido && bustaRichiesta.sizeListaEccezioni() > 0) {
                            msgDiag.addKeyword("@ECCEZIONI@", bustaRichiesta.toStringListaEccezioni(protocolFactory));
                            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", bustaRichiesta.sizeListaEccezioni() + "");
                            msgDiag.logPersonalizzato("ricezioneBustaErrore");
                        }
                        if ((dettaglioEccezione = sbustamentoMsg.getDettaglioEccezione()) != null) {
                            msgDiag.addKeyword("@OPENSPCOOP2_DETAILS@", XMLUtils.toString((DettaglioEccezione)dettaglioEccezione));
                            msgDiag.logPersonalizzato("ricezioneBustaErroreDetails");
                        }
                        if (sendSbloccoRicezioneBuste) {
                            msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste...");
                            msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                        }
                        msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                        eccezioneDaInviareServizioApplicativo = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                        erroreIntegrazioneDaInviareServizioApplicativo = null;
                        if (msgErroreProtocolloValido) {
                            if (bustaRichiesta.sizeListaEccezioni() > 1) {
                                bfDescrizione = new StringBuffer();
                                for (k = 0; k < bustaRichiesta.sizeListaEccezioni(); ++k) {
                                    eccLista = bustaRichiesta.getEccezione(k);
                                    if (eccLista.getDescrizione(protocolFactory) == null) continue;
                                    bfDescrizione.append("[" + traduttore.toString(eccLista.getCodiceEccezione(), eccLista.getSubCodiceEccezione()) + "] " + eccLista.getDescrizione(protocolFactory) + "\n");
                                }
                                if (bfDescrizione.length() > 0) {
                                    eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                }
                            } else if (bustaRichiesta.sizeListaEccezioni() == 1) {
                                eccezioneDaInviareServizioApplicativo = bustaRichiesta.getEccezione(0);
                            } else if (dettaglioEccezione != null && dettaglioEccezione.getEccezioni() != null && dettaglioEccezione.getEccezioni().sizeEccezioneList() > 0) {
                                e = dettaglioEccezione.getEccezioni().getEccezione(0);
                                if ("EccezioneProtocollo".equals(e.getTipo())) {
                                    msgErroreCooperazione = new ErroreCooperazione(e.getDescrizione(), traduttore.toCodiceErroreCooperazione(e.getCodice()));
                                    eccezioneDaInviareServizioApplicativo = new Eccezione(msgErroreCooperazione, false, "Sbustamento", protocolFactory);
                                } else {
                                    eccezioneDaInviareServizioApplicativo = Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(e.getDescrizione()), (IProtocolFactory)protocolFactory);
                                }
                            } else {
                                eccezioneDaInviareServizioApplicativo = new Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione(), false, "Sbustamento", protocolFactory);
                            }
                        } else if (errors.size() > 1) {
                            bfDescrizione = new StringBuffer();
                            for (k = 0; k < errors.size(); ++k) {
                                error = errors.get(k);
                                if (error.getDescrizione(protocolFactory) == null) continue;
                                bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                            }
                            if (bfDescrizione.length() > 0) {
                                eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                            }
                        } else {
                            eccezioneDaInviareServizioApplicativo = errors.get(0);
                        }
                        this.gestioneErroreProtocollo(configurazionePdDManager, ejbUtils, profiloCollaborazione, repositoryBuste, bustaRichiesta, identitaPdD, eccezioneDaInviareServizioApplicativo, erroreIntegrazioneDaInviareServizioApplicativo, new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente()), dettaglioEccezione, null, versioneSoap, (IProtocolManager)protocolManager);
                        openspcoopstate.commit();
                        msgDiag.mediumDebug("Rilascio connessione...");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "RicevutoMsgBustaErrore");
                        return esito;
                    }
                    if (!isMessaggioErroreProtocollo && !configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO)) {
                        v0 = validazioneConErrori = errors.size() > 0;
                        if (protocolManager.isIgnoraEccezioniLivelloNonGrave() || this.propertiesReader.ignoraEccezioniNonGravi_Validazione()) {
                            validazioneConErrori = Busta.containsEccezioniGravi(errors);
                        }
                        if (validazioneConErrori) {
                            msgDiag.mediumDebug("Gestione messaggio di protocollo che non ha superato la validazione...");
                            mittenteRegistrato = true;
                            eccBuffer = new StringBuffer();
                            errorsClone = new Vector<Eccezione>();
                            for (k = 0; k < errors.size(); ++k) {
                                er = errors.get(k);
                                errorsClone.add(er);
                                if (k > 0) {
                                    eccBuffer.append("\n");
                                }
                                eccBuffer.append(er.toString(protocolFactory));
                                if (!CodiceErroreCooperazione.isEccezioneMittente((CodiceErroreCooperazione)er.getCodiceEccezione())) continue;
                                mittenteRegistrato = false;
                            }
                            msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                            msgDiag.logPersonalizzato("validazioneBusta.bustaNonCorretta");
                            if (configurazionePdDManager.getTipoValidazione(implementazionePdDMittente).equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                bustaNonValida = bustaRichiesta.clone();
                                ejbUtils.setRollbackRichiestaInCasoErrore(false);
                                if (mittenteRegistrato) {
                                    msgDiag.mediumDebug("Invio segnalazione di errore ...");
                                    ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, errorsClone, idCorrelazioneApplicativa, null, servizioApplicativoFruitore);
                                } else if (sendSbloccoRicezioneBuste) {
                                    msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste...");
                                    msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                                }
                                ejbUtils.setRollbackRichiestaInCasoErrore(true);
                                eccezioneDaInviareServizioApplicativo = null;
                                if (errors.size() > 1) {
                                    eccezioneDaInviareServizioApplicativo = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                    bfDescrizione = new StringBuffer();
                                    for (k = 0; k < errors.size(); ++k) {
                                        error = errors.get(k);
                                        if (error.getDescrizione(protocolFactory) == null) continue;
                                        bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                    }
                                    if (bfDescrizione.length() > 0) {
                                        eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                    }
                                } else {
                                    eccezioneDaInviareServizioApplicativo = errors.get(0);
                                }
                                msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                this.gestioneErroreProtocollo(configurazionePdDManager, ejbUtils, profiloCollaborazione, repositoryBuste, bustaNonValida, identitaPdD, eccezioneDaInviareServizioApplicativo, null, identitaPdD, null, null, versioneSoap, (IProtocolManager)protocolManager);
                                openspcoopstate.commit();
                                msgDiag.mediumDebug("Rilascio connessione...");
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                                return esito;
                            }
                        }
                    }
                    if (!bustaRichiesta.containsEccezioniGravi() && bustaRichiesta.sizeListaEccezioni() > 0) {
                        msgDiag.addKeyword("@ECCEZIONI@", bustaRichiesta.toStringListaEccezioni(protocolFactory));
                        msgDiag.logPersonalizzato("ricezioneBusta.eccezioniNonGravi");
                    }
                    if (!Busta.containsEccezioniGravi(errors) && errors.size() > 0) {
                        msgDiag.addKeyword("@ECCEZIONI@", Busta.toStringListaEccezioni(errors, (IProtocolFactory)protocolFactory));
                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                        msgDiag.logPersonalizzato("validazioneBusta.eccezioniNonGravi");
                    }
                    if (ricezioneRiscontri && bustaRichiesta.sizeListaRiscontri() > 0) {
                        for (i = 0; i < bustaRichiesta.sizeListaRiscontri(); ++i) {
                            r = bustaRichiesta.getRiscontro(i);
                            msgDiag.addKeyword("@ID_BUSTA_RISCONTRATA@", r.getID());
                            msgDiag.addKeyword("@DATA_RISCONTRO@", r.getOraRegistrazione().toString());
                            msgDiag.logPersonalizzato("ricezioneRiscontro");
                            try {
                                msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, r.getID(), "OUTBOX", msgDiag, pddContext);
                                msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato();
                                continue;
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato(" + r.getID() + ")");
                            }
                        }
                    }
                    msgDiag.mediumDebug("Controllo appartenenza Destinazione Busta (controllo esistenza soggetto)...");
                    existsSoggetto = false;
                    try {
                        existsSoggetto = configurazionePdDManager.existsSoggetto(idServizio.getSoggettoErogatore());
                    }
                    catch (Exception e) {
                        if (idServizio != null && idServizio.getSoggettoErogatore() != null) {
                            msgDiag.logErroreGenerico(e, "existsSoggetto(" + idServizio.getSoggettoErogatore().toString() + ")");
                        } else {
                            msgDiag.logErroreGenerico(e, "existsSoggetto()");
                        }
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "existsSoggetto()");
                        return esito;
                    }
                    isSoggettoVirtuale = configurazionePdDManager.isSoggettoVirtuale(idServizio.getSoggettoErogatore());
                    if (!existsSoggetto && !isSoggettoVirtuale) {
                        msgDiag.logPersonalizzato("soggettoDestinatarioNonGestito");
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_451_SOGGETTO_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("soggettoDestinatarioNonGestito"));
                        return esito;
                    }
                    if (bustaDiServizio) {
                        msgDiag.logPersonalizzato("ricezioneBustaServizio");
                        if (sendSbloccoRicezioneBuste) {
                            msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                        }
                        ejbUtils.releaseInboxMessage(false);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaServizio"));
                        return esito;
                    }
                    returnProtocolReply = false;
                    tipoOraRegistrazione = this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente);
                    bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                    if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (this.propertiesReader.isCheckFromRegistroConfermaRicezioneAbilitato(implementazionePdDMittente) && sbustamentoMsg.isConfermaRicezioneRichiestoAccordo() && !bustaRichiesta.isConfermaRicezione() && !consegnaAffidabile) {
                            msgDiag.logPersonalizzato("funzionalitaRichiestaAccordo.confermaRicezioneNonPresente");
                            e = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("funzionalitaRichiestaAccordo.confermaRicezioneNonPresente"));
                            return esito;
                        }
                        if (this.propertiesReader.isCheckFromRegistroConsegnaInOrdineAbilitato(implementazionePdDMittente) && sbustamentoMsg.isConsegnaOrdineRichiestoAccordo() && bustaRichiesta.getSequenza() < 0L) {
                            msgDiag.logPersonalizzato("funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente");
                            e = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_NON_GESTIBILE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente"));
                            return esito;
                        }
                    }
                    if (!(checkDuplicato = imbustamentoFiltroDuplicatiAbilitato)) break block265;
                    try {
                        block266: {
                            block268: {
                                block269: {
                                    block267: {
                                        gestoreFiltroDuplicati = Sbustamento.getGestoreFiltroDuplicati(this.propertiesReader, this.loader, openspcoopstate, pddContext, historyBuste, repositoryBuste, oneWayVersione11);
                                        bustaDuplicata = gestoreFiltroDuplicati.isDuplicata(protocolFactory, bustaRichiesta.getID());
                                        if (!bustaDuplicata) break block266;
                                        msgDiag.logPersonalizzato("ricezioneBustaDuplicata.count");
                                        gestoreFiltroDuplicati.incrementaNumeroDuplicati(protocolFactory, bustaRichiesta.getID());
                                        msgDiag.logPersonalizzato("ricezioneBustaDuplicata");
                                        if (!ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || !consegnaAffidabile) break block267;
                                        msgDiag.logPersonalizzato("ricezioneBuste.", "generazioneRiscontro");
                                        r = new Riscontro();
                                        r.setID(bustaRichiesta.getID());
                                        r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                                        r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente));
                                        bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                                        bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                                        bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                                        bustaHTTPReply.addRiscontro(r);
                                        msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        break block268;
                                    }
                                    if (!(!ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || this.propertiesReader.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione() || !protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() && !this.propertiesReader.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente))) {
                                        ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                        return esito;
                                    }
                                    if (ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                        ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                        return esito;
                                    }
                                    if (!ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) && !ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) break block269;
                                    ricevuta = null;
                                    if (!ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) ** GOTO lbl455
                                    ricevutaAbilitata = true;
                                    try {
                                        if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                            msgDiag.mediumDebug("Lettura Porta Delegata ...");
                                            idAsincronoCorrelazioneRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                                            if (idAsincronoCorrelazioneRichiesta == null) {
                                                idAsincronoCorrelazioneRichiesta = bustaRichiesta.getCollaborazione();
                                            }
                                            integrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(idAsincronoCorrelazioneRichiesta);
                                            idPD = new IDPortaDelegata();
                                            idPD.setLocationPD(integrazione.getLocationPD());
                                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                                            pd = configurazionePdDManager.getPortaDelegata_SafeMethod(idPD);
                                            ricevutaAbilitata = configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pd);
                                        } else {
                                            msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                            pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                                            ricevutaAbilitata = configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pa);
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log.error((Object)("Errore durante la comprensione della Porta (Delegata/Applicativa) associata alla busta: " + e.getMessage()), (Throwable)e);
                                    }
                                    if (!ricevutaAbilitata) {
                                        if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                            ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                                        } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                            ricevuta = "ricevuta di una risposta asincrona simmetrica";
                                        }
                                    } else {
                                        ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                        return esito;
lbl455:
                                        // 1 sources

                                        msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                        pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                                        if (!configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pa)) {
                                            if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
                                            } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
                                            }
                                        } else {
                                            ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                            ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                            return esito;
                                        }
                                    }
                                    if (ricevuta != null) {
                                        msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                                        msgDiag.logPersonalizzato("ricezioneBuste.", "generazioneRicevutaAsincrona");
                                        bustaHTTPReply.setVersioneServizio(bustaRichiesta.getVersioneServizio());
                                        bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                        bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                        bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                        bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                                        bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                        if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                            bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                        }
                                        if (!consegnaAffidabile) {
                                            bustaHTTPReply.setConfermaRicezione(false);
                                        }
                                        if (imbustamentoFiltroDuplicatiAbilitato) {
                                            bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                                        }
                                        msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    }
                                    break block268;
                                }
                                if (protocolManager.isGenerazioneErroreMessaggioOnewayDuplicato() || this.propertiesReader.isGenerazioneErroreProtocolloFiltroDuplicati(implementazionePdDMittente)) {
                                    ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                    ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), idCorrelazioneApplicativa, servizioApplicativoFruitore);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                    return esito;
                                }
                                if (sendSbloccoRicezioneBuste) {
                                    msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                                }
                            }
                            ejbUtils.releaseInboxMessage(false, true);
                            if (msgResponse != null) {
                                msgResponse.addMessaggiIntoCache_readFromTable("Sbustamento", "risposta in seguito a busta duplicata");
                            }
                            if (msgResponse != null) {
                                msgResponse.addProprietariIntoCache_readFromTable("Sbustamento", "risposta in seguito a busta duplicata", idMessageRequest, false);
                            }
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(1, null);
                            return esito;
                        }
                        gestoreFiltroDuplicati.registraBusta(protocolFactory, bustaRichiesta);
                        msgDiag.logPersonalizzato("ricezioneBusta.registrazionePerFiltroDuplicati");
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "GestioneHistoryBusteRicevute");
                        ejbUtils.rollbackMessage("Gestione dell'history delle buste ricevute non riuscita", esito);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(false);
                        esito.setStatoInvocazioneErroreNonGestito(e);
                        return esito;
                    }
                    pddContext.removeObject("CONNECTION_PDD");
                }
                if (consegnaAffidabile) {
                    msgDiag.mediumDebug("Gestione eventuali riscontri da inviare...");
                    senza_piggy_backing = true;
                    if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) && senza_piggy_backing && bustaRichiesta.isConfermaRicezione()) {
                        r = new Riscontro();
                        r.setID(bustaRichiesta.getID());
                        r.setOraRegistrazione(bustaHTTPReply.getOraRegistrazione());
                        r.setTipoOraRegistrazione(this.propertiesReader.getTipoTempoBusta(implementazionePdDMittente));
                        bustaHTTPReply.addRiscontro(r);
                        bustaHTTPReply.setTipoServizioRichiedenteBustaDiServizio(bustaRichiesta.getTipoServizio());
                        bustaHTTPReply.setServizioRichiedenteBustaDiServizio(bustaRichiesta.getServizio());
                        bustaHTTPReply.setAzioneRichiedenteBustaDiServizio(bustaRichiesta.getAzione());
                        returnProtocolReply = true;
                    }
                }
                if (consegnaInOrdine && !ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    msgDiag.mediumDebug("Gestione vincoli consegna in ordine...");
                    msgDiag.logPersonalizzato("consegnaInOrdine.profiloDiversoOneway");
                    e = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.CONSEGNA_IN_ORDINE_NON_SUPPORTATA.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, e, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.profiloDiversoOneway"));
                    return esito;
                }
                scenarioCooperazione = null;
                generazioneMsgOK = false;
                existsPA = true;
                pa = null;
                sa = null;
                integrazioneAsincrona = null;
                if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                    msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay...");
                    scenarioCooperazione = "OneWay_InvocazioneServizio";
                    msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay (existsPA)...");
                    try {
                        existsPA = configurazionePdDManager.existsPA(richiestaApplicativa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,oneway)");
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,oneway)");
                        return esito;
                    }
                    if (!existsPA) {
                        msgDiag.logPersonalizzato("portaApplicativaNonEsistente");
                        ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                        return esito;
                    }
                    msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                    pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                    generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                } else {
                    if (ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono...");
                        if (bustaRichiesta.getRiferimentoMessaggio() != null) {
                            msgDiag.logPersonalizzato("ricezioneRispostaSincrona");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneRispostaSincrona"));
                            return esito;
                        }
                        scenarioCooperazione = "Sincrono_InvocazioneServizio";
                        msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (existsPA)...");
                        try {
                            existsPA = configurazionePdDManager.existsPA(richiestaApplicativa);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,sincrono)");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,sincrono)");
                            return esito;
                        }
                        if (!existsPA) {
                            msgDiag.logPersonalizzato("portaApplicativaNonEsistente");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                            return esito;
                        }
                        msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                        pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                        msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (registra busta ricevuta)...");
                        try {
                            profiloCollaborazione.registraBustaRicevuta(bustaRichiesta.getID());
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "profiloCollaborazione.registraBustaRicevuta(" + bustaRichiesta.getID() + ")");
                            ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(2, "profiloCollaborazione.registraBustaRicevuta(" + bustaRichiesta.getID() + ")");
                            return esito;
                        }
                    }
                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta...");
                            scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (existsPA)...");
                            try {
                                existsPA = configurazionePdDManager.existsPA(richiestaApplicativa);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoSimmetricoRichiesta)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,asincronoSimmetricoRichiesta)");
                                return esito;
                            }
                            if (!existsPA) {
                                msgDiag.logPersonalizzato("portaApplicativaNonEsistente");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                            pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (controllo ricevuta abilitata)...");
                            try {
                                richiestaApplicativa.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pa));
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "ricevutaAsincronaSimmetricaAbilitata(pa)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "ricevutaAsincronaSimmetricaAbilitata(pa)");
                                return esito;
                            }
                            generazioneMsgOK = configurazionePdDManager.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false ? richiestaApplicativa.isRicevutaAsincrona() == false : false;
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta (registrazione busta ricevuta)...");
                            try {
                                tipoServizioCorrelato = null;
                                servizioCorrelato = null;
                                if (bustaRichiesta.getTipoServizioCorrelato() != null && bustaRichiesta.getServizioCorrelato() != null) {
                                    tipoServizioCorrelato = bustaRichiesta.getTipoServizioCorrelato();
                                    servizioCorrelato = bustaRichiesta.getServizioCorrelato();
                                } else {
                                    validazione = registroServiziManager.validaServizio(idSoggettoFruitore, idServizio, null);
                                    if (validazione == null || !validazione.getServizioRegistrato()) {
                                        throw new Exception("Servizio [" + idServizio.toString() + "] non esiste nel registro dei servizi");
                                    }
                                    if (validazione.getServizioCorrelato() == null || validazione.getTipoServizioCorrelato() == null) {
                                        throw new Exception("Servizio [" + idServizio.toString() + "] non possiede un servizio correlato associato");
                                    }
                                    tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
                                    servizioCorrelato = validazione.getServizioCorrelato();
                                }
                                collaborazione = null;
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    collaborazione = bustaRichiesta.getCollaborazione();
                                }
                                profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), collaborazione, tipoServizioCorrelato, servizioCorrelato, richiestaApplicativa.isRicevutaAsincrona(), this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "SalvataggioInformazioniProfiloAsincronoSimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "SalvataggioInformazioniProfiloAsincronoSimmetrico");
                                return esito;
                            }
                            if (generazioneMsgOK) {
                                returnProtocolReply = true;
                                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                }
                                if (!consegnaAffidabile) {
                                    bustaHTTPReply.setConfermaRicezione(false);
                                }
                                if (imbustamentoFiltroDuplicatiAbilitato) {
                                    bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                                }
                            }
                        } else {
                            if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico risposta...");
                                scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                            } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta richiesta asincrona...");
                                ricevutaAsincrona = "ricevuta di una richiesta asincrona simmetrica";
                            } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta risposta asincrona ...");
                                ricevutaAsincrona = "ricevuta di una risposta asincrona simmetrica";
                            } else {
                                msgDiag.logPersonalizzato("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico risposta (raccolta dati per consegna risposta)...");
                            try {
                                if (ricevutaAsincrona == null) {
                                    integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRisposta(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta));
                                }
                                integrazioneAsincrona = profiloCollaborazione.asincronoSimmetrico_getDatiConsegnaRicevuta(bustaRichiesta.getRiferimentoMessaggio());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "RaccoltaDatiIntegrazioneProfiloAsincronoSimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "RaccoltaDatiIntegrazioneProfiloAsincronoSimmetrico");
                                return esito;
                            }
                        }
                    } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        if (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta...");
                            scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (existsPA)...");
                            try {
                                existsPA = configurazionePdDManager.existsPA(richiestaApplicativa);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiesta)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiesta)");
                                return esito;
                            }
                            if (!existsPA) {
                                msgDiag.logPersonalizzato("(Richiesta) " + msgDiag.getMessaggio("portaApplicativaNonEsistente"), msgDiag.getLivello("portaApplicativaNonEsistente"), msgDiag.getCodice("portaApplicativaNonEsistente"));
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "(Richiesta) " + msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                            pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (lettura servizio applicativo)...");
                            servizioApplicativo = null;
                            try {
                                servizioApplicativo = configurazionePdDManager.getServiziApplicativi(pa);
                                if (servizioApplicativo == null) {
                                    throw new Exception("Servizio applicativo non esistente");
                                }
                                if (servizioApplicativo.length > 1) {
                                    throw new Exception("profilo non utilizzabile con una porta applicativa a cui sono stati associati piu' servizi applicativi");
                                }
                                if (servizioApplicativo.length <= 0) {
                                    throw new Exception("Non sono stati associati servizi applicativi alla porta applicativa");
                                }
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "LetturaServizioApplicatiProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "LetturaServizioApplicatiProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            richiestaApplicativa.setServizioApplicativo(servizioApplicativo[0]);
                            msgDiag.mediumDebug("Lettura Servizio Applicativo ...");
                            try {
                                sa = configurazionePdDManager.getServizioApplicativo(richiestaApplicativa.getIdPA(), servizioApplicativo[0]);
                            }
                            catch (DriverConfigurazioneNotFound e) {
                                msgDiag.logErroreGenerico("Servizio applicativo [" + servizioApplicativo[0] + "] non esistente", "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_453_SA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, (Exception)e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "Servizio applicativo [" + servizioApplicativo[0] + "] non esistente");
                                return esito;
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "getServizioApplicativoProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (exists ConsegnaRispostAsincrona)...");
                            existsConsegnaRispostaAsincrona = false;
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", sa.getNome());
                            try {
                                existsConsegnaRispostaAsincrona = configurazionePdDManager.existsConsegnaRispostaAsincrona(sa);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "existsConsegnaRispostaAsincrona_ProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "existsConsegnaRispostaAsincrona_ProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            if (!existsConsegnaRispostaAsincrona) {
                                msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_411_RICEZIONE_CONTENUTI_ASINCRONA_RICHIESTA.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (servizio correlato)...");
                            if (sbustamentoMsg.getServizioCorrelato() == null || sbustamentoMsg.getTipoServizioCorrelato() == null) {
                                msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_408_SERVIZIO_CORRELATO_NON_TROVATO.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente"));
                                return esito;
                            }
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (ricevuta abilitata)...");
                            try {
                                richiestaApplicativa.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pa));
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "ricevutaAsincronaAsimmetricaAbilitata(pa)");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "ricevutaAsincronaAsimmetricaAbilitata(pa)");
                                return esito;
                            }
                            generazioneMsgOK = configurazionePdDManager.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione()) == false ? richiestaApplicativa.isRicevutaAsincrona() == false : false;
                            msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta (registrazione busta ricevuta)...");
                            try {
                                collaborazione = null;
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    collaborazione = bustaRichiesta.getCollaborazione();
                                }
                                profiloCollaborazione.asincronoAsimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), collaborazione, sbustamentoMsg.getTipoServizioCorrelato(), sbustamentoMsg.getServizioCorrelato(), richiestaApplicativa.isRicevutaAsincrona(), this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "SalvataggioInformazioniProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "SalvataggioInformazioniProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                            if (generazioneMsgOK) {
                                returnProtocolReply = true;
                                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                                if (protocolManager.isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDMittente)) {
                                    bustaHTTPReply.setServizioCorrelato(sbustamentoMsg.getServizioCorrelato());
                                    bustaHTTPReply.setTipoServizioCorrelato(sbustamentoMsg.getTipoServizioCorrelato());
                                }
                                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                                if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                                }
                                if (!consegnaAffidabile) {
                                    bustaHTTPReply.setConfermaRicezione(false);
                                }
                                if (imbustamentoFiltroDuplicatiAbilitato) {
                                    bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                                }
                            }
                        } else {
                            if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta Stato...");
                                scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                                idServizioOriginale = null;
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico richiesta Stato (lettura servizio originale)...");
                                try {
                                    idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta));
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta");
                                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, "profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta");
                                    return esito;
                                }
                                richiestaApplicativa.getIDServizio().setServizio(idServizioOriginale.getServizio());
                                richiestaApplicativa.getIDServizio().setTipoServizio(idServizioOriginale.getTipoServizio());
                                richiestaApplicativa.getIDServizio().setAzione(idServizioOriginale.getAzione());
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico richiesta Stato (existsPA)...");
                                try {
                                    existsPA = configurazionePdDManager.existsPA(richiestaApplicativa);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiestaStato)");
                                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, "existsPA(richiestaApplicativa,asincronoAsimmetricoRichiestaStato)");
                                    return esito;
                                }
                                if (!existsPA) {
                                    msgDiag.logPersonalizzato("(RichiestaStato) " + msgDiag.getMessaggio("portaApplicativaNonEsistente"), msgDiag.getLivello("portaApplicativaNonEsistente"), msgDiag.getCodice("portaApplicativaNonEsistente"));
                                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    esito.setStatoInvocazione(2, "(RichiestaStato) " + msgDiag.getMessaggio_replaceKeywords("portaApplicativaNonEsistente"));
                                    return esito;
                                }
                                msgDiag.mediumDebug("Lettura Porta Applicativa ...");
                                pa = configurazionePdDManager.getPortaApplicativa_SafeMethod(richiestaApplicativa.getIdPAbyNome());
                            } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta richiesta...");
                                ricevutaAsincrona = "ricevuta di una richiesta asincrona asimmetrica";
                            } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico ricevuta risposta...");
                                ricevutaAsincrona = "ricevuta di una risposta asincrona asimmetrica contenente l'esito della richiesta stato";
                            } else {
                                msgDiag.logPersonalizzato("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, null);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto"));
                                return esito;
                            }
                            try {
                                if (ricevutaAsincrona == null) ** GOTO lbl932
                                msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico ricevuta (raccolta dati consegna per ricevuta)...");
                                integrazioneAsincrona = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRicevuta(bustaRichiesta.getRiferimentoMessaggio());
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "RaccoltaDatiIntegrazioneProfiloAsincronoAsimmetrico");
                                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                                openspcoopstate.releaseResource();
                                esito.setEsitoInvocazione(true);
                                esito.setStatoInvocazione(2, "RaccoltaDatiIntegrazioneProfiloAsincronoAsimmetrico");
                                return esito;
                            }
                        }
                    } else {
                        ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_SCONOSCIUTO.getErroreProfiloCollaborazioneSconosciuto(bustaRichiesta.getProfiloDiCollaborazioneValue()), (IProtocolFactory)protocolFactory);
                        msgDiag.addKeyword("@ECCEZIONI@", ecc.toString(protocolFactory));
                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", "1");
                        msgDiag.logPersonalizzato("validazioneBusta.bustaNonCorretta");
                        ejbUtils.sendAsRispostaBustaErroreValidazione(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ecc, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                        return esito;
                    }
                }
lbl932:
                // 10 sources

                msgDiag.mediumDebug("Gestione profilo di collaborazione Asincrono, raccolta dati consegna...");
                consegnaApplicativaAsincrona = null;
                pdConsegnaApplicativaAsincrona = null;
                saConsegnaApplicativaAsincrona = null;
                try {
                    block264: {
                        if (integrazioneAsincrona == null) break block263;
                        soggettoFruitoreRichiestaAsincrona = new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario());
                        soggettoErogatoreRichiestaAsincrona = new IDSoggetto(bustaRichiesta.getTipoMittente(), bustaRichiesta.getMittente());
                        servizioRichiestaAsincrona = new IDServizio(soggettoErogatoreRichiestaAsincrona, bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione());
                        proprietaErroreApplAsincrono = this.propertiesReader.getProprietaGestioneErrorePD((IProtocolManager)protocolManager);
                        proprietaErroreApplAsincrono.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreApplAsincrono.setIdModulo("Sbustamento");
                        consegnaApplicativaAsincrona = new RichiestaDelegata(soggettoFruitoreRichiestaAsincrona, integrazioneAsincrona.getLocationPD(), integrazioneAsincrona.getServizioApplicativo(), servizioRichiestaAsincrona, null, proprietaErroreApplAsincrono, identitaPdD);
                        consegnaApplicativaAsincrona.setScenario(scenarioCooperazione);
                        consegnaApplicativaAsincrona.setProfiloGestione(profiloGestione);
                        pdConsegnaApplicativaAsincrona = configurazionePdDManager.getPortaDelegata(consegnaApplicativaAsincrona.getIdPortaDelegata());
                        try {
                            saConsegnaApplicativaAsincrona = configurazionePdDManager.getServizioApplicativo(consegnaApplicativaAsincrona.getIdPortaDelegata(), consegnaApplicativaAsincrona.getServizioApplicativo());
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(consegnaApplicativaAsincrona.getServizioApplicativo())) break block264;
                            throw e;
                        }
                    }
                    configurazionePdDManager.aggiornaProprietaGestioneErrorePD(proprietaErroreApplAsincrono, saConsegnaApplicativaAsincrona);
                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pdConsegnaApplicativaAsincrona));
                    } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(true);
                    } else {
                        consegnaApplicativaAsincrona.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pdConsegnaApplicativaAsincrona));
                    }
                    if (ricevutaAsincrona != null) {
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                        if (profiloCollaborazione.asincrono_spedizioneRichiestaInCorso(bustaRichiesta.getRiferimentoMessaggio()) && ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                            consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(false);
                        }
                        consegnaApplicativaAsincrona.setIdModuloInAttesa(integrazioneAsincrona.getIdModuloInAttesa());
                    } else {
                        consegnaApplicativaAsincrona.setIdModuloInAttesa(richiestaApplicativa.getIdModuloInAttesa());
                        if (!consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                            profiloCollaborazione.eliminaBustaInviata(protocolManager.getIdCorrelazioneAsincrona(bustaRichiesta), true);
                        }
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                        generazioneMsgOK = configurazionePdDManager.isModalitaStateless(pdConsegnaApplicativaAsincrona, bustaRichiesta.getProfiloDiCollaborazione()) == false ? consegnaApplicativaAsincrona.isRicevutaAsincrona() == false : false;
                        if (generazioneMsgOK) {
                            returnProtocolReply = true;
                            bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                            bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                            bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                            bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                            bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                            if (this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                                bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                            }
                            bustaHTTPReply.setRiferimentoMsgBustaRichiedenteServizio(bustaRichiesta.getRiferimentoMessaggio());
                            if (!consegnaAffidabile) {
                                bustaHTTPReply.setConfermaRicezione(false);
                            }
                            if (imbustamentoFiltroDuplicatiAbilitato) {
                                bustaHTTPReply.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "GestioneConsegnaProfiloAsincrono");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "GestioneConsegnaProfiloAsincrono");
                    return esito;
                }
            }
            msgDiag.mediumDebug("Impostazione scenario di cooperazione...");
            try {
                richiestaApplicativa.setScenario(scenarioCooperazione);
                repositoryBuste.aggiornaInfoIntegrazioneIntoInBox_Scenario(bustaRichiesta.getID(), scenarioCooperazione);
                ejbUtils.setScenarioCooperazione(scenarioCooperazione);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "repository.aggiornaInfoIntegrazioneIntoInBox_Scenario");
                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, "repository.aggiornaInfoIntegrazioneIntoInBox_Scenario");
                return esito;
            }
            behaviour = null;
            try {
                if (ricevutaAsincrona == null) {
                    if (consegnaApplicativaAsincrona == null) {
                        msgDiag.mediumDebug("Invio messaggio a ConsegnaContenutiApplicativi...");
                        behaviour = ejbUtils.sendToConsegnaContenutiApplicativi(richiestaApplicativa, bustaRichiesta, msgRequest, pa, repositoryBuste);
                        if (ejbUtils.isGestioneStatelessConIntegrationManager()) {
                            generazioneMsgOK = true;
                            sendSbloccoRicezioneBuste = true;
                        }
                    } else {
                        msgDiag.mediumDebug("Invio messaggio a ConsegnaContenutiApplicativi (consegnaAsincrona)...");
                        ejbUtils.sendToConsegnaContenutiApplicativi_gestioneMessaggio(consegnaApplicativaAsincrona, bustaRichiesta, msgRequest, saConsegnaApplicativaAsincrona);
                    }
                } else if (consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                    msgDiag.mediumDebug("Invio messaggio asincrono a Ricezione/Consegna ContenutiApplicativi...");
                    ejbUtils.updateIdSessione(bustaRichiesta.getRiferimentoMessaggio());
                    msgRequest = ejbUtils.sendRispostaApplicativa(consegnaApplicativaAsincrona, pdConsegnaApplicativaAsincrona, saConsegnaApplicativaAsincrona);
                    ejbUtils.updateIdSessione(idMessageRequest);
                }
                msgDiag.setServizioApplicativo(null);
            }
            catch (EJBUtilsConsegnaException e) {
                msgDiag.logPersonalizzato(e.getMessaggio(), e.getLivello(), e.getCodice());
                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, e.getMessaggio());
                return esito;
            }
            catch (Exception e) {
                ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, "Abilitazione modulo ConsegnaMessaggio non riuscita (Busta " + bustaRichiesta.getID() + "): " + e.getMessage());
                return esito;
            }
            v1 = behaviourResponseTo = behaviour != null && behaviour.isResponseTo() != false;
            if (generazioneMsgOK || behaviourResponseTo) {
                try {
                    pddContext.addObject("DATA_PRESA_IN_CARICO", Costanti.newSimpleDateFormat().format(DateManager.getDate()));
                    if (behaviourResponseTo) {
                        msgReplyTo = null;
                        bustaReplyTo = null;
                        if (behaviour.getResponseTo() != null) {
                            msgReplyTo = behaviour.getResponseTo().getMessage();
                            bustaReplyTo = behaviour.getResponseTo().getBusta();
                        }
                        if (msgReplyTo == null) {
                            msgReplyTo = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
                        }
                        msgDiag.mediumDebug("Invio messaggio a Ricezione/Consegna ContenutiApplicativi (Behaviour)...");
                        msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaReplyTo, msgReplyTo, profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                    }
                    if (!returnProtocolReply) {
                        if (!sendSbloccoRicezioneBuste) ** GOTO lbl1087
                        msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste...");
                        msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                    }
                    msgDiag.mediumDebug("Invio messaggio a Ricezione/Consegna ContenutiApplicativi...");
                    msgResponse = ejbUtils.buildAndSendBustaRisposta(richiestaApplicativa.getIdModuloInAttesa(), bustaHTTPReply, SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap), profiloGestione, idCorrelazioneApplicativa, servizioApplicativoFruitore);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "GenerazioneMsgOK(Riscontro/Ricevuta/Sblocco)");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "GenerazioneMsgOK(Riscontro/Ricevuta/Sblocco)");
                    return esito;
                }
            } else if (ricevutaAsincrona != null) {
                try {
                    pddContext.addObject("DATA_PRESA_IN_CARICO", Costanti.newSimpleDateFormat().format(DateManager.getDate()));
                    if (sendSbloccoRicezioneBuste) {
                        msgDiag.mediumDebug("Invio messaggio di sblocco a RicezioneBuste (ricevuta asincrona)...");
                        msgResponse = ejbUtils.sendSbloccoRicezioneBuste(richiestaApplicativa.getIdModuloInAttesa());
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "SendSbloccoDopoRicezione(" + ricevutaAsincrona + ")");
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "SendSbloccoDopoRicezione(" + ricevutaAsincrona + ")");
                    return esito;
                }
            }
lbl1087:
            // 7 sources

            msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
            if (ricevutaAsincrona == null) {
                msgRequest.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
            } else if (consegnaApplicativaAsincrona != null && !consegnaApplicativaAsincrona.isRicevutaAsincrona()) {
                repositoryBuste.eliminaUtilizzoPdDFromInBox(idMessageRequest, true);
                msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale");
            if (ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                try {
                    ejbUtils.sendAsRispostaBustaErroreProcessamento(richiestaApplicativa.getIdModuloInAttesa(), bustaRichiesta, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), idCorrelazioneApplicativa, servizioApplicativoFruitore, e);
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "ErroreGenerale");
                }
                catch (Exception er) {
                    msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                    ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta sincrona non riuscita", esito);
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazioneErroreNonGestito(er);
                }
            } else {
                ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage(), esito);
                esito.setStatoInvocazioneErroreNonGestito(e);
                esito.setEsitoInvocazione(false);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
        if (msgRequest != null) {
            msgRequest.addMessaggiIntoCache_readFromTable("Sbustamento", "richiesta");
        }
        if (msgResponse != null) {
            msgResponse.addMessaggiIntoCache_readFromTable("Sbustamento", "risposta");
        }
        if (msgRequest != null) {
            msgRequest.addProprietariIntoCache_readFromTable("Sbustamento", "richiesta", null, false);
        }
        if (msgResponse != null) {
            msgResponse.addProprietariIntoCache_readFromTable("Sbustamento", "risposta", idMessageRequest, false);
        }
        if (ricevutaAsincrona != null) {
            msgDiag.mediumDebug("Gestione ricevute asincrone...");
            try {
                forzaEliminazioneMessaggio = false;
                if (openspcoopstate instanceof OpenSPCoopStateless && "ricevuta di una richiesta asincrona simmetrica".equals(ricevutaAsincrona)) {
                    forzaEliminazioneMessaggio = true;
                }
                msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, bustaRichiesta.getRiferimentoMessaggio(), "OUTBOX", msgDiag, pddContext);
                msgRiscontrato.setReadyForDrop(forzaEliminazioneMessaggio);
                msgRiscontrato.validateAndDeleteMsgAsincronoRiscontrato(bustaRichiesta);
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevutaAsincrona);
                msgDiag.logPersonalizzato("validazioneRicevutaAsincrona");
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Validazione(" + ricevutaAsincrona + ")");
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        msgDiag.mediumDebug("Lavoro Terminato.");
        esito.setEsitoInvocazione(true);
        esito.setStatoInvocazione(1, null);
        return esito;
    }

    private void gestioneErroreProtocollo(ConfigurazionePdDManager configurazionePdDManager, EJBUtils ejbUtils, org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione, RepositoryBuste repositoryBuste, Busta busta, IDSoggetto identitaPdD, Eccezione eccezioneProtocollo, ErroreIntegrazione erroreIntegrazione, IDSoggetto soggettoProduttoreEccezione, DettaglioEccezione dettaglioEccezione, Exception eParsing, SOAPVersion versioneSoap, IProtocolManager protocolManager) throws Exception {
        if (ProfiloDiCollaborazione.SINCRONO.equals(busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() != null) {
            ejbUtils.releaseInboxMessage("OUTBOX", busta.getRiferimentoMessaggio(), true);
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(busta.getProfiloDiCollaborazione())) {
            Integrazione integrazioneRispostaErrore = null;
            boolean spedizioneRichiestaInCorso = profiloCollaborazione.asincrono_spedizioneRichiestaInCorso(busta.getRiferimentoMessaggio());
            boolean spedizioneRispostaInCorso = profiloCollaborazione.asincrono_spedizioneRispostaInCorso(busta.getRiferimentoMessaggio());
            boolean ricevutaApplicativaAbilitata = true;
            boolean gestioneEffettuata = false;
            if ((spedizioneRichiestaInCorso || spedizioneRispostaInCorso) && (ricevutaApplicativaAbilitata = profiloCollaborazione.asincrono_ricevutaApplicativaAbilitata(busta.getRiferimentoMessaggio()))) {
                try {
                    integrazioneRispostaErrore = repositoryBuste.getInfoIntegrazioneFromOutBox(busta.getRiferimentoMessaggio());
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante l'esamina dei dati di integrazione per la generazione di una risposta applicativa asincrona, in seguito alla ricezione di un Messaggio Errore Protocollo: " + e.getMessage());
                }
                if (integrazioneRispostaErrore != null) {
                    ServizioApplicativo sappl;
                    PortaDelegata pd;
                    RichiestaDelegata consegnaApplicativaAsincrona;
                    ProprietaErroreApplicativo proprietaErroreApplAsincrono;
                    block14: {
                        IDSoggetto soggettoFruitoreAsincrono = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                        IDSoggetto soggettoErogatoreAsincrono = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                        IDServizio servizioAsincrono = new IDServizio(soggettoErogatoreAsincrono, busta.getTipoServizio(), busta.getServizio(), busta.getAzione());
                        proprietaErroreApplAsincrono = this.propertiesReader.getProprietaGestioneErrorePD(protocolManager);
                        proprietaErroreApplAsincrono.setDominio(identitaPdD.getCodicePorta());
                        proprietaErroreApplAsincrono.setIdModulo(ID_MODULO);
                        consegnaApplicativaAsincrona = new RichiestaDelegata(soggettoFruitoreAsincrono, integrazioneRispostaErrore.getLocationPD(), integrazioneRispostaErrore.getServizioApplicativo(), servizioAsincrono, null, proprietaErroreApplAsincrono, identitaPdD);
                        pd = configurazionePdDManager.getPortaDelegata(consegnaApplicativaAsincrona.getIdPortaDelegata());
                        sappl = null;
                        try {
                            sappl = configurazionePdDManager.getServizioApplicativo(consegnaApplicativaAsincrona.getIdPortaDelegata(), consegnaApplicativaAsincrona.getServizioApplicativo());
                        }
                        catch (Exception e) {
                            if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(consegnaApplicativaAsincrona.getServizioApplicativo())) break block14;
                            throw e;
                        }
                    }
                    configurazionePdDManager.aggiornaProprietaGestioneErrorePD(proprietaErroreApplAsincrono, sappl);
                    consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(true);
                    if (spedizioneRichiestaInCorso && ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione())) {
                        consegnaApplicativaAsincrona.setUtilizzoConsegnaAsincrona(false);
                    }
                    consegnaApplicativaAsincrona.setIdModuloInAttesa(integrazioneRispostaErrore.getIdModuloInAttesa());
                    this.erroreApplicativoBuilder.setProprietaErroreApplicato(proprietaErroreApplAsincrono);
                    this.erroreApplicativoBuilder.setTipoPdD(TipoPdD.DELEGATA);
                    this.erroreApplicativoBuilder.setServizioApplicativo(consegnaApplicativaAsincrona.getServizioApplicativo());
                    this.erroreApplicativoBuilder.setMittente(consegnaApplicativaAsincrona.getSoggettoFruitore());
                    this.erroreApplicativoBuilder.setServizio(consegnaApplicativaAsincrona.getIdServizio());
                    this.erroreApplicativoBuilder.setDominio(consegnaApplicativaAsincrona.getDominio());
                    OpenSPCoop2Message responseMessageError = null;
                    responseMessageError = eccezioneProtocollo != null ? this.erroreApplicativoBuilder.toMessage(eccezioneProtocollo, soggettoProduttoreEccezione, dettaglioEccezione, eParsing) : this.erroreApplicativoBuilder.toMessage(erroreIntegrazione, eParsing);
                    ejbUtils.updateIdSessione(busta.getRiferimentoMessaggio());
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, consegnaApplicativaAsincrona, spedizioneRichiestaInCorso, pd, sappl);
                    ejbUtils.updateIdSessione(busta.getID());
                    gestioneEffettuata = true;
                } else if (spedizioneRichiestaInCorso) {
                    ejbUtils.releaseInboxMessage("OUTBOX", busta.getRiferimentoMessaggio(), true);
                    gestioneEffettuata = true;
                }
            }
            if (!gestioneEffettuata) {
                ejbUtils.releaseInboxMessage(true);
            }
        } else {
            ejbUtils.releaseInboxMessage(true);
        }
    }

    public static IFiltroDuplicati getGestoreFiltroDuplicati(OpenSPCoop2Properties propertiesReader, Loader loader, IOpenSPCoopState openspcoopstate, PdDContext pddContext, History historyBuste, RepositoryBuste repositoryBuste, boolean oneWayVersione11) throws Exception {
        String gestoreFiltroDuplicatiType = propertiesReader.getGestoreFiltroDuplicatiRepositoryBuste();
        ClassNameProperties prop = ClassNameProperties.getInstance();
        String gestoreFiltroDuplicatiClass = prop.getFiltroDuplicati(gestoreFiltroDuplicatiType);
        if (gestoreFiltroDuplicatiClass == null) {
            throw new Exception("GestoreFiltroDuplicati non registrato (" + gestoreFiltroDuplicatiType + ")");
        }
        IFiltroDuplicati gestoreFiltroDuplicati = (IFiltroDuplicati)loader.newInstance(gestoreFiltroDuplicatiClass);
        pddContext.addObject("CONNECTION_PDD", ((OpenSPCoopState)openspcoopstate).getConnectionDB());
        gestoreFiltroDuplicati.init((Object)pddContext);
        if (gestoreFiltroDuplicati instanceof FiltroDuplicati) {
            ((FiltroDuplicati)gestoreFiltroDuplicati).setHistoryBuste(historyBuste);
            ((FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryBuste(repositoryBuste);
            ((FiltroDuplicati)gestoreFiltroDuplicati).setGestioneStateless(openspcoopstate instanceof OpenSPCoopStateless && !oneWayVersione11);
            ((FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryIntervalloScadenzaMessaggi(propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
        }
        return gestoreFiltroDuplicati;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo;

        static {
            $SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo = new int[StatoFunzionalitaProtocollo.values().length];
            try {
                1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[StatoFunzionalitaProtocollo.ABILITATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openspcoop2$protocol$sdk$constants$StatoFunzionalitaProtocollo[StatoFunzionalitaProtocollo.DISABILITATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

