/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.resources.Loader;

public abstract class GenericLib {
    protected Logger log = null;
    protected OpenSPCoop2Properties propertiesReader;
    protected Loader loader;
    protected String idModulo;
    protected ProtocolFactoryManager protocolFactoryManager = null;
    protected boolean inizializzazioneUltimata = false;

    public boolean getInizializzazioneUltimata() {
        return this.inizializzazioneUltimata;
    }

    protected synchronized void inizializza() throws GenericLibException {
        if (!this.inizializzazioneUltimata) {
            try {
                this.propertiesReader = OpenSPCoop2Properties.getInstance();
                this.loader = Loader.getInstance();
                this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
                boolean error = false;
                this.inizializzazioneUltimata = !error;
            }
            catch (Exception e) {
                throw new GenericLibException(e.getMessage(), e);
            }
        }
    }

    public GenericLib(String idModulo, Logger log) {
        this.idModulo = idModulo;
        this.log = log;
    }

    protected MsgDiagnostico initMsgDiagnostico(IOpenSPCoopState openspcoop_state) throws OpenSPCoopStateException {
        try {
            return new MsgDiagnostico(this.idModulo, openspcoop_state.getStatoRichiesta(), openspcoop_state.getStatoRisposta());
        }
        catch (Exception e) {
            this.log.error((Object)"Riscontrato Errore durante l'inizializzazione del MsgDiagnostico", (Throwable)e);
            throw new OpenSPCoopStateException("Riscontrato Errore durante l'inizializzazione del MsgDiagnostico");
        }
    }

    public EsitoLib onMessage(IOpenSPCoopState openspcoop_state) throws OpenSPCoopStateException {
        RegistroServiziManager registroServiziManager = null;
        ConfigurazionePdDManager configurazionePdDManager = null;
        if (openspcoop_state instanceof OpenSPCoopState) {
            OpenSPCoopState openspcoopState = (OpenSPCoopState)openspcoop_state;
            registroServiziManager = RegistroServiziManager.getInstance((IState[])new IState[]{openspcoopState.getStatoRichiesta(), openspcoopState.getStatoRisposta()});
            configurazionePdDManager = ConfigurazionePdDManager.getInstance(openspcoopState.getStatoRichiesta(), openspcoopState.getStatoRisposta());
        } else {
            registroServiziManager = RegistroServiziManager.getInstance();
            configurazionePdDManager = ConfigurazionePdDManager.getInstance();
        }
        return this._onMessage(openspcoop_state, registroServiziManager, configurazionePdDManager, this.initMsgDiagnostico(openspcoop_state));
    }

    public abstract EsitoLib _onMessage(IOpenSPCoopState var1, RegistroServiziManager var2, ConfigurazionePdDManager var3, MsgDiagnostico var4) throws OpenSPCoopStateException;
}

