/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.TracciaBuilder;
import org.openspcoop2.protocol.sdk.Allegato;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.constants.TipoTraccia;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciamentoOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.date.DateManager;

public class Tracciamento {
    public static boolean tracciamentoDisponibile = true;
    public static Exception motivoMalfunzionamentoTracciamento = null;
    protected Logger loggerTracciamento = null;
    private TipoPdD tipoPdD;
    private IDSoggetto idSoggettoDominio;
    private PdDContext pddContext;
    private ProtocolFactoryManager protocolFactoryManager = null;
    private IProtocolFactory protocolFactory;
    private Vector<ITracciamentoOpenSPCoopAppender> loggerTracciamentoOpenSPCoopAppender = null;
    private Vector<String> tipoTracciamentoOpenSPCoopAppender = null;
    private ConfigurazionePdDManager configurazionePdDManager;
    private IState statoRichiesta;
    private IState statoRisposta;
    private TracciaBuilder xmlBuilder;
    private MsgDiagnostico msgDiagErroreTracciamento = null;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private GeneratoreCasualeDate generatoreDateCasuali = null;

    public static String createLocationString(boolean bustaRicevuta, String location) {
        if (bustaRicevuta) {
            return ConnettoreUtils.limitLocation255Character("IN:" + location);
        }
        return ConnettoreUtils.limitLocation255Character("OUT:" + location);
    }

    public Tracciamento(IDSoggetto idSoggettoDominio, String idFunzione, PdDContext pddContext, TipoPdD tipoPdD, IState statoRichiesta, IState statoRisposta) throws TracciamentoException {
        this.idSoggettoDominio = idSoggettoDominio;
        this.pddContext = pddContext;
        this.tipoPdD = tipoPdD;
        this.loggerTracciamento = OpenSPCoop2Logger.loggerTracciamento;
        this.loggerTracciamentoOpenSPCoopAppender = OpenSPCoop2Logger.loggerTracciamentoOpenSPCoopAppender;
        this.tipoTracciamentoOpenSPCoopAppender = OpenSPCoop2Logger.tipoTracciamentoOpenSPCoopAppender;
        this.statoRichiesta = statoRichiesta;
        this.statoRisposta = statoRisposta;
        this.configurazionePdDManager = ConfigurazionePdDManager.getInstance(this.statoRichiesta, this.statoRisposta);
        this.msgDiagErroreTracciamento = new MsgDiagnostico(idSoggettoDominio, idFunzione, this.statoRichiesta, this.statoRisposta);
        this.msgDiagErroreTracciamento.setPrefixMsgPersonalizzati("tracciamento.");
        try {
            this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
            this.protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)this.pddContext.getObject("PROTOCOLLO"));
        }
        catch (Throwable e) {
            throw new TracciamentoException(e.getMessage(), e);
        }
        this.xmlBuilder = new TracciaBuilder(this.protocolFactory);
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato()) {
            this.generatoreDateCasuali = GeneratoreCasualeDate.getGeneratoreCasualeDate();
        }
    }

    public void updateState(IState statoRichiesta, IState statoRisposta) {
        this.statoRichiesta = statoRichiesta;
        this.statoRisposta = statoRisposta;
    }

    public void setDominio(IDSoggetto dominio) {
        this.idSoggettoDominio = dominio;
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    private Connection getConnectionFromState(boolean richiesta) {
        if (richiesta) {
            if (this.statoRichiesta != null && this.statoRichiesta instanceof StateMessage) {
                boolean validConnection = false;
                try {
                    validConnection = !((StateMessage)this.statoRichiesta).getConnectionDB().isClosed();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (validConnection) {
                    return ((StateMessage)this.statoRichiesta).getConnectionDB();
                }
            }
        } else if (this.statoRisposta != null && this.statoRisposta instanceof StateMessage) {
            boolean validConnection = false;
            try {
                validConnection = !((StateMessage)this.statoRisposta).getConnectionDB().isClosed();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (validConnection) {
                return ((StateMessage)this.statoRisposta).getConnectionDB();
            }
        }
        return null;
    }

    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRichiesta(msg, securityInfo, busta, esito, location, null);
    }

    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa) throws TracciamentoException {
        if (this.configurazionePdDManager.tracciamentoBuste()) {
            String xml = null;
            boolean erroreAppender = false;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                busta.setOraRegistrazione(gdo);
            }
            Traccia traccia = this.getTraccia(busta, msg, securityInfo, esito, gdo, TipoTraccia.RICHIESTA, location, idCorrelazioneApplicativa);
            try {
                if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.toString(traccia);
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(true), traccia);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RICHIESTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.toString(traccia);
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                } else {
                    this.logError("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RICHIESTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRichiesta(msg, securityInfo, busta, bustaObject, esito, location, null);
    }

    @Deprecated
    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa) throws TracciamentoException {
        if (this.configurazionePdDManager.tracciamentoBuste()) {
            String xml = null;
            boolean erroreAppender = false;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                bustaObject.setOraRegistrazione(gdo);
            }
            Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, TipoTraccia.RICHIESTA, location, idCorrelazioneApplicativa);
            traccia.setBustaAsByteArray(busta);
            try {
                if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.toString(traccia);
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(true), traccia);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RICHIESTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.toString(traccia);
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                } else {
                    this.logError("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RICHIESTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, SOAPElement busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRichiesta(msg, securityInfo, busta, bustaObject, esito, location, null);
    }

    public void registraRichiesta(OpenSPCoop2Message msg, SecurityInfo securityInfo, SOAPElement busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa) throws TracciamentoException {
        if (this.configurazionePdDManager.tracciamentoBuste()) {
            String xml = null;
            boolean erroreAppender = false;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                bustaObject.setOraRegistrazione(gdo);
            }
            Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, TipoTraccia.RICHIESTA, location, idCorrelazioneApplicativa);
            traccia.setBustaAsElement(busta);
            try {
                if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.toString(traccia);
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(true), traccia);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RICHIESTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.toString(traccia);
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                } else {
                    this.logError("Errore durante il tracciamento della richiesta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RICHIESTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRisposta(msg, securityInfo, busta, esito, location, null, null);
    }

    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, Busta busta, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) throws TracciamentoException {
        if (this.configurazionePdDManager.tracciamentoBuste()) {
            String xml = null;
            boolean erroreAppender = false;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                busta.setOraRegistrazione(gdo);
            }
            Traccia traccia = this.getTraccia(busta, msg, securityInfo, esito, gdo, TipoTraccia.RISPOSTA, location, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
            try {
                if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.toString(traccia);
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(false), traccia);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RISPOSTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.toString(traccia);
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                } else {
                    this.logError("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RISPOSTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRisposta(msg, securityInfo, busta, bustaObject, esito, location, null, null);
    }

    @Deprecated
    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, byte[] busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) throws TracciamentoException {
        if (this.configurazionePdDManager.tracciamentoBuste()) {
            String xml = null;
            boolean erroreAppender = false;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                bustaObject.setOraRegistrazione(gdo);
            }
            Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, TipoTraccia.RISPOSTA, location, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
            traccia.setBustaAsByteArray(busta);
            try {
                if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.toString(traccia);
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(false), traccia);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RISPOSTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.toString(traccia);
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                } else {
                    this.logError("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RISPOSTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, SOAPElement busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location) throws TracciamentoException {
        this.registraRisposta(msg, securityInfo, busta, bustaObject, esito, location, null, null);
    }

    public void registraRisposta(OpenSPCoop2Message msg, SecurityInfo securityInfo, SOAPElement busta, Busta bustaObject, EsitoElaborazioneMessaggioTracciato esito, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) throws TracciamentoException {
        if (this.configurazionePdDManager.tracciamentoBuste()) {
            String xml = null;
            boolean erroreAppender = false;
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                bustaObject.setOraRegistrazione(gdo);
            }
            Traccia traccia = this.getTraccia(bustaObject, msg, securityInfo, esito, gdo, TipoTraccia.RISPOSTA, location, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta);
            traccia.setBustaAsElement(busta);
            try {
                if (OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    xml = this.xmlBuilder.toString(traccia);
                    if (xml == null) {
                        throw new Exception("Traccia non costruita");
                    }
                    this.loggerTracciamento.info((Object)xml);
                }
                for (int i = 0; i < this.loggerTracciamentoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerTracciamentoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(false), traccia);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante il tracciamento personalizzato [" + this.tipoTracciamentoOpenSPCoopAppender.get(i) + "] della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RISPOSTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoTracciamentoOpenSPCoopAppender.get(i));
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita.openspcoopAppender");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                        if (!this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) continue;
                        erroreAppender = true;
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                if (xml == null && !OpenSPCoop2Logger.loggerTracciamentoAbilitato) {
                    try {
                        xml = this.xmlBuilder.toString(traccia);
                    }
                    catch (Exception eBuild) {
                        // empty catch block
                    }
                }
                if (xml == null) {
                    this.logError("Errore durante la costruzione della traccia: " + e.getMessage(), e);
                } else {
                    this.logError("Errore durante il tracciamento della risposta: " + e.getMessage() + ". Traccia non registrata:\n" + xml, e);
                    if (!erroreAppender) {
                        try {
                            this.msgDiagErroreTracciamento.addKeyword("@TIPO_TRACCIA@", TipoTraccia.RISPOSTA.toString());
                            this.msgDiagErroreTracciamento.addKeyword("@TRACCIA@", xml);
                            this.msgDiagErroreTracciamento.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                            this.msgDiagErroreTracciamento.logPersonalizzato("registrazioneNonRiuscita");
                        }
                        catch (Exception eMsg) {
                            // empty catch block
                        }
                    }
                }
                this.gestioneErroreTracciamento(e);
            }
        }
    }

    private Traccia getTraccia(Busta busta, OpenSPCoop2Message msg, SecurityInfo securityInfo, EsitoElaborazioneMessaggioTracciato esito, Date gdo, TipoTraccia tipoTraccia, String location, String idCorrelazioneApplicativa) {
        return this.getTraccia(busta, msg, securityInfo, esito, gdo, tipoTraccia, location, idCorrelazioneApplicativa, null);
    }

    private Traccia getTraccia(Busta busta, OpenSPCoop2Message msg, SecurityInfo securityInfo, EsitoElaborazioneMessaggioTracciato esito, Date gdo, TipoTraccia tipoTraccia, String location, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta) {
        String[] key;
        Traccia traccia = new Traccia();
        traccia.setEsitoElaborazioneMessaggioTracciato(esito);
        try {
            SOAPBody body;
            if (TipoTraccia.RISPOSTA.equals(tipoTraccia) && (body = msg.getSOAPBody()) != null && body.hasFault()) {
                StringBuffer bf = new StringBuffer();
                if (esito.getDettaglio() != null) {
                    bf.append(esito.getDettaglio());
                    bf.append("\n");
                }
                bf.append(SoapUtils.toString((SOAPFault)body.getFault()));
                traccia.getEsitoElaborazioneMessaggioTracciato().setDettaglio(bf.toString());
            }
        }
        catch (Exception e) {
            this.logError("errore durante la registrazione del SOAPFault nelle tracce", e);
        }
        traccia.setGdo(gdo);
        traccia.setIdSoggetto(this.idSoggettoDominio);
        traccia.setTipoMessaggio(tipoTraccia);
        traccia.setTipoPdD(this.tipoPdD);
        traccia.setCorrelazioneApplicativa(idCorrelazioneApplicativa);
        traccia.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        traccia.setLocation(location);
        traccia.setProtocollo(this.protocolFactory.getProtocol());
        if (securityInfo != null) {
            busta.setDigest(securityInfo.getDigestHeader());
            Hashtable properties = securityInfo.getProperties();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key2 = (String)keys.nextElement();
                busta.addProperty(key2, (String)properties.get(key2));
            }
        }
        traccia.setBusta(busta);
        if (msg != null) {
            Iterator it = msg.getAttachments();
            while (it.hasNext()) {
                AttachmentPart ap = (AttachmentPart)it.next();
                Allegato allegato = new Allegato();
                allegato.setContentId(ap.getContentId());
                allegato.setContentLocation(ap.getContentLocation());
                allegato.setContentType(ap.getContentType());
                if (securityInfo != null && ap.getContentId() != null) {
                    for (int i = 0; i < securityInfo.sizeListaAllegati(); ++i) {
                        Allegato a = securityInfo.getAllegato(i);
                        if (a.getContentId() == null || !a.getContentId().equals(ap.getContentId())) continue;
                        allegato.setDigest(a.getDigest());
                    }
                }
                traccia.addAllegato(allegato);
            }
        }
        if (this.pddContext != null && (key = Costanti.CONTEXT_OBJECT) != null) {
            for (int j = 0; j < key.length; ++j) {
                Object o = this.pddContext.getObject(key[j]);
                if (o == null || !(o instanceof String)) continue;
                traccia.addProperty(key[j], (String)o);
            }
        }
        return traccia;
    }

    private void gestioneErroreTracciamento(Exception e) throws TracciamentoException {
        if (this.openspcoopProperties.isTracciaturaFallita_BloccoServiziPdD()) {
            tracciamentoDisponibile = false;
            motivoMalfunzionamentoTracciamento = e;
            try {
                this.msgDiagErroreTracciamento.logPersonalizzato("errore.bloccoServizi");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logError("Il Sistema di tracciamento ha rilevato un errore durante la registrazione di una traccia legale, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio della Porta di Dominio. Errore rilevato: ", e);
        }
        if (this.openspcoopProperties.isTracciaturaFallita_BloccaCooperazioneInCorso()) {
            throw new TracciamentoException((Throwable)e);
        }
    }

    private void logError(String msgErrore, Exception e) {
        if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error((Object)msgErrore, (Throwable)e);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)msgErrore, (Throwable)e);
        }
    }

    private void logError(String msgErrore) {
        if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error((Object)msgErrore);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)msgErrore);
        }
    }
}

