/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.MsgDiagnosticiProperties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.protocol.engine.BasicProtocolFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.DiagnosticoBuilder;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.diagnostica.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.diagnostica.InformazioniProtocollo;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazioneApplicativa;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazioneServizioApplicativo;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.date.DateManager;

public class MsgDiagnostico {
    public static boolean gestoreDiagnosticaDisponibile = true;
    public static Exception motivoMalfunzionamentoDiagnostici = null;
    private Logger loggerMsgDiagnostico = null;
    private Logger loggerOpenSPCoop2 = null;
    private Logger loggerIntegrationManager = null;
    private Logger loggerOpenSPCoop2Fatal = null;
    private Logger loggerOpenSPCoop2Core = null;
    private Vector<IMsgDiagnosticoOpenSPCoopAppender> loggerMsgDiagnosticoOpenSPCoopAppender = null;
    private Vector<String> tipoMsgDiagnosticoOpenSPCoopAppender = null;
    private IDSoggetto idSoggettoDominio;
    private String idModulo;
    private String idMessaggioRichiesta;
    private String idMessaggioRisposta;
    private PdDContext pddContext;
    private DiagnosticoBuilder diagnosticoBuilder;
    private ProtocolFactoryManager protocolFactoryManager = null;
    private IProtocolFactory protocolFactory;
    private ITraduttore traduttore;
    private ConfigurazionePdDManager configurazionePdDReader;
    private MsgDiagnosticiProperties msgDiagPropertiesReader;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private GeneratoreCasualeDate generatoreDateCasuali = null;
    private Hashtable<String, String> properties = new Hashtable();
    private Hashtable<String, String> keywordLogPersonalizzati = new Hashtable();
    private List<IState> states = new ArrayList<IState>();
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String porta;
    private boolean delegata;
    private String servizioApplicativo;
    private String idCorrelazioneApplicativa;
    private String idCorrelazioneRisposta;
    private String prefixMsgPersonalizzati = null;

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public Hashtable<String, String> getKeywordLogPersonalizzati() {
        return this.keywordLogPersonalizzati;
    }

    public MsgDiagnostico(IDSoggetto idSoggettoDominio, String modulo, IState ... state) {
        this.idSoggettoDominio = idSoggettoDominio;
        this.idModulo = modulo;
        this.loggerMsgDiagnostico = OpenSPCoop2Logger.loggerMsgDiagnostico;
        this.loggerOpenSPCoop2 = OpenSPCoop2Logger.loggerOpenSPCoop2;
        this.loggerIntegrationManager = OpenSPCoop2Logger.loggerIntegrationManager;
        this.loggerOpenSPCoop2Fatal = OpenSPCoop2Logger.loggerOpenSPCoopConsole;
        this.loggerMsgDiagnosticoOpenSPCoopAppender = OpenSPCoop2Logger.loggerMsgDiagnosticoOpenSPCoopAppender;
        this.tipoMsgDiagnosticoOpenSPCoopAppender = OpenSPCoop2Logger.tipoMsgDiagnosticoOpenSPCoopAppender;
        this.loggerOpenSPCoop2Core = OpenSPCoop2Logger.loggerOpenSPCoopCore;
        if (state != null) {
            for (int i = 0; i < state.length; ++i) {
                this.states.add(state[i]);
            }
        }
        this.configurazionePdDReader = ConfigurazionePdDManager.getInstance(state);
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato()) {
            this.generatoreDateCasuali = GeneratoreCasualeDate.getGeneratoreCasualeDate();
        }
        try {
            this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
            this.protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)this.pddContext.getObject("PROTOCOLLO"));
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (Throwable e) {
            this.protocolFactory = new BasicProtocolFactory(this.loggerOpenSPCoop2Core);
            try {
                this.traduttore = this.protocolFactory.createTraduttore();
            }
            catch (Throwable eClose) {
                // empty catch block
            }
        }
        this.diagnosticoBuilder = new DiagnosticoBuilder(this.protocolFactory);
    }

    public MsgDiagnostico(String modulo, IState ... state) {
        this(OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(null), modulo, state);
    }

    public MsgDiagnostico() {
        this.msgDiagPropertiesReader = MsgDiagnosticiProperties.getInstance();
    }

    public void updateState(IState ... state) {
        this.states.clear();
        if (state != null) {
            for (int i = 0; i < state.length; ++i) {
                this.states.add(state[i]);
            }
        }
    }

    private Connection getConnectionFromState() {
        for (IState state : this.states) {
            if (state == null || !(state instanceof StateMessage)) continue;
            boolean validConnection = false;
            try {
                validConnection = !((StateMessage)state).getConnectionDB().isClosed();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!validConnection) continue;
            return ((StateMessage)state).getConnectionDB();
        }
        return null;
    }

    public void setDominio(IDSoggetto idSoggettoDominio) {
        this.idSoggettoDominio = idSoggettoDominio;
    }

    public IDSoggetto getDominio() {
        return this.idSoggettoDominio;
    }

    public void setPddContext(PdDContext pddContext, IProtocolFactory protocolFactory) {
        this.pddContext = pddContext;
        this.protocolFactory = protocolFactory;
        try {
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diagnosticoBuilder = new DiagnosticoBuilder(protocolFactory);
        this.addKeywords(protocolFactory);
    }

    public void setFunzione(String modulo) {
        this.idModulo = modulo;
    }

    public String getFunzione() {
        return this.idModulo;
    }

    public void setIdMessaggioRichiesta(String id) {
        this.idMessaggioRichiesta = id;
    }

    public void setIdMessaggioRisposta(String id) {
        this.idMessaggioRisposta = id;
    }

    public void aggiornaFiltri() {
    }

    @Deprecated
    public String filter(String msg) {
        String xml = msg.replaceAll("&lt;", "<");
        xml = xml.replaceAll("&quot;", "\"");
        xml = xml.replaceAll("&gt;", ">");
        return xml;
    }

    public void setFruitore(IDSoggetto fruitore) {
        this.fruitore = fruitore;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setPorta(String porta) {
        this.porta = porta;
    }

    public void setDelegata(boolean delegata) {
        this.delegata = delegata;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setIdCorrelazioneApplicativa(String idCorrelazioneApplicativa) {
        this.idCorrelazioneApplicativa = idCorrelazioneApplicativa;
    }

    public void setIdCorrelazioneRisposta(String idCorrelazioneRisposta) {
        this.idCorrelazioneRisposta = idCorrelazioneRisposta;
    }

    public void addKeyword(String key, String value) {
        if (key != null) {
            String tmpValue = value;
            if (tmpValue == null) {
                tmpValue = "";
            }
            if (this.keywordLogPersonalizzati.containsKey(key)) {
                this.keywordLogPersonalizzati.remove(key);
            }
            this.keywordLogPersonalizzati.put(key, tmpValue);
        }
    }

    public void addKeywords(IProtocolFactory protocolFactory) {
        this.addKeyword("@PROTOCOLLO@", protocolFactory.getProtocol());
        try {
            this.addKeyword("@PROTOCOLLO_TIPI_SOGGETTI@", protocolFactory.createProtocolConfiguration().getTipiSoggetti().toString());
            this.addKeyword("@PROTOCOLLO_TIPI_SERVIZI@", protocolFactory.createProtocolConfiguration().getTipiServizi().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addKeywords(Busta busta, boolean richiesta) {
        if (busta != null) {
            if (richiesta) {
                if (busta.getID() != null) {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", busta.getID());
                } else {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", "N.D.");
                }
                if (busta.getProfiloDiCollaborazione() != null) {
                    String profilo = null;
                    if (this.traduttore != null) {
                        profilo = this.traduttore.toString(busta.getProfiloDiCollaborazione());
                    } else if (busta.getProtocollo() != null) {
                        try {
                            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(busta.getProtocollo());
                            ITraduttore traduttore = protocolFactory.createTraduttore();
                            profilo = traduttore.toString(busta.getProfiloDiCollaborazione());
                        }
                        catch (Exception e) {
                            profilo = busta.getProfiloDiCollaborazione().name();
                        }
                    } else {
                        profilo = busta.getProfiloDiCollaborazione().name();
                    }
                    if (profilo == null) {
                        profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                    }
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", profilo);
                }
                if (busta.getTipoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", busta.getTipoMittente());
                }
                if (busta.getMittente() != null) {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", busta.getMittente());
                }
                if (busta.getTipoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", busta.getTipoDestinatario());
                }
                if (busta.getDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", busta.getDestinatario());
                }
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", busta.getServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", busta.getSequenza() + "");
                }
                if (busta.getIndirizzoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RICHIESTA@", busta.getIndirizzoMittente());
                }
                if (busta.getIndirizzoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RICHIESTA@", busta.getIndirizzoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RICHIESTA@", busta.getScadenza().toString());
                }
            } else {
                if (busta.getID() != null) {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RISPOSTA@", busta.getID());
                } else {
                    this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RISPOSTA@", "N.D.");
                }
                if (busta.getProfiloDiCollaborazione() != null) {
                    String profilo = null;
                    if (this.traduttore != null) {
                        profilo = this.traduttore.toString(busta.getProfiloDiCollaborazione());
                    } else if (busta.getProtocollo() != null) {
                        try {
                            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(busta.getProtocollo());
                            ITraduttore traduttore = protocolFactory.createTraduttore();
                            profilo = traduttore.toString(busta.getProfiloDiCollaborazione());
                        }
                        catch (Exception e) {
                            profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                        }
                    } else {
                        profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                    }
                    if (profilo == null) {
                        profilo = busta.getProfiloDiCollaborazione().getEngineValue();
                    }
                    this.keywordLogPersonalizzati.put("@PROFILO_COLLABORAZIONE@", profilo);
                }
                if (busta.getTipoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RISPOSTA@", busta.getTipoMittente());
                }
                if (busta.getMittente() != null) {
                    this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RISPOSTA@", busta.getMittente());
                }
                if (busta.getTipoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RISPOSTA@", busta.getTipoDestinatario());
                }
                if (busta.getDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RISPOSTA@", busta.getDestinatario());
                }
                if (busta.getTipoServizio() != null) {
                    this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RISPOSTA@", busta.getTipoServizio());
                }
                if (busta.getServizio() != null) {
                    this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RISPOSTA@", busta.getServizio());
                }
                if (busta.getAzione() != null) {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", busta.getAzione());
                } else {
                    this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RISPOSTA@", "");
                }
                if (busta.getRiferimentoMessaggio() != null) {
                    this.keywordLogPersonalizzati.put("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", busta.getRiferimentoMessaggio());
                }
                if (busta.getSequenza() > 0L) {
                    this.keywordLogPersonalizzati.put("@SEQUENZA@", busta.getSequenza() + "");
                }
                if (busta.getIndirizzoMittente() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_MITTENTE_RISPOSTA@", busta.getIndirizzoMittente());
                }
                if (busta.getIndirizzoDestinatario() != null) {
                    this.keywordLogPersonalizzati.put("@INDIRIZZO_TELEMATICO_DESTINATARIO_RISPOSTA@", busta.getIndirizzoDestinatario());
                }
                if (busta.getScadenza() != null) {
                    this.keywordLogPersonalizzati.put("@SCADENZA_BUSTA_RISPOSTA@", busta.getScadenza().toString());
                }
            }
        }
    }

    public void addKeywords(IDSoggetto soggettoFruitore) {
        this.addKeywords(soggettoFruitore, null, null);
    }

    public void addKeywords(IDServizio idServizio) {
        this.addKeywords(null, idServizio, null);
    }

    public void addKeywords(IDSoggetto soggettoFruitore, IDServizio idServizio, String idMessaggio) {
        if (idMessaggio != null) {
            this.keywordLogPersonalizzati.put("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
        }
        if (soggettoFruitore != null) {
            this.keywordLogPersonalizzati.put("@TIPO_MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getTipo());
            this.keywordLogPersonalizzati.put("@MITTENTE_BUSTA_RICHIESTA@", soggettoFruitore.getNome());
        }
        if (idServizio != null) {
            if (idServizio.getSoggettoErogatore() != null) {
                this.keywordLogPersonalizzati.put("@TIPO_DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getTipo());
                this.keywordLogPersonalizzati.put("@DESTINATARIO_BUSTA_RICHIESTA@", idServizio.getSoggettoErogatore().getNome());
            }
            this.keywordLogPersonalizzati.put("@TIPO_SERVIZIO_BUSTA_RICHIESTA@", idServizio.getTipoServizio());
            this.keywordLogPersonalizzati.put("@SERVIZIO_BUSTA_RICHIESTA@", idServizio.getServizio());
            if (idServizio.getAzione() != null) {
                this.keywordLogPersonalizzati.put("@AZIONE_BUSTA_RICHIESTA@", idServizio.getAzione());
            }
        }
    }

    public String replaceKeywords(String msg) {
        if (msg != null && msg.length() > 2) {
            int index1 = msg.indexOf("@");
            int index2 = msg.indexOf("@", index1 + 1);
            if (index1 < 0 || index2 < 0) {
                return msg;
            }
        }
        StringBuffer bf = new StringBuffer();
        StringBuffer keyword = new StringBuffer();
        boolean separator = false;
        char separatorChar = '@';
        for (int i = 0; i < msg.length(); ++i) {
            char ch = msg.charAt(i);
            if (separatorChar == ch) {
                if (!separator) {
                    keyword.append(separatorChar);
                    separator = true;
                    continue;
                }
                keyword.append(separatorChar);
                String valoreRimpiazzato = this.keywordLogPersonalizzati.get(keyword.toString());
                if (valoreRimpiazzato == null) {
                    bf.append(keyword.toString());
                } else {
                    bf.append(valoreRimpiazzato);
                }
                keyword.delete(0, keyword.length());
                separator = false;
                continue;
            }
            if (separator) {
                keyword.append(ch);
                continue;
            }
            bf.append(ch);
        }
        return bf.toString();
    }

    public String getPrefixMsgPersonalizzati() {
        return this.prefixMsgPersonalizzati;
    }

    public void setPrefixMsgPersonalizzati(String v) {
        this.prefixMsgPersonalizzati = v;
    }

    public int getLivello(String keyLivelloPersonalizzato) {
        return this.getLivello(this.prefixMsgPersonalizzati, keyLivelloPersonalizzato);
    }

    public int getLivello(String prefix, String keyLivelloPersonalizzato) {
        if (this.msgDiagPropertiesReader == null) {
            return -1;
        }
        Integer livello = this.msgDiagPropertiesReader.getLivello(prefix, keyLivelloPersonalizzato);
        if (livello != null) {
            return livello;
        }
        return -1;
    }

    public String getCodice(String keyCodicePersonalizzato) {
        return this.getCodice(this.prefixMsgPersonalizzati, keyCodicePersonalizzato);
    }

    public String getCodice(String prefix, String keyCodicePersonalizzato) {
        if (this.msgDiagPropertiesReader == null) {
            return "PropertiesReader dei Messaggi Diagnostici non inizializzato";
        }
        return this.msgDiagPropertiesReader.getCodice(prefix, keyCodicePersonalizzato);
    }

    public String getMessaggio(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato, false);
    }

    public String getMessaggio(String prefix, String keyMsgPersonalizzato) {
        return this.getMessaggio(prefix, keyMsgPersonalizzato, false);
    }

    public String getMessaggio_replaceKeywords(String keyMsgPersonalizzato) {
        return this.getMessaggio(this.prefixMsgPersonalizzati, keyMsgPersonalizzato, true);
    }

    public String getMessaggio_replaceKeywords(String prefix, String keyMsgPersonalizzato) {
        return this.getMessaggio(prefix, keyMsgPersonalizzato, true);
    }

    private String getMessaggio(String prefix, String keyMsgPersonalizzato, boolean replaceKeywords) {
        if (this.msgDiagPropertiesReader == null) {
            return "PropertiesReader dei Messaggi Diagnostici non inizializzato";
        }
        String msgTmp = this.msgDiagPropertiesReader.getMessaggio(prefix, keyMsgPersonalizzato);
        if (msgTmp == null) {
            msgTmp = "Messaggio diagnostico [" + prefix + keyMsgPersonalizzato + "] non definito nella configurazione della porta di dominio??";
        }
        if (replaceKeywords) {
            String msgReplaceKey = this.replaceKeywords(msgTmp);
            return msgReplaceKey;
        }
        return msgTmp;
    }

    public void logCorrelazione() {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeverita_msgDiagnostici()) {
            try {
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        String[] key;
                        MsgDiagnosticoCorrelazione msgDiagCorrelazione = new MsgDiagnosticoCorrelazione();
                        msgDiagCorrelazione.setProtocollo(this.protocolFactory.getProtocol());
                        msgDiagCorrelazione.setIdBusta(this.idMessaggioRichiesta);
                        msgDiagCorrelazione.setIdSoggetto(this.idSoggettoDominio);
                        msgDiagCorrelazione.setGdo(gdo);
                        msgDiagCorrelazione.setNomePorta(this.porta);
                        msgDiagCorrelazione.setDelegata(this.delegata);
                        msgDiagCorrelazione.setProtocollo(this.protocolFactory.getProtocol());
                        if (this.fruitore != null || this.servizio != null) {
                            InformazioniProtocollo informazioniBusta = new InformazioniProtocollo();
                            informazioniBusta.setFruitore(this.fruitore);
                            if (this.servizio != null) {
                                informazioniBusta.setErogatore(this.servizio.getSoggettoErogatore());
                                informazioniBusta.setTipoServizio(this.servizio.getTipoServizio());
                                informazioniBusta.setServizio(this.servizio.getServizio());
                                informazioniBusta.setVersioneServizio(Integer.valueOf(Integer.parseInt(this.servizio.getVersioneServizio())));
                                informazioniBusta.setAzione(this.servizio.getAzione());
                            }
                            msgDiagCorrelazione.setInformazioniProtocollo(informazioniBusta);
                        }
                        msgDiagCorrelazione.setCorrelazioneApplicativa(this.idCorrelazioneApplicativa);
                        if (this.pddContext != null && (key = Costanti.CONTEXT_OBJECT) != null) {
                            for (int j = 0; j < key.length; ++j) {
                                Object o = this.pddContext.getObject(key[j]);
                                if (!(o instanceof String)) continue;
                                msgDiagCorrelazione.addProperty(key[j], (String)o);
                            }
                        }
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazione(this.getConnectionFromState(), msgDiagCorrelazione);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico di correlazione [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.logCorrelazione error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void logCorrelazioneServizioApplicativo() {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeverita_msgDiagnostici()) {
            try {
                MsgDiagnosticoCorrelazioneServizioApplicativo msg = new MsgDiagnosticoCorrelazioneServizioApplicativo();
                msg.setDelegata(this.delegata);
                msg.setIdBusta(this.idMessaggioRichiesta);
                msg.setServizioApplicativo(this.servizioApplicativo);
                msg.setProtocollo(this.protocolFactory.getProtocol());
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazioneServizioApplicativo(this.getConnectionFromState(), msg);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico di correlazione (servizi applicativi) [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.logCorrelazione error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void logCorrelazioneApplicativaRisposta() throws MsgDiagnosticoException {
        if (Integer.MIN_VALUE != this.configurazionePdDReader.getSeverita_msgDiagnostici()) {
            try {
                MsgDiagnosticoCorrelazioneApplicativa msg = new MsgDiagnosticoCorrelazioneApplicativa();
                msg.setIdBusta(this.idMessaggioRichiesta);
                msg.setProtocollo(this.protocolFactory.getProtocol());
                msg.setDelegata(this.delegata);
                msg.setCorrelazione(this.idCorrelazioneRisposta);
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).logCorrelazioneApplicativaRisposta(this.getConnectionFromState(), msg);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico di correlazione (id correlazione risposta) [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.logCorrelazioneApplicativaRisposta error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    private void setEmitErrorConditionInContext(int livelloLog) {
        if (this.pddContext != null && livelloLog <= 2 && !this.pddContext.containsKey("EMESSI_DIAGNOSTICI_ERRORE")) {
            this.pddContext.addObject("EMESSI_DIAGNOSTICI_ERRORE", "true");
        }
    }

    public void logPersonalizzato(String idModuloFunzionale, String idDiagnostico) {
        this.logPersonalizzato(this.getMessaggio(idModuloFunzionale, idDiagnostico), this.getLivello(idModuloFunzionale, idDiagnostico), this.getCodice(idModuloFunzionale, idDiagnostico));
    }

    public void logPersonalizzato(String idDiagnostico) {
        this.logPersonalizzato(this.getMessaggio(idDiagnostico), this.getLivello(idDiagnostico), this.getCodice(idDiagnostico));
    }

    public void logPersonalizzato(String messaggio, int livelloLog, String codiceDiagnostico) {
        if (this.msgDiagPropertiesReader == null) {
            this.logError("MsgDiagnostico.logPersonalizzato [Risorsa non inizializzata], messaggio originale: " + messaggio);
            return;
        }
        if (messaggio == null) {
            this.logError("MsgDiagnostico.logPersonalizzato error, messaggio non definito.");
            return;
        }
        int severitaLogEmessoPerFiltro = livelloLog;
        int severitaLivelloOpenSPCoop2 = LogLevels.toIntervalloOpenSPCoop2(livelloLog);
        if (severitaLivelloOpenSPCoop2 < 0 || severitaLivelloOpenSPCoop2 > 7) {
            this.logError("MsgDiagnostico.logPersonalizzato error, conversione a livello OpenSPCoop non riuscita [" + severitaLivelloOpenSPCoop2 + "]");
            return;
        }
        this.setEmitErrorConditionInContext(severitaLivelloOpenSPCoop2);
        Level logLevelseveritaLivelloLog4J = LogLevels.toLog4J(severitaLivelloOpenSPCoop2);
        int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
        int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
        if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
            severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
        }
        try {
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
            }
            String msgReplaceKey = null;
            org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
            if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                msgReplaceKey = this.replaceKeywords(messaggio);
                msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloOpenSPCoop2, msgReplaceKey, codiceDiagnostico);
                if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                    try {
                        String xml = this.diagnosticoBuilder.toString(msgDiag);
                        this.loggerMsgDiagnostico.log((Priority)logLevelseveritaLivelloLog4J, (Object)xml);
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                if (msgReplaceKey == null) {
                    msgReplaceKey = this.replaceKeywords(messaggio);
                    msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloOpenSPCoop2, msgReplaceKey, codiceDiagnostico);
                }
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            boolean humanReadableAbilitato = false;
            humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
            if (humanReadableAbilitato && severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                if (msgReplaceKey == null) {
                    msgReplaceKey = this.replaceKeywords(messaggio);
                    msgDiag = this.getMsgDiagnostico(gdo, severitaLivelloOpenSPCoop2, msgReplaceKey, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)logLevelseveritaLivelloLog4J, (Object)message);
                    } else {
                        this.loggerOpenSPCoop2.log((Priority)logLevelseveritaLivelloLog4J, (Object)message);
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            if (msgReplaceKey != null && severitaLivelloOpenSPCoop2 == 0) {
                this.loggerOpenSPCoop2Fatal.log((Priority)LogLevels.LOG_LEVEL_FATAL, (Object)msgReplaceKey);
            }
        }
        catch (Exception e) {
            this.logError("MsgDiagnostico.logPersonalizzato error " + e.getMessage(), e);
            this.gestioneErroreDiagnostica(e);
        }
    }

    public void logErroreGenerico(Throwable e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logErroreGenerico(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error((Object)(posizioneErrore + ": " + msg), e);
        }
    }

    public void logErroreGenerico(Exception e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logErroreGenerico(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error((Object)(posizioneErrore + ": " + msg), (Throwable)e);
        }
    }

    public void logErroreGenerico(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("all.", "erroreGenerico");
    }

    public void logFatalError(Exception e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logFatalError(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.fatal((Object)(posizioneErrore + ": " + msg), (Throwable)e);
        }
    }

    public void logFatalError(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("all.", "erroreGenericoMalfunzionamentoPdD");
    }

    public void logStartupError(Exception e, String posizioneErrore) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logStartupError(msg, posizioneErrore);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.fatal((Object)(posizioneErrore + ": " + msg), (Throwable)e);
        }
    }

    public void logStartupError(String message, String posizioneErrore) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", posizioneErrore);
        this.logPersonalizzato("openspcoopStartup.", "erroreGenerico");
    }

    public void logDisconnectError(Exception e, String url) {
        String msg = null;
        msg = e instanceof NullPointerException ? "NullPointerException" : e.getMessage();
        this.logDisconnectError(msg, url);
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error((Object)(url + ": " + msg), (Throwable)e);
        }
    }

    public void logDisconnectError(String message, String url) {
        this.addKeyword("@ERRORE_PROCESSAMENTO@", message);
        this.addKeyword("@POSIZIONE_ERRORE@", url);
        this.logPersonalizzato("all.", "connessioneUscita.disconnectError");
    }

    @Deprecated
    public void fatal(String msg) {
        String codiceDiagnostico = null;
        this.setEmitErrorConditionInContext(0);
        int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(0);
        int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
        int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
        if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
            severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
            severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
        }
        try {
            codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoFatal();
            Date gdo = DateManager.getDate();
            if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
            }
            org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
            if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                }
                if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                    try {
                        String xml = this.diagnosticoBuilder.toString(msgDiag);
                        this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_FATAL, (Object)xml);
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                }
                for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                    try {
                        this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                        this.gestioneErroreDiagnostica(e);
                    }
                }
            }
            boolean humanReadableAbilitato = false;
            humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
            if (humanReadableAbilitato && severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 0, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_FATAL, (Object)message);
                    } else {
                        this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_FATAL, (Object)message);
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            this.loggerOpenSPCoop2Fatal.log((Priority)LogLevels.LOG_LEVEL_FATAL, (Object)msg);
        }
        catch (Exception e) {
            this.logError("MsgDiagnostico.fatalOpenSPCoop error " + e.getMessage(), e);
            this.gestioneErroreDiagnostica(e);
        }
    }

    @Deprecated
    public void errorProtocol(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(1);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(1);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoErrorProtocol();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_ERROR_PROTOCOL, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 1, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_ERROR_PROTOCOL, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_ERROR_PROTOCOL, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.errorProtocol error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void errorIntegration(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(2);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(2);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoErrorIntegration();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_ERROR_INTEGRATION, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 2, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_ERROR_INTEGRATION, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_ERROR_INTEGRATION, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.errorIntegration error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void infoProtocol(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(3);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(3);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoInfoProtocol();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_INFO_PROTOCOL, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 3, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_INFO_PROTOCOL, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_INFO_PROTOCOL, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.infoProtocol error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void infoIntegration(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(4);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(4);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoInfoIntegration();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_INFO_INTEGRATION, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 4, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_INFO_INTEGRATION, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_INFO_INTEGRATION, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.infoIntegration error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    @Deprecated
    public void lowDebug(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(5);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(5);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoDebugLow();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 5, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_DEBUG_LOW, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.lowDebug error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void mediumDebug(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(6);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(6);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoDebugMedium();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 6, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_DEBUG_MEDIUM, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.mediumDebug error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    public void highDebug(String msg) {
        block18: {
            String codiceDiagnostico = null;
            this.setEmitErrorConditionInContext(7);
            int severitaLogEmessoPerFiltro = LogLevels.toIntervalloLog4J(7);
            int severitaRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            int severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getFiltroMsgDiagnostico_OpenSPCoop2_7();
            if (this.configurazionePdDReader != null && this.configurazionePdDReader.isInitializedConfigurazionePdDReader()) {
                severitaRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeverita_msgDiagnostici());
                severitaLog4JRichiestaPdD = this.msgDiagPropertiesReader.getValoreFiltroFromValoreOpenSPCoop2(this.configurazionePdDReader.getSeveritaLog4J_msgDiagnostici());
            }
            try {
                codiceDiagnostico = this.msgDiagPropertiesReader.getCodiceDiagnosticoDebugHigh();
                Date gdo = DateManager.getDate();
                if (this.openspcoopProperties.generazioneDateCasualiLogAbilitato() && this.pddContext != null && this.pddContext.getObject("ID") != null) {
                    gdo = this.generatoreDateCasuali.getProssimaData((String)this.pddContext.getObject("ID"));
                }
                org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiag = null;
                if (severitaLogEmessoPerFiltro <= severitaLog4JRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                    }
                    if (OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato) {
                        try {
                            String xml = this.diagnosticoBuilder.toString(msgDiag);
                            this.loggerMsgDiagnostico.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)xml);
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico su log4j (struttura xml): " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                if (severitaLogEmessoPerFiltro <= severitaRichiestaPdD) {
                    if (msgDiag == null) {
                        msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                    }
                    for (int i = 0; i < this.loggerMsgDiagnosticoOpenSPCoopAppender.size(); ++i) {
                        try {
                            this.loggerMsgDiagnosticoOpenSPCoopAppender.get(i).log(this.getConnectionFromState(), msgDiag);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante l'emissione del msg diagnostico personalizzato [" + this.tipoMsgDiagnosticoOpenSPCoopAppender.get(i) + "]: " + e.getMessage(), e);
                            this.gestioneErroreDiagnostica(e);
                        }
                    }
                }
                boolean humanReadableAbilitato = false;
                humanReadableAbilitato = IntegrationManager.ID_MODULO.equals(this.idModulo) ? OpenSPCoop2Logger.loggerIntegrationManagerAbilitato : OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
                if (!humanReadableAbilitato || severitaLogEmessoPerFiltro > severitaLog4JRichiestaPdD) break block18;
                if (msgDiag == null) {
                    msgDiag = this.getMsgDiagnostico(gdo, 7, msg, codiceDiagnostico);
                }
                String message = OpenSPCoop2Logger.humanReadable(msgDiag, this.idCorrelazioneApplicativa, this.idCorrelazioneRisposta, this.porta, this.delegata, this.fruitore, this.servizio, this.servizioApplicativo, this.protocolFactory);
                try {
                    if (IntegrationManager.ID_MODULO.equals(this.idModulo)) {
                        this.loggerIntegrationManager.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)message);
                        break block18;
                    }
                    this.loggerOpenSPCoop2.log((Priority)LogLevels.LOG_LEVEL_DEBUG_HIGH, (Object)message);
                }
                catch (Exception e) {
                    this.logError("Errore durante l'emissione del msg diagnostico 'human readable': " + e.getMessage(), e);
                    this.gestioneErroreDiagnostica(e);
                }
            }
            catch (Exception e) {
                this.logError("MsgDiagnostico.highDebug error " + e.getMessage(), e);
                this.gestioneErroreDiagnostica(e);
            }
        }
    }

    private org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico getMsgDiagnostico(Date gdo, int severitaLivelloOpenSPCoop2, String msg, String codiceDiagnostico) {
        String[] key;
        org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico msgDiagnostico = new org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico();
        msgDiagnostico.setGdo(gdo);
        msgDiagnostico.setIdSoggetto(this.idSoggettoDominio);
        msgDiagnostico.setIdFunzione(this.idModulo);
        msgDiagnostico.setSeverita(severitaLivelloOpenSPCoop2);
        msgDiagnostico.setMessaggio(msg);
        msgDiagnostico.setIdBusta(this.idMessaggioRichiesta);
        msgDiagnostico.setIdBustaRisposta(this.idMessaggioRisposta);
        msgDiagnostico.setCodice(codiceDiagnostico);
        msgDiagnostico.setProtocollo(this.protocolFactory.getProtocol());
        if (this.pddContext != null && (key = Costanti.CONTEXT_OBJECT) != null) {
            for (int j = 0; j < key.length; ++j) {
                Object o = this.pddContext.getObject(key[j]);
                if (o == null || !(o instanceof String)) continue;
                msgDiagnostico.addProperty(key[j], (String)o);
            }
        }
        if (this.properties != null) {
            Enumeration<String> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key2 = keys.nextElement();
                msgDiagnostico.addProperty(key2, this.properties.get(key2));
            }
        }
        return msgDiagnostico;
    }

    private void gestioneErroreDiagnostica(Exception e) {
        if (this.openspcoopProperties.isRegistrazioneDiagnosticaFallita_BloccoServiziPdD()) {
            gestoreDiagnosticaDisponibile = false;
            motivoMalfunzionamentoDiagnostici = e;
            this.logError("Il Sistema di gestione della diagnostica ha rilevato un errore durante la registrazione di un messaggio diagnostico, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio della Porta di Dominio. Errore rilevato: ", e);
        }
    }

    private void logError(String msgErrore, Exception e) {
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error((Object)msgErrore, (Throwable)e);
        } else if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error((Object)msgErrore, (Throwable)e);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)msgErrore, (Throwable)e);
        }
    }

    private void logError(String msgErrore) {
        if (this.loggerOpenSPCoop2Core != null) {
            this.loggerOpenSPCoop2Core.error((Object)msgErrore);
        } else if (OpenSPCoop2Logger.loggerOpenSPCoopCore != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopCore.error((Object)msgErrore);
        }
        if (OpenSPCoop2Logger.loggerOpenSPCoopResources != null) {
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)msgErrore);
        }
    }
}

