/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoMessaggio;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.AttachmentsUtils;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreUscita;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.dump.IDumpOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.dump.Messaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.date.DateManager;

public class Dump {
    public static boolean sistemaDumpDisponibile = true;
    public static Exception motivoMalfunzionamentoDump = null;
    private Logger loggerDump = null;
    private IDSoggetto dominio;
    private String idModulo;
    private String idMessaggio;
    private IDSoggetto fruitore;
    private IDServizio servizio;
    private String signature;
    private Date gdo;
    private TipoPdD tipoPdD;
    private PdDContext pddContext;
    private OpenSPCoop2Properties properties = null;
    private MsgDiagnostico msgDiagErroreDump = null;
    private Vector<IDumpOpenSPCoopAppender> loggerDumpOpenSPCoopAppender = null;
    private Vector<String> tipoDumpOpenSPCoopAppender = null;
    private IProtocolFactory protocolFactory = null;
    private IState statoRichiesta;
    private IState statoRisposta;

    public Dump(IDSoggetto dominio, String modulo, TipoPdD tipoPdD, PdDContext pddContext, IState statoRichiesta, IState statoRisposta) throws TracciamentoException {
        this(dominio, modulo, null, null, null, tipoPdD, pddContext, statoRichiesta, statoRisposta);
    }

    public Dump(IDSoggetto dominio, String modulo, String idMessaggio, IDSoggetto fruitore, IDServizio servizio, TipoPdD tipoPdD, PdDContext pddContext, IState statoRichiesta, IState statoRisposta) throws TracciamentoException {
        this.dominio = dominio;
        this.idModulo = modulo;
        this.idMessaggio = idMessaggio;
        this.fruitore = fruitore;
        this.servizio = servizio;
        this.loggerDump = OpenSPCoop2Logger.loggerDump;
        this.loggerDumpOpenSPCoopAppender = OpenSPCoop2Logger.loggerDumpOpenSPCoopAppender;
        this.tipoDumpOpenSPCoopAppender = OpenSPCoop2Logger.tipoDumpOpenSPCoopAppender;
        this.gdo = DateManager.getDate();
        this.signature = this.dominio != null ? this.dominio.getCodicePorta() + " <" + this.gdo + "> " + this.idModulo + "\n" : "<" + this.gdo + "> " + this.idModulo + "\n";
        this.tipoPdD = tipoPdD;
        this.pddContext = pddContext;
        this.properties = OpenSPCoop2Properties.getInstance();
        this.statoRichiesta = statoRichiesta;
        this.statoRisposta = statoRisposta;
        this.msgDiagErroreDump = new MsgDiagnostico(dominio, modulo, this.statoRichiesta, this.statoRisposta);
        this.msgDiagErroreDump.setPrefixMsgPersonalizzati("tracciamento.");
        String protocol = null;
        try {
            this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            protocol = this.protocolFactory.getProtocol();
            this.msgDiagErroreDump.setPddContext(pddContext, this.protocolFactory);
        }
        catch (Exception e) {
            throw new TracciamentoException("Errore durante l'inizializzazione del ProtocolFactoryManager...", (Throwable)e);
        }
        if (this.dominio == null) {
            this.dominio = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocol);
        }
    }

    @Deprecated
    public void dumpRichiestaMessage(byte[] msg) throws TracciamentoException {
        try {
            this.loggerDump.info((Object)(this.signature + "Messaggio di richiesta con identificativo [" + this.idMessaggio + "]:\n" + new String(msg)));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idMessaggio + "]:" + e));
            this.gestioneErroreDump(e);
        }
    }

    @Deprecated
    public void dumpRichiestaMessage(OpenSPCoop2Message msg) throws TracciamentoException {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream, false);
            this.loggerDump.info((Object)(this.signature + "Messaggio di richiesta con identificativo [" + this.idMessaggio + "]:\n" + stream.toString()));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idMessaggio + "]:" + e));
            this.gestioneErroreDump(e);
        }
    }

    public void dumpRichiestaIngresso(byte[] msg, InfoConnettoreIngresso infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_INGRESSO, null, msg, infoConnettore.getFromLocation(), infoConnettore.getUrlProtocolContext().getParametersTrasporto());
    }

    public void dumpRichiestaIngresso(OpenSPCoop2Message msg, InfoConnettoreIngresso infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_INGRESSO, msg, null, infoConnettore.getFromLocation(), infoConnettore.getUrlProtocolContext().getParametersTrasporto());
    }

    public void dumpRichiestaUscita(byte[] msg, InfoConnettoreUscita infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_USCITA, null, msg, infoConnettore.getLocation(), infoConnettore.getPropertiesTrasporto());
    }

    public void dumpRichiestaUscita(OpenSPCoop2Message msg, InfoConnettoreUscita infoConnettore) throws TracciamentoException {
        this.dump(TipoMessaggio.RICHIESTA_USCITA, msg, null, infoConnettore.getLocation(), infoConnettore.getPropertiesTrasporto());
    }

    @Deprecated
    public void dumpRispostaMessage(byte[] msg) {
        try {
            this.loggerDump.info((Object)(this.signature + "Messaggio di risposta relativa alla richiesta con identificativo [" + this.idMessaggio + "]:\n" + new String(msg)));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idMessaggio + "]:" + e));
        }
    }

    @Deprecated
    public void dumpRispostaMessage(OpenSPCoop2Message msg) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)stream, false);
            this.loggerDump.info((Object)(this.signature + "Messaggio di risposta relativa alla richiesta con identificativo [" + this.idMessaggio + "]:\n" + stream.toString()));
        }
        catch (Exception e) {
            this.loggerDump.error((Object)("Riscontrato errore durante il dump del messaggio con identificativo [" + this.idMessaggio + "]:" + e));
        }
    }

    public void dumpRispostaIngresso(byte[] msg, InfoConnettoreUscita infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_INGRESSO, null, msg, infoConnettore.getLocation(), transportHeaderRisposta);
    }

    public void dumpRispostaIngresso(OpenSPCoop2Message msg, InfoConnettoreUscita infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_INGRESSO, msg, null, infoConnettore.getLocation(), transportHeaderRisposta);
    }

    public void dumpRispostaUscita(byte[] msg, InfoConnettoreIngresso infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_USCITA, null, msg, infoConnettore.getFromLocation(), transportHeaderRisposta);
    }

    public void dumpRispostaUscita(OpenSPCoop2Message msg, InfoConnettoreIngresso infoConnettore, Properties transportHeaderRisposta) throws TracciamentoException {
        this.dump(TipoMessaggio.RISPOSTA_USCITA, msg, null, infoConnettore.getFromLocation(), transportHeaderRisposta);
    }

    public void dumpIntegrationManagerGetMessage(OpenSPCoop2Message msg) throws TracciamentoException {
        this.dump(TipoMessaggio.INTEGRATION_MANAGER, msg, null, null, null);
    }

    private void dump(TipoMessaggio tipoMessaggio, OpenSPCoop2Message msg, byte[] msgBytes, String location, Properties transportHeader) throws TracciamentoException {
        String[] key;
        if (OpenSPCoop2Logger.loggerDumpAbilitato) {
            try {
                StringBuffer out = new StringBuffer();
                out.append(this.signature);
                out.append("TipoMessaggio:" + tipoMessaggio.getTipo());
                if (this.idMessaggio != null) {
                    out.append(" idMessaggio:");
                    out.append(this.idMessaggio);
                }
                if (location != null) {
                    if (TipoMessaggio.RICHIESTA_INGRESSO.equals(tipoMessaggio) || TipoMessaggio.RISPOSTA_USCITA.equals(tipoMessaggio)) {
                        out.append(" source:");
                    } else {
                        out.append(" location:");
                    }
                    out.append(location);
                }
                if (this.fruitore != null) {
                    out.append(" FR:");
                    out.append(this.fruitore.toString());
                }
                if (this.fruitore != null && this.servizio != null) {
                    out.append(" -> ");
                }
                if (this.servizio != null) {
                    if (this.servizio.getServizio() != null && this.servizio.getTipoServizio() != null && this.servizio.getSoggettoErogatore() != null) {
                        out.append(" S:");
                        out.append(this.servizio.toString());
                    } else if (this.servizio.getSoggettoErogatore() != null) {
                        out.append(" ER:");
                        out.append(this.servizio.getSoggettoErogatore().toString());
                    }
                }
                out.append(" \n");
                if (transportHeader != null && transportHeader.size() > 0) {
                    Enumeration<Object> keys = transportHeader.keys();
                    out.append("------ Header di trasporto ------\n");
                    while (keys.hasMoreElements()) {
                        key = (String[])keys.nextElement();
                        String value = transportHeader.getProperty((String)key);
                        if (value instanceof String) {
                            out.append((String)key + "=" + value + "\n");
                            continue;
                        }
                        out.append((String)key + "=ObjectType(" + value.getClass().getName() + ")\n");
                    }
                }
                if (msg != null) {
                    out.append(MessageUtils.dumpMessage((OpenSPCoop2Message)msg, (boolean)this.properties.isDumpAllAttachments()));
                } else {
                    if (AttachmentsUtils.messageWithAttachment((byte[])msgBytes)) {
                        out.append("------ SOAPWithAttachments ------\n");
                    } else {
                        out.append("------ SOAPEnvelope ------\n");
                    }
                    out.append(new String(msgBytes));
                }
                this.loggerDump.info((Object)out.toString());
            }
            catch (Exception e) {
                try {
                    this.loggerDump.error((Object)("Riscontrato errore durante il dump del contenuto applicativo presente nel messaggio (" + tipoMessaggio.getTipo() + ") con identificativo [" + this.idMessaggio + "]:" + e.getMessage()));
                }
                catch (Exception eLog) {
                    // empty catch block
                }
                OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)("Errore durante il dump del contenuto applicativo presente nel messaggio (" + tipoMessaggio.getTipo() + ") con identificativo [" + this.idMessaggio + "]: " + e.getMessage()), (Throwable)e);
                try {
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getTipo());
                    this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.registrazioneNonRiuscita");
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
                this.gestioneErroreDump(e);
            }
        }
        for (int i = 0; i < this.loggerDumpOpenSPCoopAppender.size(); ++i) {
            try {
                Messaggio messaggioDump = new Messaggio();
                messaggioDump.setGdo(this.gdo);
                messaggioDump.setIdBusta(this.idMessaggio);
                messaggioDump.setIdPorta(this.dominio);
                messaggioDump.setIdFunzione(this.idModulo);
                messaggioDump.setFruitore(this.fruitore);
                messaggioDump.setServizio(this.servizio);
                messaggioDump.setMsg(msg);
                messaggioDump.setLocation(location);
                messaggioDump.setTransportHeader(transportHeader);
                messaggioDump.setTipoPdD(this.tipoPdD);
                messaggioDump.setProtocollo(this.protocolFactory.getProtocol());
                messaggioDump.setTipoMessaggio(tipoMessaggio);
                if (this.pddContext != null && (key = Costanti.CONTEXT_OBJECT) != null) {
                    for (int j = 0; j < key.length; ++j) {
                        Object o = this.pddContext.getObject(key[j]);
                        if (o == null || !(o instanceof String)) continue;
                        messaggioDump.addProperty(key[j], (String)o);
                    }
                }
                this.loggerDumpOpenSPCoopAppender.get(i).dump(messaggioDump);
                continue;
            }
            catch (Exception e) {
                OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)("Errore durante il dump personalizzato [" + this.tipoDumpOpenSPCoopAppender.get(i) + "] del contenuto applicativo presente nel messaggio (" + tipoMessaggio.getTipo() + ") con identificativo [" + this.idMessaggio + "]: " + e.getMessage()), (Throwable)e);
                try {
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIA@", tipoMessaggio.getTipo());
                    this.msgDiagErroreDump.addKeyword("@ERRORE_TRACCIAMENTO@", e.getMessage());
                    this.msgDiagErroreDump.addKeyword("@TIPO_TRACCIAMENTO_PERSONALIZZATO@", this.tipoDumpOpenSPCoopAppender.get(i));
                    this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.registrazioneNonRiuscita.openspcoopAppender");
                }
                catch (Exception eMsg) {
                    // empty catch block
                }
                this.gestioneErroreDump(e);
            }
        }
    }

    private void gestioneErroreDump(Exception e) throws TracciamentoException {
        if (this.properties.isDumpFallito_BloccoServiziPdD()) {
            sistemaDumpDisponibile = false;
            motivoMalfunzionamentoDump = e;
            try {
                this.msgDiagErroreDump.logPersonalizzato("dumpContenutiApplicativi.errore.bloccoServizi");
            }
            catch (Exception exception) {
                // empty catch block
            }
            OpenSPCoop2Logger.loggerOpenSPCoopResources.error((Object)"Il Sistema di dump dei contenuti applicativi ha rilevato un errore durante la registrazione di un contenuto applicativo, tutti i servizi/moduli della porta di dominio sono sospesi. Si richiede un intervento sistemistico per la risoluzione del problema e il riavvio della Porta di Dominio. Errore rilevato: ", (Throwable)e);
        }
        if (this.properties.isDumpFallito_BloccaCooperazioneInCorso()) {
            throw new TracciamentoException((Throwable)e);
        }
    }
}

