/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.pdd.core.StatoServiziPdD;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class StatoServiziJMXResource
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String COMPONENTE_PD = "Servizio PortaDelegata";
    public static final String COMPONENTE_PD_ABILITAZIONI = "Servizio PortaDelegata (Abilitazioni Puntuali)";
    public static final String COMPONENTE_PD_DISABILITAZIONI = "Servizio PortaDelegata (Disabilitazioni Puntuali)";
    public static final String COMPONENTE_PA = "Servizio PortaApplicativa";
    public static final String COMPONENTE_PA_ABILITAZIONI = "Servizio PortaApplicativa (Abilitazioni Puntuali)";
    public static final String COMPONENTE_PA_DISABILITAZIONI = "Servizio PortaApplicativa (Disabilitazioni Puntuali)";
    public static final String COMPONENTE_IM = "Servizio IntegrationManager";
    public static final String ABILITA_COMPONENTE_PD = "abilitaServizioPortaDelegata";
    public static final String ABILITA_COMPONENTE_PA = "abilitaServizioPortaApplicativa";
    public static final String ABILITA_COMPONENTE_IM = "abilitaServizioIntegrationManager";
    public static final String ABILITA_SERVIZI = "abilitazioneCompletaServizi";
    public static final String DISABILITA_COMPONENTE_PD = "disabilitaServizioPortaDelegata";
    public static final String DISABILITA_COMPONENTE_PA = "disabilitaServizioPortaApplicativa";
    public static final String DISABILITA_COMPONENTE_IM = "disabilitaServizioIntegrationManager";
    public static final String DISABILITA_SERVIZI = "disabilitazioneCompletaServizi";
    public static final String ABILITA_ADD_FILTRO_ABILITAZIONE_PD = "addFiltroAbilitazioneServizioPortaDelegata";
    public static final String ABILITA_ADD_FILTRO_DISABILITAZIONE_PD = "addFiltroDisabilitazioneServizioPortaDelegata";
    public static final String ABILITA_ADD_FILTRO_ABILITAZIONE_PA = "addFiltroAbilitazioneServizioPortaApplicativa";
    public static final String ABILITA_ADD_FILTRO_DISABILITAZIONE_PA = "addFiltroDisabilitazioneServizioPortaApplicativa";
    public static final String ABILITA_REMOVE_FILTRO_ABILITAZIONE_PD = "removeFiltroAbilitazioneServizioPortaDelegata";
    public static final String ABILITA_REMOVE_FILTRO_DISABILITAZIONE_PD = "removeFiltroDisabilitazioneServizioPortaDelegata";
    public static final String ABILITA_REMOVE_FILTRO_ABILITAZIONE_PA = "removeFiltroAbilitazioneServizioPortaApplicativa";
    public static final String ABILITA_REMOVE_FILTRO_DISABILITAZIONE_PA = "removeFiltroDisabilitazioneServizioPortaApplicativa";
    private StatoFunzionalita componentePD = CostantiConfigurazione.ABILITATO;
    private String componentePD_abilitazioniPuntuali = "";
    private String componentePD_disabilitazioniPuntuali = "";
    private StatoFunzionalita componentePA = CostantiConfigurazione.ABILITATO;
    private String componentePA_abilitazioniPuntuali = "";
    private String componentePA_disabilitazioniPuntuali = "";
    private StatoFunzionalita componenteIM = CostantiConfigurazione.ABILITATO;

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(COMPONENTE_PD)) {
            return this.componentePD;
        }
        if (attributeName.equals(COMPONENTE_PD_ABILITAZIONI)) {
            return this.componentePD_abilitazioniPuntuali;
        }
        if (attributeName.equals(COMPONENTE_PD_DISABILITAZIONI)) {
            return this.componentePD_disabilitazioniPuntuali;
        }
        if (attributeName.equals(COMPONENTE_PA)) {
            return this.componentePA;
        }
        if (attributeName.equals(COMPONENTE_PA_ABILITAZIONI)) {
            return this.componentePA_abilitazioniPuntuali;
        }
        if (attributeName.equals(COMPONENTE_PA_DISABILITAZIONI)) {
            return this.componentePA_disabilitazioniPuntuali;
        }
        if (attributeName.equals(COMPONENTE_IM)) {
            return this.componenteIM;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
        }
        try {
            if (attribute.getName().equals(COMPONENTE_PD)) {
                String v = (String)attribute.getValue();
                if (CostantiConfigurazione.ABILITATO.equals(v)) {
                    this.abilitaServizioPortaDelegata();
                } else {
                    this.disabilitaServizioPortaDelegata();
                }
            } else if (attribute.getName().equals(COMPONENTE_PA)) {
                String v = (String)attribute.getValue();
                if (CostantiConfigurazione.ABILITATO.equals(v)) {
                    this.abilitaServizioPortaApplicativa();
                } else {
                    this.disabilitaServizioPortaApplicativa();
                }
            } else if (attribute.getName().equals(COMPONENTE_IM)) {
                String v = (String)attribute.getValue();
                if (CostantiConfigurazione.ABILITATO.equals(v)) {
                    this.abilitaServizioIntegrationManager();
                } else {
                    this.disabilitaServizioIntegrationManager();
                }
            } else if (!(attribute.getName().equals(COMPONENTE_PD_ABILITAZIONI) || attribute.getName().equals(COMPONENTE_PD_DISABILITAZIONI) || attribute.getName().equals(COMPONENTE_PA_ABILITAZIONI) || attribute.getName().equals(COMPONENTE_PA_DISABILITAZIONI))) {
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
        }
        catch (ClassCastException ce) {
            throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
        }
        catch (JMException j) {
            throw new MBeanException(j);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(ABILITA_COMPONENTE_PD)) {
            return this.abilitaServizioPortaDelegata();
        }
        if (actionName.equals(ABILITA_COMPONENTE_PA)) {
            return this.abilitaServizioPortaApplicativa();
        }
        if (actionName.equals(ABILITA_COMPONENTE_IM)) {
            return this.abilitaServizioIntegrationManager();
        }
        if (actionName.equals(ABILITA_SERVIZI)) {
            return this.abilitazioneCompletaServizi();
        }
        if (actionName.equals(DISABILITA_COMPONENTE_PD)) {
            return this.disabilitaServizioPortaDelegata();
        }
        if (actionName.equals(DISABILITA_COMPONENTE_PA)) {
            return this.disabilitaServizioPortaApplicativa();
        }
        if (actionName.equals(DISABILITA_COMPONENTE_IM)) {
            return this.disabilitaServizioIntegrationManager();
        }
        if (actionName.equals(DISABILITA_SERVIZI)) {
            return this.disabilitazioneCompletaServizi();
        }
        if (actionName.equals(ABILITA_ADD_FILTRO_ABILITAZIONE_PD)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[addFiltroAbilitazioneServizioPortaDelegata] Lunghezza parametri non corretta: " + params.length));
            }
            return this.addFiltroAbilitazioneServizioPortaDelegata(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_ADD_FILTRO_DISABILITAZIONE_PD)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[addFiltroDisabilitazioneServizioPortaDelegata] Lunghezza parametri non corretta: " + params.length));
            }
            return this.addFiltroDisabilitazioneServizioPortaDelegata(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_REMOVE_FILTRO_ABILITAZIONE_PD)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[removeFiltroAbilitazioneServizioPortaDelegata] Lunghezza parametri non corretta: " + params.length));
            }
            return this.removeFiltroAbilitazioneServizioPortaDelegata(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_REMOVE_FILTRO_DISABILITAZIONE_PD)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[removeFiltroDisabilitazioneServizioPortaDelegata] Lunghezza parametri non corretta: " + params.length));
            }
            return this.removeFiltroDisabilitazioneServizioPortaDelegata(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_ADD_FILTRO_ABILITAZIONE_PA)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[addFiltroAbilitazioneServizioPortaApplicativa] Lunghezza parametri non corretta: " + params.length));
            }
            return this.addFiltroAbilitazioneServizioPortaApplicativa(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_ADD_FILTRO_DISABILITAZIONE_PA)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[addFiltroDisabilitazioneServizioPortaApplicativa] Lunghezza parametri non corretta: " + params.length));
            }
            return this.addFiltroDisabilitazioneServizioPortaApplicativa(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_REMOVE_FILTRO_ABILITAZIONE_PA)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[removeFiltroAbilitazioneServizioPortaApplicativa] Lunghezza parametri non corretta: " + params.length));
            }
            return this.removeFiltroAbilitazioneServizioPortaApplicativa(this.getTipoFiltroAbilitazioneServizi(params));
        }
        if (actionName.equals(ABILITA_REMOVE_FILTRO_DISABILITAZIONE_PA)) {
            if (params.length != 9) {
                throw new MBeanException(new Exception("[removeFiltroDisabilitazioneServizioPortaApplicativa] Lunghezza parametri non corretta: " + params.length));
            }
            return this.removeFiltroDisabilitazioneServizioPortaApplicativa(this.getTipoFiltroAbilitazioneServizi(params));
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    private TipoFiltroAbilitazioneServizi getTipoFiltroAbilitazioneServizi(Object[] params) {
        TipoFiltroAbilitazioneServizi tipo = new TipoFiltroAbilitazioneServizi();
        int index = 0;
        String tmp = (String)params[index];
        if (tmp != null && !"".equals(tmp)) {
            tipo.setTipoSoggettoFruitore(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setSoggettoFruitore(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setIdentificativoPortaFruitore(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setTipoSoggettoErogatore(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setSoggettoErogatore(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setIdentificativoPortaErogatore(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setTipoServizio(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setServizio(tmp);
        }
        if ((tmp = (String)params[++index]) != null && !"".equals(tmp)) {
            tipo.setAzione(tmp);
        }
        return tipo;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Stato dei servizi attivi sulla Porta di Dominio";
        MBeanAttributeInfo componentePD_VAR = new MBeanAttributeInfo(COMPONENTE_PD, String.class.getName(), "Indicazione se e' il servizio PortaDelegata risulta abilitato", true, true, false);
        MBeanAttributeInfo componentePD_abilitazioni_VAR = new MBeanAttributeInfo(COMPONENTE_PD_ABILITAZIONI, String.class.getName(), "Filtri puntuali che abilitano l'utilizzo del servizio PortaDelegata", true, false, false);
        MBeanAttributeInfo componentePD_disabilitazioni_VAR = new MBeanAttributeInfo(COMPONENTE_PD_DISABILITAZIONI, String.class.getName(), "Filtri puntuali che disabilitano l'utilizzo del servizio PortaDelegata", true, false, false);
        MBeanAttributeInfo componentePA_VAR = new MBeanAttributeInfo(COMPONENTE_PA, String.class.getName(), "Indicazione se e' il servizio PortaApplicativa risulta abilitato", true, true, false);
        MBeanAttributeInfo componentePA_abilitazioni_VAR = new MBeanAttributeInfo(COMPONENTE_PA_ABILITAZIONI, String.class.getName(), "Filtri puntuali che abilitano l'utilizzo del servizio PortaApplicativa", true, false, false);
        MBeanAttributeInfo componentePA_disabilitazioni_VAR = new MBeanAttributeInfo(COMPONENTE_PA_DISABILITAZIONI, String.class.getName(), "Filtri puntuali che disabilitano l'utilizzo del servizio PortaApplicativa", true, false, false);
        MBeanAttributeInfo componenteIM_VAR = new MBeanAttributeInfo(COMPONENTE_IM, String.class.getName(), "Indicazione se e' il servizio IntegrationManager risulta abilitato", true, true, false);
        MBeanOperationInfo abilitaPD_OP = new MBeanOperationInfo(ABILITA_COMPONENTE_PD, "Abilita il servizio PortaDelegata", null, String.class.getName(), 1);
        MBeanOperationInfo abilitaPA_OP = new MBeanOperationInfo(ABILITA_COMPONENTE_PA, "Abilita il servizio PortaApplicativa", null, String.class.getName(), 1);
        MBeanOperationInfo abilitaIM_OP = new MBeanOperationInfo(ABILITA_COMPONENTE_IM, "Abilita il servizio IntegrationManager", null, String.class.getName(), 1);
        MBeanOperationInfo abilitazioneCompleta_OP = new MBeanOperationInfo(ABILITA_SERVIZI, "Abilitazione completa di tutti i servizi della Porta di Dominio", null, String.class.getName(), 1);
        MBeanOperationInfo disabilitaPD_OP = new MBeanOperationInfo(DISABILITA_COMPONENTE_PD, "Disabilita il servizio PortaDelegata", null, String.class.getName(), 1);
        MBeanOperationInfo disabilitaPA_OP = new MBeanOperationInfo(DISABILITA_COMPONENTE_PA, "Disabilita il servizio PortaApplicativa", null, String.class.getName(), 1);
        MBeanOperationInfo disabilitaIM_OP = new MBeanOperationInfo(DISABILITA_COMPONENTE_IM, "Disabilita il servizio IntegrationManager", null, String.class.getName(), 1);
        MBeanOperationInfo disabilitazioneCompleta_OP = new MBeanOperationInfo(DISABILITA_SERVIZI, "Disabilitazione completa di tutti i servizi della Porta di Dominio", null, String.class.getName(), 1);
        MBeanOperationInfo componentePD_addFiltroAbilitazione_VAR = new MBeanOperationInfo(ABILITA_ADD_FILTRO_ABILITAZIONE_PD, "Aggiunge un filtro puntuale che abilita l'utilizzo del servizio PortaDelegata", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePD_addFiltroDisabilitazione_VAR = new MBeanOperationInfo(ABILITA_ADD_FILTRO_DISABILITAZIONE_PD, "Aggiunge un filtro puntuale che disabilita l'utilizzo del servizio PortaDelegata", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePD_removeFiltroAbilitazione_VAR = new MBeanOperationInfo(ABILITA_REMOVE_FILTRO_ABILITAZIONE_PD, "Rimuove un filtro puntuale che abilita l'utilizzo del servizio PortaDelegata", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePD_removeFiltroDisabilitazione_VAR = new MBeanOperationInfo(ABILITA_REMOVE_FILTRO_DISABILITAZIONE_PD, "Rimuove un filtro puntuale che disabilita l'utilizzo del servizio PortaDelegata", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePA_addFiltroAbilitazione_VAR = new MBeanOperationInfo(ABILITA_ADD_FILTRO_ABILITAZIONE_PA, "Aggiunge un filtro puntuale che abilita l'utilizzo del servizio PortaApplicativa", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePA_addFiltroDisabilitazione_VAR = new MBeanOperationInfo(ABILITA_ADD_FILTRO_DISABILITAZIONE_PA, "Aggiunge un filtro puntuale che disabilita l'utilizzo del servizio PortaApplicativa", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePA_removeFiltroAbilitazione_VAR = new MBeanOperationInfo(ABILITA_REMOVE_FILTRO_ABILITAZIONE_PA, "Rimuove un filtro puntuale che abilita l'utilizzo del servizio PortaApplicativa", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanOperationInfo componentePA_removeFiltroDisabilitazione_VAR = new MBeanOperationInfo(ABILITA_REMOVE_FILTRO_DISABILITAZIONE_PA, "Rimuove un filtro puntuale che disabilita l'utilizzo del servizio PortaApplicativa", this.getMBeanParameterInfoFiltroAbilitazioni(), String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{componentePD_VAR, componentePD_abilitazioni_VAR, componentePD_disabilitazioni_VAR, componentePA_VAR, componentePA_abilitazioni_VAR, componentePA_disabilitazioni_VAR, componenteIM_VAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{abilitaPD_OP, abilitaPA_OP, abilitaIM_OP, abilitazioneCompleta_OP, disabilitaPD_OP, disabilitaPA_OP, disabilitaIM_OP, disabilitazioneCompleta_OP, componentePD_addFiltroAbilitazione_VAR, componentePD_addFiltroDisabilitazione_VAR, componentePD_removeFiltroAbilitazione_VAR, componentePD_removeFiltroDisabilitazione_VAR, componentePA_addFiltroAbilitazione_VAR, componentePA_addFiltroDisabilitazione_VAR, componentePA_removeFiltroAbilitazione_VAR, componentePA_removeFiltroDisabilitazione_VAR};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    private MBeanParameterInfo[] getMBeanParameterInfoFiltroAbilitazioni() {
        MBeanParameterInfo[] m = new MBeanParameterInfo[]{new MBeanParameterInfo("tipoSoggettoFruitore", String.class.getName(), "Tipo del soggetto fruitore"), new MBeanParameterInfo("nomeSoggettoFruitore", String.class.getName(), "Nome del soggetto fruitore"), new MBeanParameterInfo("identificativoPortaSoggettoFruitore", String.class.getName(), "Identificativo della PdD del soggetto fruitore"), new MBeanParameterInfo("tipoSoggettoErogatore", String.class.getName(), "Tipo del soggetto erogatore"), new MBeanParameterInfo("nomeSoggettoErogatore", String.class.getName(), "Nome del soggetto erogatore"), new MBeanParameterInfo("identificativoPortaSoggettoErogatore", String.class.getName(), "Identificativo della PdD del soggetto erogatore"), new MBeanParameterInfo("tipoServizio", String.class.getName(), "Tipo del servizio"), new MBeanParameterInfo("nomeServizio", String.class.getName(), "Nome del servizio"), new MBeanParameterInfo("azione", String.class.getName(), "azione")};
        return m;
    }

    public StatoServiziJMXResource() throws Exception {
        this.componentePD = StatoServiziPdD.isPDServiceActive() ? CostantiConfigurazione.ABILITATO : CostantiConfigurazione.DISABILITATO;
        this.componentePA = StatoServiziPdD.isPAServiceActive() ? CostantiConfigurazione.ABILITATO : CostantiConfigurazione.DISABILITATO;
        this.componenteIM = StatoServiziPdD.isIMServiceActive() ? CostantiConfigurazione.ABILITATO : CostantiConfigurazione.DISABILITATO;
        this.componentePD_abilitazioniPuntuali = this.visualizzaFiltriAbilitazioniServizioPortaDelegata();
        this.componentePD_disabilitazioniPuntuali = this.visualizzaFiltriDisabilitazioniServizioPortaDelegata();
        this.componentePA_abilitazioniPuntuali = this.visualizzaFiltriAbilitazioniServizioPortaApplicativa();
        this.componentePA_disabilitazioniPuntuali = this.visualizzaFiltriDisabilitazioniServizioPortaApplicativa();
    }

    public String abilitaServizioPortaDelegata() {
        if (CostantiConfigurazione.ABILITATO.equals(this.componentePD)) {
            return "Operazione non riuscita:  il servizio PortaDelegata risulta gi\u00e0 abilitato";
        }
        if (StatoServiziPdD.isPDServiceActive()) {
            return "Operazione non riuscita:  il servizio PortaDelegata risulta gi\u00e0 abilitato";
        }
        try {
            StatoServiziPdD.setPDServiceActive(true);
            this.componentePD = CostantiConfigurazione.ABILITATO;
            return "Abilitazione del servizio PortaDelegata effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Abilitazione del servizio PortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String abilitaServizioPortaApplicativa() {
        if (CostantiConfigurazione.ABILITATO.equals(this.componentePA)) {
            return "Operazione non riuscita:  il servizio PortaApplicativa risulta gi\u00e0 abilitato";
        }
        if (StatoServiziPdD.isPAServiceActive()) {
            return "Operazione non riuscita:  il servizio PortaApplicativa risulta gi\u00e0 abilitato";
        }
        try {
            StatoServiziPdD.setPAServiceActive(true);
            this.componentePA = CostantiConfigurazione.ABILITATO;
            return "Abilitazione del servizio PortaApplicativa effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Abilitazione del servizio PortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String abilitaServizioIntegrationManager() {
        if (CostantiConfigurazione.ABILITATO.equals(this.componenteIM)) {
            return "Operazione non riuscita:  il servizio IntegrationManager risulta gi\u00e0 abilitato";
        }
        if (StatoServiziPdD.isIMServiceActive()) {
            return "Operazione non riuscita:  il servizio IntegrationManager risulta gi\u00e0 abilitato";
        }
        try {
            StatoServiziPdD.setIMServiceActive(true);
            this.componenteIM = CostantiConfigurazione.ABILITATO;
            return "Abilitazione del servizio IntegrationManager effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Abilitazione del servizio IntegrationManager non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String abilitazioneCompletaServizi() {
        StringBuffer bf = new StringBuffer();
        bf.append(this.abilitaServizioPortaDelegata());
        bf.append("; ");
        bf.append(this.abilitaServizioPortaApplicativa());
        bf.append("; ");
        bf.append(this.abilitaServizioIntegrationManager());
        return bf.toString();
    }

    public String disabilitaServizioPortaDelegata() {
        if (CostantiConfigurazione.DISABILITATO.equals(this.componentePD)) {
            return "Operazione non riuscita:  il servizio PortaDelegata risulta gi\u00e0 disabilitato";
        }
        if (!StatoServiziPdD.isPDServiceActive()) {
            return "Operazione non riuscita:  il servizio PortaDelegata risulta gi\u00e0 disabilitato";
        }
        try {
            StatoServiziPdD.setPDServiceActive(false);
            this.componentePD = CostantiConfigurazione.DISABILITATO;
            return "Disabilitazione del servizio PortaDelegata effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Disabilitazione del servizio PortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String disabilitaServizioPortaApplicativa() {
        if (CostantiConfigurazione.DISABILITATO.equals(this.componentePA)) {
            return "Operazione non riuscita:  il servizio PortaApplicativa risulta gi\u00e0 disabilitato";
        }
        if (!StatoServiziPdD.isPAServiceActive()) {
            return "Operazione non riuscita:  il servizio PortaApplicativa risulta gi\u00e0 disabilitato";
        }
        try {
            StatoServiziPdD.setPAServiceActive(false);
            this.componentePA = CostantiConfigurazione.DISABILITATO;
            return "Disabilitazione del servizio PortaApplicativa effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Disabilitazione del servizio PortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String disabilitaServizioIntegrationManager() {
        if (CostantiConfigurazione.DISABILITATO.equals(this.componenteIM)) {
            return "Operazione non riuscita:  il servizio IntegrationManager risulta gi\u00e0 disabilitato";
        }
        if (!StatoServiziPdD.isIMServiceActive()) {
            return "Operazione non riuscita:  il servizio IntegrationManager risulta gi\u00e0 disabilitato";
        }
        try {
            StatoServiziPdD.setIMServiceActive(false);
            this.componenteIM = CostantiConfigurazione.DISABILITATO;
            return "Disabilitazione del servizio IntegrationManager effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Disabilitazione del servizio IntegrationManager non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String disabilitazioneCompletaServizi() {
        StringBuffer bf = new StringBuffer();
        bf.append(this.disabilitaServizioPortaDelegata());
        bf.append("; ");
        bf.append(this.disabilitaServizioPortaApplicativa());
        bf.append("; ");
        bf.append(this.disabilitaServizioIntegrationManager());
        return bf.toString();
    }

    public String visualizzaFiltriAbilitazioniServizioPortaDelegata() {
        try {
            return StatoServiziPdD.getPDServiceFiltriAbilitazioneAttivi();
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione visualizzaFiltriAbilitazioniServizioPortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String visualizzaFiltriDisabilitazioniServizioPortaDelegata() {
        try {
            return StatoServiziPdD.getPDServiceFiltriDisabilitazioneAttivi();
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione visualizzaFiltriDisabilitazioniServizioPortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String addFiltroAbilitazioneServizioPortaDelegata(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.addFiltroAbilitazionePD(tipo);
            this.componentePD_abilitazioniPuntuali = this.visualizzaFiltriAbilitazioniServizioPortaDelegata();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione addFiltroAbilitazioneServizioPortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String addFiltroDisabilitazioneServizioPortaDelegata(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.addFiltroDisabilitazionePD(tipo);
            this.componentePD_disabilitazioniPuntuali = this.visualizzaFiltriDisabilitazioniServizioPortaDelegata();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione addFiltroDisabilitazioneServizioPortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String removeFiltroAbilitazioneServizioPortaDelegata(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.removeFiltroAbilitazionePD(tipo);
            this.componentePD_abilitazioniPuntuali = this.visualizzaFiltriAbilitazioniServizioPortaDelegata();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione removeFiltroAbilitazioneServizioPortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String removeFiltroDisabilitazioneServizioPortaDelegata(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.removeFiltroDisabilitazionePD(tipo);
            this.componentePD_disabilitazioniPuntuali = this.visualizzaFiltriDisabilitazioniServizioPortaDelegata();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione removeFiltroDisabilitazioneServizioPortaDelegata non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String visualizzaFiltriAbilitazioniServizioPortaApplicativa() {
        try {
            return StatoServiziPdD.getPAServiceFiltriAbilitazioneAttivi();
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione visualizzaFiltriAbilitazioniServizioPortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String visualizzaFiltriDisabilitazioniServizioPortaApplicativa() {
        try {
            return StatoServiziPdD.getPAServiceFiltriDisabilitazioneAttivi();
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione visualizzaFiltriDisabilitazioniServizioPortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String addFiltroAbilitazioneServizioPortaApplicativa(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.addFiltroAbilitazionePA(tipo);
            this.componentePA_abilitazioniPuntuali = this.visualizzaFiltriAbilitazioniServizioPortaApplicativa();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione addFiltroAbilitazioneServizioPortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String addFiltroDisabilitazioneServizioPortaApplicativa(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.addFiltroDisabilitazionePA(tipo);
            this.componentePA_disabilitazioniPuntuali = this.visualizzaFiltriDisabilitazioniServizioPortaApplicativa();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione addFiltroDisabilitazioneServizioPortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String removeFiltroAbilitazioneServizioPortaApplicativa(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.removeFiltroAbilitazionePA(tipo);
            this.componentePA_abilitazioniPuntuali = this.visualizzaFiltriAbilitazioniServizioPortaApplicativa();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione removeFiltroAbilitazioneServizioPortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }

    public String removeFiltroDisabilitazioneServizioPortaApplicativa(TipoFiltroAbilitazioneServizi tipo) {
        try {
            StatoServiziPdD.removeFiltroDisabilitazionePA(tipo);
            this.componentePA_disabilitazioniPuntuali = this.visualizzaFiltriDisabilitazioniServizioPortaApplicativa();
            return "Operazione effettuata con successo";
        }
        catch (Throwable e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Operazione removeFiltroDisabilitazioneServizioPortaApplicativa non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita:  sistema non disponibile";
        }
    }
}

