/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.jmx.JMXUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class RepositoryMessaggi
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String TIPO_REPOSITORY = "tipoRepository";
    private boolean cacheAbilitata = false;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(TIPO_REPOSITORY)) {
            return OpenSPCoop2Properties.getInstance().getRepositoryType();
        }
        if (attributeName.equals("cacheAbilitata")) {
            return this.cacheAbilitata;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block9: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals("cacheAbilitata")) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        if (!this.cacheAbilitata) {
                            this.abilitaCache();
                        }
                    } else if (this.cacheAbilitata) {
                        this.disabilitaCache();
                    }
                    break block9;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disabilitaCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("abilitaCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[AbilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            return this.abilitaCache((Long)params[0], (Boolean)params[1], (Long)params[2], (Long)params[3]);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean IS_GETTER = true;
        String className = this.getClass().getName();
        String description = "Repository dei Messaggi della Porta di Dominio " + OpenSPCoop2Properties.getInstance().getVersione();
        MBeanAttributeInfo tipoRepositoryVAR = new MBeanAttributeInfo(TIPO_REPOSITORY, String.class.getName(), "Tipo di repository messaggi della Porta di Dominio", true, false, false);
        MBeanAttributeInfo cacheAbilitataVAR = JMXUtils.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanOperationInfo resetCacheOP = JMXUtils.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo printStatCacheOP = JMXUtils.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = JMXUtils.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = JMXUtils.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = JMXUtils.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = JMXUtils.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = JMXUtils.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{tipoRepositoryVAR, cacheAbilitataVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, printStatCacheOP, disabilitaCacheOP, abilitaCacheParametriOP, listKeysCacheOP, getObjectCacheOP, removeObjectCacheOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public RepositoryMessaggi() {
        this.cacheAbilitata = GestoreMessaggi.isCacheAbilitata();
    }

    public boolean isCacheAbilitata() {
        return this.cacheAbilitata;
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            GestoreMessaggi.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return GestoreMessaggi.printStatsCache("\n");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String abilitaCache() {
        try {
            GestoreMessaggi.abilitaCache();
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) {
        try {
            GestoreMessaggi.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            GestoreMessaggi.disabilitaCache();
            this.cacheAbilitata = false;
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return GestoreMessaggi.listKeysCache("\n");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return GestoreMessaggi.getObjectCache(key);
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            GestoreMessaggi.removeObjectCache(key);
            return "Rimozione elemento dalla cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

