/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.resources.MapReader;

public class ConfigurazioneSistema
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String VERSIONE_PDD = "getVersionePdD";
    public static final String VERSIONE_BASE_DATI = "getVersioneBaseDati";
    public static final String VERSIONE_JAVA = "getVersioneJava";
    public static final String TIPO_DATABASE = "getTipoDatabase";
    public static final String INFORMAZIONI_DATABASE = "getInformazioniDatabase";
    public static final String DIRECTORY_CONFIGURAZIONE = "getDirectoryConfigurazione";
    public static final String PROTOCOLS = "getPluginProtocols";
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
        }
        try {
            throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
        }
        catch (ClassCastException ce) {
            throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
        }
        catch (JMException j) {
            throw new MBeanException(j);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(VERSIONE_PDD)) {
            return this.getVersionePdD();
        }
        if (actionName.equals(VERSIONE_BASE_DATI)) {
            return this.getVersioneBaseDati();
        }
        if (actionName.equals(VERSIONE_JAVA)) {
            return this.getVersioneJava();
        }
        if (actionName.equals(TIPO_DATABASE)) {
            return this.getTipoDatabase();
        }
        if (actionName.equals(INFORMAZIONI_DATABASE)) {
            return this.getInformazioniDatabase();
        }
        if (actionName.equals(DIRECTORY_CONFIGURAZIONE)) {
            return this.getDirectoryConfigurazione();
        }
        if (actionName.equals(PROTOCOLS)) {
            return this.getPluginProtocols();
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Configurazione di Sistema della Porta di Dominio " + this.openspcoopProperties.getVersione();
        MBeanOperationInfo versionePddOp = new MBeanOperationInfo(VERSIONE_PDD, "Visualizza la versione della Porta di Dominio", null, String.class.getName(), 1);
        MBeanOperationInfo versioneBaseDatiOp = new MBeanOperationInfo(VERSIONE_BASE_DATI, "Visualizza la versione della base dati", null, String.class.getName(), 1);
        MBeanOperationInfo versioneJavaOp = new MBeanOperationInfo(VERSIONE_JAVA, "Visualizza la versione di Java", null, String.class.getName(), 1);
        MBeanOperationInfo versioneTipoDatabaseOp = new MBeanOperationInfo(TIPO_DATABASE, "Visualizza il tipo di Database", null, String.class.getName(), 1);
        MBeanOperationInfo informazioniDatabaseOp = new MBeanOperationInfo(INFORMAZIONI_DATABASE, "Visualizza le informazioni sul Database", null, String.class.getName(), 1);
        MBeanOperationInfo confDirectoryOp = new MBeanOperationInfo(DIRECTORY_CONFIGURAZIONE, "Visualizza la directory di configurazione", null, String.class.getName(), 1);
        MBeanOperationInfo protocolsOp = new MBeanOperationInfo(PROTOCOLS, "Visualizza i protocolli installati", null, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = null;
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{versionePddOp, versioneBaseDatiOp, versioneJavaOp, versioneTipoDatabaseOp, informazioniDatabaseOp, confDirectoryOp, protocolsOp};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public String getVersionePdD() {
        try {
            String versione = "Porta di Dominio OpenSPCoop2/tags_2.2.1";
            if (this.openspcoopProperties != null) {
                versione = "Porta di Dominio " + this.openspcoopProperties.getPddDetailsForServices();
            }
            return versione;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersioneBaseDati() {
        String string;
        if (!DBManager.isInitialized()) {
            throw new Exception("Inizializzazione DBManager non effettuata");
        }
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        IDSoggetto dominio = this.openspcoopProperties.getIdentitaPortaDefault(null);
        String modulo = this.getClass().getName();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            resource = dbManager.getResource(dominio, modulo, null);
            Connection c = (Connection)resource.getResource();
            String sql = "select * from db_info order by id DESC";
            pstmt = c.prepareStatement(sql);
            rs = pstmt.executeQuery();
            StringBuffer bf = new StringBuffer();
            while (rs.next()) {
                int major_version = rs.getInt("major_version");
                int minor_version = rs.getInt("minor_version");
                String details = rs.getString("notes");
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append("[" + major_version + "." + minor_version + "] " + details);
            }
            if (bf.length() <= 0) {
                throw new Exception("BaseDati non possiede informazioni sul versionamento");
            }
            string = bf.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    if (dbManager != null) {
                        dbManager.releaseResource(dominio, modulo, resource);
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Throwable e) {
                this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
                return "Operazione non riuscita: " + e.getMessage();
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (dbManager != null) {
                dbManager.releaseResource(dominio, modulo, resource);
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        return string;
    }

    public String getVersioneJava() {
        try {
            String v = System.getProperty("java.version");
            if (v != null && !"".equals(v)) {
                return v;
            }
            throw new Exception("Versione di Java non disponibile");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getTipoDatabase() {
        try {
            if (this.openspcoopProperties != null) {
                return this.openspcoopProperties.getDatabaseType();
            }
            throw new Exception("Tipo di Database non disponibile");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInformazioniDatabase() {
        String string;
        if (!DBManager.isInitialized()) {
            throw new Exception("Inizializzazione DBManager non effettuata");
        }
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        IDSoggetto dominio = this.openspcoopProperties.getIdentitaPortaDefault(null);
        String modulo = this.getClass().getName();
        StringBuffer bf = new StringBuffer();
        if (this.openspcoopProperties == null) {
            throw new Exception("Tipo di Database non disponibile");
        }
        bf.append("TipoDatabase: " + this.openspcoopProperties.getDatabaseType());
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            resource = dbManager.getResource(dominio, modulo, null);
            Connection c = (Connection)resource.getResource();
            DatabaseMetaData dbMetaDati = c.getMetaData();
            if (dbMetaDati != null) {
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                try {
                    String productName = dbMetaDati.getDatabaseProductName();
                    bf.append("DatabaseProductName: " + productName);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    String productVersion = dbMetaDati.getDatabaseProductVersion();
                    bf.append("DatabaseProductVersion: " + productVersion);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    int v = dbMetaDati.getDatabaseMajorVersion();
                    bf.append("DatabaseMajorVersion: " + v);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    int v = dbMetaDati.getDatabaseMinorVersion();
                    bf.append("DatabaseMinorVersion: " + v);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    String driverName = dbMetaDati.getDriverName();
                    bf.append("DriverName: " + driverName);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    String productVersion = dbMetaDati.getDriverVersion();
                    bf.append("DriverVersion: " + productVersion);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                int v = dbMetaDati.getDriverMajorVersion();
                bf.append("DriverMajorVersion: " + v);
                bf.append("\n");
                v = dbMetaDati.getDriverMinorVersion();
                bf.append("DriverMinorVersion: " + v);
                bf.append("\n");
                try {
                    v = dbMetaDati.getJDBCMajorVersion();
                    bf.append("JDBCMajorVersion: " + v);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    v = dbMetaDati.getJDBCMinorVersion();
                    bf.append("JDBCMinorVersion: " + v);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    String username = dbMetaDati.getUserName();
                    bf.append("Username: " + username);
                    bf.append("\n");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    ResultSet catalogs = dbMetaDati.getCatalogs();
                    int size = 0;
                    while (catalogs.next()) {
                        ++size;
                    }
                    catalogs = dbMetaDati.getCatalogs();
                    int index = 0;
                    while (catalogs.next()) {
                        if (size == 1) {
                            bf.append("Catalog: " + catalogs.getString(1));
                        } else {
                            bf.append("Catalogs[" + index + "]: " + catalogs.getString(1));
                        }
                        bf.append("\n");
                        ++index;
                    }
                    catalogs.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (bf.length() <= 0) {
                throw new Exception("Non sono disponibili informazioni sul database");
            }
            string = bf.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                try {
                    if (dbManager != null) {
                        dbManager.releaseResource(dominio, modulo, resource);
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Throwable e) {
                this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
                return "Operazione non riuscita: " + e.getMessage();
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        try {
            if (dbManager != null) {
                dbManager.releaseResource(dominio, modulo, resource);
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        return string;
    }

    public String getDirectoryConfigurazione() {
        try {
            if (this.openspcoopProperties != null) {
                StringBuffer bf = new StringBuffer();
                if (System.getenv("OPENSPCOOP2_HOME") != null) {
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append("SystemProperty[OPENSPCOOP2_HOME]=[" + System.getenv("OPENSPCOOP2_HOME") + "]");
                }
                if (System.getProperty("OPENSPCOOP2_HOME") != null) {
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append("JavaProperty[OPENSPCOOP2_HOME]=[" + System.getProperty("OPENSPCOOP2_HOME") + "]");
                }
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append("OpenSPCoop2PropertiesReader[" + this.openspcoopProperties.getRootDirectory() + "]");
                return bf.toString();
            }
            throw new Exception("Directory di Configurazione non disponibile");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getPluginProtocols() {
        try {
            MapReader prots = ProtocolFactoryManager.getInstance().getProtocolFactories();
            if (prots.size() <= 0) {
                throw new Exception("No protocol installed");
            }
            StringBuffer bfProtocols = new StringBuffer();
            Enumeration keys = prots.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                IProtocolFactory pf = (IProtocolFactory)prots.get((Object)key);
                if (pf.getManifest().getWeb().getEmptyContext() != null && pf.getManifest().getWeb().getEmptyContext().isEnabled()) {
                    if (bfProtocols.length() > 0) {
                        bfProtocols.append("\n");
                    }
                    bfProtocols.append("\"\" (protocol:" + key + ")");
                }
                if (pf.getManifest().getWeb().sizeContextList() <= 0) continue;
                for (String context : pf.getManifest().getWeb().getContextList()) {
                    if (bfProtocols.length() > 0) {
                        bfProtocols.append("\n");
                    }
                    bfProtocols.append(context + " (protocol:" + key + ")");
                }
            }
            String enabledProtocols = bfProtocols.toString();
            return enabledProtocols;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

