/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.jmx.JMXUtils;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class ConfigurazionePdD
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String MSG_DIAGNOSTICI_SEVERITA_LIVELLO = "msgDiagnosticiLivelloSeverita";
    public static final String MSG_DIAGNOSTICI_SEVERITA_LIVELLO_LOG4J = "msgDiagnosticiLivelloSeveritaLog4J";
    public static final String MSG_DIAGNOSTICI_APPENDER = "msgDiagnosticiAppender";
    public static final String TRACCIAMENTO_ABILITATO = "tracciamentoAbilitato";
    public static final String DUMP_ABILITATO = "dumpApplicativoAbilitato";
    public static final String DUMP_BINARIO_PD_ABILITATO = "dumpBinarioPortaDelegataAbilitato";
    public static final String DUMP_BINARIO_PA_ABILITATO = "dumpBinarioPortaApplicativaAbilitato";
    public static final String TRACCIAMENTO_APPENDER = "tracciamentoAppender";
    public static final String LOG4J_DIAGNOSTICA_ABILITATO = "log4jLogFileDiagnosticaAbilitato";
    public static final String LOG4J_OPENSPCOOP_ABILITATO = "log4jLogFileOpenSPCoopAbilitato";
    public static final String LOG4J_INTEGRATION_MANAGER_ABILITATO = "log4jLogFileIntegrationManagerAbilitato";
    public static final String LOG4J_TRACCIAMENTO_ABILITATO = "log4jLogFileTracciamentoAbilitato";
    public static final String LOG4J_DUMP_ABILITATO = "log4jLogFileDumpAbilitato";
    private boolean cacheAbilitata = false;
    private String msgDiagnosticiLivelloSeverita = "";
    private String msgDiagnosticiLivelloSeveritaLog4J = "";
    private String[] msgDiagnosticiAppender = null;
    private boolean tracciamentoAbilitato = true;
    private boolean dumpApplicativoAbilitato = false;
    private boolean dumpBinarioPDAbilitato = false;
    private boolean dumpBinarioPAAbilitato = false;
    private String[] tracciamentoAppender = null;
    private boolean log4jDiagnosticaAbilitato = false;
    private boolean log4jOpenSPCoopAbilitato = false;
    private boolean log4jIntegrationManagerAbilitato = false;
    private boolean log4jTracciamentoAbilitato = false;
    private boolean log4jDumpAbilitato = false;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    ConfigurazionePdDManager configReader = ConfigurazionePdDManager.getInstance();
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals("cacheAbilitata")) {
            return this.cacheAbilitata;
        }
        if (attributeName.equals(MSG_DIAGNOSTICI_SEVERITA_LIVELLO)) {
            return this.msgDiagnosticiLivelloSeverita;
        }
        if (attributeName.equals(MSG_DIAGNOSTICI_SEVERITA_LIVELLO_LOG4J)) {
            return this.msgDiagnosticiLivelloSeveritaLog4J;
        }
        if (attributeName.equals(MSG_DIAGNOSTICI_APPENDER)) {
            return this.msgDiagnosticiAppender;
        }
        if (attributeName.equals(TRACCIAMENTO_ABILITATO)) {
            return this.tracciamentoAbilitato;
        }
        if (attributeName.equals(DUMP_ABILITATO)) {
            return this.dumpApplicativoAbilitato;
        }
        if (attributeName.equals(DUMP_BINARIO_PD_ABILITATO)) {
            return this.dumpBinarioPDAbilitato;
        }
        if (attributeName.equals(DUMP_BINARIO_PA_ABILITATO)) {
            return this.dumpBinarioPAAbilitato;
        }
        if (attributeName.equals(TRACCIAMENTO_APPENDER)) {
            return this.tracciamentoAppender;
        }
        if (attributeName.equals(LOG4J_DIAGNOSTICA_ABILITATO)) {
            return this.log4jDiagnosticaAbilitato;
        }
        if (attributeName.equals(LOG4J_OPENSPCOOP_ABILITATO)) {
            return this.log4jOpenSPCoopAbilitato;
        }
        if (attributeName.equals(LOG4J_INTEGRATION_MANAGER_ABILITATO)) {
            return this.log4jIntegrationManagerAbilitato;
        }
        if (attributeName.equals(LOG4J_TRACCIAMENTO_ABILITATO)) {
            return this.log4jTracciamentoAbilitato;
        }
        if (attributeName.equals(LOG4J_DUMP_ABILITATO)) {
            return this.log4jDumpAbilitato;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block17: {
            if (attribute == null) {
                throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
            }
            try {
                if (attribute.getName().equals("cacheAbilitata")) {
                    boolean v = (Boolean)attribute.getValue();
                    if (v) {
                        if (!this.cacheAbilitata) {
                            this.abilitaCache();
                        }
                    } else if (this.cacheAbilitata) {
                        this.disabilitaCache();
                    }
                    break block17;
                }
                if (attribute.getName().equals(MSG_DIAGNOSTICI_SEVERITA_LIVELLO)) {
                    this.setMsgDiagnosticiLivelloSeverita((String)attribute.getValue());
                    break block17;
                }
                if (attribute.getName().equals(MSG_DIAGNOSTICI_SEVERITA_LIVELLO_LOG4J)) {
                    this.setMsgDiagnosticiLivelloSeveritaLog4J((String)attribute.getValue());
                    break block17;
                }
                if (attribute.getName().equals(MSG_DIAGNOSTICI_APPENDER)) {
                    this.msgDiagnosticiAppender = (String[])attribute.getValue();
                    break block17;
                }
                if (attribute.getName().equals(TRACCIAMENTO_ABILITATO)) {
                    this.setTracciamentoAbilitato((Boolean)attribute.getValue());
                    break block17;
                }
                if (attribute.getName().equals(DUMP_ABILITATO)) {
                    this.setDumpAbilitato((Boolean)attribute.getValue());
                    break block17;
                }
                if (attribute.getName().equals(DUMP_BINARIO_PD_ABILITATO)) {
                    this.setDumpBinarioPD((Boolean)attribute.getValue());
                    break block17;
                }
                if (attribute.getName().equals(DUMP_BINARIO_PA_ABILITATO)) {
                    this.setDumpBinarioPA((Boolean)attribute.getValue());
                    break block17;
                }
                if (attribute.getName().equals(TRACCIAMENTO_APPENDER)) {
                    this.tracciamentoAppender = (String[])attribute.getValue();
                    break block17;
                }
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
            catch (ClassCastException ce) {
                throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
            }
            catch (JMException j) {
                throw new MBeanException(j);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals("resetCache")) {
            return this.resetCache();
        }
        if (actionName.equals("printStatsCache")) {
            return this.printStatCache();
        }
        if (actionName.equals("disabilitaCache")) {
            return this.disabilitaCacheConEsito();
        }
        if (actionName.equals("abilitaCache")) {
            if (params.length != 4) {
                throw new MBeanException(new Exception("[abilitaCache] Lunghezza parametri non corretta: " + params.length));
            }
            Long param1 = null;
            if (params[0] != null && !"".equals(params[0]) && (param1 = (Long)params[0]) < 0L) {
                param1 = null;
            }
            Boolean param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (Boolean)params[1];
            }
            Long param3 = null;
            if (params[2] != null && !"".equals(params[2]) && (param3 = (Long)params[2]) < 0L) {
                param3 = null;
            }
            Long param4 = null;
            if (params[3] != null && !"".equals(params[3]) && (param4 = (Long)params[3]) < 0L) {
                param4 = null;
            }
            return this.abilitaCache(param1, param2, param3, param4);
        }
        if (actionName.equals("listKeysCache")) {
            return this.listKeysCache();
        }
        if (actionName.equals("getObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getObjectCache(param1);
        }
        if (actionName.equals("removeObjectCache")) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeObjectCache] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeObjectCache(param1);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Risorsa per la configurazione della Porta di Dominio " + this.openspcoopProperties.getVersione();
        MBeanAttributeInfo cacheAbilitataVAR = JMXUtils.MBEAN_ATTRIBUTE_INFO_CACHE_ABILITATA;
        MBeanAttributeInfo livelloMsgDiagnosticiVAR = new MBeanAttributeInfo(MSG_DIAGNOSTICI_SEVERITA_LIVELLO, String.class.getName(), "Livello dei messaggi diagnostici emessi dalla Porta di Dominio \n[off,fatal,errorProtocol,errorIntegration,infoProtocol,infoIntegration,debugLow,debugMedium,debugHigh,all]", true, true, false);
        MBeanAttributeInfo livelloMsgDiagnosticiLog4JVAR = new MBeanAttributeInfo(MSG_DIAGNOSTICI_SEVERITA_LIVELLO_LOG4J, String.class.getName(), "Livello dei messaggi diagnostici human readable emessi dalla Porta di Dominio \n[off,fatal,errorProtocol,errorIntegration,infoProtocol,infoIntegration,debugLow,debugMedium,debugHigh,all]", true, true, false);
        MBeanAttributeInfo msgDiagnosticiAppenderVAR = new MBeanAttributeInfo(MSG_DIAGNOSTICI_APPENDER, String[].class.getName(), "Appender personalizzati per la registrazione dei messaggi diagnostici emessi dalla Porta di Dominio", true, false, false);
        MBeanAttributeInfo tracciamentoAbilitatoVAR = new MBeanAttributeInfo(TRACCIAMENTO_ABILITATO, Boolean.TYPE.getName(), "Indicazione se e' abilito il tracciamento delle buste emesse/ricevute dalla Porta di Dominio", true, true, false);
        MBeanAttributeInfo dumpApplicativoAbilitatoVAR = new MBeanAttributeInfo(DUMP_ABILITATO, Boolean.TYPE.getName(), "Indicazione se e' abilito la registrazione dei contenuti applicativi gestiti dalla Porta di Dominio", true, true, false);
        MBeanAttributeInfo dumpBinarioPDAbilitatoVAR = new MBeanAttributeInfo(DUMP_BINARIO_PD_ABILITATO, Boolean.TYPE.getName(), "Indicazione se e' abilito la registrazione dei dati binari transitati sulla Porta Delegata", true, true, false);
        MBeanAttributeInfo dumpBinarioPAAbilitatoVAR = new MBeanAttributeInfo(DUMP_BINARIO_PA_ABILITATO, Boolean.TYPE.getName(), "Indicazione se e' abilito la registrazione dei dati binari transitati sulla Porta Applicativa", true, true, false);
        MBeanAttributeInfo tracciamentoAppenderVAR = new MBeanAttributeInfo(TRACCIAMENTO_APPENDER, String[].class.getName(), "Appender personalizzati per la registrazione delle buste emesse/ricevute dalla Porta di Dominio", true, false, false);
        MBeanAttributeInfo log4jDiagnosticaAbilitatoVAR = new MBeanAttributeInfo(LOG4J_DIAGNOSTICA_ABILITATO, Boolean.TYPE.getName(), "Indicazione se \u00e8 abilitato il logging su file openspcoop2_msgDiagnostico.log", true, false, false);
        MBeanAttributeInfo log4jOpenSPCoopAbilitatoVAR = new MBeanAttributeInfo(LOG4J_OPENSPCOOP_ABILITATO, Boolean.TYPE.getName(), "Indicazione se \u00e8 abilitato il logging su file openspcoop2.log", true, false, false);
        MBeanAttributeInfo log4jIntegrationManagerAbilitatoVAR = new MBeanAttributeInfo(LOG4J_INTEGRATION_MANAGER_ABILITATO, Boolean.TYPE.getName(), "Indicazione se \u00e8 abilitato il logging su file openspcoop2_integrationManager.log", true, false, false);
        MBeanAttributeInfo log4jTracciamentoAbilitatoVAR = new MBeanAttributeInfo(LOG4J_DIAGNOSTICA_ABILITATO, Boolean.TYPE.getName(), "Indicazione se \u00e8 abilitato il logging su file openspcoop2_tracciamento.log", true, false, false);
        MBeanAttributeInfo log4jDumpAbilitatoVAR = new MBeanAttributeInfo(LOG4J_DUMP_ABILITATO, Boolean.TYPE.getName(), "Indicazione se \u00e8 abilitato il logging su file openspcoop2_dump.log", true, false, false);
        MBeanOperationInfo resetCacheOP = JMXUtils.MBEAN_OPERATION_RESET_CACHE;
        MBeanOperationInfo printStatCacheOP = JMXUtils.MBEAN_OPERATION_PRINT_STATS_CACHE;
        MBeanOperationInfo disabilitaCacheOP = JMXUtils.MBEAN_OPERATION_DISABILITA_CACHE;
        MBeanOperationInfo abilitaCacheParametriOP = JMXUtils.MBEAN_OPERATION_ABILITA_CACHE_CON_PARAMETRI;
        MBeanOperationInfo listKeysCacheOP = JMXUtils.MBEAN_OPERATION_LIST_KEYS_CACHE;
        MBeanOperationInfo getObjectCacheOP = JMXUtils.MBEAN_OPERATION_GET_OBJECT_CACHE;
        MBeanOperationInfo removeObjectCacheOP = JMXUtils.MBEAN_OPERATION_REMOVE_OBJECT_CACHE;
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{cacheAbilitataVAR, livelloMsgDiagnosticiVAR, livelloMsgDiagnosticiLog4JVAR, msgDiagnosticiAppenderVAR, tracciamentoAbilitatoVAR, dumpApplicativoAbilitatoVAR, dumpBinarioPDAbilitatoVAR, dumpBinarioPAAbilitatoVAR, tracciamentoAppenderVAR, log4jDiagnosticaAbilitatoVAR, log4jOpenSPCoopAbilitatoVAR, log4jIntegrationManagerAbilitatoVAR, log4jTracciamentoAbilitatoVAR, log4jDumpAbilitatoVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{resetCacheOP, printStatCacheOP, disabilitaCacheOP, abilitaCacheParametriOP, listKeysCacheOP, getObjectCacheOP, removeObjectCacheOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public ConfigurazionePdD() {
        try {
            this.cacheAbilitata = ConfigurazionePdDReader.isCacheAbilitata();
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la comprensione dello stato della cache");
        }
        this.msgDiagnosticiLivelloSeverita = LogLevels.toOpenSPCoop2(this.configReader.getSeverita_msgDiagnostici(), true);
        this.msgDiagnosticiLivelloSeveritaLog4J = LogLevels.toOpenSPCoop2(this.configReader.getSeveritaLog4J_msgDiagnostici(), true);
        this.log4jDiagnosticaAbilitato = OpenSPCoop2Logger.loggerMsgDiagnosticoAbilitato;
        this.log4jOpenSPCoopAbilitato = OpenSPCoop2Logger.loggerMsgDiagnosticoReadableAbilitato;
        this.log4jIntegrationManagerAbilitato = OpenSPCoop2Logger.loggerIntegrationManagerAbilitato;
        MessaggiDiagnostici msg = this.configReader.getOpenSPCoopAppender_MsgDiagnostici();
        if (msg != null && msg.sizeOpenspcoopAppenderList() > 0) {
            this.msgDiagnosticiAppender = new String[msg.sizeOpenspcoopAppenderList()];
            for (int i = 0; i < msg.sizeOpenspcoopAppenderList(); ++i) {
                OpenspcoopAppender appender = msg.getOpenspcoopAppender(i);
                this.msgDiagnosticiAppender[i] = "Appender di tipo " + appender.getTipo() + ", properties size:" + appender.sizePropertyList();
                for (int j = 0; j < appender.sizePropertyList(); ++j) {
                    this.msgDiagnosticiAppender[i] = this.msgDiagnosticiAppender[i] + "\n[nome=" + appender.getProperty(j).getNome() + " valore=" + appender.getProperty(j).getValore() + "]";
                }
            }
        }
        this.tracciamentoAbilitato = this.configReader.tracciamentoBuste();
        this.dumpApplicativoAbilitato = this.configReader.dumpMessaggi();
        this.dumpBinarioPDAbilitato = this.configReader.dumpBinarioPD();
        this.dumpBinarioPAAbilitato = this.configReader.dumpBinarioPA();
        this.log4jTracciamentoAbilitato = OpenSPCoop2Logger.loggerTracciamentoAbilitato;
        this.log4jDumpAbilitato = OpenSPCoop2Logger.loggerDumpAbilitato;
        Tracciamento tracciamento = this.configReader.getOpenSPCoopAppender_Tracciamento();
        if (tracciamento != null && tracciamento.sizeOpenspcoopAppenderList() > 0) {
            this.tracciamentoAppender = new String[tracciamento.sizeOpenspcoopAppenderList()];
            for (int i = 0; i < tracciamento.sizeOpenspcoopAppenderList(); ++i) {
                OpenspcoopAppender appender = tracciamento.getOpenspcoopAppender(i);
                this.tracciamentoAppender[i] = "Appender di tipo " + appender.getTipo() + ", properties size:" + appender.sizePropertyList();
                for (int j = 0; j < appender.sizePropertyList(); ++j) {
                    this.tracciamentoAppender[i] = this.tracciamentoAppender[i] + "\n[nome=" + appender.getProperty(j).getNome() + " valore=" + appender.getProperty(j).getValore() + "]";
                }
            }
        }
    }

    public boolean isCacheAbilitata() {
        return this.cacheAbilitata;
    }

    public String resetCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            ConfigurazionePdDReader.resetCache();
            return "Operazione di reset effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String printStatCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return ConfigurazionePdDReader.printStatsCache("\n");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void abilitaCache() {
        try {
            ConfigurazionePdDReader.abilitaCache();
            this.cacheAbilitata = true;
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
        }
    }

    public String abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) {
        try {
            ConfigurazionePdDReader.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            this.cacheAbilitata = true;
            return "Abilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void disabilitaCache() throws JMException {
        try {
            ConfigurazionePdDReader.disabilitaCache();
            this.cacheAbilitata = false;
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            throw new JMException(e.getMessage());
        }
    }

    public String disabilitaCacheConEsito() {
        try {
            this.disabilitaCache();
            return "Disabilitazione cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)e.getMessage(), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String listKeysCache() {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return ConfigurazionePdDReader.listKeysCache("\n");
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            return ConfigurazionePdDReader.getObjectCache(key);
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeObjectCache(String key) {
        try {
            if (!this.cacheAbilitata) {
                throw new Exception("Cache non abilitata");
            }
            ConfigurazionePdDReader.removeObjectCache(key);
            return "Rimozione elemento dalla cache effettuata con successo";
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public void setMsgDiagnosticiLivelloSeverita(String livelloMsgDiagnostici) throws JMException {
        if (!("off".equals(livelloMsgDiagnostici) || "fatal".equals(livelloMsgDiagnostici) || "errorProtocol".equals(livelloMsgDiagnostici) || "errorIntegration".equals(livelloMsgDiagnostici) || "infoProtocol".equals(livelloMsgDiagnostici) || "infoIntegration".equals(livelloMsgDiagnostici) || "debugLow".equals(livelloMsgDiagnostici) || "debugMedium".equals(livelloMsgDiagnostici) || "debugHigh".equals(livelloMsgDiagnostici) || "all".equals(livelloMsgDiagnostici))) {
            throw new JMException("Livello " + livelloMsgDiagnostici + " non conosciuto");
        }
        this.msgDiagnosticiLivelloSeverita = livelloMsgDiagnostici;
        ConfigurazionePdDReader.livello_msgDiagnosticiJMX = LogLevels.toLog4J(this.msgDiagnosticiLivelloSeverita);
        ConfigurazionePdDReader.severita_msgDiagnosticiJMX = LogLevels.toOpenSPCoop2(this.msgDiagnosticiLivelloSeverita);
    }

    public void setMsgDiagnosticiLivelloSeveritaLog4J(String livelloMsgDiagnosticiLog4j) throws JMException {
        if (!("off".equals(livelloMsgDiagnosticiLog4j) || "fatal".equals(livelloMsgDiagnosticiLog4j) || "errorProtocol".equals(livelloMsgDiagnosticiLog4j) || "errorIntegration".equals(livelloMsgDiagnosticiLog4j) || "infoProtocol".equals(livelloMsgDiagnosticiLog4j) || "infoIntegration".equals(livelloMsgDiagnosticiLog4j) || "debugLow".equals(livelloMsgDiagnosticiLog4j) || "debugMedium".equals(livelloMsgDiagnosticiLog4j) || "debugHigh".equals(livelloMsgDiagnosticiLog4j) || "all".equals(livelloMsgDiagnosticiLog4j))) {
            throw new JMException("Livello " + livelloMsgDiagnosticiLog4j + " non conosciuto");
        }
        this.msgDiagnosticiLivelloSeveritaLog4J = livelloMsgDiagnosticiLog4j;
        ConfigurazionePdDReader.livelloLog4J_msgDiagnosticiJMX = LogLevels.toLog4J(this.msgDiagnosticiLivelloSeveritaLog4J);
        ConfigurazionePdDReader.severitaLog4J_msgDiagnosticiJMX = LogLevels.toOpenSPCoop2(this.msgDiagnosticiLivelloSeveritaLog4J);
    }

    public void setTracciamentoAbilitato(boolean v) {
        this.tracciamentoAbilitato = v;
        ConfigurazionePdDReader.tracciamentoBusteJMX = v;
    }

    public void setDumpAbilitato(boolean v) {
        this.dumpApplicativoAbilitato = v;
        ConfigurazionePdDReader.dumpMessaggiJMX = v;
    }

    public void setDumpBinarioPD(boolean v) {
        this.dumpBinarioPDAbilitato = v;
        ConfigurazionePdDReader.dumpBinarioPDJMX = v;
    }

    public void setDumpBinarioPA(boolean v) {
        this.dumpBinarioPAAbilitato = v;
        ConfigurazionePdDReader.dumpBinarioPAJMX = v;
    }
}

