/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.ValidatoreXSD;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.w3c.dom.Node;

public class UtilitiesIntegrazioneWSAddressing {
    private static final String WSA_TO_FORMAT = "http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>";
    private static final String WSA_FROM_FORMAT = "http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org";
    private static final String WSA_ACTION_FORMAT = "http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>";
    private static final String WSA_ID_FORMAT = "uuid:<id>";
    private static final String WSA_RELATES_TO_FORMAT = "uuid:<id>";
    public static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    public static final String WSA_PREFIX = "wsa";
    public static final String WSA_RELATIONSHIP_TYPE_REPLY = "http://www.w3.org/2005/08/addressing/reply";
    public static final String WSA_SOAP_HEADER_TO = "To";
    public static final String WSA_SOAP_HEADER_FROM = "From";
    public static final String WSA_SOAP_HEADER_ACTION = "Action";
    public static final String WSA_SOAP_HEADER_ID = "MessageID";
    public static final String WSA_SOAP_HEADER_RELATES_TO = "RelatesTo";
    public static final String WSA_SOAP_HEADER_RELATES_TO_ATTRIBUTE = "RelationshipType";
    public static final String WSA_SOAP_HEADER_EPR_ADDRESS = "Address";
    public static final boolean INTERPRETA_COME_ID_BUSTA = true;
    public static final boolean INTERPRETA_COME_ID_APPLICATIVO = false;
    public static final boolean BUILD_VALUE_AS_EPR = true;
    public static final boolean BUILD_VALUE_RAW = false;
    private static UtilitiesIntegrazioneWSAddressing utilitiesIntegrazione = null;
    private ValidatoreXSD validatoreXSD = null;

    public static void readDatiWSATo(String wsaTO, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        int indexSoggetto;
        if (wsaTO == null) {
            throw new HeaderIntegrazioneException("WSATO value is null");
        }
        if (!(wsaTO = wsaTO.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid: http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        if (!wsaTO.contains(".openspcoop2.org/servizi/")) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid: http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        String soggetto = (wsaTO = wsaTO.substring(7, wsaTO.length())).substring(0, indexSoggetto = wsaTO.indexOf(".openspcoop2.org/servizi/"));
        if (soggetto == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Soggetto non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        if (!soggetto.contains("_")) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Soggetto non identificabile, '_' non trovato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        String[] soggetto_split = soggetto.split("_");
        if (soggetto_split == null || soggetto_split.length < 2) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Soggetto non identificabile, formato errato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        String tipoSoggetto = soggetto_split[0];
        String nomeSoggetto = soggetto.substring((tipoSoggetto + "_").length());
        if (tipoSoggetto == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (TipoSoggetto non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        if (nomeSoggetto == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (NomeSoggetto non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        tipoSoggetto = tipoSoggetto.trim();
        nomeSoggetto = nomeSoggetto.trim();
        integrazione.getBusta().setTipoDestinatario(tipoSoggetto);
        integrazione.getBusta().setDestinatario(nomeSoggetto);
        String servizio = wsaTO.substring(indexSoggetto + ".openspcoop2.org/servizi/".length(), wsaTO.length());
        if (servizio == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Servizio non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        if (!servizio.contains("_")) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Servizio non identificabile, '_' non trovato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        String[] servizio_split = servizio.split("_");
        if (servizio_split == null || servizio_split.length < 2) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (Servizio non identificabile, formato errato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        String tipoServizio = servizio_split[0];
        String nomeServizio = servizio.substring((tipoServizio + "_").length());
        if (tipoServizio == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (TipoServizio non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        if (nomeServizio == null) {
            throw new HeaderIntegrazioneException("WSATO Value is not valid (NomeServizio non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>");
        }
        tipoServizio = tipoServizio.trim();
        nomeServizio = nomeServizio.trim();
        integrazione.getBusta().setTipoServizio(tipoServizio);
        integrazione.getBusta().setServizio(nomeServizio);
    }

    public static String buildDatiWSATo(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio) {
        return "http://" + tipoSoggettoErogatore + "_" + nomeSoggettoErogatore + ".openspcoop2.org/servizi/" + tipoServizio + "_" + nomeServizio;
    }

    public static SOAPHeaderElement buildWSATo(OpenSPCoop2Message msg, String actor, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio) throws Exception {
        QName name = new QName(WSA_NAMESPACE, WSA_SOAP_HEADER_TO, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement(msg, name, UtilitiesIntegrazioneWSAddressing.buildDatiWSATo(tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio), actor, false);
        return header;
    }

    public static void readDatiWSAFrom(String wsaFrom, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        int indexSoggetto;
        if (wsaFrom == null) {
            throw new HeaderIntegrazioneException("WSAFrom value is null");
        }
        if (!(wsaFrom = wsaFrom.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid: http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        if (!wsaFrom.contains(".openspcoop2.org")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid: http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        String soggetto = (wsaFrom = wsaFrom.substring(7, wsaFrom.length())).substring(0, indexSoggetto = wsaFrom.indexOf(".openspcoop2.org"));
        if (soggetto == null) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        if (!soggetto.contains("_")) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile, '_' non trovato ): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        String[] soggetto_split = soggetto.split("_");
        if (soggetto_split == null || soggetto_split.length < 2) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (Soggetto non identificabile, formato errato ): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        String tipoSoggetto = soggetto_split[0];
        String nomeSoggetto = soggetto.substring((tipoSoggetto + "_").length());
        if (tipoSoggetto == null) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (TipoSoggetto non identificabile): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        if (nomeSoggetto == null) {
            throw new HeaderIntegrazioneException("WSAFrom Value is not valid (NomeSoggetto non identificabile): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
        }
        if (tipoSoggetto.contains(".")) {
            String[] split = tipoSoggetto.split(".");
            tipoSoggetto = split[1];
            String sa = split[0];
            if (tipoSoggetto == null) {
                throw new HeaderIntegrazioneException("WSAFrom Value is not valid (TipoSoggetto non identificabile dopo parsing ServizioApplicativo): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
            }
            if (sa == null) {
                throw new HeaderIntegrazioneException("WSAFrom Value is not valid (ServizioApplicativo non identificabile): http://[<nomeServizioApplicativoFruitore>.]<tipoSoggettoFruitore>_<nomeSoggettoFruitore>.openspcoop2.org");
            }
            tipoSoggetto = tipoSoggetto.trim();
            sa = sa.trim();
            integrazione.setServizioApplicativo(sa);
        }
        tipoSoggetto = tipoSoggetto.trim();
        nomeSoggetto = nomeSoggetto.trim();
        integrazione.getBusta().setTipoMittente(tipoSoggetto);
        integrazione.getBusta().setMittente(nomeSoggetto);
    }

    public static String buildDatiWSAFrom(String servizioApplicativoFruitore, String tipoSoggetto, String nomeSoggetto) {
        if (servizioApplicativoFruitore == null) {
            return "http://" + tipoSoggetto + "_" + nomeSoggetto + ".openspcoop2.org";
        }
        return "http://" + servizioApplicativoFruitore + "." + tipoSoggetto + "_" + nomeSoggetto + ".openspcoop2.org";
    }

    public static SOAPHeaderElement buildWSAFrom(OpenSPCoop2Message msg, String actor, String servizioApplicativoFruitore, String tipoSoggetto, String nomeSoggetto) throws Exception {
        QName name = new QName(WSA_NAMESPACE, WSA_SOAP_HEADER_FROM, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement(msg, name, UtilitiesIntegrazioneWSAddressing.buildDatiWSAFrom(servizioApplicativoFruitore, tipoSoggetto, nomeSoggetto), actor, true);
        return header;
    }

    public static void readDatiWSAAction(String wsaAction, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        if (wsaAction == null) {
            throw new HeaderIntegrazioneException("WSAAction value is null");
        }
        if (!(wsaAction = wsaAction.trim()).startsWith("http://")) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid: http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        if (!wsaAction.contains(".openspcoop2.org/")) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid: http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        int indexSoggetto = wsaAction.indexOf(".openspcoop2.org/servizi/");
        String soggetto = wsaAction.substring(0, indexSoggetto);
        if (soggetto == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Soggetto non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        if (!soggetto.contains("_")) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Soggetto non identificabile, '_' non trovato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        String[] soggetto_split = soggetto.split("_");
        if (soggetto_split == null || soggetto_split.length < 2) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Soggetto non identificabile, formato errato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        String tipoSoggetto = soggetto_split[0];
        String nomeSoggetto = soggetto.substring((tipoSoggetto + "_").length());
        if (tipoSoggetto == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (TipoSoggetto non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        if (nomeSoggetto == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (NomeSoggetto non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        String servizio = wsaAction.substring(indexSoggetto + ".openspcoop2.org/servizi/".length(), wsaAction.length());
        if (servizio == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Servizio non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        if (!servizio.contains("_")) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Servizio non identificabile, '_' non trovato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        String[] servizio_split = servizio.split("_");
        if (servizio_split == null || servizio_split.length < 2) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Servizio non identificabile, formato errato ): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        String tipoServizio = servizio_split[0];
        String nomeServizio = servizio.substring((tipoServizio + "_").length());
        if (tipoServizio == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (TipoServizio non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        if (nomeServizio == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (NomeServizio non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        int indexServizi = wsaAction.indexOf(".openspcoop2.org/servizi/");
        String servizioAzione = wsaAction.substring(indexServizi + ".openspcoop2.org/servizi/".length(), wsaAction.length());
        int indexAzione = servizioAzione.indexOf("/");
        if (indexAzione <= 0) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Azione non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        String azione = servizioAzione.substring(indexAzione + 1, servizioAzione.length());
        if (azione == null) {
            throw new HeaderIntegrazioneException("WSAAction Value is not valid (Azione non identificabile): http://<tipoSoggettoErogatore>_<nomeSoggettoErogatore>.openspcoop2.org/servizi/<tipoServizio>_<nomeServizio>/<nomeAzione>");
        }
        integrazione.getBusta().setAzione(azione);
    }

    public static String buildDatiWSAAction(String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, String azione) {
        return "http://" + tipoSoggettoErogatore + "_" + nomeSoggettoErogatore + ".openspcoop2.org/servizi/" + tipoServizio + "_" + nomeServizio + "/" + azione;
    }

    public static SOAPHeaderElement buildWSAAction(OpenSPCoop2Message msg, String actor, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, String azione) throws Exception {
        QName name = new QName(WSA_NAMESPACE, WSA_SOAP_HEADER_ACTION, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement(msg, name, UtilitiesIntegrazioneWSAddressing.buildDatiWSAAction(tipoSoggettoErogatore, nomeSoggettoErogatore, tipoServizio, nomeServizio, azione), actor, false);
        return header;
    }

    public static void readDatiWSAID(String wsaID, HeaderIntegrazione integrazione, boolean interpretaComeIDBusta) throws HeaderIntegrazioneException {
        if (wsaID == null) {
            throw new HeaderIntegrazioneException("WSAID value is null");
        }
        if (!(wsaID = wsaID.trim()).startsWith("uuid:")) {
            throw new HeaderIntegrazioneException("WSAID Value is not valid: uuid:<id>");
        }
        wsaID = wsaID.substring(5, wsaID.length());
        if (interpretaComeIDBusta) {
            integrazione.getBusta().setID(wsaID);
        } else {
            integrazione.setIdApplicativo(wsaID);
        }
    }

    public static String buildDatiWSAID(String id) {
        return "uuid:" + id;
    }

    public static SOAPHeaderElement buildWSAID(OpenSPCoop2Message msg, String actor, String wsaID) throws Exception {
        QName name = new QName(WSA_NAMESPACE, WSA_SOAP_HEADER_ID, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement(msg, name, UtilitiesIntegrazioneWSAddressing.buildDatiWSAID(wsaID), actor, false);
        return header;
    }

    public static void readDatiWSARelatesTo(String wsaRelatesTo, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        if (wsaRelatesTo == null) {
            throw new HeaderIntegrazioneException("WSARelatesTo value is null");
        }
        if (!(wsaRelatesTo = wsaRelatesTo.trim()).startsWith("uuid:")) {
            throw new HeaderIntegrazioneException("WSARelatesTo Value is not valid: uuid:<id>");
        }
        wsaRelatesTo = wsaRelatesTo.substring(5, wsaRelatesTo.length());
        integrazione.getBusta().setRiferimentoMessaggio(wsaRelatesTo);
    }

    public static String buildDatiWSARelatesTo(String id) {
        return "uuid:" + id;
    }

    public static SOAPHeaderElement buildWSARelatesTo(OpenSPCoop2Message msg, String actor, String id) throws Exception {
        QName name = new QName(WSA_NAMESPACE, WSA_SOAP_HEADER_RELATES_TO, WSA_PREFIX);
        SOAPHeaderElement header = UtilitiesIntegrazioneWSAddressing.buildHeaderElement(msg, name, UtilitiesIntegrazioneWSAddressing.buildDatiWSARelatesTo(id), actor, false);
        return header;
    }

    private static SOAPHeaderElement buildHeaderElement(OpenSPCoop2Message msg, QName name, String value, String actor, boolean epr) throws Exception {
        SOAPHeader hdr = msg.getSOAPHeader();
        if (hdr == null) {
            hdr = msg.getSOAPPart().getEnvelope().addHeader();
        }
        SOAPHeaderElement element = msg.newSOAPHeaderElement(hdr, name);
        element.setActor(actor);
        element.setMustUnderstand(false);
        element.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        if (!epr) {
            element.setValue(value);
        } else {
            QName nameAddressEPR = new QName(WSA_NAMESPACE, WSA_SOAP_HEADER_EPR_ADDRESS, WSA_PREFIX);
            element.addChildElement(nameAddressEPR).setValue(value);
        }
        return element;
    }

    public static UtilitiesIntegrazioneWSAddressing getInstance(Logger log) {
        if (utilitiesIntegrazione == null) {
            UtilitiesIntegrazioneWSAddressing.initialize(log);
        }
        return utilitiesIntegrazione;
    }

    private static synchronized void initialize(Logger log) {
        if (utilitiesIntegrazione == null) {
            utilitiesIntegrazione = new UtilitiesIntegrazioneWSAddressing(log);
        }
    }

    private UtilitiesIntegrazioneWSAddressing(Logger log) {
        try {
            this.validatoreXSD = new ValidatoreXSD(log, UtilitiesIntegrazione.class.getResourceAsStream("/ws-addr.xsd"));
        }
        catch (Exception e) {
            log.error((Object)("ws-addr.xsd, errore durante la costruzione del validatore xsd: " + e.getMessage()), (Throwable)e);
        }
    }

    public void readHeader(OpenSPCoop2Message message, HeaderIntegrazione integrazione, boolean interpretaIDComeIDBusta, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                String actor = headerElement.getActor();
                if (!actorIntegrazione.equals(actor) || !WSA_NAMESPACE.equals(namespace)) continue;
                log.debug((Object)("Trovato header WSAddressing [" + headerElement.getLocalName() + "]"));
                if (WSA_SOAP_HEADER_TO.equals(headerElement.getLocalName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_FROM.equals(headerElement.getLocalName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ACTION.equals(headerElement.getLocalName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ID.equals(headerElement.getLocalName())) {
                    wsaID = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_RELATES_TO.equals(headerElement.getLocalName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                log.debug((Object)"Header non conosciuto");
            }
            if (wsaTO == null && wsaFROM == null && wsaAction == null && wsaID == null && wsaRelatesTo == null) {
                log.debug((Object)"Header di integrazione non presente");
                return;
            }
            log.debug((Object)"Validazione XSD...");
            this.validaElementoWSA(this.validatoreXSD, wsaTO, log, message);
            this.validaElementoWSA(this.validatoreXSD, wsaFROM, log, message);
            this.validaElementoWSA(this.validatoreXSD, wsaAction, log, message);
            this.validaElementoWSA(this.validatoreXSD, wsaID, log, message);
            this.validaElementoWSA(this.validatoreXSD, wsaRelatesTo, log, message);
            log.debug((Object)"Validazione XSD effettuate");
            if (wsaTO != null) {
                log.debug((Object)"Read dati da WSATo...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSATo(wsaTO.getValue(), integrazione);
            }
            if (wsaFROM != null) {
                log.debug((Object)"Read dati da WSAFrom...");
                Iterator itFROM = wsaFROM.getChildElements();
                while (itFROM.hasNext()) {
                    SOAPElement s;
                    Object o = itFROM.next();
                    if (o == null || !(o instanceof SOAPElement) || !WSA_SOAP_HEADER_EPR_ADDRESS.equals((s = (SOAPElement)o).getLocalName())) continue;
                    UtilitiesIntegrazioneWSAddressing.readDatiWSAFrom(s.getValue(), integrazione);
                    break;
                }
            }
            if (wsaAction != null) {
                log.debug((Object)"Read dati da WSAAction...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAAction(wsaAction.getValue(), integrazione);
            }
            if (wsaID != null) {
                log.debug((Object)"Read dati da WSAId...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSAID(wsaID.getValue(), integrazione, interpretaIDComeIDBusta);
            }
            if (wsaRelatesTo != null) {
                log.debug((Object)"Read dati da WSARelatesTo...");
                UtilitiesIntegrazioneWSAddressing.readDatiWSARelatesTo(wsaRelatesTo.getValue(), integrazione);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    private void validaElementoWSA(ValidatoreXSD validatoreXSD, SOAPHeaderElement headerElement, Logger log, OpenSPCoop2Message msg) throws Exception {
        if (headerElement != null) {
            log.debug((Object)("Validazione XSD [" + headerElement.getLocalName() + "]..."));
            if (validatoreXSD == null) {
                throw new Exception("Validatore XSD non istanziato");
            }
            validatoreXSD.valida((InputStream)new ByteArrayInputStream(msg.getAsByte((Node)headerElement, false)));
        }
    }

    public void updateHeader(OpenSPCoop2Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String servizioApplicativo, String correlazioneApplicativa, String actorIntegrazione) throws Exception {
        this.updateHeader(message, soggettoFruitore, idServizio, idBusta, null, servizioApplicativo, correlazioneApplicativa, actorIntegrazione);
    }

    public void updateHeader(OpenSPCoop2Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String idBustaRisposta, String servizioApplicativo, String correlazioneApplicativa, String actorIntegrazione) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione();
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneBusta busta = new HeaderIntegrazioneBusta();
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        busta.setTipoServizio(idServizio.getTipoServizio());
        busta.setServizio(idServizio.getServizio());
        busta.setAzione(idServizio.getAzione());
        if (idBustaRisposta == null) {
            busta.setID(idBusta);
        } else {
            busta.setID(idBustaRisposta);
            busta.setRiferimentoMessaggio(idBusta);
        }
        integrazione.setBusta(busta);
        this.updateHeader(message, integrazione, actorIntegrazione);
    }

    public void updateHeader(OpenSPCoop2Message message, HeaderIntegrazione integrazione, String actorIntegrazione) throws Exception {
        SOAPHeader header = message.getSOAPHeader();
        SOAPHeaderElement wsaTO = null;
        SOAPHeaderElement wsaFROM = null;
        SOAPHeaderElement wsaAction = null;
        SOAPHeaderElement wsaID = null;
        SOAPHeaderElement wsaRelatesTo = null;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (header == null) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente: add soapHeader");
            header = message.getSOAPPart().getEnvelope().addHeader();
        } else {
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                if (!WSA_NAMESPACE.equals(namespace)) continue;
                log.debug((Object)("Trovato header WSAddressing [" + headerElement.getLocalName() + "]"));
                if (WSA_SOAP_HEADER_TO.equals(headerElement.getLocalName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_FROM.equals(headerElement.getLocalName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ACTION.equals(headerElement.getLocalName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ID.equals(headerElement.getLocalName())) {
                    wsaID = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_RELATES_TO.equals(headerElement.getLocalName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                log.debug((Object)"Header non conosciuto");
            }
        }
        if (integrazione.getBusta() != null) {
            HeaderIntegrazioneBusta hBusta = integrazione.getBusta();
            if (hBusta.getDestinatario() != null && hBusta.getServizio() != null) {
                if (wsaTO != null) {
                    wsaTO.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSATo(hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio()));
                } else {
                    wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(message, actorIntegrazione, hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio());
                    message.addHeaderElement(header, wsaTO);
                }
                if (hBusta.getAzione() != null) {
                    if (wsaAction != null) {
                        wsaAction.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAAction(hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getAzione()));
                    } else {
                        wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(message, actorIntegrazione, hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getAzione());
                        message.addHeaderElement(header, wsaTO);
                    }
                }
            }
            if (hBusta.getMittente() != null) {
                if (wsaFROM != null) {
                    Iterator itFROM = wsaFROM.getChildElements();
                    while (itFROM.hasNext()) {
                        SOAPElement s;
                        Object o = itFROM.next();
                        if (o == null || !(o instanceof SOAPElement) || !WSA_SOAP_HEADER_EPR_ADDRESS.equals((s = (SOAPElement)o).getLocalName())) continue;
                        s.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAFrom(integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente()));
                        break;
                    }
                } else {
                    wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(message, actorIntegrazione, integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente());
                    message.addHeaderElement(header, wsaFROM);
                }
            }
            if (hBusta.getID() != null) {
                if (wsaID != null) {
                    wsaID.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSAID(hBusta.getID()));
                } else {
                    wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(message, actorIntegrazione, hBusta.getID());
                    message.addHeaderElement(header, wsaID);
                }
            }
            if (hBusta.getRiferimentoMessaggio() != null || hBusta.getIdCollaborazione() != null) {
                String rif = hBusta.getRiferimentoMessaggio();
                if (rif == null) {
                    rif = hBusta.getIdCollaborazione();
                }
                if (wsaRelatesTo != null) {
                    wsaRelatesTo.setValue(UtilitiesIntegrazioneWSAddressing.buildDatiWSARelatesTo(rif));
                } else {
                    wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(message, actorIntegrazione, rif);
                    message.addHeaderElement(header, wsaRelatesTo);
                }
            }
        }
    }

    public void deleteHeader(OpenSPCoop2Message message, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                String actor = headerElement.getActor();
                if (!actorIntegrazione.equals(actor) || !WSA_NAMESPACE.equals(namespace)) continue;
                log.debug((Object)("Trovato header WSAddressing [" + headerElement.getLocalName() + "]"));
                if (WSA_SOAP_HEADER_TO.equals(headerElement.getLocalName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_FROM.equals(headerElement.getLocalName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ACTION.equals(headerElement.getLocalName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_ID.equals(headerElement.getLocalName())) {
                    wsaID = headerElement;
                    continue;
                }
                if (WSA_SOAP_HEADER_RELATES_TO.equals(headerElement.getLocalName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                log.debug((Object)"Header non conosciuto");
            }
            if (wsaTO == null && wsaFROM == null && wsaAction == null && wsaID == null && wsaRelatesTo == null) {
                log.debug((Object)"Header di integrazione non presente");
                return;
            }
            if (wsaTO != null) {
                header.removeChild(wsaTO);
            }
            if (wsaFROM != null) {
                header.removeChild(wsaFROM);
            }
            if (wsaAction != null) {
                header.removeChild(wsaAction);
            }
            if (wsaID != null) {
                header.removeChild(wsaID);
            }
            if (wsaRelatesTo != null) {
                header.removeChild(wsaRelatesTo);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }
}

