/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.ValidatoreXSD;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;

public class UtilitiesIntegrazione {
    private static UtilitiesIntegrazione utilitiesIntegrazione = null;
    private Properties keyValueIntegrazioneTrasporto = null;
    private Properties keyValueIntegrazioneUrlBased = null;
    private Properties keyValueIntegrazioneSoap = null;
    private OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private ValidatoreXSD validatoreXSD = null;

    public static UtilitiesIntegrazione getInstance(Logger log) {
        if (utilitiesIntegrazione == null) {
            UtilitiesIntegrazione.initialize(log);
        }
        return utilitiesIntegrazione;
    }

    private static synchronized void initialize(Logger log) {
        if (utilitiesIntegrazione == null) {
            utilitiesIntegrazione = new UtilitiesIntegrazione(log);
        }
    }

    private UtilitiesIntegrazione(Logger log) {
        this.keyValueIntegrazioneTrasporto = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneTrasporto();
        this.keyValueIntegrazioneUrlBased = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneUrlBased();
        this.keyValueIntegrazioneSoap = this.openspcoopProperties.getKeyValue_HeaderIntegrazioneSoap();
        try {
            XSDResourceResolver xsdResourceResolver = new XSDResourceResolver();
            xsdResourceResolver.addResource("soapEnvelope.xsd", UtilitiesIntegrazione.class.getResourceAsStream("/soapEnvelope.xsd"));
            this.validatoreXSD = new ValidatoreXSD(log, (LSResourceResolver)xsdResourceResolver, UtilitiesIntegrazione.class.getResourceAsStream("/integrazione.xsd"));
        }
        catch (Exception e) {
            log.error((Object)("Integrazione.xsd, errore durante la costruzione del validatore xsd: " + e.getMessage()), (Throwable)e);
        }
    }

    public ValidatoreXSD getValidatoreXSD() {
        return this.validatoreXSD;
    }

    public void readTransportProperties(Properties prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                Enumeration<?> keys = prop.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key == null) continue;
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("tipoMittente"))) {
                        integrazione.getBusta().setTipoMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("mittente"))) {
                        integrazione.getBusta().setMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("tipoDestinatario"))) {
                        integrazione.getBusta().setTipoDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("destinatario"))) {
                        integrazione.getBusta().setDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("tipoServizio"))) {
                        integrazione.getBusta().setTipoServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("servizio"))) {
                        integrazione.getBusta().setServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("azione"))) {
                        integrazione.getBusta().setAzione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("identificativo"))) {
                        integrazione.getBusta().setID(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("riferimentoMessaggio"))) {
                        integrazione.getBusta().setRiferimentoMessaggio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("idCollaborazione"))) {
                        integrazione.getBusta().setIdCollaborazione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("idApplicativo"))) {
                        integrazione.setIdApplicativo(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("idApplicativoRichiesta"))) {
                        integrazione.setRiferimentoIdApplicativoRichiesta(prop.getProperty(key));
                        continue;
                    }
                    if (!key.equalsIgnoreCase((String)this.keyValueIntegrazioneTrasporto.get("servizioApplicativo"))) continue;
                    integrazione.setServizioApplicativo(prop.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readUrlProperties(Properties prop, HeaderIntegrazione integrazione) throws HeaderIntegrazioneException {
        try {
            if (prop != null && integrazione != null) {
                Enumeration<?> keys = prop.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (key == null) continue;
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("tipoMittente"))) {
                        integrazione.getBusta().setTipoMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("mittente"))) {
                        integrazione.getBusta().setMittente(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("tipoDestinatario"))) {
                        integrazione.getBusta().setTipoDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("destinatario"))) {
                        integrazione.getBusta().setDestinatario(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("tipoServizio"))) {
                        integrazione.getBusta().setTipoServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("servizio"))) {
                        integrazione.getBusta().setServizio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("azione"))) {
                        integrazione.getBusta().setAzione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("identificativo"))) {
                        integrazione.getBusta().setID(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("riferimentoMessaggio"))) {
                        integrazione.getBusta().setRiferimentoMessaggio(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("idCollaborazione"))) {
                        integrazione.getBusta().setIdCollaborazione(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("idApplicativo"))) {
                        integrazione.setIdApplicativo(prop.getProperty(key));
                        continue;
                    }
                    if (key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("idApplicativoRichiesta"))) {
                        integrazione.setRiferimentoIdApplicativoRichiesta(prop.getProperty(key));
                        continue;
                    }
                    if (!key.equalsIgnoreCase((String)this.keyValueIntegrazioneUrlBased.get("servizioApplicativo"))) continue;
                    integrazione.setServizioApplicativo(prop.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setRequestUrlProperties(HeaderIntegrazione integrazione, Properties properties, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        this.setUrlProperties(integrazione, properties, true, false, protocolInfos);
    }

    public void setResponseUrlProperties(HeaderIntegrazione integrazione, Properties properties, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        this.setUrlProperties(integrazione, properties, false, true, protocolInfos);
    }

    private void setUrlProperties(HeaderIntegrazione integrazione, Properties properties, boolean request, boolean response, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getBusta() != null) {
                    if (integrazione.getBusta().getTipoMittente() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("tipoMittente"), integrazione.getBusta().getTipoMittente());
                    }
                    if (integrazione.getBusta().getMittente() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("mittente"), integrazione.getBusta().getMittente());
                    }
                    if (integrazione.getBusta().getTipoDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("tipoDestinatario"), integrazione.getBusta().getTipoDestinatario());
                    }
                    if (integrazione.getBusta().getDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("destinatario"), integrazione.getBusta().getDestinatario());
                    }
                    if (integrazione.getBusta().getTipoServizio() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("tipoServizio"), integrazione.getBusta().getTipoServizio());
                    }
                    if (integrazione.getBusta().getServizio() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("servizio"), integrazione.getBusta().getServizio());
                    }
                    if (integrazione.getBusta().getAzione() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("azione"), integrazione.getBusta().getAzione());
                    }
                    if (integrazione.getBusta().getID() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("identificativo"), integrazione.getBusta().getID());
                    }
                    if (integrazione.getBusta().getRiferimentoMessaggio() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("riferimentoMessaggio"), integrazione.getBusta().getRiferimentoMessaggio());
                    }
                    if (integrazione.getBusta().getIdCollaborazione() != null) {
                        properties.put(this.keyValueIntegrazioneUrlBased.get("idCollaborazione"), integrazione.getBusta().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneUrlBased.get("idApplicativo"), integrazione.getIdApplicativo());
                }
                if (integrazione.getRiferimentoIdApplicativoRichiesta() != null) {
                    properties.put(this.keyValueIntegrazioneUrlBased.get("idApplicativoRichiesta"), integrazione.getRiferimentoIdApplicativoRichiesta());
                }
                if (integrazione.getServizioApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneUrlBased.get("servizioApplicativo"), integrazione.getServizioApplicativo());
                }
            }
            if (properties != null) {
                properties.put("OpenSPCoop2Pdd", this.openspcoopProperties.getHttpServer());
                if (this.openspcoopProperties.getHttpXPdDDetails() != null && !"".equals(this.openspcoopProperties.getHttpXPdDDetails())) {
                    properties.put("OpenSPCoop2DettagliPdd", this.openspcoopProperties.getHttpXPdDDetails());
                }
                if (protocolInfos != null && protocolInfos.size() > 0) {
                    for (String name : protocolInfos.keySet()) {
                        String value = protocolInfos.get(name);
                        properties.put(name, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void setRequestTransportProperties(HeaderIntegrazione integrazione, Properties properties, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        this.setTransportProperties(integrazione, properties, true, false, protocolInfos);
    }

    public void setResponseTransportProperties(HeaderIntegrazione integrazione, Properties properties, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        this.setTransportProperties(integrazione, properties, false, true, protocolInfos);
    }

    private void setTransportProperties(HeaderIntegrazione integrazione, Properties properties, boolean request, boolean response, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        try {
            if (properties != null && integrazione != null) {
                if (integrazione.getBusta() != null) {
                    if (integrazione.getBusta().getTipoMittente() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("tipoMittente"), integrazione.getBusta().getTipoMittente());
                    }
                    if (integrazione.getBusta().getMittente() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("mittente"), integrazione.getBusta().getMittente());
                    }
                    if (integrazione.getBusta().getTipoDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("tipoDestinatario"), integrazione.getBusta().getTipoDestinatario());
                    }
                    if (integrazione.getBusta().getDestinatario() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("destinatario"), integrazione.getBusta().getDestinatario());
                    }
                    if (integrazione.getBusta().getTipoServizio() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("tipoServizio"), integrazione.getBusta().getTipoServizio());
                    }
                    if (integrazione.getBusta().getServizio() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("servizio"), integrazione.getBusta().getServizio());
                    }
                    if (integrazione.getBusta().getAzione() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("azione"), integrazione.getBusta().getAzione());
                    }
                    if (integrazione.getBusta().getID() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("identificativo"), integrazione.getBusta().getID());
                    }
                    if (integrazione.getBusta().getRiferimentoMessaggio() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("riferimentoMessaggio"), integrazione.getBusta().getRiferimentoMessaggio());
                    }
                    if (integrazione.getBusta().getIdCollaborazione() != null) {
                        properties.put(this.keyValueIntegrazioneTrasporto.get("idCollaborazione"), integrazione.getBusta().getIdCollaborazione());
                    }
                }
                if (integrazione.getIdApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneTrasporto.get("idApplicativo"), integrazione.getIdApplicativo());
                }
                if (integrazione.getRiferimentoIdApplicativoRichiesta() != null) {
                    properties.put(this.keyValueIntegrazioneTrasporto.get("idApplicativoRichiesta"), integrazione.getRiferimentoIdApplicativoRichiesta());
                }
                if (integrazione.getServizioApplicativo() != null) {
                    properties.put(this.keyValueIntegrazioneTrasporto.get("servizioApplicativo"), integrazione.getServizioApplicativo());
                }
            }
            if (properties != null) {
                if (request) {
                    properties.put("User-Agent", this.openspcoopProperties.getHttpUserAgent());
                }
                properties.put("X-OpenSPCoop2-Pdd", this.openspcoopProperties.getHttpServer());
                if (this.openspcoopProperties.getHttpXPdDDetails() != null && !"".equals(this.openspcoopProperties.getHttpXPdDDetails())) {
                    properties.put("X-OpenSPCoop2-PddDetails", this.openspcoopProperties.getHttpXPdDDetails());
                }
                if (protocolInfos != null && protocolInfos.size() > 0) {
                    for (String name : protocolInfos.keySet()) {
                        String value = protocolInfos.get(name);
                        properties.put(name, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione delle proprieta' dell'header non riuscita: " + e.getMessage(), e);
        }
    }

    public void readHeader(OpenSPCoop2Message message, HeaderIntegrazione integrazione, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerElement = (SOAPHeaderElement)it.next()).getActor())) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente");
                return;
            }
            if (this.validatoreXSD == null) {
                throw new Exception("Validatore XSD non istanziato");
            }
            this.validatoreXSD.valida((InputStream)new ByteArrayInputStream(message.getAsByte((Node)headerElement, false)));
            String tipoMittente = null;
            try {
                tipoMittente = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("tipoMittente"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoMittente != null && tipoMittente.compareTo("") != 0) {
                integrazione.getBusta().setTipoMittente(tipoMittente);
            }
            String mittente = null;
            try {
                mittente = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("mittente"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (mittente != null && mittente.compareTo("") != 0) {
                integrazione.getBusta().setMittente(mittente);
            }
            String tipoDestinatario = null;
            try {
                tipoDestinatario = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("tipoDestinatario"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoDestinatario != null && tipoDestinatario.compareTo("") != 0) {
                integrazione.getBusta().setTipoDestinatario(tipoDestinatario);
            }
            String destinatario = null;
            try {
                destinatario = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("destinatario"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (destinatario != null && destinatario.compareTo("") != 0) {
                integrazione.getBusta().setDestinatario(destinatario);
            }
            String tipoServizio = null;
            try {
                tipoServizio = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("tipoServizio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (tipoServizio != null && tipoServizio.compareTo("") != 0) {
                integrazione.getBusta().setTipoServizio(tipoServizio);
            }
            String servizio = null;
            try {
                servizio = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("servizio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (servizio != null && servizio.compareTo("") != 0) {
                integrazione.getBusta().setServizio(servizio);
            }
            String azione = null;
            try {
                azione = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("azione"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (azione != null && azione.compareTo("") != 0) {
                integrazione.getBusta().setAzione(azione);
            }
            String idBusta = null;
            try {
                idBusta = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("identificativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idBusta != null && idBusta.compareTo("") != 0) {
                integrazione.getBusta().setID(idBusta);
            }
            String riferimentoMessaggio = null;
            try {
                riferimentoMessaggio = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("riferimentoMessaggio"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (riferimentoMessaggio != null && riferimentoMessaggio.compareTo("") != 0) {
                integrazione.getBusta().setRiferimentoMessaggio(riferimentoMessaggio);
            }
            String collaborazione = null;
            try {
                collaborazione = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("idCollaborazione"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (collaborazione != null && collaborazione.compareTo("") != 0) {
                integrazione.getBusta().setIdCollaborazione(collaborazione);
            }
            String idApplicativo = null;
            try {
                idApplicativo = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("idApplicativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idApplicativo != null && idApplicativo.compareTo("") != 0) {
                integrazione.setIdApplicativo(idApplicativo);
            }
            String riferimentoIdApplicativoRichiesta = null;
            try {
                riferimentoIdApplicativoRichiesta = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("idApplicativoRichiesta"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (riferimentoIdApplicativoRichiesta != null && riferimentoIdApplicativoRichiesta.compareTo("") != 0) {
                integrazione.setRiferimentoIdApplicativoRichiesta(riferimentoIdApplicativoRichiesta);
            }
            String sa = null;
            try {
                sa = headerElement.getAttribute((String)this.keyValueIntegrazioneSoap.get("servizioApplicativo"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (sa != null && sa.compareTo("") != 0) {
                integrazione.setServizioApplicativo(sa);
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, lettura dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void updateHeader(OpenSPCoop2Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta, String actorIntegrazione, String nomeElemento, String prefix, String namespace, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws Exception {
        this.updateHeader(message, soggettoFruitore, idServizio, idBusta, null, servizioApplicativo, correlazioneApplicativa, riferimentoCorrelazioneApplicativaRichiesta, actorIntegrazione, nomeElemento, prefix, namespace, proprietaProtocolloNomeElemento, proprietaProtocolloNomeTipoElemento, protocolInfos);
    }

    public void updateHeader(OpenSPCoop2Message message, IDSoggetto soggettoFruitore, IDServizio idServizio, String idBusta, String idBustaRisposta, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta, String actorIntegrazione, String nomeElemento, String prefix, String namespace, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws Exception {
        HeaderIntegrazione integrazione = new HeaderIntegrazione();
        integrazione.setIdApplicativo(correlazioneApplicativa);
        integrazione.setRiferimentoIdApplicativoRichiesta(riferimentoCorrelazioneApplicativaRichiesta);
        integrazione.setServizioApplicativo(servizioApplicativo);
        HeaderIntegrazioneBusta busta = new HeaderIntegrazioneBusta();
        busta.setTipoMittente(soggettoFruitore.getTipo());
        busta.setMittente(soggettoFruitore.getNome());
        busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
        busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
        busta.setTipoServizio(idServizio.getTipoServizio());
        busta.setServizio(idServizio.getServizio());
        busta.setAzione(idServizio.getAzione());
        if (idBustaRisposta == null) {
            busta.setID(idBusta);
        } else {
            busta.setID(idBustaRisposta);
            busta.setRiferimentoMessaggio(idBusta);
        }
        integrazione.setBusta(busta);
        this.updateHeader(message, integrazione, actorIntegrazione, nomeElemento, prefix, namespace, proprietaProtocolloNomeElemento, proprietaProtocolloNomeTipoElemento, protocolInfos);
    }

    public void updateHeader(OpenSPCoop2Message message, HeaderIntegrazione integrazione, String actorIntegrazione, String nomeElemento, String prefix, String namespace, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws Exception {
        SOAPElement tmp;
        if (actorIntegrazione == null) {
            throw new Exception("Actor non definito");
        }
        SOAPHeader header = message.getSOAPHeader();
        SOAPHeaderElement headerIntegrazione = null;
        if (header == null) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente: add soapHeader");
            header = message.getSOAPPart().getEnvelope().addHeader();
        } else {
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerIntegrazione = (SOAPHeaderElement)it.next()).getActor())) {
                headerIntegrazione = null;
            }
            if (headerIntegrazione == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente, lo creo");
            }
        }
        Vector<SOAPElement> v = new Vector<SOAPElement>();
        if (headerIntegrazione != null) {
            Iterator it = headerIntegrazione.getChildElements();
            if (it.hasNext()) {
                tmp = (SOAPElement)it.next();
                v.add(tmp);
            }
            header.removeChild((Node)headerIntegrazione);
        }
        SOAPHeaderElement headerIntegrazioneNEW = this.buildHeader(integrazione, nomeElemento, prefix, namespace, actorIntegrazione, message, proprietaProtocolloNomeElemento, proprietaProtocolloNomeTipoElemento, protocolInfos);
        while (v.size() > 0) {
            tmp = (SOAPElement)v.remove(0);
            headerIntegrazioneNEW.addChildElement(tmp);
        }
        message.addHeaderElement(header, headerIntegrazioneNEW);
    }

    public SOAPHeaderElement buildHeader(HeaderIntegrazione integrazione, String nomeElemento, String prefix, String namespace, String actor, OpenSPCoop2Message m, String proprietaProtocolloNomeElemento, String proprietaProtocolloNomeTipoElemento, Map<String, String> protocolInfos) throws HeaderIntegrazioneException {
        try {
            SOAPHeader soapHeader = m.getSOAPHeader();
            if (soapHeader == null) {
                soapHeader = m.getSOAPPart().getEnvelope().addHeader();
            }
            SOAPHeaderElement header = m.newSOAPHeaderElement(soapHeader, new QName(namespace, nomeElemento, prefix));
            header.setActor(actor);
            header.setMustUnderstand(false);
            header.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            this.setAttributes(integrazione, header);
            if (protocolInfos != null && protocolInfos.size() > 0) {
                for (String name : protocolInfos.keySet()) {
                    String value = protocolInfos.get(name);
                    SOAPElement element = header.addChildElement(new QName(namespace, proprietaProtocolloNomeElemento, prefix));
                    element.setTextContent(value);
                    SOAPElement attribute = element.addAttribute(new QName(proprietaProtocolloNomeTipoElemento), name);
                }
            }
            return header;
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, creazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }

    public void setAttributes(HeaderIntegrazione integrazione, SOAPHeaderElement header) {
        if (integrazione.getBusta() != null) {
            if (integrazione.getBusta().getTipoMittente() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("tipoMittente"), integrazione.getBusta().getTipoMittente());
            }
            if (integrazione.getBusta().getMittente() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("mittente"), integrazione.getBusta().getMittente());
            }
            if (integrazione.getBusta().getTipoDestinatario() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("tipoDestinatario"), integrazione.getBusta().getTipoDestinatario());
            }
            if (integrazione.getBusta().getDestinatario() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("destinatario"), integrazione.getBusta().getDestinatario());
            }
            if (integrazione.getBusta().getTipoServizio() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("tipoServizio"), integrazione.getBusta().getTipoServizio());
            }
            if (integrazione.getBusta().getServizio() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("servizio"), integrazione.getBusta().getServizio());
            }
            if (integrazione.getBusta().getAzione() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("azione"), integrazione.getBusta().getAzione());
            }
            if (integrazione.getBusta().getID() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("identificativo"), integrazione.getBusta().getID());
            }
            if (integrazione.getBusta().getRiferimentoMessaggio() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("riferimentoMessaggio"), integrazione.getBusta().getRiferimentoMessaggio());
            }
            if (integrazione.getBusta().getIdCollaborazione() != null) {
                header.setAttribute((String)this.keyValueIntegrazioneSoap.get("idCollaborazione"), integrazione.getBusta().getIdCollaborazione());
            }
        }
        if (integrazione.getIdApplicativo() != null) {
            header.setAttribute((String)this.keyValueIntegrazioneSoap.get("idApplicativo"), integrazione.getIdApplicativo());
        }
        if (integrazione.getRiferimentoIdApplicativoRichiesta() != null) {
            header.setAttribute((String)this.keyValueIntegrazioneSoap.get("idApplicativoRichiesta"), integrazione.getRiferimentoIdApplicativoRichiesta());
        }
        if (integrazione.getServizioApplicativo() != null) {
            header.setAttribute((String)this.keyValueIntegrazioneSoap.get("servizioApplicativo"), integrazione.getServizioApplicativo());
        }
        header.setAttribute("OpenSPCoop2Pdd", this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDVersione());
        if (this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails() != null && !"".equals(this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails())) {
            header.setAttribute("OpenSPCoop2PddDetails", this.openspcoopProperties.getHeaderIntegrazioneSOAPPdDDetails());
        }
    }

    public void deleteHeader(OpenSPCoop2Message message, String actorIntegrazione) throws HeaderIntegrazioneException {
        try {
            if (actorIntegrazione == null) {
                throw new Exception("Actor non definito");
            }
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"SOAPHeader non presente");
                return;
            }
            SOAPHeaderElement headerElement = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext() && !actorIntegrazione.equals((headerElement = (SOAPHeaderElement)it.next()).getActor())) {
                headerElement = null;
            }
            if (headerElement == null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug((Object)"Header di integrazione non presente");
                return;
            }
            header.removeChild((Node)headerElement);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("UtilitiesIntegrazione, eliminazione dell'header soap non riuscita: " + e.getMessage(), e);
        }
    }
}

