/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazioneWSAddressing;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class GestoreIntegrazionePDWSAddressing
extends AbstractCore
implements IGestoreIntegrazionePDSoap {
    UtilitiesIntegrazioneWSAddressing utilities = null;
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePDWSAddressing() {
        if (this.log == null) {
            this.log = Logger.getLogger(GestoreIntegrazionePDWSAddressing.class);
        }
        try {
            this.utilities = UtilitiesIntegrazioneWSAddressing.getInstance(this.log);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'inizializzazione delle UtilitiesIntegrazioneWSAddressing: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inRequestPDMessage.getMessage(), integrazione, false, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDWSAddressing, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInRequestHeader(InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inRequestPDMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInRequestHeader(InRequestPDMessage inRequestPDMessage, IDServizio idServizio, String idMessaggio, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inRequestPDMessage.getMessage(), inRequestPDMessage.getSoggettoPropeprietarioPortaDelegata(), idServizio, idMessaggio, servizioApplicativo, correlazioneApplicativa, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDWSAddressing, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPDMessage outRequestPDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inResponsePDMessage.getMessage(), integrazione, true, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDWSAddressing, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInResponseHeader(InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inResponsePDMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInResponseHeader(InResponsePDMessage inResponsePDMessage, String idMessageRequest, String idMessageResponse, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inResponsePDMessage.getMessage(), inResponsePDMessage.getSoggettoMittente(), inResponsePDMessage.getServizio(), idMessageRequest, idMessageResponse, servizioApplicativo, correlazioneApplicativa, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDWSAddressing, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePDMessage outResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message message = outResponsePDMessage.getMessage();
            if (message.getSOAPHeader() == null) {
                message.getSOAPPart().getEnvelope().addHeader();
            }
            if (integrazione.getBusta() != null) {
                HeaderIntegrazioneBusta hBusta = integrazione.getBusta();
                if (hBusta.getDestinatario() != null && hBusta.getServizio() != null) {
                    SOAPHeaderElement wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio());
                    message.addHeaderElement(message.getSOAPHeader(), wsaTO);
                    if (hBusta.getAzione() != null) {
                        SOAPHeaderElement wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getAzione());
                        message.addHeaderElement(message.getSOAPHeader(), wsaAction);
                    }
                }
                if (hBusta.getMittente() != null) {
                    SOAPHeaderElement wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente());
                    message.addHeaderElement(message.getSOAPHeader(), wsaFROM);
                }
                if (hBusta.getID() != null) {
                    SOAPHeaderElement wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getID());
                    message.addHeaderElement(message.getSOAPHeader(), wsaID);
                }
                if (hBusta.getRiferimentoMessaggio() != null || hBusta.getIdCollaborazione() != null) {
                    String rif = hBusta.getRiferimentoMessaggio();
                    if (rif == null) {
                        rif = hBusta.getIdCollaborazione();
                    }
                    SOAPHeaderElement wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", rif);
                    message.addHeaderElement(message.getSOAPHeader(), wsaRelatesTo);
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDWSAddressing, " + e.getMessage(), e);
        }
    }
}

