/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import org.apache.log4j.Logger;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;

public class GestoreIntegrazionePDTrasporto
extends AbstractCore
implements IGestoreIntegrazionePD {
    UtilitiesIntegrazione utilities = null;
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePDTrasporto() {
        if (this.log == null) {
            this.log = Logger.getLogger(GestoreIntegrazionePDTrasporto.class);
        }
        try {
            this.utilities = UtilitiesIntegrazione.getInstance(this.log);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readTransportProperties(inRequestPDMessage.getUrlProtocolContext().getParametersTrasporto(), integrazione);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDTrasporto, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPDMessage outRequestPDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePDMessage outResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.setResponseTransportProperties(integrazione, outResponsePDMessage.getProprietaTrasporto(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outResponsePDMessage.getBustaRichiesta(), false, TipoIntegrazione.TRASPORTO));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDTrasporto, " + e.getMessage(), e);
        }
    }
}

