/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;

public class GestoreIntegrazionePDSoap
extends AbstractCore
implements IGestoreIntegrazionePDSoap {
    UtilitiesIntegrazione utilities = null;
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePDSoap() {
        if (this.log == null) {
            this.log = Logger.getLogger(GestoreIntegrazionePDSoap.class);
        }
        try {
            this.utilities = UtilitiesIntegrazione.getInstance(this.log);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inRequestPDMessage.getMessage(), integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInRequestHeader(InRequestPDMessage inRequestPDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inRequestPDMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInRequestHeader(InRequestPDMessage inRequestPDMessage, IDServizio idServizio, String idMessaggio, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inRequestPDMessage.getMessage(), inRequestPDMessage.getSoggettoPropeprietarioPortaDelegata(), idServizio, idMessaggio, servizioApplicativo, correlazioneApplicativa, null, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inRequestPDMessage.getBustaRichiesta(), true, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPDMessage outRequestPDMessage) throws HeaderIntegrazioneException {
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inResponsePDMessage.getMessage(), integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInResponseHeader(InResponsePDMessage inResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inResponsePDMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInResponseHeader(InResponsePDMessage inResponsePDMessage, String idMessageRequest, String idMessageResponse, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inResponsePDMessage.getMessage(), inResponsePDMessage.getSoggettoMittente(), inResponsePDMessage.getServizio(), idMessageRequest, idMessageResponse, servizioApplicativo, correlazioneApplicativa, riferimentoCorrelazioneApplicativaRichiesta, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inResponsePDMessage.getBustaRichiesta(), false, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePDMessage outResponsePDMessage) throws HeaderIntegrazioneException {
        try {
            SOAPHeaderElement header = this.utilities.buildHeader(integrazione, this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), outResponsePDMessage.getMessage(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outResponsePDMessage.getBustaRichiesta(), false, TipoIntegrazione.SOAP));
            if (outResponsePDMessage.getMessage().getSOAPHeader() == null) {
                outResponsePDMessage.getMessage().getSOAPPart().getEnvelope().addHeader();
            }
            outResponsePDMessage.getMessage().addHeaderElement(outResponsePDMessage.getMessage().getSOAPHeader(), header);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePDSoap, " + e.getMessage(), e);
        }
    }
}

