/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import javax.xml.soap.SOAPHeaderElement;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.integrazione.GestoreIntegrazionePAWSAddressing;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazioneWSAddressing;

public class GestoreIntegrazionePAWSAddressingWithResponseOut
extends GestoreIntegrazionePAWSAddressing {
    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePAMessage outResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message message = outResponsePAMessage.getMessage();
            if (message.getSOAPHeader() == null) {
                message.getSOAPPart().getEnvelope().addHeader();
            }
            if (integrazione.getBusta() != null) {
                HeaderIntegrazioneBusta hBusta = integrazione.getBusta();
                if (hBusta.getDestinatario() != null && hBusta.getServizio() != null) {
                    SOAPHeaderElement wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio());
                    message.addHeaderElement(message.getSOAPHeader(), wsaTO);
                    if (hBusta.getAzione() != null) {
                        SOAPHeaderElement wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getAzione());
                        message.addHeaderElement(message.getSOAPHeader(), wsaAction);
                    }
                }
                if (hBusta.getMittente() != null) {
                    SOAPHeaderElement wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente());
                    message.addHeaderElement(message.getSOAPHeader(), wsaFROM);
                }
                if (hBusta.getID() != null) {
                    SOAPHeaderElement wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getID());
                    message.addHeaderElement(message.getSOAPHeader(), wsaID);
                }
                if (hBusta.getRiferimentoMessaggio() != null || hBusta.getIdCollaborazione() != null) {
                    String rif = hBusta.getRiferimentoMessaggio();
                    if (rif == null) {
                        rif = hBusta.getIdCollaborazione();
                    }
                    SOAPHeaderElement wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", rif);
                    message.addHeaderElement(message.getSOAPHeader(), wsaRelatesTo);
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }
}

