/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazioneWSAddressing;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class GestoreIntegrazionePAWSAddressing
extends AbstractCore
implements IGestoreIntegrazionePASoap {
    UtilitiesIntegrazioneWSAddressing utilities = null;
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePAWSAddressing() {
        if (this.log == null) {
            this.log = Logger.getLogger(GestoreIntegrazionePAWSAddressing.class);
        }
        try {
            this.utilities = UtilitiesIntegrazioneWSAddressing.getInstance(this.log);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'inizializzazione delle UtilitiesIntegrazioneWSAddressing: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inRequestPAMessage.getMessage(), integrazione, true, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInRequestHeader(InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inRequestPAMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInRequestHeader(InRequestPAMessage inRequestPAMessage, String idMessaggio, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inRequestPAMessage.getMessage(), inRequestPAMessage.getSoggettoMittente(), inRequestPAMessage.getServizio(), idMessaggio, servizioApplicativo, correlazioneApplicativa, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPAMessage outRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            OpenSPCoop2Message message = outRequestPAMessage.getMessage();
            if (message.getSOAPHeader() == null) {
                message.getSOAPPart().getEnvelope().addHeader();
            }
            if (integrazione.getBusta() != null) {
                HeaderIntegrazioneBusta hBusta = integrazione.getBusta();
                if (hBusta.getDestinatario() != null && hBusta.getServizio() != null) {
                    SOAPHeaderElement wsaTO = UtilitiesIntegrazioneWSAddressing.buildWSATo(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio());
                    message.addHeaderElement(message.getSOAPHeader(), wsaTO);
                    if (hBusta.getAzione() != null) {
                        SOAPHeaderElement wsaAction = UtilitiesIntegrazioneWSAddressing.buildWSAAction(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getTipoDestinatario(), hBusta.getDestinatario(), hBusta.getTipoServizio(), hBusta.getServizio(), hBusta.getAzione());
                        message.addHeaderElement(message.getSOAPHeader(), wsaAction);
                    }
                }
                if (hBusta.getMittente() != null) {
                    SOAPHeaderElement wsaFROM = UtilitiesIntegrazioneWSAddressing.buildWSAFrom(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", integrazione.getServizioApplicativo(), hBusta.getTipoMittente(), hBusta.getMittente());
                    message.addHeaderElement(message.getSOAPHeader(), wsaFROM);
                }
                if (hBusta.getID() != null) {
                    SOAPHeaderElement wsaID = UtilitiesIntegrazioneWSAddressing.buildWSAID(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", hBusta.getID());
                    message.addHeaderElement(message.getSOAPHeader(), wsaID);
                }
                if (hBusta.getRiferimentoMessaggio() != null || hBusta.getIdCollaborazione() != null) {
                    String rif = hBusta.getRiferimentoMessaggio();
                    if (rif == null) {
                        rif = hBusta.getIdCollaborazione();
                    }
                    SOAPHeaderElement wsaRelatesTo = UtilitiesIntegrazioneWSAddressing.buildWSARelatesTo(message, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa", rif);
                    message.addHeaderElement(message.getSOAPHeader(), wsaRelatesTo);
                }
            }
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inResponsePAMessage.getMessage(), integrazione, false, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInResponseHeader(InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inResponsePAMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInResponseHeader(InResponsePAMessage inResponsePAMessage, String idMessageRequest, String idMessageResponse, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inResponsePAMessage.getMessage(), inResponsePAMessage.getSoggettoMittente(), inResponsePAMessage.getServizio(), idMessageRequest, idMessageResponse, servizioApplicativo, correlazioneApplicativa, this.openspcoopProperties.getHeaderSoapActorIntegrazione() + "/wsa");
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePAMessage outResponsePAMessage) throws HeaderIntegrazioneException {
    }
}

