/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.integrazione;

import javax.xml.soap.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneException;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.InResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.OutRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.TipoIntegrazione;

public class GestoreIntegrazionePASoap
extends AbstractCore
implements IGestoreIntegrazionePASoap {
    UtilitiesIntegrazione utilities = null;
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();

    public GestoreIntegrazionePASoap() {
        if (this.log == null) {
            this.log = Logger.getLogger(GestoreIntegrazionePASoap.class);
        }
        try {
            this.utilities = UtilitiesIntegrazione.getInstance(this.log);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'inizializzazione delle UtilitiesIntegrazione: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void readInRequestHeader(HeaderIntegrazione integrazione, InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inRequestPAMessage.getMessage(), integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInRequestHeader(InRequestPAMessage inRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inRequestPAMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInRequestHeader(InRequestPAMessage inRequestPAMessage, String idMessaggio, String servizioApplicativo, String correlazioneApplicativa) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inRequestPAMessage.getMessage(), inRequestPAMessage.getSoggettoMittente(), inRequestPAMessage.getServizio(), idMessaggio, servizioApplicativo, correlazioneApplicativa, null, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inRequestPAMessage.getBustaRichiesta(), true, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutRequestHeader(HeaderIntegrazione integrazione, OutRequestPAMessage outRequestPAMessage) throws HeaderIntegrazioneException {
        try {
            SOAPHeaderElement header = this.utilities.buildHeader(integrazione, this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), outRequestPAMessage.getMessage(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(outRequestPAMessage.getBustaRichiesta(), true, TipoIntegrazione.SOAP));
            if (outRequestPAMessage.getMessage().getSOAPHeader() == null) {
                outRequestPAMessage.getMessage().getSOAPPart().getEnvelope().addHeader();
            }
            outRequestPAMessage.getMessage().addHeaderElement(outRequestPAMessage.getMessage().getSOAPHeader(), header);
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void readInResponseHeader(HeaderIntegrazione integrazione, InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.readHeader(inResponsePAMessage.getMessage(), integrazione, this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteInResponseHeader(InResponsePAMessage inResponsePAMessage) throws HeaderIntegrazioneException {
        try {
            this.utilities.deleteHeader(inResponsePAMessage.getMessage(), this.openspcoopProperties.getHeaderSoapActorIntegrazione());
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void updateInResponseHeader(InResponsePAMessage inResponsePAMessage, String idMessaggioRichiesta, String idMessaggioRisposta, String servizioApplicativo, String correlazioneApplicativa, String riferimentoCorrelazioneApplicativaRichiesta) throws HeaderIntegrazioneException {
        try {
            this.utilities.updateHeader(inResponsePAMessage.getMessage(), inResponsePAMessage.getSoggettoMittente(), inResponsePAMessage.getServizio(), idMessaggioRichiesta, idMessaggioRisposta, servizioApplicativo, correlazioneApplicativa, riferimentoCorrelazioneApplicativaRichiesta, this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapNameIntegrazione(), this.openspcoopProperties.getHeaderSoapPrefixIntegrazione(), this.openspcoopProperties.getHeaderSoapActorIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeElementoIntegrazione(), this.openspcoopProperties.getHeaderSoapExtProtocolInfoNomeAttributoIntegrazione(), this.getProtocolFactory().createProtocolManager().buildIntegrationProperties(inResponsePAMessage.getBustaRichiesta(), false, TipoIntegrazione.SOAP));
        }
        catch (Exception e) {
            throw new HeaderIntegrazioneException("GestoreIntegrazionePASoap, " + e.getMessage(), e);
        }
    }

    @Override
    public void setOutResponseHeader(HeaderIntegrazione integrazione, OutResponsePAMessage outResponsePAMessage) throws HeaderIntegrazioneException {
    }
}

