/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.statistics;

import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.pdd.core.handlers.statistics.Statistic;
import org.openspcoop2.pdd.core.handlers.statistics.StatisticCount;
import org.openspcoop2.pdd.core.handlers.statistics.StatisticSize;
import org.openspcoop2.pdd.core.handlers.statistics.StatisticTime;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.date.DateManager;

public class StatisticsCollection {
    private static final StatisticsCollection statisticsCollection = new StatisticsCollection();
    private static final long SOGLIA_DIMENSIONE = 9223372036854675807L;
    private static final int SOGLIA_TEMPORALE = 1800000;
    private static EsitiProperties esitiProperties = null;
    long dataUltimoRefresh = -1L;
    StatisticCount statNumeroTransazioni = new StatisticCount();
    StatisticCount statNumeroTransazioni_PD = new StatisticCount();
    StatisticCount statNumeroTransazioni_PA = new StatisticCount();
    StatisticTime statLatenzaAttraversamento = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_request = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_response = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_PD = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_PD_request = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_PD_response = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_PA = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_PA_request = new StatisticTime();
    StatisticTime statLatenzaAttraversamento_PA_response = new StatisticTime();
    StatisticSize statDimensioneMessaggio = new StatisticSize();
    StatisticSize statDimensioneMessaggio_in_request = new StatisticSize();
    StatisticSize statDimensioneMessaggio_out_request = new StatisticSize();
    StatisticSize statDimensioneMessaggio_in_response = new StatisticSize();
    StatisticSize statDimensioneMessaggio_out_response = new StatisticSize();
    StatisticSize statDimensioneMessaggio_response = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PD = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PD_in_request = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PD_out_request = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PD_in_response = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PD_out_response = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PA = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PA_in_request = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PA_out_request = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PA_in_response = new StatisticSize();
    StatisticSize statDimensioneMessaggio_PA_out_response = new StatisticSize();

    public static StatisticsCollection getStatisticsCollection() {
        return statisticsCollection;
    }

    private static synchronized void initEsitiProperties() {
        if (esitiProperties == null) {
            try {
                esitiProperties = EsitiProperties.getInstance((Logger)Logger.getLogger(StatisticsCollection.class));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static boolean isEsitoOk(EsitoTransazione esito) {
        try {
            if (esitiProperties == null) {
                StatisticsCollection.initEsitiProperties();
            }
            List esitiOk = esitiProperties.getEsitiCodeOk();
            for (Integer esitoOk : esitiOk) {
                if (esitoOk != esito.getCode()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static synchronized void update(Statistic stat) {
        long outResponseSize;
        long inResponseSize;
        long outRequestSize;
        long inRequestSize;
        if (!TipoPdD.APPLICATIVA.equals(stat.getTipoPdD()) && !TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
            return;
        }
        if (StatisticsCollection.getStatisticsCollection().dataUltimoRefresh > 0L) {
            if (DateManager.getTimeMillis() - StatisticsCollection.getStatisticsCollection().dataUltimoRefresh > 1800000L) {
                StatisticsCollection.reset();
            }
        } else {
            StatisticsCollection.getStatisticsCollection().dataUltimoRefresh = stat.getTimeMillisIngressoRichiesta();
            if (StatisticsCollection.getStatisticsCollection().dataUltimoRefresh <= 0L) {
                StatisticsCollection.getStatisticsCollection().dataUltimoRefresh = DateManager.getTimeMillis();
            }
        }
        StatisticsCollection.incrementCount(stat.getEsito(), StatisticsCollection.statisticsCollection.statNumeroTransazioni);
        if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
            StatisticsCollection.incrementCount(stat.getEsito(), StatisticsCollection.statisticsCollection.statNumeroTransazioni_PA);
        } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
            StatisticsCollection.incrementCount(stat.getEsito(), StatisticsCollection.statisticsCollection.statNumeroTransazioni_PD);
        }
        if (StatisticsCollection.isEsitoOk(stat.getEsito())) {
            long latenzaTotale = -1L;
            if (stat.getTimeMillisUscitaRisposta() > 0L && stat.getTimeMillisIngressoRichiesta() > 0L) {
                latenzaTotale = stat.getTimeMillisUscitaRisposta() - stat.getTimeMillisIngressoRichiesta();
            }
            if (latenzaTotale > 0L) {
                StatisticsCollection.computeLatenza(latenzaTotale, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento);
                if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                    StatisticsCollection.computeLatenza(latenzaTotale, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_PA);
                } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                    StatisticsCollection.computeLatenza(latenzaTotale, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_PD);
                }
            }
            long latenzaRichiesta = -1L;
            if (stat.getTimeMillisUscitaRichiesta() > 0L && stat.getTimeMillisIngressoRichiesta() > 0L) {
                latenzaRichiesta = stat.getTimeMillisUscitaRichiesta() - stat.getTimeMillisIngressoRichiesta();
            }
            if (latenzaRichiesta > 0L) {
                StatisticsCollection.computeLatenza(latenzaRichiesta, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_request);
                if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                    StatisticsCollection.computeLatenza(latenzaRichiesta, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_PA_request);
                } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                    StatisticsCollection.computeLatenza(latenzaRichiesta, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_PD_request);
                }
            }
            long latenzaRisposta = -1L;
            if (stat.getTimeMillisUscitaRisposta() > 0L && stat.getTimeMillisIngressoRisposta() > 0L) {
                latenzaRisposta = stat.getTimeMillisUscitaRisposta() - stat.getTimeMillisIngressoRisposta();
            }
            if (latenzaRisposta > 0L) {
                StatisticsCollection.computeLatenza(latenzaRisposta, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_response);
                if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                    StatisticsCollection.computeLatenza(latenzaRisposta, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_PA_response);
                } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                    StatisticsCollection.computeLatenza(latenzaRisposta, StatisticsCollection.statisticsCollection.statLatenzaAttraversamento_PD_response);
                }
            }
        }
        if ((inRequestSize = stat.getDimensioneIngressoRichiesta()) > 0L) {
            StatisticsCollection.computeDimensione(inRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio);
            StatisticsCollection.computeDimensione(inRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_in_request);
            if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(inRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA);
                StatisticsCollection.computeDimensione(inRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA_in_request);
            } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(inRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD);
                StatisticsCollection.computeDimensione(inRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD_in_request);
            }
        }
        if ((outRequestSize = stat.getDimensioneUscitaRichiesta()) > 0L) {
            StatisticsCollection.computeDimensione(outRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio);
            StatisticsCollection.computeDimensione(outRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_out_request);
            if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(outRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA);
                StatisticsCollection.computeDimensione(outRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA_out_request);
            } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(outRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD);
                StatisticsCollection.computeDimensione(outRequestSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD_out_request);
            }
        }
        if ((inResponseSize = stat.getDimensioneIngressoRisposta()) > 0L) {
            StatisticsCollection.computeDimensione(inResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio);
            StatisticsCollection.computeDimensione(inResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_in_response);
            if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(inResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA);
                StatisticsCollection.computeDimensione(inResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA_in_response);
            } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(inResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD);
                StatisticsCollection.computeDimensione(inResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD_in_response);
            }
        }
        if ((outResponseSize = stat.getDimensioneUscitaRisposta()) > 0L) {
            StatisticsCollection.computeDimensione(outResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio);
            StatisticsCollection.computeDimensione(outResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_out_response);
            if (TipoPdD.APPLICATIVA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(outResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA);
                StatisticsCollection.computeDimensione(outResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PA_out_response);
            } else if (TipoPdD.DELEGATA.equals(stat.getTipoPdD())) {
                StatisticsCollection.computeDimensione(outResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD);
                StatisticsCollection.computeDimensione(outResponseSize, StatisticsCollection.statisticsCollection.statDimensioneMessaggio_PD_out_response);
            }
        }
    }

    private static boolean needResetForOverSizeLong() {
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_request.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_response.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PD.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PD_request.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PD_response.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PA.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PA_request.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PA_response.tmp_latenzaMediaAttraversamento_sumLatenze > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_in_request.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_out_request.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_in_response.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_out_response.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_in_request.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_out_request.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_in_response.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_out_response.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_in_request.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_out_request.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        if (StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_in_response.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L) {
            return true;
        }
        return StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_out_response.tmp_dimensioneMediaMessaggio_sumDimensioni > 9223372036854675807L;
    }

    public static void reset() {
        StatisticsCollection.getStatisticsCollection().dataUltimoRefresh = -1L;
        StatisticsCollection.getStatisticsCollection().statNumeroTransazioni = new StatisticCount();
        StatisticsCollection.getStatisticsCollection().statNumeroTransazioni_PD = new StatisticCount();
        StatisticsCollection.getStatisticsCollection().statNumeroTransazioni_PA = new StatisticCount();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_request = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_response = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PD = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PD_request = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PD_response = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PA = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PA_request = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statLatenzaAttraversamento_PA_response = new StatisticTime();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_in_request = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_out_request = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_in_response = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_out_response = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_response = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_in_request = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_out_request = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_in_response = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PD_out_response = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_in_request = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_out_request = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_in_response = new StatisticSize();
        StatisticsCollection.getStatisticsCollection().statDimensioneMessaggio_PA_out_response = new StatisticSize();
    }

    private static void incrementCount(EsitoTransazione esito, StatisticCount statCount) {
        ++statCount.numeroTransazioni;
        if (StatisticsCollection.isEsitoOk(esito)) {
            ++statCount.numeroTransazioni_esitoOK;
        } else {
            ++statCount.numeroTransazioni_esitoErrore;
        }
    }

    private static void computeLatenza(long latenza, StatisticTime statTime) {
        if (statTime.latenzaMinimaAttraversamento <= 0L) {
            statTime.latenzaMinimaAttraversamento = latenza;
        } else if (latenza < statTime.latenzaMinimaAttraversamento) {
            statTime.latenzaMinimaAttraversamento = latenza;
        }
        if (latenza > statTime.latenzaMassimaAttraversamento) {
            statTime.latenzaMassimaAttraversamento = latenza;
        }
        statTime.tmp_latenzaMediaAttraversamento_sumLatenze += latenza;
        ++statTime.tmp_latenzaMediaAttraversamento_countTransazioni;
        statTime.latenzaMediaAttraversamento = statTime.tmp_latenzaMediaAttraversamento_sumLatenze / statTime.tmp_latenzaMediaAttraversamento_countTransazioni;
    }

    private static void computeDimensione(long dimensione, StatisticSize statSize) {
        if (statSize.dimensioneMinimaMessaggio <= 0L) {
            statSize.dimensioneMinimaMessaggio = dimensione;
        } else if (dimensione < statSize.dimensioneMinimaMessaggio) {
            statSize.dimensioneMinimaMessaggio = dimensione;
        }
        if (dimensione > statSize.dimensioneMassimaMessaggio) {
            statSize.dimensioneMassimaMessaggio = dimensione;
        }
        statSize.tmp_dimensioneMediaMessaggio_sumDimensioni += dimensione;
        ++statSize.tmp_dimensioneMediaMessaggio_countTransazioni;
        statSize.dimensioneMediaMessaggio = statSize.tmp_dimensioneMediaMessaggio_sumDimensioni / statSize.tmp_dimensioneMediaMessaggio_countTransazioni;
    }

    public StatisticSize getStatDimensioneMessaggio() {
        return this.statDimensioneMessaggio;
    }

    public StatisticSize getStatDimensioneMessaggio_in_request() {
        return this.statDimensioneMessaggio_in_request;
    }

    public StatisticSize getStatDimensioneMessaggio_out_request() {
        return this.statDimensioneMessaggio_out_request;
    }

    public StatisticSize getStatDimensioneMessaggio_in_response() {
        return this.statDimensioneMessaggio_in_response;
    }

    public StatisticSize getStatDimensioneMessaggio_out_response() {
        return this.statDimensioneMessaggio_out_response;
    }

    public StatisticSize getStatDimensioneMessaggio_response() {
        return this.statDimensioneMessaggio_response;
    }

    public StatisticSize getStatDimensioneMessaggio_PD() {
        return this.statDimensioneMessaggio_PD;
    }

    public StatisticSize getStatDimensioneMessaggio_PD_in_request() {
        return this.statDimensioneMessaggio_PD_in_request;
    }

    public StatisticSize getStatDimensioneMessaggio_PD_out_request() {
        return this.statDimensioneMessaggio_PD_out_request;
    }

    public StatisticSize getStatDimensioneMessaggio_PD_in_response() {
        return this.statDimensioneMessaggio_PD_in_response;
    }

    public StatisticSize getStatDimensioneMessaggio_PD_out_response() {
        return this.statDimensioneMessaggio_PD_out_response;
    }

    public StatisticSize getStatDimensioneMessaggio_PA() {
        return this.statDimensioneMessaggio_PA;
    }

    public StatisticSize getStatDimensioneMessaggio_PA_in_request() {
        return this.statDimensioneMessaggio_PA_in_request;
    }

    public StatisticSize getStatDimensioneMessaggio_PA_out_request() {
        return this.statDimensioneMessaggio_PA_out_request;
    }

    public StatisticSize getStatDimensioneMessaggio_PA_in_response() {
        return this.statDimensioneMessaggio_PA_in_response;
    }

    public StatisticSize getStatDimensioneMessaggio_PA_out_response() {
        return this.statDimensioneMessaggio_PA_out_response;
    }

    public StatisticCount getStatNumeroTransazioni() {
        return this.statNumeroTransazioni;
    }

    public StatisticCount getStatNumeroTransazioni_PD() {
        return this.statNumeroTransazioni_PD;
    }

    public StatisticCount getStatNumeroTransazioni_PA() {
        return this.statNumeroTransazioni_PA;
    }

    public StatisticTime getStatLatenzaAttraversamento() {
        return this.statLatenzaAttraversamento;
    }

    public StatisticTime getStatLatenzaAttraversamento_request() {
        return this.statLatenzaAttraversamento_request;
    }

    public StatisticTime getStatLatenzaAttraversamento_response() {
        return this.statLatenzaAttraversamento_response;
    }

    public StatisticTime getStatLatenzaAttraversamento_PD() {
        return this.statLatenzaAttraversamento_PD;
    }

    public StatisticTime getStatLatenzaAttraversamento_PD_request() {
        return this.statLatenzaAttraversamento_PD_request;
    }

    public StatisticTime getStatLatenzaAttraversamento_PD_response() {
        return this.statLatenzaAttraversamento_PD_response;
    }

    public StatisticTime getStatLatenzaAttraversamento_PA() {
        return this.statLatenzaAttraversamento_PA;
    }

    public StatisticTime getStatLatenzaAttraversamento_PA_request() {
        return this.statLatenzaAttraversamento_PA_request;
    }

    public StatisticTime getStatLatenzaAttraversamento_PA_response() {
        return this.statLatenzaAttraversamento_PA_response;
    }

    public long getDataUltimoRefresh() {
        return this.dataUltimoRefresh;
    }
}

