/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers.notifier;

import java.util.List;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestHandler;
import org.openspcoop2.pdd.core.handlers.notifier.INotifierCallback;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierBufferState;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierResult;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierType;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.io.notifier.StreamingHandler;
import org.openspcoop2.utils.resources.Loader;

public class NotifierPreInRequestHandler
implements PreInRequestHandler {
    @Override
    public void invoke(PreInRequestContext context) throws HandlerException {
        try {
            INotifierCallback notifierCallback;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
            String notifierInputStreamCallback = properties.getNotifierInputStreamCallback();
            if (notifierInputStreamCallback != null && (notifierCallback = (INotifierCallback)Loader.getInstance().newInstance(classNameProperties.getNotifierCallback(notifierInputStreamCallback))).enableNotifierInputStream(NotifierType.PRE_IN_REQUEST, context)) {
                NotifierInputStreamParams notifierInputStreamParams = new NotifierInputStreamParams();
                NotifierResult notifierResult = notifierCallback.notify(NotifierType.PRE_IN_REQUEST, context);
                notifierInputStreamParams.setBufferEnabled(NotifierBufferState.ENABLE.equals((Object)notifierResult.getBufferState()));
                List<StreamingHandler> streamingHandlers = notifierResult.getStreamingHandlers();
                if (streamingHandlers != null && streamingHandlers.size() > 0) {
                    for (StreamingHandler streamingHandler : streamingHandlers) {
                        notifierInputStreamParams.addStreamingHandler(streamingHandler);
                    }
                }
                notifierInputStreamParams.setThrowStreamingHandlerException(notifierCallback.throwStreamingHandlerException(NotifierType.PRE_IN_REQUEST, context));
                notifierInputStreamParams.setLog(context.getLogCore());
                context.setNotifierInputStreamParams(notifierInputStreamParams);
            }
        }
        catch (Exception e) {
            throw new HandlerException(e.getMessage(), e);
        }
    }
}

