/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;

public class GestoreErroreConnettore {
    private boolean riconsegna;
    private Timestamp dataRispedizione;
    private String errore;
    private SOAPFault fault;
    private static Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private static GestioneErrore gestioneErroreDefaultComponenteIntegrazione = null;
    private static GestioneErrore gestioneErroreDefaultComponenteCooperazione = null;

    public static GestioneErrore getGestioneErroreDefaultComponenteIntegrazione() {
        if (gestioneErroreDefaultComponenteIntegrazione != null) {
            return gestioneErroreDefaultComponenteIntegrazione;
        }
        GestioneErrore gestione = new GestioneErrore();
        gestione.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
        GestioneErroreCodiceTrasporto codiceTrasporto = new GestioneErroreCodiceTrasporto();
        codiceTrasporto.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
        codiceTrasporto.setValoreMinimo(new Integer("200"));
        codiceTrasporto.setValoreMassimo(new Integer("299"));
        gestione.addCodiceTrasporto(codiceTrasporto);
        GestioneErroreSoapFault faultAccetta = new GestioneErroreSoapFault();
        faultAccetta.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
        gestione.addSoapFault(faultAccetta);
        gestioneErroreDefaultComponenteIntegrazione = gestione;
        return gestione;
    }

    public static GestioneErrore getGestioneErroreDefaultComponenteCooperazione() {
        if (gestioneErroreDefaultComponenteCooperazione != null) {
            return gestioneErroreDefaultComponenteCooperazione;
        }
        GestioneErrore gestione = new GestioneErrore();
        gestione.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
        GestioneErroreCodiceTrasporto codiceTrasporto = new GestioneErroreCodiceTrasporto();
        codiceTrasporto.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
        codiceTrasporto.setValoreMinimo(new Integer("200"));
        codiceTrasporto.setValoreMassimo(new Integer("299"));
        gestione.addCodiceTrasporto(codiceTrasporto);
        ProtocolFactoryManager protocolFactoryManager = null;
        try {
            protocolFactoryManager = ProtocolFactoryManager.getInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration factoriesKeys = protocolFactoryManager.getProtocolNames();
        while (factoriesKeys.hasMoreElements()) {
            String protocolName = (String)factoriesKeys.nextElement();
            ITraduttore trasl = null;
            try {
                IProtocolFactory protocolFactory = protocolFactoryManager.getProtocolFactoryByName(protocolName);
                trasl = protocolFactory.createTraduttore();
            }
            catch (ProtocolException e) {
                e.printStackTrace();
                continue;
            }
            GestioneErroreSoapFault faultClient = new GestioneErroreSoapFault();
            faultClient.setFaultCode("Client");
            faultClient.setFaultString(trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE));
            faultClient.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG);
            gestione.addSoapFault(faultClient);
            GestioneErroreSoapFault faultServer = new GestioneErroreSoapFault();
            faultServer.setFaultCode("Server");
            faultServer.setFaultString(trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO));
            faultServer.setComportamento(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
            gestione.addSoapFault(faultServer);
        }
        gestioneErroreDefaultComponenteCooperazione = gestione;
        return gestione;
    }

    public boolean verificaConsegna(GestioneErrore gestioneErrore, String msgErroreConnettore, Exception eccezioneErroreConnettore, long codiceTrasporto, OpenSPCoop2Message messageResponse) throws GestoreMessaggiException, SOAPException, UtilsException {
        GestioneErroreCodiceTrasporto gestore;
        int i;
        Date now = DateManager.getDate();
        this.dataRispedizione = new Timestamp(now.getTime());
        if (msgErroreConnettore != null) {
            this.errore = msgErroreConnettore;
            if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(gestioneErrore.getComportamento())) {
                this.riconsegna = true;
                if (gestioneErrore.getCadenzaRispedizione() != null) {
                    try {
                        int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                    }
                }
            } else {
                this.riconsegna = false;
            }
            return false;
        }
        SOAPBody body = null;
        if (messageResponse != null) {
            body = messageResponse.getSOAPBody();
        }
        if (body != null && body.hasFault()) {
            this.fault = body.getFault();
            for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                gestore = gestioneErrore.getSoapFault(i);
                boolean match = true;
                if (gestore.getFaultCode() != null && !gestore.getFaultCode().equalsIgnoreCase(this.fault.getFaultCodeAsQName().getLocalPart())) {
                    match = false;
                }
                if (gestore.getFaultActor() != null && !gestore.getFaultActor().equalsIgnoreCase(this.fault.getFaultActor())) {
                    match = false;
                }
                if (!(gestore.getFaultString() == null || this.fault.getFaultString() != null && (this.fault.getFaultString().contains(gestore.getFaultString()) || this.fault.getFaultString().contains(gestore.getFaultString().toLowerCase()) || this.fault.getFaultString().contains(gestore.getFaultString().toUpperCase())))) {
                    match = false;
                }
                if (!match) continue;
                if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(gestore.getComportamento())) {
                    this.errore = "errore applicativo, " + SoapUtils.toString((SOAPFault)this.fault);
                    this.riconsegna = true;
                    if (gestore.getCadenzaRispedizione() != null) {
                        try {
                            int cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            log.error((Object)("Intervallo di rispedizione non impostato (soap fault): " + e.getMessage()));
                        }
                    } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                        try {
                            int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                            this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                        }
                        catch (Exception e) {
                            log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                        }
                    }
                    return false;
                }
                this.riconsegna = false;
                return true;
            }
        }
        for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
            gestore = gestioneErrore.getCodiceTrasporto(i);
            long valoreMinimo = Long.MIN_VALUE;
            long valoreMassimo = Long.MAX_VALUE;
            if (gestore.getValoreMinimo() != null) {
                valoreMinimo = gestore.getValoreMinimo().longValue();
            }
            if (gestore.getValoreMassimo() != null) {
                valoreMassimo = gestore.getValoreMassimo().longValue();
            }
            if (codiceTrasporto < valoreMinimo || codiceTrasporto > valoreMassimo) continue;
            if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(gestore.getComportamento())) {
                this.errore = "errore di trasporto, codice " + codiceTrasporto;
                if (this.fault != null) {
                    this.errore = this.errore + " (" + SoapUtils.toString((SOAPFault)this.fault) + ")";
                }
                this.riconsegna = true;
                if (gestore.getCadenzaRispedizione() != null) {
                    try {
                        int cadenzaRispedizione = Integer.parseInt(gestore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        log.error((Object)("Intervallo di rispedizione non impostato (codice di trasporto): " + e.getMessage()));
                    }
                } else if (gestioneErrore.getCadenzaRispedizione() != null) {
                    try {
                        int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                        this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                    }
                    catch (Exception e) {
                        log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                    }
                }
                return false;
            }
            this.riconsegna = false;
            return true;
        }
        if (CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(gestioneErrore.getComportamento())) {
            this.errore = "errore di trasporto, codice " + codiceTrasporto;
            if (this.fault != null) {
                this.errore = this.errore + " (" + SoapUtils.toString((SOAPFault)this.fault) + ")";
            }
            this.riconsegna = true;
            if (gestioneErrore.getCadenzaRispedizione() != null) {
                try {
                    int cadenzaRispedizione = Integer.parseInt(gestioneErrore.getCadenzaRispedizione());
                    this.dataRispedizione = new Timestamp(now.getTime() + (long)(cadenzaRispedizione * 60 * 1000));
                }
                catch (Exception e) {
                    log.error((Object)("Intervallo di rispedizione non impostato: " + e.getMessage()));
                }
            }
            return false;
        }
        this.riconsegna = false;
        return true;
    }

    public String getErrore() {
        return this.errore;
    }

    public boolean isRiconsegna() {
        return this.riconsegna;
    }

    public Timestamp getDataRispedizione() {
        return this.dataRispedizione;
    }

    public SOAPFault getFault() {
        return this.fault;
    }
}

