/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.soap.encoding.soapenc.Base64;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.RFC2047Encoding;
import org.openspcoop2.utils.resources.RFC2047Utilities;

public class ConnettoreSAAJ
extends ConnettoreBase {
    private ConnettoreLogger logger = null;
    private OpenSPCoop2Message requestMsg;
    private Hashtable<String, String> properties;
    private Busta busta;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private String idMessaggio;
    private boolean debug = false;
    private SOAPConnection connection = null;
    private String idModulo = null;
    private OpenSPCoop2Properties openspcoopProperties = null;

    @Override
    public boolean send(ConnettoreMsg request) {
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.properties = request.getConnectorProperties();
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        this.logger = new ConnettoreLogger(this.debug, this.idMessaggio, this.getPddContext());
        try {
            this.requestMsg = request.getRequestMessage();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e);
            return false;
        }
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.credenziali = request.getCredenziali();
        this.idModulo = request.getIdModulo();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (Msg)";
            return false;
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        return this.sendSAAJ();
    }

    private boolean sendSAAJ() {
        try {
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            int connectionTimeout = -1;
            int readConnectionTimeout = -1;
            if (this.properties.get("connection-timeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'connection-timeout' errato", e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("read-connection-timeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'read-connection-timeout' errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]...", false);
            }
            if (this.debug) {
                this.logger.debug("Check validita URL...");
            }
            this.location = this.properties.get("location");
            URL urlTest = new URL(this.location);
            URLConnection connectionTest = urlTest.openConnection();
            HttpURLConnection httpConnTest = (HttpURLConnection)connectionTest;
            httpConnTest.setRequestMethod(MethodType.POST.name());
            httpConnTest.setConnectTimeout(connectionTimeout);
            httpConnTest.setReadTimeout(readConnectionTimeout);
            httpConnTest.setDoOutput(true);
            OutputStream outTest = httpConnTest.getOutputStream();
            outTest.close();
            httpConnTest.disconnect();
            if (this.debug) {
                this.logger.debug("PrefixOptimization...");
            }
            String prefixOptimization = "true";
            if (this.properties.get("prefix-optimization") != null) {
                if ("false".equalsIgnoreCase(this.properties.get("prefix-optimization"))) {
                    prefixOptimization = "false";
                }
                this.logger.info("Prefix Optimization = '" + prefixOptimization + "'", false);
            }
            if (this.debug) {
                this.logger.debug("Creazione connessione...");
            }
            SOAPConnectionFactory soapConnFactory = OpenSPCoop2MessageFactory.getMessageFactory().getSOAPConnectionFactory();
            SOAPConnection connection = soapConnFactory.createConnection();
            if (this.debug) {
                this.logger.debug("Creazione URL...");
            }
            if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
                this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.propertiesUrlBased, this.location);
            }
            String urlConnection = this.location;
            try {
                if (this.requestMsg.getMimeHeaders() != null) {
                    if (this.debug) {
                        this.logger.debug("Impostazione header di trasporto...");
                    }
                    boolean encodingRFC2047 = false;
                    Charset charsetRFC2047 = null;
                    RFC2047Encoding encodingAlgorithmRFC2047 = null;
                    if (this.idModulo != null) {
                        if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                            encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                            charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                            encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                        } else {
                            encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_inoltroBuste();
                            charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_inoltroBuste();
                            encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_inoltroBuste();
                        }
                    }
                    if (this.propertiesTrasporto != null) {
                        Enumeration<Object> enumSPC = this.propertiesTrasporto.keys();
                        while (enumSPC.hasMoreElements()) {
                            String key = (String)enumSPC.nextElement();
                            if ("User-Agent".equalsIgnoreCase(key)) continue;
                            String value = (String)this.propertiesTrasporto.get(key);
                            if (this.debug) {
                                this.logger.info("Set proprieta' [" + key + "]=[" + value + "]", false);
                            }
                            if (encodingRFC2047) {
                                if (!RFC2047Utilities.isAllCharactersInCharset((String)value, (Charset)charsetRFC2047)) {
                                    String encoded = RFC2047Utilities.encode((String)new String(value), (Charset)charsetRFC2047, (RFC2047Encoding)encodingAlgorithmRFC2047);
                                    if (this.debug) {
                                        this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + charsetRFC2047 + " encoding-algorithm:" + encodingAlgorithmRFC2047 + ")", false);
                                    }
                                    this.requestMsg.getMimeHeaders().addHeader(key, encoded);
                                    continue;
                                }
                                this.requestMsg.getMimeHeaders().addHeader(key, value);
                                continue;
                            }
                            this.requestMsg.getMimeHeaders().addHeader(key, value);
                        }
                    }
                    if (this.debug) {
                        this.logger.debug("Impostazione autenticazione...");
                    }
                    String user = null;
                    String password = null;
                    if (this.credenziali != null) {
                        user = this.credenziali.getUsername();
                        password = this.credenziali.getPassword();
                    } else {
                        user = this.properties.get("user");
                        password = this.properties.get("password");
                    }
                    if (user != null && password != null) {
                        String authentication = user + ":" + password;
                        authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                        this.requestMsg.getMimeHeaders().addHeader("Authorization", authentication);
                        if (this.debug) {
                            this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                        }
                    }
                }
                if (this.debug) {
                    this.logger.debug("Set timeout...");
                }
                if (this.debug) {
                    this.logger.debug("Send...");
                }
                this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(connection.call((SOAPMessage)this.requestMsg, (Object)urlConnection));
            }
            catch (SOAPException sendError) {
                this.eccezioneProcessamento = sendError;
                String errorMsg = this.readExceptionMessageFromException(sendError);
                connection.close();
                this.errore = "Errore avvenuto durante la consegna SOAP (lettura risposta): " + errorMsg;
                return false;
            }
            if (this.debug) {
                this.logger.debug("Check consistenza...");
            }
            if (this.responseMsg != null && this.responseMsg.getSOAPBody() != null && this.responseMsg.getSOAPBody().hasFault() && this.responseMsg.getSOAPBody().getFault().getFaultString().indexOf("Premature end of file") != -1) {
                this.responseMsg = null;
            }
            if (this.responseMsg != null && this.responseMsg.getMimeHeaders() != null) {
                if (this.propertiesTrasportoRisposta == null) {
                    this.propertiesTrasportoRisposta = new Properties();
                }
                Iterator it = this.responseMsg.getMimeHeaders().getAllHeaders();
                while (it.hasNext()) {
                    MimeHeader mh = (MimeHeader)it.next();
                    this.propertiesTrasportoRisposta.put(mh.getName(), mh.getValue());
                    if (!"content-length".equalsIgnoreCase(mh.getName())) continue;
                    try {
                        this.contentLength = Integer.parseInt(mh.getValue());
                    }
                    catch (Exception e) {}
                }
            }
            this.codice = 200;
            if (this.responseMsg != null && this.contentLength < 0L) {
                this.contentLength = this.responseMsg.getIncomingMessageContentLength();
            }
            if (this.debug) {
                this.logger.info("Gestione invio/risposta http effettuata con successo", false);
            }
            this.postOutRequest();
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore avvenuto durante la consegna SOAP: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore avvenuto durante la consegna SOAP: " + this.readExceptionMessageFromException(e);
            return false;
        }
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.connection != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Connection.close ...");
                }
                this.connection.close();
            }
            super.disconnect();
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }
}

