/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.engine.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.w3c.dom.Node;

public class ConnettoreNULLEcho
extends ConnettoreBase {
    private ConnettoreLogger logger = null;
    public static final String LOCATION = "openspcoop2://echo";
    private Hashtable<String, String> properties;
    private Properties propertiesUrlBased;
    private Busta busta;
    private boolean debug = false;
    private String idMessaggio;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ConnettoreMsg request) {
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.properties = request.getConnectorProperties();
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        boolean generaTrasmissione = false;
        if (this.properties.get("generaTrasmissione") != null && "true".equalsIgnoreCase(this.properties.get("generaTrasmissione").trim())) {
            generaTrasmissione = true;
        }
        boolean generaTrasmissioneInvertita = false;
        if (this.properties.get("generaTrasmissioneInvertita") != null && "true".equalsIgnoreCase(this.properties.get("generaTrasmissioneInvertita").trim())) {
            generaTrasmissioneInvertita = true;
        }
        boolean generaTrasmissioneAndataRitorno = false;
        if (this.properties.get("generaTrasmissioneAndataRitorno") != null && "true".equalsIgnoreCase(this.properties.get("generaTrasmissioneAndataRitorno").trim())) {
            generaTrasmissioneAndataRitorno = true;
        }
        this.logger = new ConnettoreLogger(this.debug, this.idMessaggio, this.getPddContext());
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.codice = 200;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        StatefulMessage state = new StatefulMessage(null, this.logger.getLogger());
        ValidazioneSintattica validatoreSintattico = null;
        Validatore validatoreProtocollo = null;
        SOAPElement headerProtocolloRisposta = null;
        String protocol = null;
        try {
            IProtocolFactory protocolFactory = this.getProtocolFactory();
            IProtocolManager protocolManager = protocolFactory.createProtocolManager();
            protocol = protocolFactory.getProtocol();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            request.getRequestMessage().writeTo((OutputStream)bout, true);
            bout.flush();
            bout.close();
            this.postOutRequest();
            this.preInResponse();
            NotifierInputStreamParams notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage((InputStream)bin, notifierInputStreamParams, false, request.getRequestMessage().getContentType(), null, properties.isFileCacheEnable(), properties.getAttachmentRepoDir(), properties.getFileThreshold());
            validatoreSintattico = new ValidazioneSintattica((IState)state, this.responseMsg, properties.isReadQualifiedAttribute("standard"), protocolFactory);
            if (validatoreSintattico.verifyProtocolPresence(TipoPdD.APPLICATIVA, null, false) && !"sdi".equals(protocolFactory.getProtocol())) {
                ProprietaValidazione property = new ProprietaValidazione();
                property.setValidazioneConSchema(false);
                property.setValidazioneProfiloCollaborazione(false);
                property.setValidazioneManifestAttachments(false);
                validatoreProtocollo = new Validatore(this.responseMsg, property, null, properties.isReadQualifiedAttribute("standard"), protocolFactory);
                if (!validatoreProtocollo.validazioneSintattica()) {
                    throw new Exception("Busta non presente: " + validatoreProtocollo.getErrore().getDescrizione(protocolFactory));
                }
                Busta busta = validatoreProtocollo.getBusta();
                IValidatoreErrori validatoreErrori = protocolFactory.createValidatoreErrori();
                ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
                pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
                boolean isBustaSPCoopErrore = validatoreErrori.isBustaErrore(busta, this.responseMsg, pValidazioneErrori);
                boolean gestioneManifest = false;
                Sbustamento sbustatore = new Sbustamento(protocolFactory);
                headerProtocolloRisposta = sbustatore.sbustamento((IState)state, this.responseMsg, busta, true, gestioneManifest, properties.getProprietaManifestAttachments("standard"));
                if (!isBustaSPCoopErrore) {
                    Trasmissione t;
                    TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta("standard");
                    Busta bustaRisposta = busta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                    bustaRisposta.setProfiloDiCollaborazione(busta.getProfiloDiCollaborazione());
                    bustaRisposta.setServizio(busta.getServizio());
                    bustaRisposta.setVersioneServizio(busta.getVersioneServizio());
                    bustaRisposta.setTipoServizio(busta.getTipoServizio());
                    bustaRisposta.setAzione(busta.getAzione());
                    bustaRisposta.setInoltro(busta.getInoltro(), busta.getInoltroValue());
                    bustaRisposta.setConfermaRicezione(busta.isConfermaRicezione());
                    if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals(busta.getProfiloDiCollaborazione()) && busta.isConfermaRicezione() && properties.isGestioneRiscontri("standard")) {
                        Riscontro r = new Riscontro();
                        r.setID(busta.getID());
                        r.setOraRegistrazione(DateManager.getDate());
                        r.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO);
                        bustaRisposta.addRiscontro(r);
                    } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                        bustaRisposta.setTipoServizioCorrelato("SPC");
                        bustaRisposta.setServizioCorrelato(busta.getServizio() + "Correlato");
                    } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                        try {
                            resource = dbManager.getResource(properties.getIdentitaPortaDefault(protocolFactory.getProtocol()), "ConnettoreNullEcho", busta.getID());
                        }
                        catch (Exception e) {
                            throw new Exception("Risorsa non ottenibile", e);
                        }
                        if (resource == null) {
                            throw new Exception("Risorsa is null");
                        }
                        if (resource.getResource() == null) {
                            throw new Exception("Connessione is null");
                        }
                        Connection connectionDB = (Connection)resource.getResource();
                        state.setConnectionDB(connectionDB);
                        RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, true, protocolFactory);
                        repositoryBuste.registraBustaIntoInBox(busta, new Vector(), OpenSPCoop2Properties.getInstance().getRepositoryIntervalloScadenzaMessaggi());
                        Integrazione infoIntegrazione = new Integrazione();
                        infoIntegrazione.setIdModuloInAttesa(null);
                        repositoryBuste.aggiornaInfoIntegrazioneIntoInBox(busta.getID(), infoIntegrazione);
                        ProfiloDiCollaborazione profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, protocolFactory);
                        profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(busta.getID(), busta.getCollaborazione(), busta.getTipoServizioCorrelato(), busta.getServizioCorrelato(), true, properties.getRepositoryIntervalloScadenzaMessaggi());
                        try {
                            connectionDB.setAutoCommit(false);
                            state.executePreparedStatement();
                            connectionDB.commit();
                            connectionDB.setAutoCommit(true);
                        }
                        catch (Exception e) {
                            this.logger.error("Riscontrato errore durante la gestione transazione del DB per la richiesta: " + e.getMessage());
                            try {
                                connectionDB.rollback();
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                connectionDB.setAutoCommit(true);
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            state.closePreparedStatement();
                        }
                    }
                    bustaRisposta.setRiferimentoMessaggio(busta.getID());
                    String dominio = null;
                    if (request.getConnectorProperties() != null) {
                        dominio = request.getConnectorProperties().get("identificativo-porta");
                    }
                    if (dominio == null) {
                        dominio = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()));
                    }
                    String idBustaRisposta = null;
                    Imbustamento imbustatore = new Imbustamento(protocolFactory);
                    idBustaRisposta = imbustatore.buildID((IState)state, new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario(), dominio), null, properties.getGestioneSerializableDB_AttesaAttiva(), properties.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
                    bustaRisposta.setID(idBustaRisposta);
                    if (generaTrasmissioneAndataRitorno) {
                        t = new Trasmissione();
                        t.setTipoOrigine(busta.getTipoMittente());
                        t.setOrigine(busta.getMittente());
                        t.setIdentificativoPortaOrigine(busta.getIdentificativoPortaMittente());
                        t.setIndirizzoOrigine(busta.getIndirizzoMittente());
                        t.setTipoDestinazione(busta.getTipoDestinatario());
                        t.setDestinazione(busta.getDestinatario());
                        t.setIdentificativoPortaDestinazione(busta.getIdentificativoPortaDestinatario());
                        t.setIndirizzoDestinazione(busta.getIndirizzoDestinatario());
                        t.setOraRegistrazione(busta.getOraRegistrazione());
                        t.setTempo(busta.getTipoOraRegistrazione(), busta.getTipoOraRegistrazioneValue());
                        bustaRisposta.addTrasmissione(t);
                    }
                    if (generaTrasmissione || generaTrasmissioneInvertita || generaTrasmissioneAndataRitorno) {
                        t = new Trasmissione();
                        if (generaTrasmissione || generaTrasmissioneAndataRitorno) {
                            t.setTipoOrigine(bustaRisposta.getTipoMittente());
                            t.setOrigine(bustaRisposta.getMittente());
                            t.setIdentificativoPortaOrigine(bustaRisposta.getIdentificativoPortaMittente());
                            t.setIndirizzoOrigine(bustaRisposta.getIndirizzoMittente());
                            t.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                            t.setDestinazione(bustaRisposta.getDestinatario());
                            t.setIdentificativoPortaDestinazione(bustaRisposta.getIdentificativoPortaDestinatario());
                            t.setIndirizzoDestinazione(bustaRisposta.getIndirizzoDestinatario());
                        }
                        if (generaTrasmissioneInvertita) {
                            t.setTipoOrigine(bustaRisposta.getTipoDestinatario());
                            t.setOrigine(bustaRisposta.getDestinatario());
                            t.setIdentificativoPortaOrigine(bustaRisposta.getIdentificativoPortaDestinatario());
                            t.setIndirizzoOrigine(bustaRisposta.getIndirizzoDestinatario());
                            t.setTipoDestinazione(bustaRisposta.getTipoMittente());
                            t.setDestinazione(bustaRisposta.getMittente());
                            t.setIdentificativoPortaDestinazione(bustaRisposta.getIdentificativoPortaMittente());
                            t.setIndirizzoDestinazione(bustaRisposta.getIndirizzoMittente());
                        }
                        t.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                        t.setTempo(bustaRisposta.getTipoOraRegistrazione(), bustaRisposta.getTipoOraRegistrazioneValue());
                        bustaRisposta.addTrasmissione(t);
                    }
                    Integrazione integrazione = new Integrazione();
                    integrazione.setStateless(true);
                    imbustatore.imbustamento((IState)state, this.responseMsg, bustaRisposta, integrazione, gestioneManifest, false, false, properties.getProprietaManifestAttachments("standard"));
                } else if (this.responseMsg.getSOAPBody() != null && this.responseMsg.getSOAPBody().hasFault()) {
                    this.responseMsg.getSOAPBody().removeChild((Node)this.responseMsg.getSOAPBody().getFault());
                }
            }
            if (this.responseMsg != null) {
                this.contentLength = this.responseMsg.getIncomingMessageContentLength();
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante l'echo del msg soap", e);
            this.errore = "Riscontrato errore durante l'echo del msg soap:" + this.readExceptionMessageFromException(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (validatoreSintattico != null) {
                validatoreSintattico.setHeaderSOAP(null);
            }
            validatoreSintattico = null;
            if (validatoreProtocollo != null) {
                if (validatoreProtocollo.getValidatoreSintattico() != null) {
                    validatoreProtocollo.getValidatoreSintattico().setHeaderSOAP(null);
                }
                validatoreProtocollo.setValidatoreSintattico(null);
            }
            validatoreProtocollo = null;
            headerProtocolloRisposta = null;
            dbManager.releaseResource(properties.getIdentitaPortaDefault(protocol), "ConnettoreNullEcho", resource);
        }
        return true;
    }

    @Override
    public String getLocation() {
        if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
            return ConnettoreUtils.buildLocationWithURLBasedParameter(this.propertiesUrlBased, LOCATION);
        }
        return LOCATION;
    }
}

