/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.io.output.NullOutputStream;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.protocol.sdk.Busta;

public class ConnettoreNULL
extends ConnettoreBase {
    private ConnettoreLogger logger = null;
    public static final String LOCATION = "openspcoop2://dev/null";
    private Hashtable<String, String> properties;
    private Properties propertiesUrlBased;
    private Busta busta;
    private boolean debug = false;
    private String idMessaggio;

    @Override
    public boolean send(ConnettoreMsg request) {
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.properties = request.getConnectorProperties();
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        this.logger = new ConnettoreLogger(this.debug, this.idMessaggio, this.getPddContext());
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.codice = 200;
        try {
            NullOutputStream nullOutputStream = new NullOutputStream();
            request.getRequestMessage().writeTo((OutputStream)nullOutputStream, true);
            nullOutputStream.flush();
            nullOutputStream.close();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante la writeTo", e);
            this.errore = "Riscontrato errore durante la writeTo: " + this.readExceptionMessageFromException(e);
            return false;
        }
        try {
            this.postOutRequest();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante la gestione PostOutRequestHandler", e);
            this.errore = "Riscontrato errore durante la gestione PostOutRequestHandler: " + this.readExceptionMessageFromException(e);
            return false;
        }
        try {
            this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(request.getRequestMessage().getVersioneSoap());
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Riscontrato errore durante la generazione di un msg SoapVuoto", e);
            this.errore = "Riscontrato errore durante la generazione di un msg SoapVuoto: " + this.readExceptionMessageFromException(e);
            return false;
        }
        return true;
    }

    @Override
    public String getLocation() {
        if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
            return ConnettoreUtils.buildLocationWithURLBasedParameter(this.propertiesUrlBased, LOCATION);
        }
        return LOCATION;
    }
}

