/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class ConnettoreJMSProperties {
    private static Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    private Properties reader = new Properties();
    private static ConnettoreJMSProperties connettoreJMSProperties = null;

    public ConnettoreJMSProperties() throws Exception {
        InputStream properties = null;
        try {
            properties = ConnettoreJMSProperties.class.getResourceAsStream("/jmsPublisher.properties");
            this.reader.load(properties);
            properties.close();
        }
        catch (IOException e) {
            log.error((Object)("Riscontrato errore durante la lettura del file 'jmsPublisher.properties': \n\n" + e.getMessage()));
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception("ConnettoreJMSProperties initialize error: " + e.getMessage());
        }
    }

    public static boolean initialize() {
        try {
            connettoreJMSProperties = new ConnettoreJMSProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ConnettoreJMSProperties getInstance() {
        if (connettoreJMSProperties == null) {
            ConnettoreJMSProperties.initialize();
        }
        return connettoreJMSProperties;
    }

    public Hashtable<String, IDServizio> getIDServizi_Pubblicazione() {
        Hashtable<String, IDServizio> servizi = new Hashtable<String, IDServizio>();
        try {
            Vector<String> idServizi = new Vector<String>();
            Enumeration<?> en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String property = (String)en.nextElement();
                if (!property.startsWith("org.openspcoop.pubblicazione.")) continue;
                String key = property.substring("org.openspcoop.pubblicazione.".length());
                int indexOf = key.indexOf(".");
                if ((key = key.substring(0, indexOf)) != null) {
                    key = key.trim();
                }
                if (idServizi.contains(key)) continue;
                idServizi.add(key);
            }
            for (int i = 0; i < idServizi.size(); ++i) {
                IDServizio idServizio = new IDServizio();
                idServizio.setTipoServizio((String)this.reader.get("org.openspcoop.pubblicazione." + (String)idServizi.get(i) + ".tipoServizio"));
                idServizio.setServizio((String)this.reader.get("org.openspcoop.pubblicazione." + (String)idServizi.get(i) + ".servizio"));
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setTipo((String)this.reader.get("org.openspcoop.pubblicazione." + (String)idServizi.get(i) + ".tipoSoggettoErogatore"));
                idSoggetto.setNome((String)this.reader.get("org.openspcoop.pubblicazione." + (String)idServizi.get(i) + ".soggettoErogatore"));
                idServizio.setSoggettoErogatore(idSoggetto);
                servizi.put((String)idServizi.get(i), idServizio);
            }
            return servizi;
        }
        catch (Exception e) {
            log.error((Object)"Riscontrato errore durante la lettura dei servizi pubblicatori : 'org.openspcoop.pubblicazione.*'");
            return null;
        }
    }

    public Properties getJNDIContext_Configurazione(String id) {
        Properties prop = new Properties();
        try {
            String ricerca = "org.openspcoop.pubblicazione." + id + ".jndi.contextProperty.";
            Enumeration<?> en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(ricerca)) continue;
                String key = property.substring(ricerca.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.reader.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI per la configurazione: " + e.getMessage()));
            return null;
        }
    }

    public Properties getJNDIPool_Configurazione(String id) {
        Properties prop = new Properties();
        try {
            String ricerca = "org.openspcoop.pubblicazione." + id + ".jndi.poolProperty.";
            Enumeration<?> en = this.reader.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(ricerca)) continue;
                String key = property.substring(ricerca.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.reader.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante la lettura delle propriete' JNDI per la configurazione: " + e.getMessage()));
            return null;
        }
    }

    public String[] getClassNameSetPropertiesJMS() {
        try {
            String value = this.reader.getProperty("org.openspcoop.pubblicazione.setProprietaJMS.class");
            if (value != null) {
                String[] classi = (value = value.trim()).split(",");
                if (classi != null) {
                    for (int i = 0; i < classi.length; ++i) {
                        classi[i] = classi[i].trim();
                    }
                }
                return classi;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Riscontrato errore durante la lettura delle classi da utilizzare per il setting delle proprieta' JMS: " + e.getMessage()));
            return null;
        }
    }
}

