/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.soap.SOAPBody;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.soap.encoding.soapenc.Base64;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.message.MailcapActivationReader;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.RFC2047Encoding;
import org.openspcoop2.utils.resources.RFC2047Utilities;

public class ConnettoreHTTPCORE
extends ConnettoreBase {
    private static boolean USE_POOL = true;
    private ConnettoreLogger logger = null;
    private OpenSPCoop2Message requestMsg;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private Busta busta;
    private boolean debug = false;
    private String idModulo = null;
    private String idMessaggio;
    private InputStream isResponse = null;
    private HttpEntity httpEntityResponse = null;
    private HttpClient httpClient = null;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private static PoolingClientConnectionManager cm = null;

    private static synchronized void initialize() {
        if (cm == null) {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            cm = new PoolingClientConnectionManager(schemeRegistry);
            cm.setMaxTotal(10000);
            cm.setDefaultMaxPerRoute(1000);
        }
    }

    private static HttpClient getHttpClient() {
        return new DefaultHttpClient();
    }

    private static HttpClient getHttpClientFromPool() {
        if (cm == null) {
            ConnettoreHTTPCORE.initialize();
        }
        cm.closeExpiredConnections();
        cm.closeIdleConnections(30L, TimeUnit.SECONDS);
        DefaultHttpClient http = new DefaultHttpClient((ClientConnectionManager)cm);
        return http;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean send(ConnettoreMsg request) {
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.properties = request.getConnectorProperties();
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        this.logger = new ConnettoreLogger(this.debug, this.idMessaggio, this.getPddContext());
        try {
            this.requestMsg = request.getRequestMessage();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e);
            return false;
        }
        this.sbustamentoSoap = request.isSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        this.idModulo = request.getIdModulo();
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        try {
            if (this.debug) {
                this.logger.debug("Creazione URL...");
            }
            this.location = this.properties.get("location");
            if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
                this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.propertiesUrlBased, this.location);
            }
            if (this.debug) {
                this.logger.debug("Creazione URL [" + this.location + "]...");
            }
            url = new URL(this.location);
            if (this.debug) {
                this.logger.info("Creazione connessione alla URL [" + this.location + "]...", false);
            }
            this.httpClient = ConnettoreHTTPCORE.USE_POOL != false ? ConnettoreHTTPCORE.getHttpClientFromPool() : ConnettoreHTTPCORE.getHttpClient();
            httppost = new HttpPost(url.toString());
            ((DefaultHttpClient)this.httpClient).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                    while (it.hasNext()) {
                        HeaderElement he = it.nextElement();
                        String param = he.getName();
                        String value = he.getValue();
                        if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                        try {
                            return Long.parseLong(value) * 1000L;
                        }
                        catch (NumberFormatException ignore) {
                        }
                    }
                    return 120000L;
                }
            });
            this.requestMsg.updateContentType();
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            contentTypeRichiesta = null;
            contentTypeRichiesta = this.sbustamentoSoap != false && this.requestMsg.countAttachments() > 0 && SoapUtils.isTunnelOpenSPCoopSoap((SOAPBody)this.requestMsg.getSOAPBody()) != false ? SoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)this.requestMsg.getSOAPBody()) : this.requestMsg.getContentType();
            if (contentTypeRichiesta == null) {
                throw new Exception("Content-Type del messaggio da spedire non definito");
            }
            if (this.debug) {
                this.logger.info("Impostazione http Content-Type [" + contentTypeRichiesta + "]", false);
            }
            httppost.setHeader("Content-Type", contentTypeRichiesta);
            if (this.debug) {
                this.logger.debug("Spedizione byte...");
            }
            out = new ByteArrayOutputStream();
            if (this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Sbustamento...");
                }
                SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)this.requestMsg, (OutputStream)out);
            } else {
                this.requestMsg.writeTo((OutputStream)out, true);
            }
            out.flush();
            out.close();
            if (this.debug) {
                this.logger.info("Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + out.toString(), false);
            }
            httpEntity = new ByteArrayEntity(out.toByteArray());
            httppost.setEntity((HttpEntity)httpEntity);
            if (this.debug) {
                this.logger.debug("Impostazione transfer-length...");
            }
            transferEncodingChunked = false;
            tlm = null;
            chunkLength = -1;
            if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                tlm = this.openspcoopProperties.getTransferLengthModes_consegnaContenutiApplicativi();
                chunkLength = this.openspcoopProperties.getChunkLength_consegnaContenutiApplicativi();
            } else {
                tlm = this.openspcoopProperties.getTransferLengthModes_inoltroBuste();
                chunkLength = this.openspcoopProperties.getChunkLength_inoltroBuste();
            }
            transferEncodingChunked = TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals(tlm);
            if (transferEncodingChunked) {
                // empty if block
            }
            if (this.debug) {
                this.logger.info("Impostazione transfer-length effettuata (chunkLength:" + chunkLength + "): " + tlm, false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            connectionTimeout = -1;
            readConnectionTimeout = -1;
            if (this.properties.get("connection-timeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'connection-timeout' errato", e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("read-connection-timeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'read-connection-timeout' errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]", false);
            }
            this.httpClient.getParams().setIntParameter("http.connection.timeout", connectionTimeout);
            this.httpClient.getParams().setIntParameter("http.socket.timeout", readConnectionTimeout);
            if (this.debug) {
                this.logger.debug("Impostazione soap action...");
            }
            soapAction = null;
            if (!this.sbustamentoSoap) {
                soapAction = (String)this.requestMsg.getProperty("SOAPAction");
                if (soapAction == null) {
                    soapAction = "\"OpenSPCoop\"";
                }
                httppost.setHeader("SOAPAction", soapAction);
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + soapAction + "]", false);
                }
            }
            if (this.debug) {
                this.logger.debug("Impostazione autenticazione...");
            }
            user = null;
            password = null;
            if (this.credenziali != null) {
                user = this.credenziali.getUsername();
                password = this.credenziali.getPassword();
            } else {
                user = this.properties.get("user");
                password = this.properties.get("password");
            }
            if (user != null && password != null) {
                authentication = user + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                httppost.setHeader("Authorization", authentication);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                }
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            encodingRFC2047 = false;
            charsetRFC2047 = null;
            encodingAlgorithmRFC2047 = null;
            if (this.idModulo != null) {
                if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                    encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                    charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                    encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                } else {
                    encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_inoltroBuste();
                    charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_inoltroBuste();
                    encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_inoltroBuste();
                }
            }
            if (this.propertiesTrasporto != null) {
                enumSPC = this.propertiesTrasporto.keys();
                while (enumSPC.hasMoreElements()) {
                    key = (String)enumSPC.nextElement();
                    value = (String)this.propertiesTrasporto.get(key);
                    if (this.debug) {
                        this.logger.info("Set proprieta' [" + key + "]=[" + value + "]", false);
                    }
                    httppost.setHeader(key, value);
                    if (encodingRFC2047) {
                        if (!RFC2047Utilities.isAllCharactersInCharset((String)value, (Charset)charsetRFC2047)) {
                            encoded = RFC2047Utilities.encode((String)new String(value), (Charset)charsetRFC2047, (RFC2047Encoding)encodingAlgorithmRFC2047);
                            if (this.debug) {
                                this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + charsetRFC2047 + " encoding-algorithm:" + encodingAlgorithmRFC2047 + ")", false);
                            }
                            httppost.setHeader(key, encoded);
                            continue;
                        }
                        httppost.setHeader(key, value);
                        continue;
                    }
                    httppost.setHeader(key, value);
                }
            }
            if (this.debug) {
                this.logger.debug("Spedizione byte...");
            }
            postResponse = this.httpClient.execute((HttpUriRequest)httppost);
            this.httpEntityResponse = postResponse.getEntity();
            if (this.debug) {
                this.logger.debug("Analisi risposta...");
            }
            if ((hdrRisposta = postResponse.getAllHeaders()) != null) {
                for (i = 0; i < hdrRisposta.length; ++i) {
                    if (hdrRisposta[i].getName() == null) {
                        this.propertiesTrasportoRisposta.put("ReturnCode", hdrRisposta[i].getValue());
                        continue;
                    }
                    this.propertiesTrasportoRisposta.put(hdrRisposta[i].getName(), hdrRisposta[i].getValue());
                }
            }
            if ((tipoRispostaHdr = postResponse.getFirstHeader("Content-Type")) == null) {
                tipoRispostaHdr = postResponse.getFirstHeader("Content-Type".toLowerCase());
            }
            if (tipoRispostaHdr == null) {
                tipoRispostaHdr = postResponse.getFirstHeader("Content-Type".toUpperCase());
            }
            tipoRisposta = null;
            if (tipoRispostaHdr != null) {
                tipoRisposta = tipoRispostaHdr.getValue();
            }
            if ((locationRispostaHdr = postResponse.getFirstHeader("Content-Location")) == null) {
                locationRispostaHdr = postResponse.getFirstHeader("Content-Location".toLowerCase());
            }
            if (locationRispostaHdr == null) {
                locationRispostaHdr = postResponse.getFirstHeader("Content-Location".toUpperCase());
            }
            locationRisposta = null;
            if (locationRispostaHdr != null) {
                locationRisposta = locationRispostaHdr.getValue();
            }
            if ((contentLengthHdr = postResponse.getFirstHeader("Content-Length")) == null) {
                contentLengthHdr = postResponse.getFirstHeader("Content-Length".toLowerCase());
            }
            if (contentLengthHdr == null) {
                contentLengthHdr = postResponse.getFirstHeader("Content-Length".toUpperCase());
            }
            contentLenght = -1L;
            if (contentLengthHdr != null) {
                contentLenght = Long.parseLong(contentLengthHdr.getValue());
            }
            if (this.httpEntityResponse.getContentLength() > 0L) {
                this.contentLength = this.httpEntityResponse.getContentLength();
            }
            imbustamentoConAttachment = false;
            tunnelSoapHdr = postResponse.getFirstHeader(this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto());
            if (tunnelSoapHdr != null && "true".equals(tunnelSoapHdr.getValue())) {
                imbustamentoConAttachment = true;
            }
            mimeTypeAttachmentHdr = postResponse.getFirstHeader(this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto());
            mimeTypeAttachment = null;
            if (mimeTypeAttachmentHdr != null) {
                mimeTypeAttachment = mimeTypeAttachmentHdr.getValue();
            }
            if (mimeTypeAttachment == null) {
                mimeTypeAttachment = "application/openspcoop2";
            }
            if (this.debug) {
                this.logger.debug("Analisi risposta input stream e risultato http...");
            }
            resultHTTPOperation = postResponse.getStatusLine().getStatusCode();
            resultHTTPMessage = postResponse.getStatusLine().getReasonPhrase();
            this.isResponse = resultHTTPOperation < 300 ? this.httpEntityResponse.getContent() : this.httpEntityResponse.getContent();
            this.postOutRequest();
            this.preInResponse();
            notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            b = new byte[1];
            this.isResponse = this.isResponse != null && this.isResponse.read(b) == -1 ? null : new SequenceInputStream(new ByteArrayInputStream(b), this.isResponse);
            tipoLetturaRisposta = null;
            if (resultHTTPOperation >= 400 && tipoRisposta != null && tipoRisposta.contains("text/html")) {
                tipoLetturaRisposta = "(" + resultHTTPOperation + ") " + resultHTTPMessage;
                this.codice = resultHTTPOperation;
                this.errore = tipoLetturaRisposta;
                return false;
            }
            if (this.isResponse != null) {
                soapVersionRisposta = null;
                protocolConfiguration = this.getProtocolFactory().createProtocolConfiguration();
                if (tipoRisposta != null) {
                    try {
                        soapVersionRisposta = ServletUtils.getVersioneSoap(this.logger.getLogger(), tipoRisposta);
                    }
                    catch (Exception e) {
                        this.logger.error("SOAPVersion response unknown: " + e.getMessage(), e);
                    }
                }
                if (tipoRisposta == null || soapVersionRisposta == null || !soapVersionRisposta.equals((Object)this.requestMsg.getVersioneSoap()) || !ServletUtils.isContentTypeSupported(this.requestMsg.getVersioneSoap(), this.getProtocolFactory())) {
                    checkContentType = true;
                    if (this.idModulo != null) {
                        checkContentType = "ConsegnaContenutiApplicativi".equals(this.idModulo) != false ? this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneBuste() : this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneContenutiApplicativi();
                    }
                    msgErrore = null;
                    msgErrore = tipoRisposta == null ? "Header Content-Type non definito nell'http reply" : (soapVersionRisposta == null ? "Il valore dell'header HTTP Content-Type definito nell'http reply (" + tipoRisposta + ") non rientra tra quelli conosciuti (" + SOAPVersion.getKnownContentTypes() + ")" : (soapVersionRisposta.equals((Object)this.requestMsg.getVersioneSoap()) == false ? "Header Content-Type definito nell'http reply (" + tipoRisposta + ") indica una versione " + soapVersionRisposta.getSoapVersionAsString() + " non compatibile con la versione " + this.requestMsg.getVersioneSoap().getSoapVersionAsString() + " del messaggio di richiesta" : "Il valore dell'header HTTP Content-Type definito nell'http reply (" + tipoRisposta + ") non rientra tra quelli supportati dal protocollo (" + SOAPVersion.getKnownContentTypes((boolean)protocolConfiguration.isSupportoSOAP11(), (boolean)protocolConfiguration.isSupportoSOAP12()) + ")"));
                    if (checkContentType) {
                        throw new Exception(msgErrore);
                    }
                    this.logger.warn(msgErrore + "; viene utilizzato forzatamente il tipo: " + SOAPVersion.SOAP11.getContentTypeForMessageWithoutAttachments());
                    tipoRisposta = SOAPVersion.SOAP11.getContentTypeForMessageWithoutAttachments();
                }
                try {
                    if (this.debug) {
                        bout = new ByteArrayOutputStream();
                        readB = new byte[65536];
                        readByte = 0;
                        while ((readByte = this.isResponse.read(readB)) != -1) {
                            bout.write(readB, 0, readByte);
                        }
                        this.isResponse.close();
                        bout.flush();
                        bout.close();
                        this.logger.info("Messaggio ricevuto (ContentType:" + tipoRisposta + ") :\n" + bout.toString(), false);
                        this.isResponse = new ByteArrayInputStream(bout.toByteArray());
                    }
                    if (!this.sbustamentoSoap) {
                        if (this.debug) {
                            this.logger.debug("Ricostruzione normale...");
                        }
                        tipoLetturaRisposta = "Costruzione messaggio SOAP";
                        if (contentLenght > 0L) {
                            this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(this.isResponse, notifierInputStreamParams, false, tipoRisposta, locationRisposta, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                        } else if (contentLenght == 0L) {
                            this.responseMsg = null;
                        } else {
                            try {
                                buffer = new byte[1];
                                letti = this.isResponse.read(buffer);
                                if (letti != 1) ** GOTO lbl337
                                sInput = new SequenceInputStream(new ByteArrayInputStream(buffer), this.isResponse);
                                this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage((InputStream)sInput, notifierInputStreamParams, false, tipoRisposta, locationRisposta, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                            }
                            catch (Exception e) {
                                this.responseMsg = null;
                                result2XX = resultHTTPOperation >= 200 && resultHTTPOperation <= 299;
                                v0 = premature = Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) != false && result2XX != false;
                                if (premature || !result2XX) ** GOTO lbl337
                                this.eccezioneProcessamento = e;
                                this.errore = "Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e);
                                this.logger.error("Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e), e);
                                return false;
                            }
                        }
                    } else {
                        cis = null;
                        try {
                            cis = new CountingInputStream(this.isResponse);
                            if (imbustamentoConAttachment) {
                                if (this.debug) {
                                    this.logger.debug("Imbustamento con attachments...");
                                }
                                tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + mimeTypeAttachment;
                                try {
                                    this.responseMsg = SoapUtils.imbustamentoMessaggioConAttachment((SOAPVersion)this.requestMsg.getVersioneSoap(), (InputStream)cis, (String)mimeTypeAttachment, (boolean)MailcapActivationReader.existsDataContentHandler((String)mimeTypeAttachment), (String)tipoRisposta, (String)this.openspcoopProperties.getHeaderSoapActorIntegrazione());
                                }
                                catch (UtilsException e) {
                                    if (e.getMessage() != null && e.getMessage().equals("Contenuto da imbustare non presente")) ** GOTO lbl327
                                    throw e;
                                }
                            } else if (tipoRisposta != null && tipoRisposta.contains("multipart/related")) {
                                if (this.debug) {
                                    this.logger.debug("Imbustamento messaggio multipart/related...");
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio multipart/related in un SOAP WithAttachments";
                                byteBuffer = new ByteArrayOutputStream();
                                readB = new byte[65536];
                                readByte = 0;
                                while ((readByte = cis.read(readB)) != -1) {
                                    byteBuffer.write(readB, 0, readByte);
                                }
                                if (byteBuffer.size() > 0) {
                                    this.responseMsg = SoapUtils.imbustamentoMessaggio((NotifierInputStreamParams)notifierInputStreamParams, (byte[])byteBuffer.toByteArray(), (boolean)this.openspcoopProperties.isDeleteInstructionTargetMachineXml(), (boolean)this.openspcoopProperties.isFileCacheEnable(), (String)this.openspcoopProperties.getAttachmentRepoDir(), (String)this.openspcoopProperties.getFileThreshold());
                                }
                            } else {
                                if (this.debug) {
                                    this.logger.debug("Imbustamento messaggio...");
                                }
                                tipoLetturaRisposta = "Imbustamento messaggio xml in un messaggio SOAP";
                                this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage((InputStream)cis, notifierInputStreamParams, true, tipoRisposta, locationRisposta, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                            }
lbl327:
                            // 4 sources

                            if (this.responseMsg != null) {
                                this.responseMsg.updateIncomingMessageContentLength(cis.getByteCount());
                            }
                        }
                        finally {
                            try {
                                if (cis != null) {
                                    cis.close();
                                }
                            }
                            catch (Exception eClose) {}
                        }
                    }
                    try {
                        if (this.responseMsg != null) {
                            this.responseMsg.getSOAPPart().getEnvelope();
                        }
                    }
                    catch (Exception e) {
                        this.responseMsg = null;
                        result2XX = resultHTTPOperation >= 200 && resultHTTPOperation <= 299;
                        v1 = premature = Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) != false && result2XX != false;
                        if (!premature && result2XX) {
                            this.eccezioneProcessamento = e;
                            this.errore = "Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e);
                            this.logger.error("Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e), e);
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    this.eccezioneProcessamento = e;
                    this.errore = "Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + "): " + this.readExceptionMessageFromException(e);
                    this.logger.error("Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + ")", e);
                    return false;
                }
                if (this.debug) {
                    this.logger.debug("Save messaggio...");
                }
                try {
                    if (this.responseMsg != null && this.responseMsg.countAttachments() == 0) {
                        this.responseMsg.getSOAPPart();
                    }
                }
                catch (Exception e) {
                    this.eccezioneProcessamento = e;
                    this.errore = "Errore avvenuto durante la consegna HTTP (salvataggio risposta): " + this.readExceptionMessageFromException(e);
                    this.logger.error("Errore avvenuto durante la consegna HTTP (salvataggio risposta): " + this.readExceptionMessageFromException(e), e);
                    return false;
                }
            }
            this.codice = resultHTTPOperation;
            if (this.debug) {
                this.logger.info("Gestione invio/risposta http effettuata con successo", false);
            }
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore avvenuto durante la consegna HTTP: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore avvenuto durante la consegna HTTPNIO: " + this.readExceptionMessageFromException(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.isResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura socket...");
                }
                this.isResponse.close();
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
        try {
            if (this.httpEntityResponse != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura httpEntityResponse...");
                }
                EntityUtils.consume((HttpEntity)this.httpEntityResponse);
            }
            if (this.httpEntityResponse == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
        try {
            super.disconnect();
            return;
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura risorse non riuscita: " + e.getMessage(), e);
        }
    }
}

