/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.soap.SOAPBody;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.log4j.Logger;
import org.apache.soap.encoding.soapenc.Base64;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.core.api.utils.Imbustamento;
import org.openspcoop2.core.api.utils.Sbustamento;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.message.MailcapActivationReader;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPSProperties;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.connettori.HttpAuthenticator;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.HttpUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.RFC2047Encoding;
import org.openspcoop2.utils.resources.RFC2047Utilities;
import org.openspcoop2.utils.resources.SSLConfig;
import org.openspcoop2.utils.resources.SSLUtilities;

public class ConnettoreHTTP
extends ConnettoreBase {
    public ByteArrayOutputStream outByte = new ByteArrayOutputStream();
    protected OpenSPCoop2Message requestMsg;
    protected Hashtable<String, String> properties;
    protected boolean sbustamentoSoap;
    protected Properties propertiesTrasporto;
    protected Properties propertiesUrlBased;
    protected Credenziali credenziali;
    protected Busta busta;
    protected boolean debug = false;
    protected OpenSPCoop2Properties openspcoopProperties = null;
    protected String idMessaggio;
    protected ConnettoreLogger logger = null;
    protected Loader loader = null;
    protected String idModulo = null;
    protected boolean connettoreHttps = false;
    protected ConnettoreHTTPSProperties sslContextProperties;
    protected Proxy.Type proxyType = null;
    protected String proxyUrl = null;
    protected int proxyPort;
    protected String proxyUsername;
    protected String proxyPassword;
    protected boolean followRedirects = false;
    protected String routeRedirect = null;
    protected int numberRedirect = 0;
    protected int maxNumberRedirects = 5;
    protected InputStream is = null;
    protected HttpURLConnection httpConn = null;
    protected String httpMethod = null;
    protected boolean sbustamentoApi;

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public boolean isSbustamentoApi() {
        return this.sbustamentoApi;
    }

    public ConnettoreHTTP() {
        this.connettoreHttps = false;
    }

    public ConnettoreHTTP(boolean https) {
        this.connettoreHttps = https;
    }

    protected void setSSLContext() throws Exception {
        if (this.connettoreHttps) {
            this.sslContextProperties = ConnettoreHTTPSProperties.readProperties(this.properties);
        }
    }

    @Override
    public boolean send(ConnettoreMsg request) {
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.loader = Loader.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.properties = request.getConnectorProperties();
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        this.logger = new ConnettoreLogger(this.debug, this.idMessaggio, this.getPddContext());
        try {
            this.requestMsg = request.getRequestMessage();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e);
            return false;
        }
        this.sbustamentoSoap = request.isSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        try {
            Object o = this.requestMsg.getContextProperty("MESSAGGIO_API");
            if (o != null) {
                this.sbustamentoApi = (Boolean)o;
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e), e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + this.readExceptionMessageFromException(e);
            return false;
        }
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (Msg)";
            return false;
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        try {
            this.setSSLContext();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("[HTTPS error]" + this.readExceptionMessageFromException(e), e);
            this.errore = "[HTTPS error]" + this.readExceptionMessageFromException(e);
            return false;
        }
        if (this.properties.get("proxyType") != null) {
            String tipo = this.properties.get("proxyType").trim();
            if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP.equals(tipo)) {
                this.proxyType = Proxy.Type.HTTP;
            } else if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS.equals(tipo)) {
                this.proxyType = Proxy.Type.HTTP;
            } else {
                this.errore = "Proprieta' 'proxyType' non corretta. Impostato un tipo sconosciuto [" + tipo + "] (valori ammessi: " + CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP + "," + CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS + ")";
                return false;
            }
            this.proxyUrl = this.properties.get("proxyUrl");
            if (this.proxyUrl == null) {
                this.errore = "Proprieta' 'proxyUrl' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'";
                return false;
            }
            this.proxyUrl = this.proxyUrl.trim();
            String proxyPortTmp = this.properties.get("proxyPort");
            if (proxyPortTmp == null) {
                this.errore = "Proprieta' 'proxyPort' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'";
                return false;
            }
            proxyPortTmp = proxyPortTmp.trim();
            try {
                this.proxyPort = Integer.parseInt(proxyPortTmp);
            }
            catch (Exception e) {
                this.errore = "Proprieta' 'proxyPort' non corretta: " + this.readExceptionMessageFromException(e);
                return false;
            }
            this.proxyUsername = this.properties.get("proxyUsername");
            if (this.proxyUsername != null) {
                this.proxyUsername = this.proxyUsername.trim();
            }
            this.proxyPassword = this.properties.get("proxyPassword");
            if (this.proxyPassword != null) {
                this.proxyPassword = this.proxyPassword.trim();
            } else if (this.proxyUsername != null) {
                this.errore = "Proprieta' 'proxyPassword' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyUsername'";
                return false;
            }
        }
        this.idModulo = request.getIdModulo();
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
            this.followRedirects = this.openspcoopProperties.isFollowRedirects_consegnaContenutiApplicativi();
            this.maxNumberRedirects = this.openspcoopProperties.getFollowRedirectsMaxHop_consegnaContenutiApplicativi();
        } else {
            this.followRedirects = this.openspcoopProperties.isFollowRedirects_inoltroBuste();
            this.maxNumberRedirects = this.openspcoopProperties.getFollowRedirectsMaxHop_inoltroBuste();
        }
        String redirectTmp = this.properties.get("followRedirects");
        if (redirectTmp != null) {
            redirectTmp = redirectTmp.trim();
            this.followRedirects = Boolean.parseBoolean(redirectTmp);
        }
        if (this.followRedirects) {
            redirectTmp = this.properties.get("numberRedirect");
            if (redirectTmp != null) {
                redirectTmp = redirectTmp.trim();
                this.numberRedirect = Integer.parseInt(redirectTmp);
            }
            if ((redirectTmp = this.properties.get("routeRedirect")) != null) {
                this.routeRedirect = redirectTmp = redirectTmp.trim();
            }
        }
        return this.sendHTTP(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean sendHTTP(ConnettoreMsg request) {
        sbustamentoAPIengine = null;
        imbustamentoAPIengine = null;
        try {
            if (this.sbustamentoApi) {
                sbustamentoAPIengine = new Sbustamento(this.requestMsg);
            }
            sslContext = null;
            if (this.sslContextProperties != null) {
                bfSSLConfig = new StringBuffer();
                sslContext = SSLUtilities.generateSSLContext((SSLConfig)this.sslContextProperties, (StringBuffer)bfSSLConfig);
                if (this.debug) {
                    this.logger.info(bfSSLConfig.toString(), false);
                }
            }
            if (this.debug) {
                this.logger.debug("Creazione URL...");
            }
            this.location = this.properties.get("location");
            if (this.sbustamentoApi) {
                if (this.debug) {
                    this.logger.debug("Build URL for API ...");
                }
                this.location = sbustamentoAPIengine.buildUrl(this.location, this.propertiesUrlBased);
            } else if (this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
                this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.propertiesUrlBased, this.location);
            }
            if (this.debug) {
                this.logger.debug("Creazione URL [" + this.location + "]...");
            }
            url = new URL(this.location);
            connection = null;
            if (this.proxyType == null) {
                if (this.debug) {
                    this.logger.info("Creazione connessione alla URL [" + this.location + "]...", false);
                }
                connection = url.openConnection();
            } else {
                if (this.debug) {
                    this.logger.info("Creazione connessione alla URL [" + this.location + "] (via proxy " + this.proxyUrl + ":" + this.proxyPassword + ") (username[" + this.proxyUsername + "] password[" + this.proxyPassword + "])...", false);
                }
                if (this.proxyUsername != null) {
                    Authenticator.setDefault(new HttpAuthenticator(this.proxyUsername, this.proxyPassword));
                }
                proxy = new Proxy(this.proxyType, new InetSocketAddress(this.proxyUrl, this.proxyPort));
                connection = url.openConnection(proxy);
            }
            this.httpConn = (HttpURLConnection)connection;
            if (this.sslContextProperties != null) {
                httpsConn = (HttpsURLConnection)this.httpConn;
                httpsConn.setSSLSocketFactory(sslContext.getSocketFactory());
                bfLog = new StringBuffer();
                hostnameVerifier = SSLUtilities.generateHostnameVerifier((SSLConfig)this.sslContextProperties, (StringBuffer)bfLog, (Logger)this.logger.getLogger(), (Loader)this.loader);
                if (this.debug) {
                    this.logger.debug(bfLog.toString());
                }
                if (hostnameVerifier != null) {
                    httpsConn.setHostnameVerifier(hostnameVerifier);
                }
            }
            this.requestMsg.updateContentType();
            contentTypeRichiesta = null;
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            if (this.sbustamentoApi) {
                contentTypeRichiesta = sbustamentoAPIengine.getContentType();
            } else {
                contentTypeRichiesta = this.sbustamentoSoap != false && this.requestMsg.countAttachments() > 0 && SoapUtils.isTunnelOpenSPCoopSoap((SOAPBody)this.requestMsg.getSOAPBody()) != false ? SoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)this.requestMsg.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new Exception("Content-Type del messaggio da spedire non definito");
                }
            }
            if (this.debug) {
                this.logger.info("Impostazione http Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.httpConn.setRequestProperty("Content-Type", contentTypeRichiesta);
            }
            this.httpMethod = MethodType.POST.name();
            if (this.sbustamentoApi) {
                this.httpMethod = sbustamentoAPIengine.getHttpMethod();
            }
            if (this.debug) {
                this.logger.debug("Impostazione transfer-length...");
            }
            transferEncodingChunked = false;
            tlm = null;
            chunkLength = -1;
            if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                tlm = this.openspcoopProperties.getTransferLengthModes_consegnaContenutiApplicativi();
                chunkLength = this.openspcoopProperties.getChunkLength_consegnaContenutiApplicativi();
            } else {
                tlm = this.openspcoopProperties.getTransferLengthModes_inoltroBuste();
                chunkLength = this.openspcoopProperties.getChunkLength_inoltroBuste();
            }
            transferEncodingChunked = TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals(tlm);
            if (transferEncodingChunked) {
                HttpUtilities.setChunkedStreamingMode((HttpURLConnection)this.httpConn, (int)chunkLength, (String)this.httpMethod, (String)contentTypeRichiesta);
            }
            if (this.debug) {
                this.logger.info("Impostazione transfer-length effettuata (chunkLength:" + chunkLength + "): " + tlm, false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            connectionTimeout = -1;
            readConnectionTimeout = -1;
            if (this.properties.get("connection-timeout") != null) {
                try {
                    connectionTimeout = Integer.parseInt(this.properties.get("connection-timeout"));
                }
                catch (Exception e) {
                    this.logger.error("Parametro 'connection-timeout' errato", e);
                }
            }
            if (connectionTimeout == -1) {
                connectionTimeout = 10000;
            }
            if (this.properties.get("read-connection-timeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt(this.properties.get("read-connection-timeout"));
                }
                catch (Exception e) {
                    this.logger.error("Parametro read-connection-timeout errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione http timeout CT[" + connectionTimeout + "] RT[" + readConnectionTimeout + "]", false);
            }
            this.httpConn.setConnectTimeout(connectionTimeout);
            this.httpConn.setReadTimeout(readConnectionTimeout);
            if (this.debug) {
                this.logger.debug("Impostazione soap action...");
            }
            soapAction = null;
            if (!this.sbustamentoSoap && !this.sbustamentoApi) {
                soapAction = (String)this.requestMsg.getProperty("SOAPAction");
                if (soapAction == null && SOAPVersion.SOAP11.equals((Object)this.requestMsg.getVersioneSoap())) {
                    soapAction = "\"OpenSPCoop\"";
                }
                if (SOAPVersion.SOAP11.equals((Object)this.requestMsg.getVersioneSoap())) {
                    this.httpConn.setRequestProperty("SOAPAction", soapAction);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + soapAction + "]", false);
                }
            }
            if (this.debug) {
                this.logger.debug("Impostazione autenticazione...");
            }
            user = null;
            password = null;
            if (this.credenziali != null) {
                user = this.credenziali.getUsername();
                password = this.credenziali.getPassword();
            } else {
                user = this.properties.get("user");
                password = this.properties.get("password");
            }
            if (user != null && password != null) {
                authentication = user + ":" + password;
                authentication = "Basic " + Base64.encode((byte[])authentication.getBytes());
                this.httpConn.setRequestProperty("Authorization", authentication);
                if (this.debug) {
                    this.logger.info("Impostazione autenticazione (username:" + user + " password:" + password + ") [" + authentication + "]", false);
                }
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            encodingRFC2047 = false;
            charsetRFC2047 = null;
            encodingAlgorithmRFC2047 = null;
            if (this.idModulo != null) {
                if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                    encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                    charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                    encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_consegnaContenutiApplicativi();
                } else {
                    encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValue_inoltroBuste();
                    charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValue_inoltroBuste();
                    encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValue_inoltroBuste();
                }
            }
            if (this.sbustamentoApi) {
                if (this.debug) {
                    this.logger.debug("Aggiunta header di trasporto api...");
                }
                if ((pTrasporto = sbustamentoAPIengine.getTransportProperties()) != null && pTrasporto.size() > 0) {
                    if (this.propertiesTrasporto == null) {
                        this.propertiesTrasporto = new Properties();
                    }
                    this.propertiesTrasporto.putAll((Map<?, ?>)pTrasporto);
                    if (this.debug) {
                        this.logger.debug("Aggiunta header di trasporto api (" + pTrasporto.size() + ")");
                    }
                }
            }
            if (this.propertiesTrasporto != null) {
                enumProperties = this.propertiesTrasporto.keys();
                while (enumProperties.hasMoreElements()) {
                    key = (String)enumProperties.nextElement();
                    value = (String)this.propertiesTrasporto.get(key);
                    if (this.debug) {
                        this.logger.info("Set proprieta' [" + key + "]=[" + value + "]", false);
                    }
                    if (encodingRFC2047) {
                        if (!RFC2047Utilities.isAllCharactersInCharset((String)value, (Charset)charsetRFC2047)) {
                            encoded = RFC2047Utilities.encode((String)new String(value), (Charset)charsetRFC2047, (RFC2047Encoding)encodingAlgorithmRFC2047);
                            if (this.debug) {
                                this.logger.info("RFC2047 Encoded value in [" + encoded + "] (charset:" + charsetRFC2047 + " encoding-algorithm:" + encodingAlgorithmRFC2047 + ")", false);
                            }
                            this.httpConn.setRequestProperty(key, encoded);
                            continue;
                        }
                        this.httpConn.setRequestProperty(key, value);
                        continue;
                    }
                    this.httpConn.setRequestProperty(key, value);
                }
            }
            if (this.debug) {
                this.logger.info("Impostazione " + this.httpMethod + "...", false);
            }
            HttpUtilities.setStream((HttpURLConnection)this.httpConn, (String)this.httpMethod, (String)contentTypeRichiesta);
            consumeRequestMessage = true;
            if (this.followRedirects) {
                consumeRequestMessage = false;
            }
            if (this.debug) {
                this.logger.debug("Spedizione byte (consume-request-message:" + consumeRequestMessage + ")...");
            }
            if (this.sbustamentoApi) {
                resource = sbustamentoAPIengine.getBody();
                if (resource != null) {
                    out = this.httpConn.getOutputStream();
                    if (this.debug) {
                        this.logger.info("Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + new String(resource), false);
                    }
                    out.write(resource);
                    out.flush();
                    out.close();
                }
            } else {
                out = this.httpConn.getOutputStream();
                if (this.debug) {
                    bout = new ByteArrayOutputStream();
                    if (this.sbustamentoSoap) {
                        this.logger.debug("Sbustamento...");
                        SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)this.requestMsg, (OutputStream)bout);
                    } else {
                        this.requestMsg.writeTo((OutputStream)bout, consumeRequestMessage);
                    }
                    bout.flush();
                    bout.close();
                    out.write(bout.toByteArray());
                    this.logger.info("Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + bout.toString(), false);
                    bout.close();
                } else if (this.sbustamentoSoap) {
                    if (this.debug) {
                        this.logger.debug("Sbustamento...");
                    }
                    SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)this.requestMsg, (OutputStream)out);
                } else {
                    this.requestMsg.writeTo(out, consumeRequestMessage);
                }
                out.flush();
                out.close();
            }
            if (this.debug) {
                this.logger.debug("Analisi risposta...");
            }
            if ((mapHeaderHttpResponse = this.httpConn.getHeaderFields()) != null && mapHeaderHttpResponse.size() > 0) {
                if (this.propertiesTrasportoRisposta == null) {
                    this.propertiesTrasportoRisposta = new Properties();
                }
                for (String keyHttpResponse : mapHeaderHttpResponse.keySet()) {
                    valueHttpResponse = mapHeaderHttpResponse.get(keyHttpResponse);
                    bfHttpResponse = new StringBuffer();
                    for (i = 0; i < valueHttpResponse.size(); ++i) {
                        if (i > 0) {
                            bfHttpResponse.append(",");
                        }
                        bfHttpResponse.append(valueHttpResponse.get(i));
                    }
                    if (keyHttpResponse == null) {
                        keyHttpResponse = "ReturnCode";
                    }
                    this.propertiesTrasportoRisposta.put(keyHttpResponse, bfHttpResponse.toString());
                }
            }
            if ((tipoRisposta = this.httpConn.getHeaderField("Content-Type")) == null) {
                tipoRisposta = this.httpConn.getHeaderField("Content-Type".toLowerCase());
            }
            if (tipoRisposta == null) {
                tipoRisposta = this.httpConn.getHeaderField("Content-Type".toUpperCase());
            }
            if ((locationRisposta = this.httpConn.getHeaderField("Content-Location")) == null) {
                locationRisposta = this.httpConn.getHeaderField("Content-Location".toLowerCase());
            }
            if (locationRisposta == null) {
                locationRisposta = this.httpConn.getHeaderField("Content-Location".toUpperCase());
            }
            contentLenght = -1;
            contentLenghtString = this.httpConn.getHeaderField("Content-Length");
            if (contentLenghtString == null) {
                contentLenghtString = this.httpConn.getHeaderField("Content-Length".toLowerCase());
            }
            if (contentLenghtString == null) {
                contentLenghtString = this.httpConn.getHeaderField("Content-Length".toUpperCase());
            }
            if (contentLenghtString != null) {
                contentLenght = Integer.valueOf(contentLenghtString);
            }
            if (this.httpConn.getContentLength() > 0) {
                this.contentLength = this.httpConn.getContentLength();
            }
            imbustamentoConAttachment = false;
            if ("true".equals(this.httpConn.getHeaderField(this.openspcoopProperties.getTunnelSOAPKeyWord_headerTrasporto()))) {
                imbustamentoConAttachment = true;
            }
            if ((mimeTypeAttachment = this.httpConn.getHeaderField(this.openspcoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto())) == null) {
                mimeTypeAttachment = "application/openspcoop2";
            }
            acceptOnlyReturnCode_202_200 = true;
            acceptOnlyReturnCode_202_200 = this.sbustamentoApi != false ? false : ("ConsegnaContenutiApplicativi".equals(this.idModulo) != false ? this.openspcoopProperties.isAcceptOnlyReturnCode_200_202_consegnaContenutiApplicativi() : this.openspcoopProperties.isAcceptOnlyReturnCode_200_202_inoltroBuste());
            if (this.debug) {
                this.logger.debug("Analisi risposta input stream e risultato http...");
            }
            this.codice = this.httpConn.getResponseCode();
            resultHTTPMessage = this.httpConn.getResponseMessage();
            if (this.codice >= 400) {
                this.is = this.httpConn.getErrorStream();
            } else {
                if (this.codice > 299) {
                    redirectLocation = this.httpConn.getHeaderField("Location");
                    if (redirectLocation == null) {
                        redirectLocation = this.httpConn.getHeaderField("Location".toLowerCase());
                    }
                    if (redirectLocation == null) {
                        redirectLocation = this.httpConn.getHeaderField("Location".toUpperCase());
                    }
                    if (redirectLocation == null) {
                        throw new Exception("Non \u00e8 stato rilevato l'header HTTP [Location] necessario alla gestione del Redirect (code:" + this.codice + ")");
                    }
                    if (this.followRedirects) {
                        request.getConnectorProperties().remove("location");
                        request.getConnectorProperties().remove("numberRedirect");
                        request.getConnectorProperties().remove("routeRedirect");
                        request.getConnectorProperties().put("location", redirectLocation);
                        request.getConnectorProperties().put("numberRedirect", this.numberRedirect + 1 + "");
                        if (this.routeRedirect != null) {
                            request.getConnectorProperties().put("routeRedirect", this.routeRedirect + " -> " + redirectLocation);
                        } else {
                            request.getConnectorProperties().put("routeRedirect", redirectLocation);
                        }
                        this.logger.warn("(hope:" + (this.numberRedirect + 1) + ") Redirect verso [" + redirectLocation + "] ...");
                        if (this.numberRedirect == this.maxNumberRedirects) {
                            throw new Exception("Gestione redirect (code:" + this.codice + " " + "Location" + ":" + redirectLocation + ") non consentita ulteriormente, sono gi\u00e0 stati gestiti " + this.maxNumberRedirects + " redirects: " + this.routeRedirect);
                        }
                        acceptOnlyReturnCode_307 = false;
                        acceptOnlyReturnCode_307 = "ConsegnaContenutiApplicativi".equals(this.idModulo) != false ? this.openspcoopProperties.isAcceptOnlyReturnCode_307_consegnaContenutiApplicativi() : this.openspcoopProperties.isAcceptOnlyReturnCode_307_inoltroBuste();
                        if (acceptOnlyReturnCode_307 && this.codice != 307) {
                            throw new Exception("Return code [" + this.codice + "] (redirect " + "Location" + ":" + redirectLocation + ") non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Redirect_Status_Codes)");
                        }
                        return this.send(request);
                    }
                    throw new Exception("Gestione redirect (code:" + this.codice + " " + "Location" + ":" + redirectLocation + ") non attiva");
                }
                if (acceptOnlyReturnCode_202_200 && this.codice != 200 && this.codice != 202) {
                    throw new Exception("Return code [" + this.codice + "] non consentito dal WS-I Basic Profile (http://www.ws-i.org/Profiles/BasicProfile-1.1-2004-08-24.html#HTTP_Success_Status_Codes)");
                }
                this.is = this.httpConn.getInputStream();
            }
            this.postOutRequest();
            this.preInResponse();
            notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            b = new byte[1];
            if (this.is != null) {
                this.is = this.is.read(b) == -1 ? null : new SequenceInputStream(new ByteArrayInputStream(b), this.is);
            } else {
                this.logger.info("Stream di risposta (return-code:" + this.codice + ") is null", true);
            }
            tipoLetturaRisposta = null;
            if (this.sbustamentoApi) {
                if (this.debug) {
                    this.logger.debug("gestione API in corso ...");
                }
                imbustamentoAPIengine = new Imbustamento(this.requestMsg.getVersioneSoap(), notifierInputStreamParams, this.is, MethodType.toEnumConstant((String)this.httpMethod), tipoRisposta, this.propertiesTrasportoRisposta, Integer.valueOf(this.codice), resultHTTPMessage, this.openspcoopProperties.getAPIServicesWhiteListResponseHeaderList());
                this.responseMsg = imbustamentoAPIengine.getMessage();
            } else {
                if (this.debug) {
                    this.logger.debug("gestione WS/SOAP in corso ...");
                }
                if (this.codice >= 400 && tipoRisposta != null && tipoRisposta.contains("text/html")) {
                    tipoLetturaRisposta = "(" + this.codice + ") " + resultHTTPMessage;
                    htmlRicevuto = null;
                    if (this.is != null) {
                        bout = new ByteArrayOutputStream();
                        readB = new byte[65536];
                        readByte = 0;
                        while ((readByte = this.is.read(readB)) != -1) {
                            bout.write(readB, 0, readByte);
                        }
                        this.is.close();
                        bout.flush();
                        bout.close();
                        htmlRicevuto = bout.toString();
                    }
                    if (this.debug) {
                        if (htmlRicevuto != null && !"".equals(htmlRicevuto)) {
                            this.logger.info("Messaggio ricevuto (ContentType:" + tipoRisposta + ") :\n" + htmlRicevuto, false);
                        } else {
                            this.logger.info("Messaggio ricevuto (ContentType:" + tipoRisposta + ") senza contenuto nell'http-reply", false);
                        }
                    }
                    this.errore = htmlRicevuto != null && "".equals(htmlRicevuto) == false ? tipoLetturaRisposta + "\nhttp response: " + htmlRicevuto : tipoLetturaRisposta;
                    return false;
                }
                if (this.is != null) {
                    soapVersionRisposta = null;
                    protocolConfiguration = this.getProtocolFactory().createProtocolConfiguration();
                    if (tipoRisposta != null) {
                        try {
                            soapVersionRisposta = ServletUtils.getVersioneSoap(this.logger.getLogger(), tipoRisposta);
                        }
                        catch (Exception e) {
                            this.logger.error("SOAPVersion response unknown: " + e.getMessage(), e);
                        }
                    }
                    if (tipoRisposta == null || soapVersionRisposta == null || !soapVersionRisposta.equals((Object)this.requestMsg.getVersioneSoap()) || !ServletUtils.isContentTypeSupported(this.requestMsg.getVersioneSoap(), this.getProtocolFactory())) {
                        checkContentType = true;
                        if (this.idModulo != null) {
                            checkContentType = "ConsegnaContenutiApplicativi".equals(this.idModulo) != false ? this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneBuste() : this.openspcoopProperties.isControlloContentTypeAbilitatoRicezioneContenutiApplicativi();
                        }
                        msgErrore = null;
                        msgErrore = tipoRisposta == null ? "Header Content-Type non definito nell'http reply" : (soapVersionRisposta == null ? "Il valore dell'header HTTP Content-Type definito nell'http reply (" + tipoRisposta + ") non rientra tra quelli conosciuti (" + SOAPVersion.getKnownContentTypesAsString() + ")" : (soapVersionRisposta.equals((Object)this.requestMsg.getVersioneSoap()) == false ? "Header Content-Type definito nell'http reply (" + tipoRisposta + ") indica una versione " + soapVersionRisposta.getSoapVersionAsString() + " non compatibile con la versione " + this.requestMsg.getVersioneSoap().getSoapVersionAsString() + " del messaggio di richiesta" : "Il valore dell'header HTTP Content-Type definito nell'http reply (" + tipoRisposta + ") non rientra tra quelli supportati dal protocollo (" + SOAPVersion.getKnownContentTypesAsString((boolean)protocolConfiguration.isSupportoSOAP11(), (boolean)protocolConfiguration.isSupportoSOAP12()) + ")"));
                        if (checkContentType) {
                            throw new Exception(msgErrore);
                        }
                        this.logger.warn(msgErrore + "; viene utilizzato forzatamente il tipo: " + SOAPVersion.SOAP11.getContentTypeForMessageWithoutAttachments());
                        tipoRisposta = SOAPVersion.SOAP11.getContentTypeForMessageWithoutAttachments();
                    }
                    try {
                        if (this.debug) {
                            bout = new ByteArrayOutputStream();
                            readB = new byte[65536];
                            readByte = 0;
                            while ((readByte = this.is.read(readB)) != -1) {
                                bout.write(readB, 0, readByte);
                            }
                            this.is.close();
                            bout.flush();
                            bout.close();
                            this.logger.info("Messaggio ricevuto (ContentType:" + tipoRisposta + ") :\n" + bout.toString(), false);
                            this.is = new ByteArrayInputStream(bout.toByteArray());
                        }
                        if (!this.sbustamentoSoap) {
                            if (this.debug) {
                                this.logger.debug("Ricostruzione normale...");
                            }
                            tipoLetturaRisposta = "Costruzione messaggio SOAP";
                            if (contentLenght > 0) {
                                this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(this.is, notifierInputStreamParams, false, tipoRisposta, locationRisposta, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                            } else if (contentLenght == 0) {
                                this.responseMsg = null;
                            } else {
                                try {
                                    buffer = new byte[1];
                                    letti = this.is.read(buffer);
                                    if (letti != 1) ** GOTO lbl440
                                    sInput = new SequenceInputStream(new ByteArrayInputStream(buffer), this.is);
                                    this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage((InputStream)sInput, notifierInputStreamParams, false, tipoRisposta, locationRisposta, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                                }
                                catch (Exception e) {
                                    this.responseMsg = null;
                                    result2XX = this.codice >= 200 && this.codice <= 299;
                                    v0 = premature = Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) != false && result2XX != false;
                                    if (premature) ** GOTO lbl440
                                    this.eccezioneProcessamento = e;
                                    this.errore = "Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e);
                                    this.logger.error("Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e), e);
                                    if (!result2XX) ** GOTO lbl440
                                    return false;
                                }
                            }
                        } else {
                            cis = null;
                            try {
                                cis = new CountingInputStream(this.is);
                                if (imbustamentoConAttachment) {
                                    if (this.debug) {
                                        this.logger.debug("Imbustamento con attachments...");
                                    }
                                    tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + mimeTypeAttachment;
                                    try {
                                        this.responseMsg = SoapUtils.imbustamentoMessaggioConAttachment((SOAPVersion)this.requestMsg.getVersioneSoap(), (InputStream)cis, (String)mimeTypeAttachment, (boolean)MailcapActivationReader.existsDataContentHandler((String)mimeTypeAttachment), (String)tipoRisposta, (String)this.openspcoopProperties.getHeaderSoapActorIntegrazione());
                                    }
                                    catch (UtilsException e) {
                                        if (e.getMessage() != null && e.getMessage().equals("Contenuto da imbustare non presente")) ** GOTO lbl430
                                        throw e;
                                    }
                                } else if (tipoRisposta != null && tipoRisposta.contains("multipart/related")) {
                                    if (this.debug) {
                                        this.logger.debug("Imbustamento messaggio multipart/related...");
                                    }
                                    tipoLetturaRisposta = "Imbustamento messaggio multipart/related in un SOAP WithAttachments";
                                    byteBuffer = new ByteArrayOutputStream();
                                    readB = new byte[65536];
                                    readByte = 0;
                                    while ((readByte = cis.read(readB)) != -1) {
                                        byteBuffer.write(readB, 0, readByte);
                                    }
                                    if (byteBuffer.size() > 0) {
                                        this.responseMsg = SoapUtils.imbustamentoMessaggio((NotifierInputStreamParams)notifierInputStreamParams, (byte[])byteBuffer.toByteArray(), (boolean)this.openspcoopProperties.isDeleteInstructionTargetMachineXml(), (boolean)this.openspcoopProperties.isFileCacheEnable(), (String)this.openspcoopProperties.getAttachmentRepoDir(), (String)this.openspcoopProperties.getFileThreshold());
                                    }
                                } else {
                                    if (this.debug) {
                                        this.logger.debug("Imbustamento messaggio...");
                                    }
                                    tipoLetturaRisposta = "Imbustamento messaggio xml in un messaggio SOAP";
                                    this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage((InputStream)cis, notifierInputStreamParams, true, tipoRisposta, locationRisposta, this.openspcoopProperties.isFileCacheEnable(), this.openspcoopProperties.getAttachmentRepoDir(), this.openspcoopProperties.getFileThreshold());
                                }
lbl430:
                                // 4 sources

                                if (this.responseMsg != null) {
                                    this.responseMsg.updateIncomingMessageContentLength(cis.getByteCount());
                                }
                            }
                            finally {
                                try {
                                    if (cis != null) {
                                        cis.close();
                                    }
                                }
                                catch (Exception eClose) {}
                            }
                        }
                        try {
                            if (this.responseMsg != null) {
                                this.responseMsg.getSOAPPart().getEnvelope();
                            }
                        }
                        catch (Exception e) {
                            this.responseMsg = null;
                            result2XX = this.codice >= 200 && this.codice <= 299;
                            v1 = premature = Utilities.existsInnerMessageException((Throwable)e, (String)"Premature end of file", (boolean)true) != false && result2XX != false;
                            if (!premature) {
                                this.eccezioneProcessamento = e;
                                this.errore = "Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e);
                                this.logger.error("Errore avvenuto durante la consegna HTTP (lettura risposta): " + this.readExceptionMessageFromException(e), e);
                                if (result2XX) {
                                    return false;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.eccezioneProcessamento = e;
                        this.errore = "Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + "): " + this.readExceptionMessageFromException(e);
                        this.logger.error("Errore avvenuto durante la consegna HTTP (" + tipoLetturaRisposta + ")", e);
                        return false;
                    }
                    if (this.debug) {
                        this.logger.debug("Save messaggio...");
                    }
                    try {
                        if (this.responseMsg != null && this.responseMsg.countAttachments() == 0) {
                            this.responseMsg.getSOAPPart();
                        }
                    }
                    catch (Exception e) {
                        this.eccezioneProcessamento = e;
                        this.errore = "Errore avvenuto durante la consegna HTTP (salvataggio risposta): " + this.readExceptionMessageFromException(e);
                        this.logger.error("Errore avvenuto durante la consegna HTTP (salvataggio risposta): " + this.readExceptionMessageFromException(e), e);
                        return false;
                    }
                }
            }
            if (this.debug) {
                this.logger.info("Gestione invio/risposta http effettuata con successo", false);
            }
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.errore = "Errore avvenuto durante la consegna HTTP: " + this.readExceptionMessageFromException(e);
            this.logger.error("Errore avvenuto durante la consegna HTTP: " + this.readExceptionMessageFromException(e), e);
            return false;
        }
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.is != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura socket...");
                }
                this.is.close();
            }
            if (this.httpConn != null) {
                if (this.debug && this.logger != null) {
                    this.logger.debug("Chiusura connessione...");
                }
                this.httpConn.disconnect();
            }
            super.disconnect();
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public String getLocation() {
        if (this.routeRedirect == null) {
            return this.location;
        }
        return this.location + " [redirects route path: " + this.routeRedirect + "]";
    }
}

